`write.pqr` <-
function (pdb = NULL,
          xyz = pdb$xyz,
          resno = NULL,
          resid = NULL,
          eleno = NULL,
          elety = NULL,
          chain = NULL,
          o = NULL,
          b = NULL,
          het = FALSE,
          append = FALSE,
          verbose =FALSE,
          chainter = FALSE,
          file = "R.pdb") {

  if(is.null(xyz) || !is.numeric(xyz))
    stop("write.pdb: please provide a 'pdb' object or numeric 'xyz' coordinates"
)

  if(any(is.na(xyz)))
    stop("write.pdb: 'xyz' coordinates must have no NA's.")
  
  if (is.vector(xyz)) {
    natom <- length(xyz)/3
    nfile <- 1
  } else if (is.matrix(xyz)) {
    natom <- ncol(xyz)/3 
    nfile <- nrow(xyz)
    if (verbose) {
      cat("Multiple rows in 'xyz' will be interperted as multimodels/frames\n")
    }
  } else {
    stop("write.pdb: 'xyz' or 'pdb$xyz' must be either a vector or matrix")
  }

  card <- rep("ATOM", natom)
  
  if (!is.null(pdb)) {
    if(natom == 1)
      ## make sure we are a matrix
      pdb$atom <- t(as.matrix(pdb$atom))
    
    if (het) 
      card <- c( rep("ATOM", nrow(pdb$atom)), rep("HETATM", nrow(pdb$het)) )
    if (is.null(resno)) {
      resno = pdb$atom[, "resno"]
      if (het) { resno = c(resno, pdb$het[, "resno"]) }}
    
    if (is.null(resid)) {
      resid = pdb$atom[, "resid"]
      if (het) { resid = c(resid, pdb$het[, "resid"]) }}
    
    if (is.null(eleno)) {
      eleno = pdb$atom[, "eleno"]
      if (het) { eleno = c(eleno, pdb$het[, "eleno"]) }}
    
    if (is.null(elety)) {
      elety = pdb$atom[, "elety"]
      if (het) { elety = c(elety, pdb$het[, "elety"]) }}
    
    if (is.null(chain)) {
      chain = pdb$atom[, "chain"]
      if (het) { chain = c(chain, pdb$het[, "chain"]) }}
    
    if (is.null(o)) {
      o = pdb$atom[, "o"]
      if (het) { o = c(o, pdb$het[, "o"]) }}
    
    if (is.null(b)) {
      b = pdb$atom[, "b"]
      if (het) { b = c(b, pdb$het[, "b"]) }}
    
    if (any(is.na(o))) {      o = rep("1.00", natom) }
    if (any(is.na(b))) {      b = rep("0.00", natom) }
    #if (any(is.na(chain))) { chain = rep(" ", natom) }
    chain[is.na(chain)]= " "
    
  } else {
    if (is.null(resno)) resno = c(1:natom)
    if (is.null(resid)) resid = rep("ALA", natom)
    if (is.null(eleno)) eleno = c(1:natom)
    if (is.null(elety)) elety = rep("CA", natom)
    if (is.null(chain)) chain = rep(" ", natom)
    if (is.null(o))         o = rep("1.00",natom)
    if (is.null(b))         b = rep("0.00", natom)
  }

  
  if (!is.logical(append)) 
    stop("write.pdb: 'append' must be logical TRUE/FALSE")
  
  if (length(as.vector(xyz))%%3 != 0) {
    stop("write.pdb: 'length(xyz)' must be divisable by 3.")
  }
  check.lengths <- sum(length(resno), length(resid), length(eleno),
                       length(elety), length(o), length(b))
  if (check.lengths%%natom != 0) {
    stop("write.pdb: the lengths of all input vectors != 'length(xyz)/3'.")
  }

  
  o <- as.numeric(o)
  b <- as.numeric(b)
  eleno <- as.character(eleno)
  resno <- as.character(resno)
  ## Inserted Jul 8th 2008 for adding TER between chains
  ter.lines <- (which(!duplicated(chain))[-1] - 1)


  
  atom.print <- function(card = "ATOM", eleno, elety, alt = "",
        resid, chain = "", resno, insert = "", x, y, z, o = "1.00",
        b = "0.00", segid = "") {

##    PDB format
##    format <- "%-6s%5s  %-3s%1s%-4s%1s%4s%1s%3s%8.3f%8.3f%8.3f%6.2f%6.2f%6s%4s"
##    PQR fromat
    format <- "%-6s%5s  %-3s%1s%-4s%1s%4s%1s%3s%8.3f%8.3f%8.3f%8.4f%7.4f%6s%4s"


    if (nchar(elety) > 3) {
#    if (nchar(elety) >= 3) {
#      if ((substr(elety, 2, 2) == "H") | (substr(elety, 1, 1) == "H")) {
      
##    ##-PDB format
##        format <- "%-6s%5s %-4s%1s%-4s%1s%4s%1s%3s%8.3f%8.3f%8.3f%6.2f%6.2f%6s%4s"
##    ##-PQB format
      format <- "%-6s%5s %-4s%1s%-4s%1s%4s%1s%3s%8.3f%8.3f%8.3f%8.4f%7.4f%6s%4s"
        
#      }
    }
    sprintf(format, card, eleno, elety, alt, resid, chain,
            resno, insert, "", x, y, z, o, b, "", segid)
  } 


  
  if(nfile==1) {
    coords <- matrix(round(as.numeric(xyz), 3), ncol = 3, byrow = TRUE)
    if (verbose) {
      cat(paste("Writing 1 frame with",natom,"atoms "))
    }
    lines <- NULL
    for (i in 1:natom) {
      lines <- rbind(lines, atom.print( card = card[i],
                                       eleno = eleno[i],
                                       elety = elety[i],
                                       resid = resid[i],
                                       chain = chain[i],
                                       resno = resno[i],
                                       x = coords[i, 1],
                                       y = coords[i, 2],
                                       z = coords[i, 3],
                                       o = o[i], b = b[i]) )
      
      ## Inserted Jul 8th 2008 for adding TER between chains 
      if(chainter) {
        if(i  %in% ter.lines) {
          lines <- rbind(lines, "TER   ")
        }
      }
          
    }
    ## Changed cat() for write.table() as sugested by Joao Martins <joao.martins@env.ethz.ch>
    ##cat(lines, file = file, sep = "\n", append = append)
    write.table(lines, file=file, quote=FALSE, row.names=FALSE, col.names=FALSE, append=append)
    ##EDIT 25-apr-09##cat("TER   ","END", file = file, sep = "\n", append = TRUE)

    
  } else {
    if (verbose) {
      cat(paste("Writing",nfile,"frames with",natom,"atoms"),"\n")
      cat("Frame Progress (x50) ")
    }
    if(!append) unlink(file) 
    for (j in 1:nfile) {
      coords <- matrix(round(as.numeric(xyz[j,]), 3), ncol = 3, byrow = TRUE)
      lines <- NULL
      for (i in 1:natom) {
        lines <- rbind(lines, atom.print( eleno = eleno[i],
                                         elety = elety[i],
                                         resid = resid[i],
                                         chain = chain[i],
                                         resno = resno[i],
                                         x = coords[i, 1],
                                         y = coords[i, 2],
                                         z = coords[i, 3],
                                         o = o[i], b = b[i]) )

        ## Inserted Jul 8th 2008 for adding TER between chains (untested) 
        if(chainter) {
          if(i  %in% ter.lines) {
            lines <- rbind(lines, "TER   ")
          }
        }
        
      }
      if (verbose) {
        if (j%%50 == 0) cat(".")
      }
      ##cat(lines, file = file, sep = "\n", append = TRUE)
      write.table(lines, file = file, quote=FALSE, row.names=FALSE, col.names=FALSE, append=TRUE)
      ##EDIT 25-apr-09##cat("TER   ","END", file = file, sep = "\n", append = TRUE)
    }

  }
  if (verbose) cat(" DONE","\n")
}

