\name{read.all}
\alias{read.all}
\title{ Read Aligned Structure Data}
\description{
  Read aligned PDB structures and store their equalvalent atom data, including xyz
  coordinates, residue numbers, residue type and B-factors.
}
\usage{
read.all(aln, pdb.path = "./", pdbext = ".pdb", sel = NULL)
}

\arguments{
  \item{aln}{ an alignment data structure obtained with
    \code{\link{read.fasta}}. }
  \item{pdb.path}{ path to PDB files. }
  \item{pdbext}{ the file name extention of the PDB files. }
  \item{sel}{ a selection string detailing the atom type data to store
    (see function store.atom) }
}
\details{
  The input \code{aln}, produced with \code{\link{read.fasta}}, must
  have identifers (i.e. sequence names) that match the PDB file
  names. For example the sequence corresponding to the structure
  \dQuote{1bg2.pdb} should have the identifer \sQuote{1bg2}. See
  examples below.

  Sequence miss-matches will generate errors.  Thus, care should be taken
  to ensure that the sequences in the alignment match the sequences in
  their associated PDB files.
}
\value{
  Returns a list of class \code{"3dalign"} with the following five
  components:
  \item{xyz}{numeric matrix of aligned C-alpha coordinates.}
  \item{resno}{character matrix of aligned residue numbers.}
  \item{b}{numeric matrix of aligned B-factor values.}
  \item{chain}{character matrix of aligned chain identifiers.}
  \item{id}{character vector of PDB sequence/structure names.}
  \item{ali}{character matrix of aligned sequences.}
  \item{all }{numeric matrix of aligned equalvelent atom coordinates. }
  \item{all.elety}{numeric matrix of aligned atom element types. }
  \item{all.resid}{numeric matrix of aligned three-letter residue codes. }
  \item{all.resno}{numeric matrix of aligned residue numbers. }
}
\references{
  Grant, B.J. et al. (2006) \emph{Bioinformatics} \bold{22}, 2695--2696.
}
\author{ Barry Grant }
\note{
  This function is still in development and is NOT part of the
  offical bio3d package.
  
  The sequence character \sQuote{X} is useful for masking unusual
  or unknown residues, as it can match any other residue type.
}
\seealso{
  \code{\link{read.fasta}}, \code{\link{read.pdb}},
  \code{\link{core.find}}, \code{\link{fit.xyz}}  }
\examples{
# still working on speeding this guy up
\dontrun{
# Read sequence alignment
file <- system.file("examples/kif1a.fa",package="bio3d")
aln  <- read.fasta(file)

# Read aligned PDBs
pdb.path = system.file("examples",package="bio3d")
sel <- c("N", "CA", "C", "O", "CB", "*G", "*D",  "*E", "*Z")
pdbs <- read.all(aln, pdb.path = pdb.path, pdbext = ".ent", sel=sel)


#pdbs$all[,(colnames(pdbs$all)=="CA")] == pdbs$xyz

#atm <- rep( rep(sel,each=3), ncol(aln$ali))
#colnames(pdbs$all) == atm

#ca.ind  <- which(atm == "CA")
#core.ind <- c( matrix(ca.ind, nrow=3)[,core$c0.5A.atom] )


}

}
\keyword{ IO }
