% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subscript-loc.R
\name{vec_as_location}
\alias{vec_as_location}
\alias{num_as_location}
\alias{vec_as_location2}
\alias{num_as_location2}
\title{Create a vector of locations}
\usage{
vec_as_location(
  i,
  n,
  names = NULL,
  ...,
  missing = c("propagate", "error"),
  arg = caller_arg(i),
  call = caller_env()
)

num_as_location(
  i,
  n,
  ...,
  missing = c("propagate", "error"),
  negative = c("invert", "error", "ignore"),
  oob = c("error", "extend"),
  zero = c("remove", "error", "ignore"),
  arg = caller_arg(i),
  call = caller_env()
)

vec_as_location2(
  i,
  n,
  names = NULL,
  ...,
  missing = c("error", "propagate"),
  arg = caller_arg(i),
  call = caller_env()
)

num_as_location2(
  i,
  n,
  ...,
  negative = c("error", "ignore"),
  missing = c("error", "propagate"),
  arg = caller_arg(i),
  call = caller_env()
)
}
\arguments{
\item{i}{An integer, character or logical vector specifying the
locations or names of the observations to get/set. Specify
\code{TRUE} to index all elements (as in \code{x[]}), or \code{NULL}, \code{FALSE} or
\code{integer()} to index none (as in \code{x[NULL]}).}

\item{n}{A single integer representing the total size of the
object that \code{i} is meant to index into.}

\item{names}{If \code{i} is a character vector, \code{names} should be a character
vector that \code{i} will be matched against to construct the index. Otherwise,
not used. The default value of \code{NULL} will result in an error
if \code{i} is a character vector.}

\item{...}{These dots are for future extensions and must be empty.}

\item{missing}{Whether to throw an \code{"error"} when \code{i} is a missing
value, or \code{"propagate"} it (return it as is). By default, vector
subscripts can contain missing values and scalar subscripts can't.}

\item{arg}{The argument name to be displayed in error messages when
\code{vec_as_location()} and \code{vec_as_location2()} are used to check the
type of a function input.}

\item{call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}

\item{negative}{Whether to throw an \code{"error"} when \code{i} is a
negative location value, or \code{"ignore"} it.}

\item{oob}{If \code{"error"}, throws an informative \code{"error"} if some
elements are out-of-bounds. If \code{"extend"}, out-of-bounds
locations are allowed if they are consecutive after the end. This
can be used to implement extendable vectors like \code{letters[1:30]}.}

\item{zero}{Whether to \code{"remove"} zero values, throw an informative
\code{"error"}, or \code{"ignore"} them.}
}
\value{
\code{vec_as_location()} returns an integer vector that can be used
as an index in a subsetting operation. \code{vec_as_location2()}
returns an integer of size 1 that can be used a scalar index for
extracting an element.
}
\description{
These helpers provide a means of standardizing common indexing
methods such as integer, character or logical indexing.
\itemize{
\item \code{vec_as_location()} accepts integer, character, or logical vectors
of any size. The output is always an integer vector that is
suitable for subsetting with \code{[} or \code{\link[=vec_slice]{vec_slice()}}. It might be a
different size than the input because negative selections are
transformed to positive ones and logical vectors are transformed
to a vector of indices for the \code{TRUE} locations.
\item \code{vec_as_location2()} accepts a single number or string. It returns
a single location as a integer vector of size 1. This is suitable
for extracting with \code{[[}.
}
}
\examples{
x <- array(1:6, c(2, 3))
dimnames(x) <- list(c("r1", "r2"), c("c1", "c2", "c3"))

# The most common use case validates row indices
vec_as_location(1, vec_size(x))

# Negative indices can be used to index from the back
vec_as_location(-1, vec_size(x))

# Character vectors can be used if `names` are provided
vec_as_location("r2", vec_size(x), rownames(x))

# You can also construct an index for dimensions other than the first
vec_as_location(c("c2", "c1"), ncol(x), colnames(x))

}
\keyword{internal}
