% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporter-zzz.R
\name{reporter-accessors}
\alias{reporter-accessors}
\alias{set_reporter}
\alias{get_reporter}
\alias{with_reporter}
\title{Get and set active reporter.}
\usage{
set_reporter(reporter)

get_reporter()

with_reporter(reporter, code, start_end_reporter = TRUE)
}
\arguments{
\item{reporter}{Reporter to use to summarise output. Can be supplied
as a string (e.g. "summary") or as an R6 object
(e.g. \code{SummaryReporter$new()}).

See \link{Reporter} for more details and a list of built-in reporters.}

\item{code}{Code to execute.}

\item{start_end_reporter}{Should the reporters \code{start_reporter()} and
\code{end_reporter()} methods be called? For expert use only.}
}
\value{
\code{with_reporter()} invisible returns the reporter active when \code{code}
was evaluated.
}
\description{
\code{get_reporter()} and \code{set_reporter()} access and modify the current "active"
reporter. Generally, these functions should not be called directly; instead
use \code{with_reporter()} to temporarily change, then reset, the active reporter.
}
\keyword{internal}
