% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snapshot.R
\name{expect_snapshot}
\alias{expect_snapshot}
\alias{expect_snapshot_output}
\alias{expect_snapshot_error}
\alias{expect_snapshot_value}
\title{Snapshot testing}
\usage{
expect_snapshot(x, cran = FALSE, error = FALSE)

expect_snapshot_output(x, cran = FALSE)

expect_snapshot_error(x, class = "error", cran = FALSE)

expect_snapshot_value(
  x,
  style = c("json", "json2", "deparse", "serialize"),
  cran = FALSE,
  ...
)
}
\arguments{
\item{x}{Code to evaluate.}

\item{cran}{Should these expectations be verified on CRAN? By default,
they are not, because snapshot tests tend to be fragile because they
often rely on minor details of dependencies.}

\item{error}{Do you expect the code to throw an error? The expectation
will fail (even on CRAN) if an unexpected error is thrown or the
expected error is not thrown.}

\item{class}{Expected class of condition, e.g. use \code{error} for errors,
\code{warning} for warnings, \code{message} for messages. The expectation will
always fail (even on CRAN) if a condition of this class isn't seen
when executing \code{x}.}

\item{style}{Serialization style to use:
\itemize{
\item \code{json} uses \code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} and \code{\link[jsonlite:fromJSON]{jsonlite::toJSON()}}. This
produces the simplest output but only works for relatively simple
objects.
\item \code{json2} uses \code{\link[jsonlite:serializeJSON]{jsonlite::serializeJSON()}} and \code{\link[jsonlite:serializeJSON]{jsonlite::unserializeJSON()}}
which are more verbose but work for a wider range of type.
\item \code{deparse} uses \code{\link[=deparse]{deparse()}}, which generates a depiction of the object
using R code.
\item \code{serialize()} produces a binary serialization of the object using
\code{\link[=serialize]{serialize()}}. This is all but guaranteed to work for any R object,
but produces a completely opaque serialization.
}}

\item{...}{For \code{expect_snapshot_value()} only, passed on to
\code{\link[waldo:compare]{waldo::compare()}} so you can control the details of the comparison.}
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#experimental'><img src='figures/lifecycle-experimental.svg' alt='Experimental lifecycle'></a>}}{\strong{Experimental}}

Snapshot tests (aka golden tests) are similar to unit tests except that the
expected result is stored in a separate file that is managed by testthat.
Snapshot tests are useful for when the expected value is large, or when
the intent of the code is something that can only be verified by a human
(e.g. this is a useful error message). Learn more in
\code{vignette("snapshotting")}.
\itemize{
\item \code{expect_snapshot()} captures all messages, warnings, errors, and
output from code.
\item \code{expect_snapshot_output()} captures just output printed to the console.
\item \code{expect_snapshot_error()} captures just error messages.
\item \code{expect_snapshot_value()} captures the return value.
}

(These functions supersede \code{\link[=verify_output]{verify_output()}}, \code{\link[=expect_known_output]{expect_known_output()}},
\code{\link[=expect_known_value]{expect_known_value()}}, and \code{\link[=expect_known_hash]{expect_known_hash()}}.)
}
\section{Workflow}{

The first time that you run a snapshot expectation it will run \code{x},
capture the results, and record in \verb{tests/testthat/snap/\{test\}.json}.
Each test file gets its own snapshot file, e.g. \code{test-foo.R} will get
\code{snap/foo.json}.

It's important to review the JSON files and commit them to git. They are
designed to be human readable, and you should always review new additions
to ensure that the salient information has been capture. They should also
be carefully reviewed in pull requests, to make sure that snapshots have
updated in the expected way.

On subsequent runs, the result of \code{x} will be compared to the value stored
on disk. If it's different, the expectation will fail, and a new file
\verb{snap/\{test\}.new.json} will be created. If the change was deliberate,
you can approve the change with \code{\link[=snapshot_accept]{snapshot_accept()}} and then the tests will
pass the next time you run them.

Note that snapshotting can onµly work when executing a complete test file
(with \code{\link[=test_file]{test_file()}}, \code{\link[=test_dir]{test_dir()}}, or friends) because there's otherwise
no way to figure out the snapshot path. If you run snapshot tests
interactively, they'll just display the current value.
}

