% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareFit.R
\name{compareFit}
\alias{compareFit}
\title{Build an object summarizing fit indices across multiple models}
\usage{
compareFit(..., nested = TRUE)
}
\arguments{
\item{...}{fitted \code{lavaan} models or list(s) of \code{lavaan} objects}

\item{nested}{\code{logical} indicating whether the models in \code{...} are
nested. See the \code{\link{net}} function for an empirical test of nesting.}
}
\value{
A \code{\linkS4class{FitDiff}} object that saves model fit
comparisons across multiple models. If the output is not assigned as an
object, the output is printed in two parts: (1) nested model comparison (if
models are nested) and (2) summary of fit indices. In the fit indices
summaries, daggers are tagged to the model with the best fit according to
each fit index.
}
\description{
This function will create the template to compare fit indices across
multiple fitted lavaan objects. The results can be exported to a clipboard
or a file later.
}
\examples{

m1 <- ' visual  =~ x1 + x2 + x3
        textual =~ x4 + x5 + x6
        speed   =~ x7 + x8 + x9 '

fit1 <- cfa(m1, data = HolzingerSwineford1939)

m2 <- ' f1  =~ x1 + x2 + x3 + x4
        f2 =~ x5 + x6 + x7 + x8 + x9 '
fit2 <- cfa(m2, data = HolzingerSwineford1939)
compareFit(fit1, fit2, nested = FALSE)

HW.model <- ' visual =~ x1 + x2 + x3
              textual =~ x4 + x5 + x6
              speed =~ x7 + x8 + x9 '

out <- measurementInvariance(model = HW.model, data = HolzingerSwineford1939,
                             group = "school", quiet = TRUE)
compareFit(out)

}
\seealso{
\code{\linkS4class{FitDiff}}, \code{\link{clipboard}}
}
\author{
Sunthud Pornprasertmanit (\email{psunthud@gmail.com})
}
