% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag.R
\name{roxy_tag}
\alias{roxy_tag}
\alias{roxy_tag_parse}
\alias{roxy_tag_warning}
\alias{warn_roxy_tag}
\title{\code{roxy_tag} S3 constructor}
\usage{
roxy_tag(tag, raw, val = NULL, file = NA_character_, line = NA_character_)

roxy_tag_parse(x)

roxy_tag_warning(x, ...)

warn_roxy_tag(tag, message, ...)
}
\arguments{
\item{tag}{Tag name. Arguments starting with \code{.} are reserved for internal
usage.}

\item{raw}{Raw tag value, a string.}

\item{val}{Parsed tag value, typically a character vector, but sometimes
a list. Usually filled in by \code{tag_parsers}}

\item{file, line}{Location of the tag}

\item{x}{A tag}
}
\description{
\code{roxy_tag()} is the constructor for tag objects.
\code{roxy_tag_warning()} is superseded by \code{warn_roxy_tag()}; use to generate a
warning that includes the location of the tag.
}
\section{Methods}{

Define a method for \code{roxy_tag_parse} to support new tags. See \link{tag_parsers}
for more details.
}

\keyword{internal}
