% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls.R
\name{step_pls}
\alias{step_pls}
\alias{tidy.step_pls}
\title{Partial Least Squares Feature Extraction}
\usage{
step_pls(recipe, ..., role = "predictor", trained = FALSE,
  num_comp = 2, outcome = NULL, options = NULL, res = NULL,
  num = NULL, prefix = "PLS", skip = FALSE, id = rand_id("pls"))

\method{tidy}{step_pls}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables will be used to compute the dimensions. See
\code{\link[=selections]{selections()}} for more details. For the \code{tidy} method, these
are not currently used.}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the new dimension columns created by the original variables
will be used as predictors in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{num_comp}{The number of pls dimensions to retain as new
predictors. If \code{num_comp} is greater than the number of columns
or the number of possible dimensions, a smaller value will be
used.}

\item{outcome}{When a single outcome is available, character
string or call to \code{\link[dplyr:vars]{dplyr::vars()}} can be used to specify the
variable. When there are multipole outcomes, \code{\link[dplyr:vars]{dplyr::vars()}}
must be used. This that can include specific variable names
separated by commas or different selectors (see \code{\link[=selections]{selections()}}).}

\item{options}{A list of options to \code{\link[pls:plsr]{pls::plsr()}}.}

\item{res}{The \code{\link[pls:plsr]{pls::plsr()}} object is stored
here once this preprocessing step has be trained by
\code{\link[=prep.recipe]{prep.recipe()}}.}

\item{num}{The number of components to retain (this will be
deprecated in factor of \code{num_comp} in version 0.1.5). \code{num_comp}
will override this option.}

\item{prefix}{A character string that will be the prefix to the
resulting new variables. See notes below.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_pls} object}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} (the
selectors or variables selected).
}
\description{
\code{step_pls} creates a \emph{specification} of a recipe step that will
convert numeric data into one or more new dimensions.
}
\details{
PLS is a supervised version of principal component
analysis that requires one or more numeric outcomes to compute
the new features. The data should be scaled (and perhaps
centered) prior to running these calculations.

This step requires the \pkg{pls} package. If not installed, the
step will stop with a note about installing the package.

The argument \code{num_comp} controls the number of components that will
be retained (the original variables that are used to derive the
components are removed from the data). The new components will
have names that begin with \code{prefix} and a sequence of numbers.
The variable names are padded with zeros. For example, if \code{num_comp < 10}, their names will be \code{PLS1} - \code{PLS9}. If \code{num_comp = 101}, the
names would be \code{PLS001} - \code{PLS101}.
}
\examples{
data(biomass)

biomass_tr <- biomass[biomass$dataset == "Training",]
biomass_te <- biomass[biomass$dataset == "Testing",]

pls_rec <- recipe(HHV ~ ., data = biomass_tr) \%>\%
  step_rm(sample, dataset) \%>\%
  step_center(all_predictors()) \%>\%
  step_scale(all_predictors()) \%>\%
  # If the outcome(s) need standardization, do it in separate
  # steps with skip = FALSE so that new data where the
  # outcome is missing can be processed.
  step_center(all_outcomes(), skip = TRUE) \%>\%
  step_scale(all_outcomes(), skip = TRUE) \%>\%
  step_pls(all_predictors(), outcome = "HHV")

pls_rec <- prep(pls_rec, training = biomass_tr, retain = TRUE)

pls_test_scores <- bake(pls_rec, new_data = biomass_te[, -8])

tidy(pls_rec, number = 6)
}
\seealso{
\code{\link[=step_pca]{step_pca()}} \code{\link[=step_kpca]{step_kpca()}}
\code{\link[=step_ica]{step_ica()}} \code{\link[=recipe]{recipe()}} \code{\link[=prep.recipe]{prep.recipe()}}
\code{\link[=bake.recipe]{bake.recipe()}}
}
\concept{pls}
\concept{preprocessing}
\concept{projection_methods}
\keyword{datagen}
