% Generated by roxygen2 (4.0.1): do not edit by hand
\name{manhattan}
\alias{manhattan}
\title{Creates a manhattan plot}
\usage{
manhattan(x, chr = "CHR", bp = "BP", p = "P", snp = "SNP",
  col = c("gray10", "gray60"), chrlabs = NULL,
  suggestiveline = -log10(1e-05), genomewideline = -log10(5e-08),
  highlight = NULL, logp = TRUE, ...)
}
\arguments{
\item{x}{A data.frame with columns "BP," "CHR," "P," and optionally, "SNP."}

\item{chr}{A string denoting the column name for the chromosome. Defaults to
PLINK's "CHR." Said column must be numeric. If you have X, Y, or MT
chromosomes, be sure to renumber these 23, 24, 25, etc.}

\item{bp}{A string denoting the column name for the chromosomal position.
Defaults to PLINK's "BP." Said column must be numeric.}

\item{p}{A string denoting the column name for the p-value. Defaults to
PLINK's "P." Said column must be numeric.}

\item{snp}{A string denoting the column name for the SNP name (rs number).
Defaults to PLINK's "SNP." Said column should be a character.}

\item{col}{A character vector indicating which colors to alternate.}

\item{chrlabs}{A character vector equal to the number of chromosomes
specifying the chromosome labels (e.g., \code{c(1:22, "X", "Y", "MT")}).}

\item{suggestiveline}{Where to draw a "suggestive" line. Default
-log10(1e-5). Set to FALSE to disable.}

\item{genomewideline}{Where to draw a "genome-wide sigificant" line. Default
-log10(5e-8). Set to FALSE to disable.}

\item{highlight}{A character vector of SNPs in your dataset to highlight.
These SNPs should all be in your dataset.}

\item{logp}{If TRUE, the -log10 of the p-value is plotted. It isn't very
useful to plot raw p-values, but plotting the raw value could be useful for
other genome-wide plots, for example, peak heights, bayes factors, test
statistics, other "scores," etc.}

\item{...}{Arguments passed on to other plot/points functions}
}
\value{
A manhattan plot.
}
\description{
Creates a manhattan plot from PLINK assoc output (or any data frame with
chromosome, position, and p-value).
}
\examples{
manhattan(gwasResults)
}
\keyword{manhattan}
\keyword{visualization}

