% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_parameters.R
\name{bootstrap_parameters}
\alias{bootstrap_parameters}
\title{Parameters bootstrapping}
\usage{
bootstrap_parameters(
  model,
  iterations = 1000,
  centrality = "median",
  ci = 0.95,
  ci_method = "quantile",
  test = "p-value",
  ...
)
}
\arguments{
\item{model}{Statistical model.}

\item{iterations}{The number of draws to simulate/bootstrap.}

\item{centrality}{The point-estimates (centrality indices) to compute.  Character (vector) or list with one or more of these options: \code{"median"}, \code{"mean"}, \code{"MAP"} or \code{"all"}.}

\item{ci}{Value or vector of probability of the CI (between 0 and 1)
to be estimated. Default to \code{.89} (89\%) for Bayesian models and \code{.95} (95\%) for frequentist models.}

\item{ci_method}{The type of index used for Credible Interval. Can be
\code{"HDI"} (default, see \code{\link[bayestestR:hdi]{hdi}}), \code{"ETI"}
(see \code{\link[bayestestR:eti]{eti}}) or \code{"SI"}
(see \code{\link[bayestestR:si]{si}}).}

\item{test}{The indices to compute. Character (vector) with one or more of these options: \code{"p-value"} (or \code{"p"}), \code{"p_direction"} (or \code{"pd"}), \code{"rope"}, \code{"p_map"}, \code{"equivalence_test"} (or \code{"equitest"}), \code{"bayesfactor"} (or \code{"bf"}) or \code{"all"} to compute all tests. For each "test", the corresponding \pkg{bayestestR} function is called (e.g. \code{\link[bayestestR]{rope}} or \code{\link[bayestestR]{p_direction}}) and its results included in the summary output.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
Bootstrapped parameters.
}
\description{
Compute bootstrapped parameters and their related indices such as Confidence Intervals (CI) and p-values.
}
\details{
This function first calls \code{\link{bootstrap_model}} to generate
  bootstrapped coefficients. The resulting replicated for each coefficient
  are treated as "distribution", and is passed to \code{\link[bayestestR]{describe_posterior}}
  to calculate the related indices defined in the \code{"test"} argument.
}
\examples{
library(parameters)

model <- lm(Sepal.Length ~ Species * Petal.Width, data = iris)
bootstrap_parameters(model)
}
\references{
Davison, A. C., & Hinkley, D. V. (1997). Bootstrap methods and their application (Vol. 1). Cambridge university press.
}
\seealso{
\code{\link{bootstrap_model}}, \code{\link{simulate_parameters}}, \code{\link{simulate_model}}
}
