% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowTabulates.R
\name{rowTabulates}
\alias{rowTabulates}
\alias{colTabulates}
\title{Tabulates the values in a matrix by row (column)}
\usage{
rowTabulates(x, rows = NULL, cols = NULL, values = NULL, ...)

colTabulates(x, rows = NULL, cols = NULL, values = NULL, ...)
}
\arguments{
\item{x}{An \code{\link[base]{integer}}, a \code{\link[base]{logical}}, or
a \code{\link[base]{raw}} NxK \code{\link[base]{matrix}}.}

\item{rows, cols}{A \code{\link[base]{vector}} indicating subset of rows
(and/or columns) to operate over. If \code{\link[base]{NULL}}, no subsetting
is done.}

\item{values}{An \code{\link[base]{vector}} of J values of count. If
\code{\link[base]{NULL}}, all (unique) values are counted.}

\item{...}{Not used.}
}
\value{
Returns a NxJ (KxJ) \code{\link[base]{matrix}} where N (K) is the
number of row (column) \code{\link[base]{vector}}s tabulated and J is the
number of values counted.
}
\description{
Tabulates the values in a matrix by row (column).
}
\examples{
x <- matrix(1:5, nrow = 10, ncol = 5)
print(x)
print(rowTabulates(x))
print(colTabulates(x))
# Count only certain values
print(rowTabulates(x, values = 1:3))


y <- as.raw(x)
dim(y) <- dim(x)
print(y)
print(rowTabulates(y))
print(colTabulates(y))
}
\author{
Henrik Bengtsson
}
\keyword{utilities}
