% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_FilterCombinations.R
\name{plot_FilterCombinations}
\alias{plot_FilterCombinations}
\title{Plot filter combinations along with net transmission window}
\usage{
plot_FilterCombinations(filters, wavelength_range = 200:1000,
  show_net_transmission = TRUE, plot = TRUE, ...)
}
\arguments{
\item{filters}{\code{\link{list}} (\bold{required}): a named list of filter data for each filter to be shown.
The filter data itself should be either provided as \code{\link{data.frame}} or \code{\link{matrix}}.
(for more options s. Details)}

\item{wavelength_range}{\code{\link{numeric}} (with default): wavelength range used for the interpolation}

\item{show_net_transmission}{\code{\link{logical}} (with default): show net transmission window
as polygon.}

\item{plot}{\code{\link{logical}} (with default): enables or disables the plot output}

\item{\dots}{further arguments that can be passed to control the plot output. Suppored are \code{main},
\code{xlab}, \code{ylab}, \code{xlim}, \code{ylim}, \code{type}, \code{lty}, \code{lwd}. For non common plotting
parameters see the details section.}
}
\value{
Returns an S4 object of type \code{\linkS4class{RLum.Results}}.

\bold{@data}
\tabular{lll}{
\bold{Object} \tab \bold{Type} \bold{Description} \cr
 net_transmission_window \tab \code{matrix} \tab the resulting net transmission window \cr
 filter_matrix \tab \code{matrix} \tab the filter matrix used for plotting

}

\bold{@info}
\tabular{lll}{
\bold{Object} \tab \bold{Type} \bold{Description} \cr
call \tab \code{call} \tab the original function call

}
}
\description{
The function allows to plot transmission windows for different filters. Missing data for specific
wavelenghts are automatically interpolated for the given filter data using the function \code{\link{approx}}.
With that a standardised output is reached and a net transmission window can be shown.\cr
}
\details{
\bold{How to provide input data?}\cr

CASE 1\cr

The function expects that all filter values are either of type \code{matrix} or \code{data.frame}
with two columns. The first columens contains the wavelength, the second the relative transmission
(but not in percentage, i.e. the maximum transmission can be only become 1).

In this case only the transmission window is show as provided. Changes in filter thickness and
relection factor are not considered. \cr

CASE 2\cr

The filter data itself are provided as list element containing a \code{matrix} or \code{data.frame}
and additional information on the thickness of the filter, e.g., \code{list(filter1 = list(filter_matrix, d = 2))}.
The given filter data are always considered as standard input and the filter thickness value
is taken into account by

\deqn{Transmission = Transmission^(d)}

with d given in the same dimension as the original filter data.\cr

CASE 3\cr

Same as CASE 2 but additionally a reflection factor P is provided, e.g.,
\code{list(filter1 = list(filter_matrix, d = 2, P = 0.9))}. The final transmission
becomes:

\deqn{Transmission = Transmission^(d) * P}\cr

\bold{Advanced plotting parameters}\cr

The following further non-common plotting parameters can be passed to the function:\cr

\tabular{lll}{
\bold{Argument} \tab \bold{Datatype} \tab \bold{Description}\cr
\code{legend} \tab \code{logical} \tab enable/disable legend \cr
\code{legend.pos} \tab \code{character} \tab change legend position (\code{\link[graphics]{legend}}) \cr
\code{legend.text} \tab \code{character} \tab same as the argument \code{legend} in (\code{\link[graphics]{legend}}) \cr
\code{net_transmission.col} \tab \code{col} \tab colour of net transmission window polygon \cr
\code{grid} \tab \code{list} \tab full list of arguments that can be passd to the function \code{\link[graphics]{grid}}
}

For further modifications standard additional R plot functions are recommend, e.g., the legend
can be fully customised by disabling the standard legend and use the function \code{\link[graphics]{legend}}
instead.
}
\section{Function version}{
 0.1.0 (2016-05-02 09:36:06)
}
\examples{

## (For legal reasons no real filter data are provided)

## Create filter sets
filter1 <- density(rnorm(100, mean = 450, sd = 20))
filter1 <- matrix(c(filter1$x, filter1$y/max(filter1$y)), ncol = 2)
filter2 <- matrix(c(200:799,rep(c(0,0.8,0),each = 200)), ncol = 2)

## Example 1 (standard)
plot_FilterCombinations(filters = list(filter1, filter2))

## Example 2 (with d and P value and name for filter 2)
results <- plot_FilterCombinations(
filters = list(filter_1 = filter1, Rectangle = list(filter2, d = 2, P = 0.6)))
results


}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montagine (France)\cr
\cr R Luminescence Package Team}
\seealso{
\code{\linkS4class{RLum.Results}}, \code{\link{approx}}
}
\keyword{aplot}
\keyword{datagen}

