% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty.r
\name{pretty_dates}
\alias{pretty_dates}
\title{Computes attractive axis breaks for date-time data}
\usage{
pretty_dates(x, n, ...)
}
\arguments{
\item{x}{a vector of POSIXct, POSIXlt, Date, or chron date-time objects}

\item{n}{integer value of the desired number of breaks}

\item{...}{additional arguments to pass to function}
}
\value{
a vector of date-times that can be used as axis tick marks or bin breaks
}
\description{
pretty.dates indentifies which unit of time the sub-intervals should be
measured in to provide approximately n breaks. It then chooses a "pretty"
length for the sub-intervals and sets start and endpoints that 1) span the
entire range of the data, and 2) allow the breaks to occur on important
date-times (i.e. on the hour, on the first of the month, etc.)
}
\examples{
x <- seq.Date(as.Date("2009-08-02"), by = "year", length.out = 2)
pretty_dates(x, 12)
}
\keyword{chron}
\keyword{dplot}
\keyword{utilities}

