% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gh.R
\name{gh}
\alias{gh}
\title{Query the GitHub API}
\usage{
gh(
  endpoint,
  ...,
  per_page = NULL,
  .token = NULL,
  .destfile = NULL,
  .overwrite = FALSE,
  .api_url = NULL,
  .method = "GET",
  .limit = NULL,
  .accept = "application/vnd.github.v3+json",
  .send_headers = NULL,
  .progress = TRUE,
  .params = list()
)
}
\arguments{
\item{endpoint}{GitHub API endpoint. Must be one of the following forms:
\itemize{
\item \verb{METHOD path}, e.g. \code{GET /rate_limit},
\item \code{path}, e.g. \verb{/rate_limit},
\item \verb{METHOD url}, e.g. \verb{GET https://api.github.com/rate_limit},
\item \code{url}, e.g. \verb{https://api.github.com/rate_limit}.
}

If the method is not supplied, will use \code{.method}, which defaults
to \code{"GET"}.}

\item{...}{Name-value pairs giving API parameters. Will be matched into
\code{endpoint} placeholders, sent as query parameters in GET requests, and as a
JSON body of POST requests. If there is only one unnamed parameter, and it
is a raw vector, then it will not be JSON encoded, but sent as raw data, as
is. This can be used for example to add assets to releases. Named \code{NULL}
values are silently dropped. For GET requests, named \code{NA} values trigger an
error. For other methods, named \code{NA} values are included in the body of the
request, as JSON \code{null}.}

\item{per_page}{Number of items to return per page. If omitted,
will be substituted by \code{max(.limit, 100)} if \code{.limit} is set,
otherwise determined by the API (never greater than 100).}

\item{.token}{Authentication token. Defaults to \code{GITHUB_PAT} or
\code{GITHUB_TOKEN} environment variables, in this order if any is set.
See \code{\link[=gh_token]{gh_token()}} if you need more flexibility, e.g. different tokens
for different GitHub Enterprise deployments.}

\item{.destfile}{Path to write response to disk. If \code{NULL} (default),
response will be processed and returned as an object. If path is given,
response will be written to disk in the form sent.}

\item{.overwrite}{If \code{.destfile} is provided, whether to overwrite an
existing file.  Defaults to \code{FALSE}.}

\item{.api_url}{Github API url (default: \url{https://api.github.com}). Used
if \code{endpoint} just contains a path. Defaults to \code{GITHUB_API_URL}
environment variable if set.}

\item{.method}{HTTP method to use if not explicitly supplied in the
\code{endpoint}.}

\item{.limit}{Number of records to return. This can be used
instead of manual pagination. By default it is \code{NULL},
which means that the defaults of the GitHub API are used.
You can set it to a number to request more (or less)
records, and also to \code{Inf} to request all records.
Note, that if you request many records, then multiple GitHub
API calls are used to get them, and this can take a potentially
long time.}

\item{.accept}{The value of the \code{Accept} HTTP header. Defaults to
\code{"application/vnd.github.v3+json"} . If \code{Accept} is given in
\code{.send_headers}, then that will be used. This parameter can be used to
provide a custom media type, in order to access a preview feature of
the API.}

\item{.send_headers}{Named character vector of header field values
(except \code{Authorization}, which is handled via \code{.token}). This can be
used to override or augment the default \code{User-Agent} header:
\code{"https://github.com/r-lib/gh"}.}

\item{.progress}{Whether to show a progress indicator for calls that
need more than one HTTP request.}

\item{.params}{Additional list of parameters to append to \code{...}.
It is easier to use this than \code{...} if you have your parameters in
a list already.}
}
\value{
Answer from the API as a \code{gh_response} object, which is also a
\code{list}. Failed requests will generate an R error. Requests that
generate a raw response will return a raw vector.
}
\description{
This is an extremely minimal client. You need to know the API
to be able to use this client. All this function does is:
\itemize{
\item Try to substitute each listed parameter into \code{endpoint}, using the
\code{{parameter}} notation.
\item If a GET request (the default), then add all other listed parameters
as query parameters.
\item If not a GET request, then send the other parameters in the request
body, as JSON.
\item Convert the response to an R list using \code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}}.
}
}
\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Repositories of a user, these are equivalent
gh("/users/hadley/repos", .limit = 2)
gh("/users/{username}/repos", username = "hadley", .limit = 2)

## Starred repositories of a user
gh("/users/hadley/starred", .limit = 2)
gh("/users/{username}/starred", username = "hadley", .limit = 2)
\dontshow{\}) # examplesIf}
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Create a repository, needs a token in GITHUB_PAT (or GITHUB_TOKEN)
## environment variable
gh("POST /user/repos", name = "foobar")
\dontshow{\}) # examplesIf}
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Issues of a repository
gh("/repos/hadley/dplyr/issues")
gh("/repos/{owner}/{repo}/issues", owner = "hadley", repo = "dplyr")

## Automatic pagination
users <- gh("/users", .limit = 50)
length(users)
\dontshow{\}) # examplesIf}
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Access developer preview of Licenses API (in preview as of 2015-09-24)
gh("/licenses") # used to error code 415
gh("/licenses", .accept = "application/vnd.github.drax-preview+json")
\dontshow{\}) # examplesIf}
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Access Github Enterprise API
## Use GITHUB_API_URL environment variable to change the default.
gh("/user/repos", type = "public", .api_url = "https://github.foobar.edu/api/v3")
\dontshow{\}) # examplesIf}
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Use I() to force body part to be sent as an array, even if length 1
## This works whether assignees has length 1 or > 1
assignees <- "gh_user"
assignees <- c("gh_user1", "gh_user2")
gh("PATCH /repos/OWNER/REPO/issues/1", assignees = I(assignees))
\dontshow{\}) # examplesIf}
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## There are two ways to send JSON data. One is that you supply one or
## more objects that will be converted to JSON automatically via
## jsonlite::toJSON(). In this case sometimes you need to use
## jsonlite::unbox() because fromJSON() creates lists from scalar vectors
## by default. The Content-Type header is automatically added in this
## case. For example this request turns on GitHub Pages, using this
## API: https://docs.github.com/v3/repos/pages/#enable-a-pages-site

gh::gh(
  "POST /repos/{owner}/{repo}/pages",
  owner = "r-lib",
  repo = "gh",
  source = list(
    branch = jsonlite::unbox("gh-pages"),
    path = jsonlite::unbox("/")
  ),
  .send_headers = c(Accept = "application/vnd.github.switcheroo-preview+json")
)

## The second way is to handle the JSON encoding manually, and supply it
## as a raw vector in an unnamed argument, and also a Content-Type header:

body <- '{ "source": { "branch": "gh-pages", "path": "/" } }'
gh::gh(
  "POST /repos/{owner}/{repo}/pages",
  owner = "r-lib",
  repo = "gh",
  charToRaw(body),
  .send_headers = c(
    Accept = "application/vnd.github.switcheroo-preview+json",
    "Content-Type" = "application/json"
  )
)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=gh_gql]{gh_gql()}} if you want to use the GitHub GraphQL API,
\code{\link[=gh_whoami]{gh_whoami()}} for details on GitHub API token management.
}
