% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme-defaults.r
\name{ggtheme}
\alias{theme_grey}
\alias{theme_gray}
\alias{theme_bw}
\alias{theme_linedraw}
\alias{theme_light}
\alias{theme_dark}
\alias{theme_minimal}
\alias{theme_classic}
\alias{theme_void}
\alias{theme_test}
\title{Complete themes}
\usage{
theme_grey(base_size = 11, base_family = "",
  base_line_size = base_size/22, base_rect_size = base_size/22)

theme_gray(base_size = 11, base_family = "",
  base_line_size = base_size/22, base_rect_size = base_size/22)

theme_bw(base_size = 11, base_family = "", base_line_size = base_size/22,
  base_rect_size = base_size/22)

theme_linedraw(base_size = 11, base_family = "",
  base_line_size = base_size/22, base_rect_size = base_size/22)

theme_light(base_size = 11, base_family = "",
  base_line_size = base_size/22, base_rect_size = base_size/22)

theme_dark(base_size = 11, base_family = "",
  base_line_size = base_size/22, base_rect_size = base_size/22)

theme_minimal(base_size = 11, base_family = "",
  base_line_size = base_size/22, base_rect_size = base_size/22)

theme_classic(base_size = 11, base_family = "",
  base_line_size = base_size/22, base_rect_size = base_size/22)

theme_void(base_size = 11, base_family = "",
  base_line_size = base_size/22, base_rect_size = base_size/22)

theme_test(base_size = 11, base_family = "",
  base_line_size = base_size/22, base_rect_size = base_size/22)
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}

\item{base_line_size}{base size for line elements}

\item{base_rect_size}{base size for rect elements}
}
\description{
These are complete themes which control all non-data display. Use
\code{\link[=theme]{theme()}} if you just need to tweak the display of an existing
theme.
}
\details{
\describe{

\item{\code{theme_gray}}{
The signature ggplot2 theme with a grey background and white gridlines,
designed to put the data forward yet make comparisons easy.}

\item{\code{theme_bw}}{
The classic dark-on-light ggplot2 theme. May work better for presentations
displayed with a projector.}

\item{\code{theme_linedraw}}{
A theme with only black lines of various widths on white backgrounds,
reminiscent of a line drawings. Serves a purpose similar to \code{theme_bw}.
Note that this theme has some very thin lines (<< 1 pt) which some journals
may refuse.}

\item{\code{theme_light}}{
A theme similar to \code{theme_linedraw} but with light grey lines and axes,
to direct more attention towards the data.}

\item{\code{theme_dark}}{
The dark cousin of \code{theme_light}, with similar line sizes but a dark background. Useful to make thin coloured lines pop out.}

\item{\code{theme_minimal}}{
A minimalistic theme with no background annotations.}

\item{\code{theme_classic}}{
A classic-looking theme, with x and y axis lines and no gridlines.}

\item{\code{theme_void}}{
A completely empty theme.}

\item{\code{theme_test}}{
A theme for visual unit tests. It should ideally never change except
for new features.}

}
}
\examples{
p <- ggplot(mtcars) + geom_point(aes(x = wt, y = mpg,
     colour = factor(gear))) + facet_wrap(~am)
p + theme_gray() # the default
p + theme_bw()
p + theme_linedraw()
p + theme_light()
p + theme_dark()
p + theme_minimal()
p + theme_classic()
p + theme_void()
}
