% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rebase.R
\name{dyRebase}
\alias{dyRebase}
\title{Rebase data handler for straw broom charts with Dygraph}
\usage{
dyRebase(dygraph, value = 100, percent = FALSE)
}
\arguments{
\item{dygraph}{Dygraph to draw chart on}

\item{value}{Value to rebase to}

\item{percent}{If true, ingnore value argument and rebase to percentage difference}
}
\value{
Dygraph with specified straw broom chart
}
\description{
Draw a straw broom chart.
}
\examples{
\dontrun{
library(quantmod)
tickers <- c("AAPL", "MSFT")
getSymbols(tickers)
closePrices <- do.call(merge, lapply(tickers, function(x) Cl(get(x))))
dateWindow <- c("2008-01-01", "2009-01-01")
dygraph(closePrices, main = "Value", group = "stock") \%>\%
  dyRebase(value = 100) \%>\%
  dyRangeSelector(dateWindow = dateWindow)
dygraph(closePrices, main = "Percent", group = "stock") \%>\%
  dyRebase(percent = TRUE) \%>\%
  dyRangeSelector(dateWindow = dateWindow)
dygraph(closePrices, main = "None", group = "stock") \%>\%
  dyRangeSelector(dateWindow = dateWindow)
}

}
