% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/email.R
\name{send_mail}
\alias{send_mail}
\title{Send email}
\usage{
send_mail(mail_from, mail_rcpt, message, smtp_server = "localhost",
  verbose = TRUE, ...)
}
\arguments{
\item{mail_from}{email address of the sender.}

\item{mail_rcpt}{one or more recipient email addresses. Do not include names,
these go into the \code{message} headers.}

\item{message}{either a string or connection with (properly formatted) email
message, including sender/recipient/subject headers. See example.}

\item{smtp_server}{address of the SMTP server without the \code{smtp://} part}

\item{verbose}{print output}

\item{...}{other options passed to \code{\link{handle_setopt}}. In most cases
you will need to set a \code{username} and \code{password} to authenticate
with the SMTP server.}
}
\description{
Use the curl SMTP client to send an email. The \code{message} argument must be
properly formatted RFC2822 email message with From/To/Subject headers and CRLF
line breaks.
}
\examples{
\donttest{# Message in RFC2822 format
message <- 'From: "Testbot" <jeroen@ocpu.io>
To: "Jeroen Ooms" <jeroenooms@gmail.com>
Subject: Hello there!

Hi Jeroen,
I am sending this email using curl.'


# Actually send the email
recipients <- c('test@opencpu.org', 'jeroenooms@gmail.com')
sender <- 'test@ocpu.io'
username <- 'mail@ocpu.io'
password <- askpass::askpass(paste("SMTP server password for", username))
send_mail(sender, recipients, smtp_server = 'smtp.mailgun.org',
  message = message, username = username, password = password)}
}
