% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{VonMises}
\alias{VonMises}
\alias{dvon_mises}
\alias{pvon_mises}
\alias{rvon_mises}
\title{The von Mises Distribution}
\usage{
dvon_mises(x, mu, kappa, log = FALSE)

pvon_mises(q, mu, kappa, lower.tail = TRUE, log.p = FALSE, acc = 1e-20)

rvon_mises(n, mu, kappa)
}
\arguments{
\item{x, q}{Vector of quantiles.}

\item{mu}{Vector of location values.}

\item{kappa}{Vector of precision values.}

\item{log}{Logical; If \code{TRUE}, values are returned on the log scale.}

\item{lower.tail}{Logical; If \code{TRUE} (default), return P(X <= x).
Else, return P(X > x) .}

\item{log.p}{Logical; If \code{TRUE}, values are returned on the log scale.}

\item{acc}{Accuracy of numerical approximations.}

\item{n}{Number of draws to sample from the distribution.}
}
\description{
Density, distribution function, and random generation for the
von Mises distribution with location \code{mu}, and precision \code{kappa}.
}
\details{
See \code{vignette("brms_families")} for details
on the parameterization.
}
