% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ar_validate.R
\name{ar_validate}
\alias{ar_validate}
\title{Validating Data for Interpolation}
\usage{
ar_validate(source, target, varList, method = "aw", verbose = FALSE)
}
\arguments{
\item{source}{A \code{sf} object with data to be interpolated}

\item{target}{A \code{sf} object that data should be interpolated to}

\item{varList}{A vector of variable names to be added to the \code{target} object}

\item{method}{The areal interpolation method validation is being performed for. This
should be set to \code{"aw"}. Additional functionality will be added as the package
adds new interpolation techniques.}

\item{verbose}{A logical scalar; if \code{TRUE}, a tibble with test results is returned}
}
\value{
If \code{verbose} is \code{FALSE}, a logical scalar is returned that is \code{TRUE}
    is all tests are passed and \code{FALSE} if one or more tests is failed. If \code{verbose}
    is \code{TRUE}, a tibble with detailed test results is returned.
}
\description{
\code{ar_validate} executes a series of logic tests for \code{sf} object status,
    shared coordinates between source and target data, appropriate project, and absence of
    variable name conflicts.
}
\examples{
ar_validate(source = ar_stl_asthma, target = ar_stl_wards, varList = "ASTHMA")

ar_validate(source = ar_stl_asthma, target = ar_stl_wards, varList = "ASTHMA", verbose = TRUE)

}
\seealso{
\link{c}
}
