% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/methods_row.R
\name{colSums2,xgCMatrix-method}
\alias{colSums2,xgCMatrix-method}
\alias{rowSums2,xgCMatrix-method}
\title{Calculates the sum for each row (column) of a matrix-like object}
\usage{
\S4method{colSums2}{xgCMatrix}(x, rows = NULL, cols = NULL, na.rm = FALSE, useNames = NA)

\S4method{rowSums2}{xgCMatrix}(x, rows = NULL, cols = NULL, na.rm = FALSE, useNames = NA)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the sum for each row (column) of a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowSums2}} /
\code{matrixStats::\link[matrixStats]{colSums2}}.
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
mat[2, 1] <- NA
mat[3, 3] <- Inf
mat[4, 1] <- 0

print(mat)

rowSums2(mat)
colSums2(mat)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowSums2}()} and
\code{matrixStats::\link[matrixStats:rowSums2]{colSums2}()} which are used
when the input is a \code{matrix} or \code{numeric} vector.
\item For mean estimates, see \code{\link[MatrixGenerics]{rowMeans2}()} and
\code{\link[base:colSums]{rowMeans}()}.
\item \code{base::\link{sum}()}.
}
}
