\name{cellCounts}
\alias{cellCounts}
\title{Map and Count Single-Cell RNA Data Sets}
\description{The \code{cellCounts} function maps and counts reads in single-cell RNA (scRNA) data sets to generate cell-level UMI count tables.}
\usage{
cellCounts(

    # the mandatory arguments
    index,
    input.directory,
    output.BAM,
    sample.sheet,
    cell.barcode.list = NULL,
  
    # the optional arguments related to read mapping
    input.mode = "BCL",
    aligner = "align",
    nthreads = 16,
  
    # the optional arguments related to counting
    annot.inbuilt = "mm10",
    annot.ext = NULL,
    isGTFAnnotationFile = FALSE,
    GTF.featureType = "exon",
    GTF.attrType = "gene_id",
    GTF.attrType.extra = NULL,
    chrAliases = NULL,
    useMetaFeatures = TRUE,
    allowMultiOverlap = FALSE,
    countMultiMappingReads = TRUE)
}
\arguments{
  \item{index}{ a character string giving the subread index built by the {buildindex} function.}
  \item{input.directory}{ a character strings giving one or many directories containing the input data sets. Each data set should be put into an individual directory.}
  \item{output.BAM}{ a character strings giving one or many output file names, each corrsponding to an input directory. The output files are in the BAM format.}
  \item{sample.sheet}{ a character strings giving one or many sample sheet files in the CSV format, with each sample sheet corresponding to an input directory. See the Illumina bcl2fastq manual for the file format.}
  \item{cell.barcode.list}{ a character string giving the name of a textual file (can be gzipped) containing the set of cell barcodes used in sample preparation. All the input data sets must use the same cell barcode set. If \code{NULL} is given then a best cell barcode set is automatically chosen for the input data. \code{NULL} by default.}
  \item{input.mode}{ a character string giving the input mode. Currently only the BCL-format input (ie \code{"BCL"}) is supported.}
  \item{aligner}{ a character string giving the name of the aligner: \code{"align"} or \code{"subjunc"} (not yet implemented). A NULL value indicates the function to skip the mapping step but directly use the BAM file in \code{"output.BAM"} for generating UMI counts. \code{"align"} by default.}
  \item{nthreads}{ a numeric value giving the number of threads used for read mapping and counting. 16 by default.}
  \item{annot.inbuilt, annot.ext, isGTFAnnotationFile, GTF.featureType, GTF.attrType, GTF.attrType.extra, chrAliases, useMetaFeatures, allowMultiOverlap, countMultiMappingReads}{ options for counting the mapping results. The options have the same meanings as them \code{featureCounts}}
}

\details{
  \code{cellCounts} is designed to process single-cell RNA data that is generated by an Illumina sequencer. It does not need the data sets being demultiplexed and converted into fastq files, rather it does demultiplexing and BCL-format decoding on-the-fly. It is capable to process many data sets, each containing many samples, in one run.
}

\value{
  \code{cellCounts} returns a list object containing many elements. The \code{counts.*} elements give the counts of reads to each feature or meta-feature in each sample, the same as the returned object from \code{featureCounts}. The \code{scRNA.table.*} elements are tables giving the feature or meta-feature level UMI counts in each cells. 
}
\author{Wei Shi and Yang Liao}
