\name{plotTopMotifsGroup,MotifEnrichmentResults-method}
\alias{plotTopMotifsGroup}
\alias{plotTopMotifsGroup,MotifEnrichmentResults-method}
\title{Plot the top N enrichment motifs in a group of sequences}
\arguments{
  \item{obj}{a MotifEnrichmentResults object}

  \item{n}{the number of top ranked motifs to plot}

  \item{bg}{if to use background corrected P-values to do
  the ranking (if available)}

  \item{id}{if to show PWM IDs instead of target TF names}

  \item{...}{other parameters passed to
  \code{plotMultipleMotifs()}}
}
\description{
  Plot the top N enrichment motifs in a group of sequences
}
\examples{
if(require("PWMEnrich.Dmelanogaster.background")){
   ###
   # load the pre-compiled lognormal background
   data(PWMLogn.dm3.MotifDb.Dmel)

   # scan two sequences for motif enrichment
   sequences = list(DNAString("GAAGTATCAAGTGACCAGTAAGTCCCAGATGA"), DNAString("AGGTAGATAGAACAGTAGGCAATGAAGCCGATG"))

   res = motifEnrichment(sequences, PWMLogn.dm3.MotifDb.Dmel)

   # plot the top 4 motifs in a 2x2 grid
   plotTopMotifsGroup(res, 4)

   # plot top 3 motifs in a single row
   plotTopMotifsGroup(res, 3, row=1, cols=3)
}
}

