% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleData-class.R
\docType{methods}
\name{subset_samples}
\alias{subset_samples}
\title{Subset samples by sample_data expression}
\usage{
subset_samples(physeq, ...)
}
\arguments{
\item{physeq}{A \code{\link{sample_data-class}}, or a \code{\link{phyloseq-class}}
object with a 
\code{sample_data}. If the \code{sample_data} slot is missing in \code{physeq},
then \code{physeq} will be returned as-is, and a warning will be printed to screen.}

\item{...}{The subsetting expression that should be applied to the 
\code{sample_data}. This is passed on to \code{\link{subset}}, see its
documentation for more details.}
}
\value{
A subsetted object with the same class as \code{physeq}.
}
\description{
This is a convenience wrapper around the \code{\link{subset}} function.
It is intended to allow subsetting complex experimental objects with one
function call.
Subsetting is based on an expression for which the context first includes
the variables contained in \code{\link{sample_data}}.
The \code{samples} retained in the dataset is equivalent to
\code{x[subset & !is.na(subset)]}, where \code{x} is the vector of sample IDs
and \code{subset} is the logical that results from your subsetting expression.
This is important to keep in mind, as users are often unaware that this
subsetting step also removes/omits samples that have a missing value, \code{NA},
somewhere in the expression.
}
\examples{
 # data(GlobalPatterns)
 # subset_samples(GlobalPatterns, SampleType=="Ocean")
}
\seealso{
\code{\link{subset_species}}
}

