% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{plot_bar}
\alias{plot_bar}
\title{A flexible, informative barplot phyloseq data}
\usage{
plot_bar(physeq, x="Sample", y="Abundance", fill=NULL,
 title=NULL, facet_grid=NULL)
}
\arguments{
\item{physeq}{(Required). An \code{\link{otu_table-class}} or 
\code{\link{phyloseq-class}}.}

\item{x}{(Optional). Optional, but recommended, especially if your data
is comprised of many samples. A character string.
The variable in the melted-data that should be mapped to the x-axis.
See \code{\link{psmelt}}, \code{\link{melt}},
and \code{\link{ggplot}} for more details.}

\item{y}{(Optional). A character string.
The variable in the melted-data that should be mapped to the y-axis.
Typically this will be \code{"Abundance"}, in order to
quantitatively display the abundance values for each OTU/group. 
However, alternative variables could be used instead,
producing a very different, though possibly still informative, plot.
See \code{\link{psmelt}}, \code{\link{melt}},
and \code{\link{ggplot}} for more details.}

\item{fill}{(Optional). A character string. Indicates which sample variable
should be used to map to the fill color of the bars. 
The default is \code{NULL}, resulting in a gray fill for all bar segments.}

\item{title}{(Optional). Default \code{NULL}. Character string.
The main title for the graphic.}

\item{facet_grid}{(Optional). A formula object.
It should describe the faceting you want in exactly the same way as for 
\code{\link[ggplot2]{facet_grid}}, 
and is ulitmately provided to \code{\link{ggplot}}2 graphics.
The default is: \code{NULL}, resulting in no faceting.}
}
\value{
A \code{\link[ggplot2]{ggplot}}2 graphic object -- rendered in the graphical device
 as the default \code{\link[base]{print}}/\code{\link[methods]{show}} method.
}
\description{
There are many useful examples of phyloseq barplot graphics in the
\href{http://joey711.github.io/phyloseq/plot_bar-examples}{phyloseq online tutorials}.
This function wraps \code{ggplot2} plotting, and returns a \code{ggplot2}
 graphic object
that can be saved or further modified with additional layers, options, etc.
The main purpose of this function is to quickly and easily create informative
summary graphics of the differences in taxa abundance between samples in
an experiment.
}
\examples{
data("GlobalPatterns")
gp.ch = subset_taxa(GlobalPatterns, Phylum == "Chlamydiae")
plot_bar(gp.ch)
plot_bar(gp.ch, fill="Genus")
plot_bar(gp.ch, x="SampleType", fill="Genus")
plot_bar(gp.ch, "SampleType", fill="Genus", facet_grid=~Family)
# See additional examples in the plot_bar online tutorial. Link above.
}
\seealso{
\href{http://joey711.github.io/phyloseq/plot_bar-examples}{phyloseq online tutorials}.

 \code{\link{psmelt}}

 \code{\link{ggplot}}

 \code{\link{qplot}}
}

