\name{readSummaries}
\alias{readSummaries}
\title{Read summaries generated by crlmm}
\description{
  This function read the different summaries generated by crlmm.
}
\usage{
readSummaries(type, tmpdir)
}
\arguments{
  \item{type}{type of summary of \code{character} class: 'alleleA', 'alleleB', 'alleleA-sense',
    'alleleA-antisense', 'alleleB-sense', 'alleleB-antisense', 'calls',
    'llr', 'conf'.}
  \item{tmpdir}{directory containing the output saved by crlmm}
}

\details{
  On the 50K and 250K arrays, given a SNP, there are probes on both
  strands (sense and antisense). For this reason, the options
  'alleleA-sense', 'alleleA-antisense', 'alleleB-sense' and
  'alleleB-antisense' should be used **only** with such arrays (XBA,
  HIND, NSP or STY).

  On the SNP 5.0 and SNP 6.0 platforms, this distinction does not exist
  in terms of algorithm (note that the actual strand could be queried
  from the annotation package). For these arrays, options 'alleleA',
  'alleleB' are the ones to be used.

  The options \code{calls}, \code{llr} and \code{conf} will return,
  respectivelly, the CRLMM calls, log-likelihood ratios (for devel
  purpose **only**) and CRLMM confidence calls matrices.
}

\value{
  Matrix with values of summaries.
}
%% Add example
\keyword{manip}

