% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment_depletion_test.R
\name{enrichment_depletion_test}
\alias{enrichment_depletion_test}
\title{Test for enrichment or depletion of mutations in genomic regions}
\usage{
enrichment_depletion_test(x, by = c())
}
\arguments{
\item{x}{data.frame result from genomic_distribution()}

\item{by}{Optional grouping variable, e.g. tissue type}
}
\value{
data.frame with the observed and expected number of mutations per
genomic region per group (by) or sample
}
\description{
This function aggregates mutations per group (optional) and performs an
enrichment depletion test.
}
\examples{
## See the 'genomic_distribution()' example for how we obtained the
## following data:
distr <- readRDS(system.file("states/distr_data.rds",
                    package="MutationalPatterns"))

tissue <- c(rep("colon", 3), rep("intestine", 3), rep("liver", 3))

## Perform the enrichment/depletion test by tissue type.
distr_test <- enrichment_depletion_test(distr, by = tissue)

## Or without specifying the 'by' parameter.
distr_test2 <- enrichment_depletion_test(distr)

}
\seealso{
\code{\link{genomic_distribution}},
\code{\link{plot_enrichment_depletion}}
}
