% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiAssayExperiment-helpers.R
\name{MultiAssayExperiment-helpers}
\alias{MultiAssayExperiment-helpers}
\alias{intersectRows}
\alias{intersectColumns}
\alias{mergeReplicates}
\alias{replicated}
\alias{complete.cases,MultiAssayExperiment-method}
\alias{isEmpty,MultiAssayExperiment-method}
\alias{replicated,MultiAssayExperiment-method}
\alias{anyReplicated}
\alias{anyReplicated,MultiAssayExperiment-method}
\alias{mergeReplicates,MultiAssayExperiment-method}
\alias{mergeReplicates,ANY-method}
\alias{longFormat}
\alias{wideFormat}
\alias{hasRowRanges}
\alias{hasRowRanges,MultiAssayExperiment-method}
\alias{hasRowRanges,ExperimentList-method}
\alias{getWithColData}
\title{A group of helper functions for manipulating and cleaning a
MultiAssayExperiment}
\usage{
\S4method{complete.cases}{MultiAssayExperiment}(...)

\S4method{isEmpty}{MultiAssayExperiment}(x)

intersectRows(x)

intersectColumns(x)

replicated(x)

\S4method{replicated}{MultiAssayExperiment}(x)

anyReplicated(x)

\S4method{anyReplicated}{MultiAssayExperiment}(x)

mergeReplicates(x, replicates = list(), simplify = BiocGenerics::mean, ...)

\S4method{mergeReplicates}{MultiAssayExperiment}(
  x,
  replicates = replicated(x),
  simplify = BiocGenerics::mean,
  ...
)

\S4method{mergeReplicates}{ANY}(x, replicates = list(), simplify = BiocGenerics::mean, ...)

longFormat(object, colDataCols = NULL, i = 1L)

wideFormat(
  object,
  colDataCols = NULL,
  check.names = TRUE,
  collapse = "_",
  i = 1L
)

hasRowRanges(x)

\S4method{hasRowRanges}{MultiAssayExperiment}(x)

\S4method{hasRowRanges}{ExperimentList}(x)

getWithColData(x, i, mode = c("append", "replace"))
}
\arguments{
\item{...}{Additional arguments. See details for more information.}

\item{x}{A MultiAssayExperiment or ExperimentList}

\item{replicates}{A list of \linkS4class{LogicalList}s
indicating multiple / duplicate entries for each biological unit per assay,
see \code{replicated} (default \code{replicated(x)}).}

\item{simplify}{A function for merging repeat measurements in experiments
as indicated by the \code{replicated} method for \code{MultiAssayExperiment}}

\item{object}{Any supported class object}

\item{colDataCols}{A \code{character}, \code{logical}, or \code{numeric}
index for \code{colData} columns to be included}

\item{i}{The assay indicator for \linkS4class{SummarizedExperiment}
objects. A vector input is supported in the case that the
SummarizedExperiment object(s) has more than one assay (default 1L)}

\item{check.names}{(logical default TRUE) Column names of the output
\code{DataFrame} will be checked for syntactic validity and made unique,
if necessary}

\item{collapse}{(character default "_") A single string delimiter for output
column names. In \code{wideFormat}, experiments and rownames (and when
replicate samples are present, colnames) are seperated by this delimiter}

\item{mode}{String indicating how \linkS4class{MultiAssayExperiment}
column-level metadata should be added to the
\linkS4class{SummarizedExperiment} \code{colData}.}
}
\description{
A set of helper functions were created to help clean and
manipulate a MultiAssayExperiment object. \code{intersectRows} also works
for \code{ExperimentList} objects.

\itemize{
    \item complete.cases: Returns a logical vector corresponding to 'colData'
    rows that have data across all experiments
    \item isEmpty: Returns a logical \code{TRUE} value for zero length
    \code{MultiAssayExperiment} objects
    \item intersectRows: Takes all common rows across experiments,
    excludes experiments with empty rownames
    \item intersectColumns: A wrapper for \code{complete.cases} to return a
    \code{MultiAssayExperiment} with only those biological units that have
    measurements across all experiments
    \item replicated: A function that identifies multiple samples that
    originate from a single biological unit within each assay
    \item anyReplicated: Displays which assays have replicate measurements
    \item mergeReplicates: A function that combines replicated / repeated
    measurements across all experiments and is guided by the replicated
    return value
    \item longFormat: A \code{MultiAssayExperiment} method that
    returns a small and skinny \link{DataFrame}. The \code{colDataCols}
    arguments allows the user to append \code{colData} columns to the data.
    \item wideFormat: A function to return a wide \link{DataFrame} where
    each row represents an observation. Optional \code{colDataCols} can be
    added when using a \code{MultiAssayExperiment}.
    \item hasRowRanges: A function that identifies ExperimentList elements
    that have a \link[=RangedSummarizedExperiment-class]{rowRanges} method
    \item getWithColData: A convenience function for extracting an assay
    and associated colData
}
}
\details{
The \code{replicated} function finds replicate measurements in each
assay and returns a list of \linkS4class{LogicalList}s.
Each element in a single \linkS4class{LogicalList} corresponds to a
biological or \emph{primary} unit as in the \code{sampleMap}. Below is a
small graphic for one particular biological unit in one assay, where the
logical vector corresponds to the number of measurements/samples in the
assay:
\preformatted{
 >      replicated(MultiAssayExperiment)
 (list str)       '-- $ AssayName
 (LogicalList str)      '-- [[ "Biological Unit" ]]
 Replicated if sum(...) > 1          '-- TRUE TRUE FALSE FALSE
}
\code{anyReplicated} determines if any of the assays have at least one
replicate. \emph{Note}. These methods are not available for the
\code{ExperimentList} class due to a missing \code{sampleMap} structure
(by design).

The \code{mergeReplicates} function is a house-keeping method
for a \code{MultiAssayExperiment} where only \code{complete.cases} are
returned, replicate measurements are averaged (by default), and columns are
aligned by the row order in \code{colData}. Additional arguments can be
passed on to the \code{simplify} function.

The \code{mergeReplicates} "ANY" method consolidates duplicate
measurements for rectangular data structures, returns object of the same
class (endomorphic). The ellipsis or \code{\ldots} argument allows the
user to provide additional arguments to the \code{simplify} functional
argument.

The \code{longFormat} "ANY" class method, works with classes such as
\link{ExpressionSet} and \link{SummarizedExperiment} as well as \code{matrix}
to provide a consistent long and skinny \link{DataFrame}.

The \code{hasRowRanges} method identifies assays that support
a \link[=RangedSummarizedExperiment-class]{rowRanges} method \emph{and}
return a \linkS4class{GRanges} object.
}
\section{mergeReplicates}{

The \code{mergeReplicates} function makes use of the output from
\code{replicated} which will point out the duplicate measurements by
biological unit in the \code{MultiAssayExperiment}. This function will return
a \code{MultiAssayExperiment} with merged replicates. Additional arguments
can be provided to the simplify argument via the ellipsis (\ldots).
}

\section{longFormat}{

The longFormat method takes data from the \code{\link{ExperimentList}}
in a \code{\link{MultiAssayExperiment}} and returns a uniform
\code{\link{DataFrame}}. The resulting DataFrame has columns indicating
primary, rowname, colname and value. This method can optionally include
colData columns with the \code{colDataCols} argument
(\code{MultiAssayExperiment} method only). The \code{i} argument
allows the user to specify the assay value in a
\linkS4class{SummarizedExperiment}. It directly relates to the \code{i}
argument in the assay method.
}

\section{wideFormat}{

The \code{wideFormat} function returns standardized wide \link{DataFrame}
where each row represents a biological unit as in the \code{colData}.
Depending on the data and setup, biological units can be patients, tumors,
specimens, etc. Optionally, \code{colData} columns can be added to the
wide data output (see the \code{colDataCols} argument). Metadata columns are
generated based on the names produced in the wide format
\linkS4class{DataFrame}. These can be accessed via the
\link[=Vector-class]{mcols} function. See the \code{Arguments} and
\code{longFormat} sections for argument descriptions.
}

\section{hasRowRanges}{

The \code{hasRowRanges} method identifies assays with associated ranged
row data by directly testing the method on the object. The result from the
test must be a \linkS4class{GRanges} class object to satisfy the test.
}

\section{getWithColData}{

The \code{getWithColData} function allows the user to conveniently extract
a particular assay as indicated by the \strong{\code{i}} index argument. It
will also attempt to provide the
\code{\link[=SummarizedExperiment-class]{colData}} along with the
extracted object using the \code{colData<-} replacement
method when possible. Typically, this method is available for
\linkS4class{SummarizedExperiment} and \code{RaggedExperiment}
classes.

The setting of \code{mode} determines how the \code{\link{colData}}
is added. If \code{mode="append"}, the \linkS4class{MultiAssayExperiment}
metadata is appended onto that of the \linkS4class{SummarizedExperiment}.
If any fields are duplicated by name, the values in the \linkS4class{SummarizedExperiment}
are retained, with a warning emitted if the values are different.
For \code{mode="replace"}, the \linkS4class{MultiAssayExperiment}
metadata replaces that of the \linkS4class{SummarizedExperiment},
while for \code{mode="none"}, no replacement or appending is performed.
}

