% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{testForDEU}
\alias{testForDEU}
\title{Test for Differential Exon Usage}
\usage{
testForDEU(
  object,
  fullModel = design(object),
  reducedModel = ~sample + exon,
  BPPARAM = SerialParam(),
  fitType = c("DESeq2", "glmGamPoi")
)
}
\arguments{
\item{object}{A DEXSeqDataSet object.}

\item{fullModel}{The full model formula.}

\item{reducedModel}{Null model formula.}

\item{BPPARAM}{A "BiocParallelParam" instance. See \code{?bplapply} for details.}

\item{fitType}{Specifies what internal engine to use for fitting the GLMs. Options are "DESeq2" or "glmGamPoi".}
}
\value{
A \code{DEXSeqDataSet} with slots filled with information about the test.
}
\description{
This will perform a likelihood ratio test for differential
exon usage. Internally, it calls the DESeq2 function \code{nbinomLRT}.
}
\details{
The information of the variables of the formulas
should be present in the \code{colData} of the
\code{DEXSeqDataSet} object.
}
\examples{

data(pasillaDEXSeqDataSet, package="pasilla")
dxd <- estimateSizeFactors( dxd )
dxd <- estimateDispersions( dxd )
dxd <- testForDEU( dxd )
}
