% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotSparsity}
\alias{plotSparsity}
\title{Sparsity plot}
\usage{
plotSparsity(x, normalized = TRUE, ...)
}
\arguments{
\item{x}{a matrix or DESeqDataSet}

\item{normalized}{whether to normalize the counts from a DESeqDataSEt}

\item{...}{passed to \code{plot}}
}
\description{
A simple plot of the concentration of counts in a single sample over the
sum of counts per gene. Not technically the same as "sparsity", but this
plot is useful diagnostic for datasets which might not fit a negative
binomial assumption: genes with many zeros and individual very large
counts are difficult to model with the negative binomial distribution.
}
\examples{

dds <- makeExampleDESeqDataSet(n=1000,m=4,dispMeanRel=function(x) .5)
dds <- estimateSizeFactors(dds)
plotSparsity(dds)

}

