% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeMixT_S1.R
\name{DeMixT_S1}
\alias{DeMixT_S1}
\title{Estimates the proportions of mixed samples for each mixing component}
\usage{
DeMixT_S1(
  data.Y,
  data.N1,
  data.N2 = NULL,
  niter = 10,
  nbin = 50,
  if.filter = TRUE,
  filter.sd = 0.5,
  ngene.selected.for.pi = NA,
  nspikein = NULL,
  mean.diff.in.CM = 0.25,
  tol = 10^(-5),
  pi01 = NULL,
  pi02 = NULL,
  nthread = parallel::detectCores() - 1
)
}
\arguments{
\item{data.Y}{A SummarizedExperiment object of expression data from mixed 
tumor samples. It is a \eqn{G} by \eqn{My} matrix where \eqn{G} is the number
of genes and \eqn{My} is the number of mixed samples. Samples with the same
tissue type should be placed together in columns.}

\item{data.N1}{A SummarizedExperiment object of expression data 
from reference component 1 (e.g., normal). It is a \eqn{G} by \eqn{M1} matrix 
where \eqn{G} is the number of genes and \eqn{M1} is the number of samples 
for component 1.}

\item{data.N2}{A SummarizedExperiment object of expression data from
additional reference samples. It is a \eqn{G} by \eqn{M2} matrix where 
\eqn{G} is the number of genes and \eqn{M2} is the number of samples for
component 2. Component 2 is needed only for running a three-component model.}

\item{niter}{The maximum number of iterations used in the algorithm of 
iterated conditional modes. A larger value better guarantees 
the convergence in estimation but increases the running time. The default is 
10.}

\item{nbin}{The number of bins used in numerical integration for computing
complete likelihood. A larger value increases accuracy in estimation but
increases the running time, especially in a three-component deconvolution
problem. The default is 50.}

\item{if.filter}{The logical flag indicating whether a predetermined filter
rule is used to select genes for proportion estimation. The default is TRUE.}

\item{filter.sd}{The cut-off for the standard deviation of lognormal 
distribution. Genes whose log transferred standard deviation smaller than
the cut-off will be selected into the model. The default is 0.5.}

\item{ngene.selected.for.pi}{The percentage or the number of genes used for
proportion estimation. The difference between the expression levels from
mixed tumor samples and the known component(s) are evaluated, and the most
differential expressed genes are selected, which is called S1. It is enabled
when if.filter = TRUE. The default is \eqn{min(1500, 0.3*My)}, where
\eqn{My} is the number of mixed sample. Users can also try using more genes,
ranging from \eqn{0.3*My} to \eqn{0.5*My}, and evaluate the outcome.}

\item{nspikein}{The number of spikes in normal reference used for proportion
estimation. The default value is \eqn{ min(200, 0.3*My)}, where 
\eqn{My} the number of mixed samples. If it is set to 0, proportion 
estimation is performed without any spike in normal reference.}

\item{mean.diff.in.CM}{Threshold of expression difference for selecting genes
in the component merging strategy. We merge three-component to two-component
by selecting genes with similar expressions for the two known components.
Genes with the mean differences less than the threshold will be selected for
component merging. It is used in the three-component setting, and is enabled
when if.filter = TRUE. The default is 0.25.}

\item{tol}{The convergence criterion. The default is 10^(-5).}

\item{pi01}{Initialized proportion for first kown component. The default is 
\eqn{Null} and pi01 will be generated randomly from uniform distribution.}

\item{pi02}{Initialized proportion for second kown component. pi02 is needed 
only for running a three-component model. The default is \eqn{Null} and pi02 
will be generated randomly from uniform distribution.}

\item{nthread}{The number of threads used for deconvolution when OpenMP is
available in the system. The default is the number of whole threads minus one.
In our no-OpenMP version, it is set to 1.}
}
\value{
\item{pi}{A matrix of estimated proportion. First row and second row 
corresponds to the proportion estimate for the known components and unkown 
component respectively for two or three component settings, and each column 
corresponds to one sample.}
\item{pi.iter}{Estimated proportions in each iteration. It is a \eqn{niter 
*Ny*p} array, where \eqn{p} is the number of components. This is 
enabled only when output.more.info = TRUE.}
\item{gene.name}{The names of genes used in estimating the proportions. 
If no gene names are provided in the original data set, the genes will
be automatically indexed.}
}
\description{
This function is designed to estimate the deconvolved 
expressions of individual mixed tumor samples for unknown component 
for each gene.
}
\examples{
# Example 1: estimate proportions for simulated two-component data 
# with spike-in normal reference
  data(test.data.2comp)
# res.S1 = DeMixT_S1(data.Y = test.data.2comp$data.Y, 
#                    data.N1 = test.data.2comp$data.N1,
#                    niter = 10, nbin = 50, nspikein = 50,
#                    if.filter = TRUE, 
#                    mean.diff.in.CM = 0.25, ngene.selected.for.pi = 150,
#                    tol = 10^(-5))
#
# Example 2: estimate proportions for simulated two-component data 
# without spike-in normal reference
# data(test.data.2comp)
# res.S1 = DeMixT_S1(data.Y = test.data.2comp$data.Y, 
#                    data.N1 = test.data.2comp$data.N1,
#                    niter = 10, nbin = 50, nspikein = 0,
#                    if.filter = TRUE, 
#                    mean.diff.in.CM = 0.25, ngene.selected.for.pi = 150,
#                    tol = 10^(-5))
#
# Example 3: estimate proportions for simulated three-component 
# mixed cell line data 
# data(test.data.3comp)
# res.S1 <- DeMixT_S1(data.Y = test.data.3comp$data.Y,
#                     data.N1 = test.data.3comp$data.N1,
#                     data.N2 = test.data.3comp$data.N2, 
#                     if.filter = TRUE)

}
\references{
Wang Z, Cao S, Morris J S, et al. Transcriptome Deconvolution of 
Heterogeneous Tumor Samples with Immune Infiltration. iScience, 2018, 9: 451-460.
}
\seealso{
http://bioinformatics.mdanderson.org/main/DeMixT
}
\author{
Zeya Wang, Wenyi Wang
}
\keyword{DeMixT_S1}
