## ----exampleInpProcessing------------------------------------------------
makeinparanoid8ToAHMs <-
   function(currentMetadata, justRunUnitTests=FALSE, BiocVersion=biocVersion())
{
    baseUrl <- 'http://inparanoid.sbc.su.se/download/current/Orthologs_other_formats'
    ## Make list of metadata in a helper function
    meta <- .inparanoidMetadataFromUrl(baseUrl)
    ## then make AnnotationHubMetadata objects.
    Map(AnnotationHubMetadata,
        Description=meta$description,
        Genome=meta$genome,
        SourceFile=meta$sourceFile,
        SourceUrl=meta$sourceUrl,
        SourceVersion=meta$sourceVersion,
        Species=meta$species,
        TaxonomyId=meta$taxonomyId,
        Title=meta$title,
        RDataPath=meta$rDataPath,
        MoreArgs=list(
          Coordinate_1_based = TRUE,
          DataProvider = baseUrl,
          Maintainer = "Marc Carlson <mcarlson@fhcrc.org>",
          RDataClass = "SQLiteFile",
          RDataDateAdded = Sys.time(),
          RDataVersion = "0.0.1",
          Recipe = "AnnotationHubData:::inparanoid8ToDbsRecipe",
          Tags = c("Inparanoid", "Gene", "Homology", "Annotation")))
}

## ----exampleRecipe-------------------------------------------------------
inparanoid8ToDbsRecipe <-
    function(ahm)
{
    require(AnnotationForge)
    inputFiles <- metadata(ahm)$SourceFile
    dbname <- makeInpDb(dir=file.path(inputFiles,""),
                        dataDir=tempdir())
    db <- loadDb(file=dbname)
    outputPath <- file.path(metadata(ahm)$AnnotationHubRoot,
                            metadata(ahm)$RDataPath)
    saveDb(db, file=outputPath)
    outputFile(ahm)
}

## ---- eval=FALSE---------------------------------------------------------
#  setClass("BEDFileResource", contains="AnnotationHubResource")
#  
#  setMethod(".get1", "BEDFileResource",
#      function(x, ...)
#  {
#      .require("rtracklayer")
#      yy <- getHub(x)
#      dat <- rtracklayer::BEDFile(cache(yy))
#      rtracklayer::import(dat, format="bed", genome=yy$genome, ...)
#  })

## ----SessionInfo, echo=FALSE---------------------------------------------
sessionInfo()

