## ----style, echo = FALSE, results = 'asis'-------------------------------
BiocStyle::markdown()

## ----library, message=FALSE----------------------------------------------
library(AnnotationHub)

## ----AnnotationHub-------------------------------------------------------
ah = AnnotationHub()

## ----show----------------------------------------------------------------
ah

## ----dataprovider--------------------------------------------------------
unique(ah$dataprovider)

## ----species-------------------------------------------------------------
head(unique(ah$species))

## ----rdataclass----------------------------------------------------------
head(unique(ah$rdataclass))

## ----dm1-----------------------------------------------------------------
dm <- query(ah, c("ChainFile", "UCSC", "Drosophila melanogaster"))
dm

## ----show2---------------------------------------------------------------
df <- mcols(dm)

## ----length--------------------------------------------------------------
length(ah)

## ----subset--------------------------------------------------------------
ahs <- query(ah, c('inparanoid8', 'ailuropoda'))
ahs

## ----display, eval=FALSE-------------------------------------------------
#  d <- display(ah)

## ----dm2-----------------------------------------------------------------
dm
dm["AH15146"]

## ----dm3-----------------------------------------------------------------
dm[["AH15146"]]

## ----show-2--------------------------------------------------------------
ah

## ----snapshot------------------------------------------------------------
snapshotDate(ah)

## ----possibleDates-------------------------------------------------------
pd <- possibleDates(ah)
pd

## ----setdate, eval=FALSE-------------------------------------------------
#  snapshotDate(ah) <- pd[1]

## ----sessionInfo---------------------------------------------------------
sessionInfo()

