; ra.iss: install ra using inno installer
;
; RA_TODO add user internet setting to the Rgui command line
; RA_TODO only install quick start icon etc. if there is already an R quick start icon
; RA_TODO resolve {app} versus explicit directory name confusion -- Inno
;         seems to sometime use old R version for app -- why?

[Setup]
AppName=Ra
AppVerName=Ra 1.2.8
DefaultDirName={code:UserPF}\R\{code:RVersion}
DefaultGroupName=R
Compression=lzma/ultra
SolidCompression=yes
DisableStartupPrompt=yes
PrivilegesRequired=none
DisableDirPage=no
; don't ask "R-DIR already exists, install to that folder anyway?" else the user
; may think we are about to do something to his or her existing R installation
DirExistsWarning=no
; don't show "Select Start Menu Folder" window
DisableProgramGroupPage=yes
DisableReadyPage=yes
UninstallDisplayIcon={app}\bin-ra\Rgui.exe
SetupIconFile=..\..\src\gnuwin32\front-ends\R.ico
; following displayed in Add/Remove Programs for Ra
AppPublisher=www.milbo.users.sonic.net/ra

[Icons]
Name: "{group}\Ra\Ra"; Filename: "{app}\bin-ra\Rgui.exe"; WorkingDir: "{app}\bin-ra"
Name: "{group}\Ra\Uninstall Ra"; Filename: "{uninstallexe}"
Name: "{group}\Ra\Ra README"; Filename: "{app}\bin-ra\README-RaWin32.html"; IconFilename: "{app}\bin-ra\Rgui.exe"
Name: "{commondesktop}\Ra"; Filename: "{app}\bin-ra\Rgui.exe"; WorkingDir: "{app}\bin-ra"; MinVersion: 4,4
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\Ra"; Filename: "{app}\bin-ra\Rgui.exe"; WorkingDir: "{app}\bin-ra"

[Code]

function RVersion(Param:String): String;
begin
  Result := 'R-2.9.2';
end;

function IsAdmin: boolean;
begin
  Result := IsAdminLoggedOn or IsPowerUserLoggedOn;
end;

function UserPF(Param:String): String;
begin
  Result := ExpandConstant('{pf}');
  if (not IsAdmin) then
  begin
    try
      Result := ExpandConstant('{userdocs}');
    except
    // Do nothing, user doesn't have a My Documents folder
    end;
  end;
end;

procedure CurStepChanged(CurStep: TSetupStep);
var
  RDir: String;
  RGui: String;
begin
  if (CurStep = ssInstall) then // actual installation is about to start?
  begin
    RDir := ExpandConstant('{app}');
    if (not DirExists(RDir)) then
    begin
      MsgBox(RDir + ' does not exist' #13
             'Ra installation cannot continue.', mbError, MB_OK);
      Abort;
    end;
    RGui := ExpandConstant('{app}') + '\bin\Rgui.exe';
    if (not FileExists(RGui)) then
    begin
      MsgBox(RGui + ' does not exist' #13
             'Ra installation cannot continue.', mbError, MB_OK);
      Abort;
    end;
  end;
end;

[Messages]

SelectDirDesc=Please enter your existing R 2.9.2 directory.  Typically C:\Program Files\R\R-2.9.2.

[Files]

; Copy bin to bin-ra
Source: "{app}\bin\*"; DestDir: "{app}\bin-ra"; Flags: external ignoreversion

; Replace selected files in bin-ra with the Ra versions
Source: "..\..\bin\Rgui.exe";  DestDir: "{app}\bin-ra"; Flags: ignoreversion
Source: "..\..\bin\R.exe";     DestDir: "{app}\bin-ra"; Flags: ignoreversion
Source: "..\..\bin\R.dll";     DestDir: "{app}\bin-ra"; Flags: ignoreversion

Source: "..\ra.png"; DestDir: "{app}\bin-ra"; Flags: ignoreversion
Source: "README-RaWin32.html";   DestDir: "{app}\bin-ra"; Flags: ignoreversion isreadme

; Create jit library
Source: "..\..\library\jit\*";  DestDir: "{app}\library\jit"; Flags: ignoreversion recursesubdirs uninsneveruninstall
