/*! 
 *  @file
 *  @author Artem Iglikov <artem.iglikov@gmail.com>
 *  
 *  @section LICENSE
 *  
 *  This file is part of Qwit.
 *  
 *  Copyright (C) 2008, 2009 Artem Iglikov
 *  
 *  Qwit is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  Qwit is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with Qwit.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  @section DESCRIPTION
 *
 *  AccountConfigurationDialog class declaration
 */

#ifndef AccountConfigurationDialog_h
#define AccountConfigurationDialog_h

#include "ui_AccountConfigurationDialog.h"

#include "QwitHeaders.h"

class AccountConfigurationDialog: public QDialog, public Ui::AccountConfigurationDialog {
	Q_OBJECT
	
public:
	static const int ActionAdd = 0;
	static const int ActionEdit = 1;

	int action;
	int accountId;
	int accountType;
	
	AccountConfigurationDialog(QWidget *parent);
	
public slots:
	void useHttpsCheckBoxChanged(int state);
};

#endif
