$LOAD_PATH << '..' unless $LOAD_PATH.include? '..'
require 'qwik/ml-session'
require 'qwik/test-module-ml'

if $0 == __FILE__
  $test = true
end

class TestMSJapanese < Test::Unit::TestCase
  include TestModuleML

  def test_submit_1
    send_normal_mail('bob@example.net')
    ok_log(["[test]: New ML by bob@example.net",
	     "[test]: Add: bob@example.net",
	     "[test]: QwikPost: test"], 0..2)

    sm("eXg") { 'eB' }
    ok_log("[test]: QwikPost: 1
[test:2]: Send:")
    eq "eXg", @site['1'].get_title
    eq "* eXg
{{mail(bob@example.net,0)
eB
}}
", @site['1'].load

    sm("eXg") { 'eB' }
    ok_log("[test]: QwikPost: 1
[test:3]: Send:")
    eq "eXg", @site['1'].get_title
    # The new mail is added.
    eq "* eXg
{{mail(bob@example.net,0)
eB
}}
{{mail(bob@example.net,0)
eB
}}
", @site['1'].load

    unsubscribe('bob@example.net')		# close ML
    ok_log("[test]: Remove: bob@example.net
[test]: ML Closed
[test]: Unsubscribe: bob@example.net")
  end

  def test_submit_with_attach_image
    send_normal_mail('bob@example.net')
    ok_log(["[test]: New ML by bob@example.net",
	     "[test]: Add: bob@example.net",
	     "[test]: QwikPost: test"], 0..2)

    sm("eXg") {
"MIME-Version: 1.0
Content-Type: multipart/mixed; boundary=\"------_410DDC04C7AD046D3600_MULTIPART_MIXED_\"
Content-Transfer-Encoding: 7bit

--------_410DDC04C7AD046D3600_MULTIPART_MIXED_
Content-Type: text/plain; charset='ISO-2022-JP'
Content-Transfer-Encoding: 7bit

eB
--------_410DDC04C7AD046D3600_MULTIPART_MIXED_
Content-Type: image/png; name=\"1x1.png\"
Content-Disposition: attachment;
 filename=\"1x1.png\"
Content-Transfer-Encoding: base64

iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAIAAACQd1PeAAAADElEQVR42mP4//8/AAX+Av4zEpUU
AAAAAElFTkSuQmCC

--------_410DDC04C7AD046D3600_MULTIPART_MIXED_--
" }
    page = @site['1']
    eq "eXg", page.get_title
    eq true, @site.files('1').exist?('1x1.png')
  end

  def nu
    eq "* eXg
{{mail(bob@example.net,0)

eB

{{file(1x1.png)}}

}}
", page.load
  end
end
