# This file is part of qVamps.
#
# qVamps is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# qVamps is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with qVamps; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


use strict;
use warnings;

package Iso639;
use encoding "latin-1";


our %map =
(
  "aa" => "afar",
  "ab" => "Abkhazian",
  "ae" => "Avestan",
  "af" => "Afrikaans",
  "ak" => "akana",
  "am" => "amarinja",
  "ar" => "'arabiy",
  "as" => "Assamese",
  "av" => "Avar",
  "ay" => "aymara",
  "az" => "Azerbaijani",
  "ba" => "Bashkir",
  "be" => "belaruska mova",
  "bg" => "Bulgarian",
  "bh" => "Bihari",
  "bi" => "bislama",
  "bm" => "bambankan",
  "bn" => "Bengali",
  "bo" => "bod skad",
  "br" => "Brezhoneg",
  "bs" => "bosanski",
  "ca" => "catal",
  "ce" => "Chechen",
  "ch" => "Chamorro",
  "co" => "corsu",
  "cr" => "nhiyawa",
  "cs" => "Czech",
  "cu" => "cerkovno-slavnskij",
  "cv" => "Chuvash",
  "cy" => "Cymraeg",
  "da" => "dansk",
  "de" => "Deutsch",
  "dv" => "dhivehi",
  "dz" => "dzongkha",
  "ee" => "eve",
  "el" => "ellinik",
  "en" => "English",
  "eo" => "esperanto",
  "es" => "espaol",
  "et" => "eesti keel",
  "eu" => "euskera",
  "fa" => "frsy",
  "ff" => "fulfulde",
  "fi" => "suomi",
  "fj" => "Na Vosa Vakaviti",
  "fo" => "froyskt",
  "fr" => "franais",
  "fy" => "frysk",
  "ga" => "Gaeilge",
  "gd" => "Gidhlig",
  "gl" => "galego",
  "gn" => "guaran",
  "gu" => "Gujarati",
  "gv" => "Gaelg",
  "ha" => "hausa",
  "he" => "ivrit",
  "hi" => "Hindi",
  "ho" => "Hiri Motu",
  "hr" => "hrvatski jezik",
  "hu" => "magyar nyelv",
  "hy" => "hayeren lezow",
  "hz" => "otshiherero",
  "ia" => "interlingua",
  "id" => "bahasa Indonesia",
  "ie" => "interlingue",
  "ig" => "igbo",
  "ik" => "inupiaq",
  "in" => "bahasa Indonesia",
  "is" => "slenska",
  "it" => "italiano",
  "iu" => "inuktitut",
  "iw" => "ivrit",
  "ja" => "nihongo",
  "ji" => "Yiddish",
  "jv" => "bahasa Jawa",
  "ka" => "k'art'uli ena",
  "kg" => "kikongo",
  "ki" => "Gikuyu",
  "kj" => "oshikwanyama",
  "kk" => "Kazakh",
  "kl" => "kalaallisut",
  "km" => "khmr",
  "kn" => "Kannada",
  "ko" => "choson-o",
  "kr" => "kanuri",
  "ks" => "Kashmiri",
  "ku" => "zimany kurdy",
  "kv" => "komi kyv",
  "kw" => "Kernewek",
  "ky" => "kyrgyz tili",
  "la" => "lingua latina",
  "lb" => "ltzebuergesch",
  "lg" => "luganda",
  "ln" => "lingala",
  "lo" => "pha xa lao",
  "lt" => "Lithuanian",
  "lu" => "tshiluba",
  "lv" => "Latvian",
  "mg" => "Malagasy",
  "mh" => "Marshallese",
  "mi" => "Maori",
  "mk" => "makedonski",
  "ml" => "Malayalam",
  "mn" => "mongol",
  "mo" => "Moldavian",
  "mr" => "Marathi",
  "ms" => "bahasa Malaysia",
  "mt" => "il-Malti",
  "my" => "myanmasa",
  "na" => "nauru",
  "nb" => "bokml",
  "nd" => "isiNdebele",
  "ne" => "Nepali",
  "ng" => "oshindonga",
  "nl" => "Nederlands",
  "nn" => "nynorsk",
  "no" => "norsk",
  "nr" => "isiNdebele",
  "nv" => "din bizaad",
  "ny" => "tshichewa",
  "oc" => "occitan",
  "oj" => "chippewa",
  "om" => "oromo",
  "or" => "Oriya",
  "os" => "iron avzg",
  "pa" => "Punjabi",
  "pi" => "Pali",
  "pl" => "polski",
  "ps" => "pashto",
  "pt" => "portugus",
  "qu" => "qhtshwa",
  "rm" => "romontsch",
  "rn" => "kirundi",
  "ro" => "Romanian",
  "ru" => "russkij",
  "rw" => "kinyarwanda",
  "sa" => "Sanskrit",
  "sc" => "sardu",
  "sd" => "Sindhi",
  "se" => "davvismegiella",
  "sg" => "sango",
  "sh" => "srpskohrvatski",
  "si" => "Sinhala",
  "sk" => "slovensk",
  "sl" => "slovenski",
  "sm" => "samoa",
  "sn" => "chiShona",
  "so" => "soomaali",
  "sq" => "shqip",
  "sr" => "srpski",
  "ss" => "siSwati",
  "st" => "Sesotho",
  "su" => "bahasa Sunda",
  "sv" => "svenska",
  "sw" => "Kiswahili",
  "ta" => "Tamil",
  "te" => "telugu",
  "tg" => "Tajiki",
  "th" => "thai",
  "ti" => "tigria",
  "tk" => "trkmen dili",
  "tl" => "tagalog",
  "tn" => "Setswana",
  "to" => "tonga",
  "tr" => "trke",
  "ts" => "Xitsonga",
  "tt" => "tatar tele",
  "tw" => "twi",
  "ty" => "Tahitian",
  "ug" => "Uighur",
  "uk" => "ukrans'ka mova",
  "ur" => "Urdu",
  "uz" => "Uzbek",
  "ve" => "Venda",
  "vi" => "Vietnamese",
  "vo" => "volapk",
  "wo" => "wolof",
  "xh" => "isiXhosa",
  "yi" => "Yiddish",
  "yo" => "Yorb",
  "za" => "cuengh",
  "zh" => "zhongwen",
  "zu" => "isiZulu",
  "xx" =>
          "unspecified language",	#$translate
  "??" => 
          "unknown language"		#$translate
);


sub code2lang
{
  my $code = shift;

  return $map {$code};
}
