/*
 * hicumL2p1.core.cpp - device implementations for hicumL2p1 module
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include "hicumL2p1.analogfunction.h"

#include "logging.h"
#include "complex.h"
#include "matrix.h"
#include "object.h"
#include "node.h"
#include "circuit.h"
#include "net.h"
#include "component_id.h"
#include "constants.h"
#include "device.h"
#include "hicumL2p1.core.h"

// external nodes
#define c 0
#define b 1
#define e 2
#define s 3
#define tnode 4
// internal nodes
#define ci 5
#define ei 6
#define bp 7
#define bi 8
#define si 9

// useful macro definitions
#define NP(node) real (getV (node))
#define BP(pnode,nnode) (NP(pnode) - NP(nnode))
#define _load_static_residual2(pnode,nnode,current)\
	_rhs[pnode] -= current;\
	_rhs[nnode] += current;
#define _load_static_augmented_residual2(pnode,nnode,current)\
	_rhs[pnode] -= current;\
	_rhs[nnode] += current;
#define _load_static_residual1(node,current)\
	_rhs[node] -= current;
#define _load_static_augmented_residual1(node,current)\
	_rhs[node] -= current;
#define _load_static_jacobian4(pnode,nnode,vpnode,vnnode,conductance)\
	_jstat[pnode][vpnode] += conductance;\
	_jstat[nnode][vnnode] += conductance;\
	_jstat[pnode][vnnode] -= conductance;\
	_jstat[nnode][vpnode] -= conductance;\
	if (doHB) {\
	_ghs[pnode] += conductance * BP(vpnode,vnnode);\
	_ghs[nnode] -= conductance * BP(vpnode,vnnode);\
        } else {\
	_rhs[pnode] += conductance * BP(vpnode,vnnode);\
	_rhs[nnode] -= conductance * BP(vpnode,vnnode);\
	}
#define _load_static_jacobian2p(node,vpnode,vnnode,conductance)\
	_jstat[node][vpnode] += conductance;\
	_jstat[node][vnnode] -= conductance;\
	if (doHB) {\
        _ghs[node] += conductance * BP(vpnode,vnnode);\
        } else {\
        _rhs[node] += conductance * BP(vpnode,vnnode);\
	}
#define _load_static_jacobian2s(pnode,nnode,node,conductance)\
	_jstat[pnode][node] += conductance;\
	_jstat[nnode][node] -= conductance;\
	if (doHB) {\
	_ghs[pnode] += conductance * NP(node);\
	_ghs[nnode] -= conductance * NP(node);\
        } else {\
	_rhs[pnode] += conductance * NP(node);\
	_rhs[nnode] -= conductance * NP(node);\
	}
#define _load_static_jacobian1(node,vnode,conductance)\
	_jstat[node][vnode] += conductance;\
	if (doHB) {\
	_ghs[node] += conductance * NP(vnode);\
        } else {\
	_rhs[node] += conductance * NP(vnode);\
	}
#define _load_dynamic_residual2(pnode,nnode,charge)\
	if (doTR) _charges[pnode][nnode] += charge;\
	if (doHB) {\
	_qhs[pnode] -= charge;\
	_qhs[nnode] += charge;\
	}
#define _load_dynamic_residual1(node,charge)\
	if (doTR) _charges[node][node] += charge;\
	if (doHB) {\
	_qhs[node] -= charge;\
	}
#define _load_dynamic_jacobian4(pnode,nnode,vpnode,vnnode,capacitance)\
	if (doAC) {\
	_jdyna[pnode][vpnode] += capacitance;\
	_jdyna[nnode][vnnode] += capacitance;\
	_jdyna[pnode][vnnode] -= capacitance;\
	_jdyna[nnode][vpnode] -= capacitance;\
	}\
        if (doTR) {\
        _caps[pnode][nnode][vpnode][vnnode] += capacitance;\
  	}\
	if (doHB) {\
	_chs[pnode] += capacitance * BP(vpnode,vnnode);\
	_chs[nnode] -= capacitance * BP(vpnode,vnnode);\
	}
#define _load_dynamic_jacobian2s(pnode,nnode,vnode,capacitance)\
	if (doAC) {\
	_jdyna[pnode][vnode] += capacitance;\
	_jdyna[nnode][vnode] -= capacitance;\
	}\
	if (doTR) {\
	_caps[pnode][nnode][vnode][vnode] += capacitance;\
	}\
	if (doHB) {\
	_chs[pnode] += capacitance * NP(vnode);\
	_chs[nnode] -= capacitance * NP(vnode);\
	}
#define _load_dynamic_jacobian2p(node,vpnode,vnnode,capacitance)\
	if (doAC) {\
	_jdyna[node][vpnode] += capacitance;\
        _jdyna[node][vnnode] -= capacitance;\
        }\
	if (doTR) {\
        _caps[node][node][vpnode][vnnode] += capacitance;\
	}\
	if (doHB) {\
	_chs[node] += capacitance * BP(vpnode,vnnode);\
	}
#define _load_dynamic_jacobian1(node,vnode,capacitance)\
	if (doAC) {\
	_jdyna[node][vnode] += capacitance;\
	}\
	if (doTR) {\
	_caps[node][node][vnode][vnode] += capacitance;\
	}\
	if (doHB) {\
	_chs[node] += capacitance * NP(vnode);\
	}

#define _save_whitenoise1(n1,pwr,type)\
	_white_pwr[n1][n1] += pwr;
#define _save_whitenoise2(n1,n2,pwr,type)\
	_white_pwr[n1][n2] += pwr;
#define _save_flickernoise1(n1,pwr,exp,type)\
	_flicker_pwr[n1][n1] += pwr;\
	_flicker_exp[n1][n1] += exp;
#define _save_flickernoise2(n1,n2,pwr,exp,type)\
	_flicker_pwr[n1][n2] += pwr;\
	_flicker_exp[n1][n2] += exp;
#define _load_whitenoise2(n1,n2,pwr)\
	cy (n1,n2) -= pwr/kB/T0; cy (n2,n1) -= pwr/kB/T0;\
	cy (n1,n1) += pwr/kB/T0; cy (n2,n2) += pwr/kB/T0;
#define _load_whitenoise1(n1,pwr)\
	cy (n1,n1) += pwr/kB/T0;
#define _load_flickernoise2(n1,n2,pwr,exp)\
	cy (n1,n2) -= pwr*pow(_freq,-exp)/kB/T0;\
	cy (n2,n1) -= pwr*pow(_freq,-exp)/kB/T0;\
	cy (n1,n1) += pwr*pow(_freq,-exp)/kB/T0;\
	cy (n2,n2) += pwr*pow(_freq,-exp)/kB/T0;
#define _load_flickernoise1(n1,pwr,exp)\
	cy (n1,n1) += pwr*pow(_freq,-exp)/kB/T0;

// derivative helper macros
#define _cos(val,arg)            val = cos(arg);
#define _d_cos(val,dval,arg)     val = cos(arg);     dval = (-sin(arg));
#define _sin(val,arg)            val = sin(arg);
#define _d_sin(val,dval,arg)     val = sin(arg);     dval = (cos(arg));
#define _tan(val,arg)            val = tan(arg);
#define _d_tan(val,dval,arg)     val = tan(arg);     dval = (1.0/cos(arg)/cos(arg));
#define _hypot(xy,x,y)           xy = xhypot(x,y);
#define _dx_hypot(dx,xy,x,y)     dx = (x)/(xy);
#define _dy_hypot(dy,xy,x,y)     dy = (y)/(xy);
#define _max(xy,x,y)             xy = ((x)>(y))?(x):(y);
#define _dx_max(dx,xy,x,y)       dx = ((x)>(y))?1.0:0.0;
#define _dy_max(dy,xy,x,y)       dy = ((x)>(y))?0.0:1.0;
#define _min(xy,x,y)             xy = ((x)<(y))?(x):(y);
#define _dx_min(dx,xy,x,y)       dx = ((x)<(y))?1.0:0.0;
#define _dy_min(dy,xy,x,y)       dy = ((x)<(y))?0.0:1.0;
#define _cosh(val,arg)           val = cosh(arg);
#define _d_cosh(val,dval,arg)    val = cosh(arg);    dval = (sinh(arg));
#define _sinh(val,arg)           val = sinh(arg);
#define _d_sinh(val,dval,arg)    val = sinh(arg);    dval = (cosh(arg));
#define _tanh(val,arg)           val = tanh(arg);
#define _d_tanh(val,dval,arg)    val = tanh(arg);    dval = (1.0/cosh(arg)/cosh(arg));
#define _acos(val,arg)           val = acos(arg);
#define _d_acos(val,dval,arg)    val = acos(arg);    dval = (-1.0/sqrt(1-arg*arg));
#define _asin(val,arg)           val = asin(arg);
#define _d_asin(val,dval,arg)    val = asin(arg);    dval = (+1.0/sqrt(1-arg*arg));
#define _atan(val,arg)           val = atan(arg);
#define _d_atan(val,dval,arg)    val = atan(arg);    dval = (+1.0/(1+arg*arg));
#define _logE(val,arg)           val = log(arg);
#define _d_logE(val,dval,arg)    val = log(arg);     dval = (1.0/arg);
#define _log10(val,arg)          val = log10(arg);
#define _d_log10(val,dval,arg)   val = log10(arg);   dval = (1.0/arg/M_LN10);
#define _exp(val,arg)            val = exp(arg);
#define _d_exp(val,dval,arg)     val = exp(arg);     dval = val;
#define _sqrt(val,arg)           val = sqrt(arg);
#define _d_sqrt(val,dval,arg)    val = sqrt(arg);    dval = (1.0/val/2.0);
#define _pow(xy,x,y)             xy = pow(x,y);
#define _dx_pow(dx,xy,x,y)       dx = (x==0.0)?0.0:((y/x)*xy);
#define _dy_pow(dy,xy,x,y)       dy = (x==0.0)?0.0:((log(x)/exp(0.0))*xy);
#define _limexp(val,arg)         val = ((arg)<(80))?(exp(arg)):(exp(80)*(1.0+(arg-80)));
#define _d_limexp(val,dval,arg)  val = ((arg)<(80))?(exp(arg)):(exp(80)*(1.0+(arg-80))); dval = ((arg)<(80))?(exp(arg)):(exp(80));
#define _fabs(val,arg)           val = fabs(arg);
#define _d_fabs(val,dval,arg)    val = fabs(arg);    dval = (((val)>=0)?(+1.0):(-1.0));
#define _abs(val,arg)            val = ((arg)<(0)?(-(arg)):(arg));
#define _d_abs(val,dval,arg)     val = ((arg)<(0)?(-(arg)):(arg)); dval = (((arg)>=0)?(+1.0):(-1.0));
#define _vt(arg)                 (kBoverQ*(arg))
#define _d_vt(arg)               (kBoverQ)


// $vt and $vt() functions 
#define _vt_nom                  (kBoverQ)


// simulator specific definitions
#define _modelname               "hicumL2p1"
#define _instancename            getName()
#define _circuit_temp		 (getPropertyDouble ("Temp")+273.15)

using namespace device;

/* Device constructor. */
hicumL2p1::hicumL2p1() : circuit (10)
{
  type = CIR_hicumL2p1;
}

/* Initialization of model. */
void hicumL2p1::initModel (void)
{
  // create internal nodes
  setNode (ci, createInternal (getName (), "ci"));
  setNode (ei, createInternal (getName (), "ei"));
  setNode (bp, createInternal (getName (), "bp"));
  setNode (bi, createInternal (getName (), "bi"));
  setNode (si, createInternal (getName (), "si"));
}

/* Initialization of DC analysis. */
void hicumL2p1::initDC (void)
{
  allocMatrixMNA ();
  initModel ();
  char * type = getPropertyString ("Type");
  pol = (type != NULL && !strcmp (type, "pnp")) ? -1 : 1;
  restartDC ();
  doAC = 1;
  doTR = 0;
  doHB = 0;
}

/* Run when DC is restarted (fallback algorithms). */
void hicumL2p1::restartDC (void)
{
}

/* Initialize Verilog-AMS code. */
void hicumL2p1::initVerilog (void)
{
  // initialization of noise variables
  _white_pwr[ci][bi] = 0.0;
  _white_pwr[si][s] = 0.0;
  _white_pwr[ei][e] = 0.0;
  _white_pwr[ci][c] = 0.0;
  _white_pwr[bp][bi] = 0.0;
  _white_pwr[b][bp] = 0.0;
  _white_pwr[ci][ei] = 0.0;
  _white_pwr[si][ci] = 0.0;
  _white_pwr[bi][ci] = 0.0;
  _white_pwr[bp][ci] = 0.0;
  _white_pwr[bi][ei] = 0.0;
  _white_pwr[bp][ei] = 0.0;
  _flicker_pwr[bi][ei] = 0.0;
  _flicker_exp[bi][ei] = 0.0;

  int i1, i2, i3, i4;

  // zero charges
  for (i1 = 0; i1 < 10; i1++) {
  for (i2 = 0; i2 < 10; i2++) {
    _charges[i1][i2] = 0.0;
  } }

  // zero capacitances
  for (i1 = 0; i1 < 10; i1++) {
  for (i2 = 0; i2 < 10; i2++) {
  for (i3 = 0; i3 < 10; i3++) {
  for (i4 = 0; i4 < 10; i4++) {
    _caps[i1][i2][i3][i4] = 0.0;
  } } } }

  // zero right hand side, static and dynamic jacobian
  for (i1 = 0; i1 < 10; i1++) {
    _rhs[i1] = 0.0;
    _qhs[i1] = 0.0;
    _chs[i1] = 0.0;
    _ghs[i1] = 0.0;
    for (i2 = 0; i2 < 10; i2++) {
      _jstat[i1][i2] = 0.0;
      _jdyna[i1][i2] = 0.0;
    }
  }
}

/* Evaluate Verilog-AMS equations. */
void hicumL2p1::calcVerilog (void)
{
  // get device model parameters
  int pnp = getPropertyInteger ("pnp");
  int npn = getPropertyInteger ("npn");
  nr_double_t c10 = getPropertyDouble ("c10");
  nr_double_t qp0 = getPropertyDouble ("qp0");
  nr_double_t ich = getPropertyDouble ("ich");
  nr_double_t hfe = getPropertyDouble ("hfe");
  nr_double_t hfc = getPropertyDouble ("hfc");
  nr_double_t hjei = getPropertyDouble ("hjei");
  nr_double_t hjci = getPropertyDouble ("hjci");
  nr_double_t ibeis = getPropertyDouble ("ibeis");
  nr_double_t mbei = getPropertyDouble ("mbei");
  nr_double_t ireis = getPropertyDouble ("ireis");
  nr_double_t mrei = getPropertyDouble ("mrei");
  nr_double_t ibeps = getPropertyDouble ("ibeps");
  nr_double_t mbep = getPropertyDouble ("mbep");
  nr_double_t ireps = getPropertyDouble ("ireps");
  nr_double_t mrep = getPropertyDouble ("mrep");
  nr_double_t mcf = getPropertyDouble ("mcf");
  nr_double_t ibcis = getPropertyDouble ("ibcis");
  nr_double_t mbci = getPropertyDouble ("mbci");
  nr_double_t ibcxs = getPropertyDouble ("ibcxs");
  nr_double_t mbcx = getPropertyDouble ("mbcx");
  nr_double_t ibets = getPropertyDouble ("ibets");
  nr_double_t abet = getPropertyDouble ("abet");
  nr_double_t favl = getPropertyDouble ("favl");
  nr_double_t qavl = getPropertyDouble ("qavl");
  nr_double_t alfav = getPropertyDouble ("alfav");
  nr_double_t alqav = getPropertyDouble ("alqav");
  nr_double_t rbi0 = getPropertyDouble ("rbi0");
  nr_double_t rbx = getPropertyDouble ("rbx");
  nr_double_t fgeo = getPropertyDouble ("fgeo");
  nr_double_t fdqr0 = getPropertyDouble ("fdqr0");
  nr_double_t fcrbi = getPropertyDouble ("fcrbi");
  nr_double_t fqi = getPropertyDouble ("fqi");
  nr_double_t re = getPropertyDouble ("re");
  nr_double_t rcx = getPropertyDouble ("rcx");
  nr_double_t itss = getPropertyDouble ("itss");
  nr_double_t msf = getPropertyDouble ("msf");
  nr_double_t iscs = getPropertyDouble ("iscs");
  nr_double_t msc = getPropertyDouble ("msc");
  nr_double_t tsf = getPropertyDouble ("tsf");
  nr_double_t rsu = getPropertyDouble ("rsu");
  nr_double_t csu = getPropertyDouble ("csu");
  nr_double_t cjei0 = getPropertyDouble ("cjei0");
  nr_double_t vdei = getPropertyDouble ("vdei");
  nr_double_t zei = getPropertyDouble ("zei");
  nr_double_t aljei = getPropertyDouble ("aljei");
  nr_double_t cjep0 = getPropertyDouble ("cjep0");
  nr_double_t vdep = getPropertyDouble ("vdep");
  nr_double_t zep = getPropertyDouble ("zep");
  nr_double_t aljep = getPropertyDouble ("aljep");
  nr_double_t cjci0 = getPropertyDouble ("cjci0");
  nr_double_t vdci = getPropertyDouble ("vdci");
  nr_double_t zci = getPropertyDouble ("zci");
  nr_double_t vptci = getPropertyDouble ("vptci");
  nr_double_t cjcx0 = getPropertyDouble ("cjcx0");
  nr_double_t vdcx = getPropertyDouble ("vdcx");
  nr_double_t zcx = getPropertyDouble ("zcx");
  nr_double_t vptcx = getPropertyDouble ("vptcx");
  nr_double_t fbc = getPropertyDouble ("fbc");
  nr_double_t cjs0 = getPropertyDouble ("cjs0");
  nr_double_t vds = getPropertyDouble ("vds");
  nr_double_t zs = getPropertyDouble ("zs");
  nr_double_t vpts = getPropertyDouble ("vpts");
  nr_double_t t0 = getPropertyDouble ("t0");
  nr_double_t dt0h = getPropertyDouble ("dt0h");
  nr_double_t tbvl = getPropertyDouble ("tbvl");
  nr_double_t tef0 = getPropertyDouble ("tef0");
  nr_double_t gtfe = getPropertyDouble ("gtfe");
  nr_double_t thcs = getPropertyDouble ("thcs");
  nr_double_t alhc = getPropertyDouble ("alhc");
  nr_double_t fthc = getPropertyDouble ("fthc");
  nr_double_t rci0 = getPropertyDouble ("rci0");
  nr_double_t vlim = getPropertyDouble ("vlim");
  nr_double_t vces = getPropertyDouble ("vces");
  nr_double_t vpt = getPropertyDouble ("vpt");
  nr_double_t tr = getPropertyDouble ("tr");
  nr_double_t ceox = getPropertyDouble ("ceox");
  nr_double_t ccox = getPropertyDouble ("ccox");
  nr_double_t alqf = getPropertyDouble ("alqf");
  nr_double_t alit = getPropertyDouble ("alit");
  nr_double_t kf = getPropertyDouble ("kf");
  nr_double_t af = getPropertyDouble ("af");
  nr_double_t krbi = getPropertyDouble ("krbi");
  nr_double_t latb = getPropertyDouble ("latb");
  nr_double_t latl = getPropertyDouble ("latl");
  nr_double_t vgb = getPropertyDouble ("vgb");
  nr_double_t alt0 = getPropertyDouble ("alt0");
  nr_double_t kt0 = getPropertyDouble ("kt0");
  nr_double_t zetaci = getPropertyDouble ("zetaci");
  nr_double_t zetacx = getPropertyDouble ("zetacx");
  nr_double_t alvs = getPropertyDouble ("alvs");
  nr_double_t alces = getPropertyDouble ("alces");
  nr_double_t zetarbi = getPropertyDouble ("zetarbi");
  nr_double_t zetarbx = getPropertyDouble ("zetarbx");
  nr_double_t zetarcx = getPropertyDouble ("zetarcx");
  nr_double_t zetare = getPropertyDouble ("zetare");
  nr_double_t alb = getPropertyDouble ("alb");
  nr_double_t rth = getPropertyDouble ("rth");
  nr_double_t cth = getPropertyDouble ("cth");
  nr_double_t tnom = getPropertyDouble ("tnom");
  nr_double_t dt = getPropertyDouble ("dt");


/* ----------------- evaluate verilog analog equations -------------------- */
double flicker_Pwr_Vtnode_GND=0.0;
double flicker_Pwr_Vbi_ei=0.0;
double flicker_Pwr_Vbp_ei=0.0;
double flicker_Pwr_Vbi_ci=0.0;
double rbin_Vtnode_GND=0.0;
double rbin_Vbi_ei=0.0;
double rbin_Vci_ei=0.0;
double rbin_Vbi_ci=0.0;
double fourkt_Vtnode_GND=0.0;
double pterm_Vci_ei=0.0;
double pterm_Vtnode_GND=0.0;
double pterm_Vbi_ei=0.0;
double pterm_Vbi_ci=0.0;
double ijsc_Vtnode_GND=0.0;
double ijsc_Vsi_ci=0.0;
double ijsc_Vbp_ci=0.0;
double ijsc_Vbp_ei=0.0;
double ijsc_Vbi_ci=0.0;
double ijsc_Vbi_ei=0.0;
double Qdsu_Vtnode_GND=0.0;
double Qdsu_Vbp_ci=0.0;
double HSI_Tsu_Vtnode_GND=0.0;
double HSI_Tsu_Vbp_ci=0.0;
double HSI_Tsu_Vsi_ci=0.0;
double HSb_Vsi_ci=0.0;
double HSb_Vtnode_GND=0.0;
double HSa_Vbp_ci=0.0;
double HSa_Vtnode_GND=0.0;
double HSUM_Vtnode_GND=0.0;
double Qjs_Vbp_ei=0.0;
double Qjs_Vbi_ei=0.0;
double Qjs_Vsi_ci=0.0;
double Qjs_Vb_ci=0.0;
double Qjs_Vbp_ci=0.0;
double Qjs_Vtnode_GND=0.0;
double Qjs_Vbi_ci=0.0;
double qjcx0_t_i_Vbp_ei=0.0;
double qjcx0_t_i_Vbi_ei=0.0;
double qjcx0_t_i_Vb_ci=0.0;
double qjcx0_t_i_Vbp_ci=0.0;
double qjcx0_t_i_Vtnode_GND=0.0;
double qjcx0_t_i_Vbi_ci=0.0;
double ijbcx_Vtnode_GND=0.0;
double ijbcx_Vbp_ci=0.0;
double ijbcx_Vbp_ei=0.0;
double ijbcx_Vbi_ci=0.0;
double ijbcx_Vbi_ei=0.0;
double qjcx0_t_ii_Vbp_ei=0.0;
double qjcx0_t_ii_Vbi_ei=0.0;
double qjcx0_t_ii_Vbp_ci=0.0;
double qjcx0_t_ii_Vtnode_GND=0.0;
double qjcx0_t_ii_Vbi_ci=0.0;
double ibet_Vtnode_GND=0.0;
double ibet_Vbp_ei=0.0;
double ibet_Vbi_ci=0.0;
double ibet_Vbi_ei=0.0;
double czz_Vtnode_GND=0.0;
double czz_Vbp_ei=0.0;
double czz_Vbi_ci=0.0;
double czz_Vbi_ei=0.0;
double pocce_Vbp_ei=0.0;
double pocce_Vbi_ci=0.0;
double pocce_Vtnode_GND=0.0;
double pocce_Vbi_ei=0.0;
double cce_Vbp_ei=0.0;
double cce_Vbi_ci=0.0;
double cce_Vtnode_GND=0.0;
double cce_Vbi_ei=0.0;
double vve_Vbp_ei=0.0;
double vve_Vtnode_GND=0.0;
double ibets_t_Vtnode_GND=0.0;
double ab_Vtnode_GND=0.0;
double a_eg_Vtnode_GND=0.0;
double Qjep_Vbp_ei=0.0;
double Qjep_Vbi_ci=0.0;
double Qjep_Vtnode_GND=0.0;
double Qjep_Vbi_ei=0.0;
double Cjep_Vbp_ei=0.0;
double Cjep_Vbi_ci=0.0;
double Cjep_Vtnode_GND=0.0;
double Cjep_Vbi_ei=0.0;
double irep_Vtnode_GND=0.0;
double irep_Vbp_ei=0.0;
double irep_Vbi_ci=0.0;
double irep_Vbi_ei=0.0;
double ibep_Vtnode_GND=0.0;
double ibep_Vbp_ei=0.0;
double ibep_Vbi_ci=0.0;
double ibep_Vbi_ei=0.0;
double ETA_Vtnode_GND=0.0;
double ETA_Vbi_ei=0.0;
double ETA_Vci_ei=0.0;
double ETA_Vbi_ci=0.0;
double I_BI_Vtnode_GND=0.0;
double I_BI_Vbi_ei=0.0;
double rbi_Vtnode_GND=0.0;
double rbi_Vbi_ei=0.0;
double rbi_Vci_ei=0.0;
double rbi_Vbi_ci=0.0;
double f_p_Vtnode_GND=0.0;
double f_p_Vbi_ei=0.0;
double f_p_Vci_ei=0.0;
double f_p_Vbi_ci=0.0;
double Q_fi_Vci_ei=0.0;
double Q_fi_Vtnode_GND=0.0;
double Q_fi_Vbi_ci=0.0;
double Q_fi_Vbi_ei=0.0;
double Qz_Vtnode_GND=0.0;
double Qz_Vbi_ei=0.0;
double Qz_Vci_ei=0.0;
double Qz_Vbi_ci=0.0;
double f_QR_Vtnode_GND=0.0;
double iavl_Vci_ei=0.0;
double iavl_Vtnode_GND=0.0;
double iavl_Vbi_ei=0.0;
double iavl_Vbi_ci=0.0;
double AVLS_avl_Vtnode_GND=0.0;
double AVLS_avl_Vbi_ei=0.0;
double AVLS_avl_Vbi_ci=0.0;
double AVLa_Vtnode_GND=0.0;
double AVLa_Vbi_ei=0.0;
double AVLa_Vbi_ci=0.0;
double AVLU0_Vtnode_GND=0.0;
double AVLv_q_Vtnode_GND=0.0;
double AVLv_q_Vbi_ei=0.0;
double AVLv_q_Vbi_ci=0.0;
double AVLv_bord_Vtnode_GND=0.0;
double AVLv_bord_Vbi_ci=0.0;
double ibci_Vtnode_GND=0.0;
double ibci_Vbi_ci=0.0;
double ibci_Vbi_ei=0.0;
double qrbi_Vtnode_GND=0.0;
double qrbi_Vbi_ei=0.0;
double qrbi_Vci_ei=0.0;
double qrbi_Vbi_ci=0.0;
double Qdci_Vci_ei=0.0;
double Qdci_Vtnode_GND=0.0;
double Qdci_Vbi_ci=0.0;
double Qdci_Vbi_ei=0.0;
double Qdei_Vci_ei=0.0;
double Qdei_Vtnode_GND=0.0;
double Qdei_Vbi_ci=0.0;
double Qdei_Vbi_ei=0.0;
double it_Vci_ei=0.0;
double it_Vtnode_GND=0.0;
double it_Vbi_ei=0.0;
double it_Vbi_ci=0.0;
double d_Q_Vtnode_GND=0.0;
double d_Q_Vbi_ei=0.0;
double d_Q_Vbi_ci=0.0;
double d_Q_Vci_ei=0.0;
double Q_pT_Vtnode_GND=0.0;
double Q_pT_Vbi_ei=0.0;
double Q_pT_Vbi_ci=0.0;
double Q_pT_Vci_ei=0.0;
double Qr_Vci_ei=0.0;
double Qr_Vtnode_GND=0.0;
double Qr_Vbi_ci=0.0;
double Qr_Vbi_ei=0.0;
double FCd_f_Vci_ei=0.0;
double FCd_f_Vtnode_GND=0.0;
double FCd_f_Vbi_ei=0.0;
double FCd_f_Vbi_ci=0.0;
double FCz_1_Vci_ei=0.0;
double FCz_1_Vtnode_GND=0.0;
double FCz_1_Vbi_ei=0.0;
double FCz_1_Vbi_ci=0.0;
double FCdfCT_ditf_Vci_ei=0.0;
double FCdfCT_ditf_Vbi_ei=0.0;
double FCdfCT_ditf_Vbi_ci=0.0;
double FCdfCT_ditf_Vtnode_GND=0.0;
double FCdfCT_dw_Vci_ei=0.0;
double FCdfCT_dw_Vbi_ei=0.0;
double FCdfCT_dw_Vbi_ci=0.0;
double FCdfCT_dw_Vtnode_GND=0.0;
double FCdfc_ditf_Vci_ei=0.0;
double FCdfc_ditf_Vtnode_GND=0.0;
double FCdfc_ditf_Vbi_ei=0.0;
double FCdfc_ditf_Vbi_ci=0.0;
double FCdw_ditf_Vci_ei=0.0;
double FCdw_ditf_Vtnode_GND=0.0;
double FCdw_ditf_Vbi_ei=0.0;
double FCdw_ditf_Vbi_ci=0.0;
double FCdfc_dw_Vci_ei=0.0;
double FCdfc_dw_Vtnode_GND=0.0;
double FCdfc_dw_Vbi_ei=0.0;
double FCdfc_dw_Vbi_ci=0.0;
double FCf_ci_Vci_ei=0.0;
double FCf_ci_Vtnode_GND=0.0;
double FCf_ci_Vbi_ei=0.0;
double FCf_ci_Vbi_ci=0.0;
double FCdf3_dw_Vci_ei=0.0;
double FCdf3_dw_Vtnode_GND=0.0;
double FCdf3_dw_Vbi_ei=0.0;
double FCdf3_dw_Vbi_ci=0.0;
double FCf3_Vci_ei=0.0;
double FCf3_Vbi_ei=0.0;
double FCf3_Vbi_ci=0.0;
double FCf3_Vtnode_GND=0.0;
double FCdf2_dw_Vci_ei=0.0;
double FCdf2_dw_Vtnode_GND=0.0;
double FCdf2_dw_Vbi_ei=0.0;
double FCdf2_dw_Vbi_ci=0.0;
double FCf2_Vci_ei=0.0;
double FCf2_Vbi_ei=0.0;
double FCf2_Vbi_ci=0.0;
double FCf2_Vtnode_GND=0.0;
double a3_Vci_ei=0.0;
double a3_Vbi_ei=0.0;
double a3_Vbi_ci=0.0;
double a3_Vtnode_GND=0.0;
double a2_Vci_ei=0.0;
double a2_Vbi_ei=0.0;
double a2_Vbi_ci=0.0;
double a2_Vtnode_GND=0.0;
double x_Vci_ei=0.0;
double x_Vtnode_GND=0.0;
double x_Vbi_ei=0.0;
double x_Vbi_ci=0.0;
double z_Vci_ei=0.0;
double z_Vtnode_GND=0.0;
double z_Vbi_ei=0.0;
double z_Vbi_ci=0.0;
double FCdf1_dw_Vci_ei=0.0;
double FCdf1_dw_Vtnode_GND=0.0;
double FCdf1_dw_Vbi_ei=0.0;
double FCdf1_dw_Vbi_ci=0.0;
double FCw2_Vci_ei=0.0;
double FCw2_Vtnode_GND=0.0;
double FCw2_Vbi_ei=0.0;
double FCw2_Vbi_ci=0.0;
double FCf_CT_Vci_ei=0.0;
double FCf_CT_Vbi_ei=0.0;
double FCf_CT_Vbi_ci=0.0;
double FCf_CT_Vtnode_GND=0.0;
double FCf1_Vci_ei=0.0;
double FCf1_Vtnode_GND=0.0;
double FCf1_Vbi_ei=0.0;
double FCf1_Vbi_ci=0.0;
double FCda1_dw_Vci_ei=0.0;
double FCda1_dw_Vtnode_GND=0.0;
double FCda1_dw_Vbi_ei=0.0;
double FCda1_dw_Vbi_ci=0.0;
double FClnl_Vci_ei=0.0;
double FClnl_Vtnode_GND=0.0;
double FClnl_Vbi_ei=0.0;
double FClnl_Vbi_ci=0.0;
double FClnb_Vci_ei=0.0;
double FClnb_Vtnode_GND=0.0;
double FClnb_Vbi_ei=0.0;
double FClnb_Vbi_ci=0.0;
double FCdw_daick_Vci_ei=0.0;
double FCdw_daick_Vtnode_GND=0.0;
double FCdw_daick_Vbi_ei=0.0;
double FCdw_daick_Vbi_ci=0.0;
double FCw_Vci_ei=0.0;
double FCw_Vtnode_GND=0.0;
double FCw_Vbi_ei=0.0;
double FCw_Vbi_ci=0.0;
double FCd_a_Vci_ei=0.0;
double FCd_a_Vtnode_GND=0.0;
double FCd_a_Vbi_ei=0.0;
double FCd_a_Vbi_ci=0.0;
double FCa1_Vci_ei=0.0;
double FCa1_Vtnode_GND=0.0;
double FCa1_Vbi_ei=0.0;
double FCa1_Vbi_ci=0.0;
double FCz_Vci_ei=0.0;
double FCz_Vtnode_GND=0.0;
double FCz_Vbi_ei=0.0;
double FCz_Vbi_ci=0.0;
double FCdaick_ditf_Vci_ei=0.0;
double FCdaick_ditf_Vtnode_GND=0.0;
double FCdaick_ditf_Vbi_ei=0.0;
double FCdaick_ditf_Vbi_ci=0.0;
double FCa_ck_Vci_ei=0.0;
double FCa_ck_Vtnode_GND=0.0;
double FCa_ck_Vbi_ei=0.0;
double FCa_ck_Vbi_ci=0.0;
double FCrt_Vci_ei=0.0;
double FCrt_Vtnode_GND=0.0;
double FCrt_Vbi_ei=0.0;
double FCrt_Vbi_ci=0.0;
double FCa_Vci_ei=0.0;
double FCa_Vtnode_GND=0.0;
double FCa_Vbi_ei=0.0;
double FCa_Vbi_ci=0.0;
double FFT_cT_Vtnode_GND=0.0;
double FFT_cT_Vci_ei=0.0;
double FFT_cT_Vbi_ei=0.0;
double FFT_cT_Vbi_ci=0.0;
double FFQ_cT_Vtnode_GND=0.0;
double FFQ_cT_Vbi_ei=0.0;
double FFQ_cT_Vbi_ci=0.0;
double FFQ_cT_Vci_ei=0.0;
double FFT_fC_Vtnode_GND=0.0;
double FFT_fC_Vci_ei=0.0;
double FFT_fC_Vbi_ei=0.0;
double FFT_fC_Vbi_ci=0.0;
double FFQ_fC_Vtnode_GND=0.0;
double FFQ_fC_Vbi_ei=0.0;
double FFQ_fC_Vbi_ci=0.0;
double FFQ_fC_Vci_ei=0.0;
double FFT_pcS_Vtnode_GND=0.0;
double FFd_TfB_Vtnode_GND=0.0;
double FFd_TfB_Vci_ei=0.0;
double FFd_TfB_Vbi_ei=0.0;
double FFd_TfB_Vbi_ci=0.0;
double FFa_w_Vci_ei=0.0;
double FFa_w_Vtnode_GND=0.0;
double FFa_w_Vbi_ei=0.0;
double FFa_w_Vbi_ci=0.0;
double FFd_QfB_Vtnode_GND=0.0;
double FFd_QfB_Vbi_ei=0.0;
double FFd_QfB_Vbi_ci=0.0;
double FFd_QfB_Vci_ei=0.0;
double FFw_2_Vci_ei=0.0;
double FFw_2_Vtnode_GND=0.0;
double FFw_2_Vbi_ei=0.0;
double FFw_2_Vbi_ci=0.0;
double FFw_Vci_ei=0.0;
double FFw_Vtnode_GND=0.0;
double FFw_Vbi_ei=0.0;
double FFw_Vbi_ci=0.0;
double FFs_Vci_ei=0.0;
double FFs_Vtnode_GND=0.0;
double FFs_Vbi_ei=0.0;
double FFs_Vbi_ci=0.0;
double FFx_Vci_ei=0.0;
double FFx_Vtnode_GND=0.0;
double FFx_Vbi_ei=0.0;
double FFx_Vbi_ci=0.0;
double FFT_fbS_Vtnode_GND=0.0;
double FFd_QfE_Vtnode_GND=0.0;
double FFd_QfE_Vci_ei=0.0;
double FFd_QfE_Vbi_ei=0.0;
double FFd_QfE_Vbi_ci=0.0;
double FFd_TfE_Vtnode_GND=0.0;
double FFd_TfE_Vci_ei=0.0;
double FFd_TfE_Vbi_ei=0.0;
double FFd_TfE_Vbi_ci=0.0;
double FFa_Vci_ei=0.0;
double FFa_Vtnode_GND=0.0;
double FFa_Vbi_ei=0.0;
double FFa_Vbi_ci=0.0;
double T_fT_Vci_ei=0.0;
double T_fT_Vtnode_GND=0.0;
double T_fT_Vbi_ci=0.0;
double T_fT_Vbi_ei=0.0;
double Q_fT_Vci_ei=0.0;
double Q_fT_Vtnode_GND=0.0;
double Q_fT_Vbi_ci=0.0;
double Q_fT_Vbi_ei=0.0;
double Qf_Vci_ei=0.0;
double Qf_Vtnode_GND=0.0;
double Qf_Vbi_ci=0.0;
double Qf_Vbi_ei=0.0;
double Tf_Vci_ei=0.0;
double Tf_Vtnode_GND=0.0;
double Tf_Vbi_ci=0.0;
double Tf_Vbi_ei=0.0;
double itr_Vci_ei=0.0;
double itr_Vtnode_GND=0.0;
double itr_Vbi_ci=0.0;
double itr_Vbi_ei=0.0;
double itf_Vci_ei=0.0;
double itf_Vtnode_GND=0.0;
double itf_Vbi_ei=0.0;
double itf_Vbi_ci=0.0;
double a_h_Vci_ei=0.0;
double a_h_Vtnode_GND=0.0;
double a_h_Vbi_ei=0.0;
double a_h_Vbi_ci=0.0;
double I_Tf1_Vci_ei=0.0;
double I_Tf1_Vtnode_GND=0.0;
double I_Tf1_Vbi_ei=0.0;
double I_Tf1_Vbi_ci=0.0;
double Q_p_Vtnode_GND=0.0;
double Q_p_Vbi_ei=0.0;
double Q_p_Vbi_ci=0.0;
double A_Vtnode_GND=0.0;
double A_Vbi_ei=0.0;
double A_Vbi_ci=0.0;
double ICKa_Vci_ei=0.0;
double ICKa_Vtnode_GND=0.0;
double ick_Vci_ei=0.0;
double ick_Vtnode_GND=0.0;
double vceff_Vci_ei=0.0;
double vceff_Vtnode_GND=0.0;
double ICKv_Vci_ei=0.0;
double ICKv_Vtnode_GND=0.0;
double vc_Vci_ei=0.0;
double vc_Vtnode_GND=0.0;
double T_f0_Vtnode_GND=0.0;
double T_f0_Vbi_ci=0.0;
double T_f0_Vbi_ei=0.0;
double cc_Vtnode_GND=0.0;
double cc_Vbi_ci=0.0;
double cc_Vbi_ei=0.0;
double Cjcit_Vbi_ci=0.0;
double Cjcit_Vtnode_GND=0.0;
double Cjcit_Vbi_ei=0.0;
double b_q_Vtnode_GND=0.0;
double b_q_Vbi_ei=0.0;
double b_q_Vbi_ci=0.0;
double Q_bpt_Vtnode_GND=0.0;
double Q_0_Vtnode_GND=0.0;
double Q_0_Vbi_ei=0.0;
double Q_0_Vbi_ci=0.0;
double Qjci_Vbi_ei=0.0;
double Qjci_Vtnode_GND=0.0;
double Qjci_Vbi_ci=0.0;
double DQ_j3_Vsi_ci=0.0;
double DQ_j3_Vb_ci=0.0;
double DQ_j3_Vbp_ci=0.0;
double DQ_j3_Vtnode_GND=0.0;
double DQ_j3_Vbi_ci=0.0;
double DQ_j2_Vsi_ci=0.0;
double DQ_j2_Vb_ci=0.0;
double DQ_j2_Vbp_ci=0.0;
double DQ_j2_Vtnode_GND=0.0;
double DQ_j2_Vbi_ci=0.0;
double DQ_j1_Vsi_ci=0.0;
double DQ_j1_Vb_ci=0.0;
double DQ_j1_Vbp_ci=0.0;
double DQ_j1_Vtnode_GND=0.0;
double DQ_j1_Vbi_ci=0.0;
double Cjci_Vbi_ei=0.0;
double Cjci_Vtnode_GND=0.0;
double Cjci_Vbi_ci=0.0;
double DC_j3_Vsi_ci=0.0;
double DC_j3_Vb_ci=0.0;
double DC_j3_Vbp_ci=0.0;
double DC_j3_Vtnode_GND=0.0;
double DC_j3_Vbi_ci=0.0;
double DC_j2_Vsi_ci=0.0;
double DC_j2_Vb_ci=0.0;
double DC_j2_Vbp_ci=0.0;
double DC_j2_Vtnode_GND=0.0;
double DC_j2_Vbi_ci=0.0;
double DC_j1_Vsi_ci=0.0;
double DC_j1_Vb_ci=0.0;
double DC_j1_Vbp_ci=0.0;
double DC_j1_Vtnode_GND=0.0;
double DC_j1_Vbi_ci=0.0;
double DCln2_Vsi_ci=0.0;
double DCln2_Vb_ci=0.0;
double DCln2_Vbp_ci=0.0;
double DCln2_Vtnode_GND=0.0;
double DCln2_Vbi_ci=0.0;
double DCln1_Vsi_ci=0.0;
double DCln1_Vb_ci=0.0;
double DCln1_Vbp_ci=0.0;
double DCln1_Vtnode_GND=0.0;
double DCln1_Vbi_ci=0.0;
double Dv_j4_Vsi_ci=0.0;
double Dv_j4_Vb_ci=0.0;
double Dv_j4_Vbp_ci=0.0;
double Dv_j4_Vbi_ci=0.0;
double Dv_j4_Vtnode_GND=0.0;
double Dv_j2_Vsi_ci=0.0;
double Dv_j2_Vb_ci=0.0;
double Dv_j2_Vbp_ci=0.0;
double Dv_j2_Vtnode_GND=0.0;
double Dv_j2_Vbi_ci=0.0;
double De_2_Vsi_ci=0.0;
double De_2_Vb_ci=0.0;
double De_2_Vbp_ci=0.0;
double De_2_Vtnode_GND=0.0;
double De_2_Vbi_ci=0.0;
double Dv_r_Vsi_ci=0.0;
double Dv_r_Vb_ci=0.0;
double Dv_r_Vbp_ci=0.0;
double Dv_r_Vtnode_GND=0.0;
double Dv_r_Vbi_ci=0.0;
double Dv_j1_Vsi_ci=0.0;
double Dv_j1_Vb_ci=0.0;
double Dv_j1_Vbp_ci=0.0;
double Dv_j1_Vtnode_GND=0.0;
double Dv_j1_Vbi_ci=0.0;
double De_1_Vsi_ci=0.0;
double De_1_Vb_ci=0.0;
double De_1_Vbp_ci=0.0;
double De_1_Vtnode_GND=0.0;
double De_1_Vbi_ci=0.0;
double De_Vsi_ci=0.0;
double De_Vb_ci=0.0;
double De_Vbp_ci=0.0;
double De_Vtnode_GND=0.0;
double De_Vbi_ci=0.0;
double Dv_e_Vsi_ci=0.0;
double Dv_e_Vb_ci=0.0;
double Dv_e_Vbp_ci=0.0;
double Dv_e_Vtnode_GND=0.0;
double Dv_e_Vbi_ci=0.0;
double Da_Vtnode_GND=0.0;
double DC_c_Vtnode_GND=0.0;
double DC_max_Vtnode_GND=0.0;
double DV_f_Vtnode_GND=0.0;
double Dv_p_Vtnode_GND=0.0;
double Qjei_Vtnode_GND=0.0;
double Qjei_Vbi_ei=0.0;
double DFQ_j_Vsi_ci=0.0;
double DFQ_j_Vb_ci=0.0;
double DFQ_j_Vbp_ci=0.0;
double DFQ_j_Vbp_ei=0.0;
double DFQ_j_Vbi_ci=0.0;
double DFQ_j_Vtnode_GND=0.0;
double DFQ_j_Vbi_ei=0.0;
double DFC_j1_Vsi_ci=0.0;
double DFC_j1_Vb_ci=0.0;
double DFC_j1_Vbp_ci=0.0;
double DFC_j1_Vbp_ei=0.0;
double DFC_j1_Vbi_ci=0.0;
double DFC_j1_Vtnode_GND=0.0;
double DFC_j1_Vbi_ei=0.0;
double DFb_Vsi_ci=0.0;
double DFb_Vb_ci=0.0;
double DFb_Vbp_ci=0.0;
double DFb_Vbp_ei=0.0;
double DFb_Vbi_ci=0.0;
double DFb_Vtnode_GND=0.0;
double DFb_Vbi_ei=0.0;
double DFdvj_dv_Vsi_ci=0.0;
double DFdvj_dv_Vb_ci=0.0;
double DFdvj_dv_Vbp_ci=0.0;
double DFdvj_dv_Vbp_ei=0.0;
double DFdvj_dv_Vbi_ci=0.0;
double DFdvj_dv_Vtnode_GND=0.0;
double DFdvj_dv_Vbi_ei=0.0;
double DFv_j_Vsi_ci=0.0;
double DFv_j_Vb_ci=0.0;
double DFv_j_Vbp_ci=0.0;
double DFv_j_Vbp_ei=0.0;
double DFv_j_Vbi_ci=0.0;
double DFv_j_Vtnode_GND=0.0;
double DFv_j_Vbi_ei=0.0;
double DFe_Vsi_ci=0.0;
double DFe_Vb_ci=0.0;
double DFe_Vbp_ci=0.0;
double DFe_Vbp_ei=0.0;
double DFe_Vbi_ci=0.0;
double DFe_Vtnode_GND=0.0;
double DFe_Vbi_ei=0.0;
double DFv_e_Vsi_ci=0.0;
double DFv_e_Vb_ci=0.0;
double DFv_e_Vbp_ci=0.0;
double DFv_e_Vbp_ei=0.0;
double DFv_e_Vbi_ci=0.0;
double DFv_e_Vtnode_GND=0.0;
double DFv_e_Vbi_ei=0.0;
double DFC_max_Vtnode_GND=0.0;
double DFV_f_Vtnode_GND=0.0;
double i_0r_Vtnode_GND=0.0;
double i_0r_Vbi_ci=0.0;
double i_0f_Vtnode_GND=0.0;
double i_0f_Vbi_ei=0.0;
double VT_f_Vtnode_GND=0.0;
double irei_Vtnode_GND=0.0;
double irei_Vbi_ei=0.0;
double ibei_Vtnode_GND=0.0;
double ibei_Vbi_ei=0.0;
double le_Vsi_ci=0.0;
double le_Vbp_ci=0.0;
double le_Vbp_ei=0.0;
double le_Vbi_ci=0.0;
double le_Vbi_ei=0.0;
double le_Vtnode_GND=0.0;
double DIOY_Vsi_ci=0.0;
double DIOY_Vbp_ci=0.0;
double DIOY_Vbp_ei=0.0;
double DIOY_Vbi_ci=0.0;
double DIOY_Vbi_ei=0.0;
double DIOY_Vtnode_GND=0.0;
double vpts_t_Vtnode_GND=0.0;
double cjs0_t_Vtnode_GND=0.0;
double vds_t_Vtnode_GND=0.0;
double iscs_t_Vtnode_GND=0.0;
double itss_t_Vtnode_GND=0.0;
double tsf_t_Vtnode_GND=0.0;
double re_t_Vtnode_GND=0.0;
double rbx_t_Vtnode_GND=0.0;
double rcx_t_Vtnode_GND=0.0;
double ibcxs_t_Vtnode_GND=0.0;
double cjcx02_t_Vtnode_GND=0.0;
double cjcx01_t_Vtnode_GND=0.0;
double vptcx_t_Vtnode_GND=0.0;
double cratio_t_Vtnode_GND=0.0;
double vdcx_t_Vtnode_GND=0.0;
double aljep_t_Vtnode_GND=0.0;
double cjep0_t_Vtnode_GND=0.0;
double vdep_t_Vtnode_GND=0.0;
double ireps_t_Vtnode_GND=0.0;
double ibeps_t_Vtnode_GND=0.0;
double rbi0_t_Vtnode_GND=0.0;
double qavl_t_Vtnode_GND=0.0;
double favl_t_Vtnode_GND=0.0;
double thcs_t_Vtnode_GND=0.0;
double tef0_t_Vtnode_GND=0.0;
double t0_t_Vtnode_GND=0.0;
double vptci_t_Vtnode_GND=0.0;
double cjci0_t_Vtnode_GND=0.0;
double vdci_t_Vtnode_GND=0.0;
double ibcis_t_Vtnode_GND=0.0;
double vces_t_Vtnode_GND=0.0;
double vlim_t_Vtnode_GND=0.0;
double k_Vtnode_GND=0.0;
double Orci0_t_Vtnode_GND=0.0;
double qtt0_zci_Vtnode_GND=0.0;
double qp0_t_Vtnode_GND=0.0;
double c10_t_Vtnode_GND=0.0;
double aljei_t_Vtnode_GND=0.0;
double cjei0_t_Vtnode_GND=0.0;
double vdei_t_Vtnode_GND=0.0;
double vdjt_Vtnode_GND=0.0;
double vdj0_Vtnode_GND=0.0;
double ireis_t_Vtnode_GND=0.0;
double ibeis_t_Vtnode_GND=0.0;
double a_Vci_ei=0.0;
double a_Vbi_ei=0.0;
double a_Vbi_ci=0.0;
double a_Vtnode_GND=0.0;
double r_VgVT_Vtnode_GND=0.0;
double V_gT_Vtnode_GND=0.0;
double ln_qtt0_Vtnode_GND=0.0;
double qtt0_Vtnode_GND=0.0;
double dT_Vtnode_GND=0.0;
double VT_Vtnode_GND=0.0;
double Tdev_Vtnode_GND=0.0;
double VT=0.0;
double Tamb=0.0;
double Tdev=0.0;
double Tnom=0.0;
double qtt0=0.0;
double qtt0_zci=0.0;
double ln_qtt0=0.0;
double r_VgVT=0.0;
double V_gT=0.0;
double dT=0.0;
double k=0.0;
double ireis_t=0.0;
double ibeis_t=0.0;
double ibcxs_t=0.0;
double ibcis_t=0.0;
double iscs_t=0.0;
double cje0_t=0.0;
double cjci0_t=0.0;
double cjcx0_t=0.0;
double cjs0_t=0.0;
double rci0_t=0.0;
double vlim_t=0.0;
double vces_t=0.0;
double thcs_t=0.0;
double tef0_t=0.0;
double rbi_t=0.0;
double rbi0_t=0.0;
double rbx_t=0.0;
double rcx_t=0.0;
double re_t=0.0;
double rsu_t=0.0;
double t0_t=0.0;
double vdei_t=0.0;
double vdci_t=0.0;
double c10_t=0.0;
double cjei0_t=0.0;
double qp0_t=0.0;
double vdcx_t=0.0;
double vptcx_t=0.0;
double cjcx01_t=0.0;
double cjcx02_t=0.0;
double vpts_t=0.0;
double itss_t=0.0;
double tsf_t=0.0;
double ibeps_t=0.0;
double ireps_t=0.0;
double cjep0_t=0.0;
double ibets_t=0.0;
double abet_t=0.0;
double aljei_t=0.0;
double qavl_t=0.0;
double favl_t=0.0;
double vptci_t=0.0;
double vdep_t=0.0;
double aljep_t=0.0;
double mg=0.0;
double zetabci=0.0;
double zetabcxt=0.0;
double zetasct=0.0;
double zetatef=0.0;
double avs=0.0;
double k1=0.0;
double k2=0.0;
double k10=0.0;
double k20=0.0;
double vgbe0=0.0;
double vgbc0=0.0;
double vgsc0=0.0;
double dvg0=0.0;
double vgb0=0.0;
double vge0=0.0;
double vgc0=0.0;
double vgs0=0.0;
double vge_t0=0.0;
double vge_t=0.0;
double vgb_t=0.0;
double vgb_t0=0.0;
double vgbe_t=0.0;
double vgbe_t0=0.0;
double vt0=0.0;
double Qjci=0.0;
double Cjci=0.0;
double Qjcx=0.0;
double Qjcxi=0.0;
double Qjcii=0.0;
double qjcx0_t_i=0.0;
double ccox1=0.0;
double ccox2=0.0;
double C_1=0.0;
double cjcx0_t_ii=0.0;
double cjcx0_t_i=0.0;
double qjcx0_t_ii=0.0;
double cratio_t=0.0;
double Cjcit=0.0;
double cc=0.0;
double Qjei=0.0;
double Cjei=0.0;
double vdj1=0.0;
double DFe=0.0;
double Qjep=0.0;
double Cjep=0.0;
double itf=0.0;
double itr=0.0;
double it=0.0;
double ibei=0.0;
double irei=0.0;
double ibci=0.0;
double ibep=0.0;
double irep=0.0;
double ibh_rec=0.0;
double Oich=0.0;
double Orci0_t=0.0;
double Ovpt=0.0;
double Otbhrec=0.0;
double Tf=0.0;
double Tr=0.0;
double VT_f=0.0;
double i_0f=0.0;
double i_0r=0.0;
double a_bpt=0.0;
double Q_0=0.0;
double Q_p=0.0;
double Q_bpt=0.0;
double T_f0=0.0;
double Q_fT=0.0;
double Q_bf=0.0;
double T_fT=0.0;
double b_q=0.0;
double Q_fC=0.0;
double T_fC=0.0;
double T_cT=0.0;
double I_Tf1=0.0;
double A=0.0;
double a_h=0.0;
double vds_t=0.0;
double Q_pT=0.0;
double l_it=0.0;
double d_Q=0.0;
double d_Q0=0.0;
double cbepar1=0.0;
double cbepar2=0.0;
double qrbi=0.0;
double Qf=0.0;
double Qdei=0.0;
double tf0=0.0;
double Qr=0.0;
double Qdci=0.0;
double ick=0.0;
double vc=0.0;
double vceff=0.0;
double ibet=0.0;
double iavl=0.0;
double rbi=0.0;
double ijbcx=0.0;
double cjcx01=0.0;
double cjcx02=0.0;
double ijsc=0.0;
double Cjs=0.0;
double Qjs=0.0;
double HSUM=0.0;
double HSI_Tsu=0.0;
double HSa=0.0;
double HSb=0.0;
double Qdsu=0.0;
double pterm=0.0;
double itnode=0.0;
double qtnode=0.0;
double ICKv=0.0;
double ICKa=0.0;
double AVLS_avl=0.0;
double AVLv_bord=0.0;
double AVLv_q=0.0;
double AVLU0=0.0;
double AVLa=0.0;
double vdj0=0.0;
double vdjt=0.0;
double vdt=0.0;
double d1=0.0;
double DIOY=0.0;
double le=0.0;
double FFT_fbS=0.0;
double FFa=0.0;
double FFx=0.0;
double FFs=0.0;
double FFw=0.0;
double FFw_2=0.0;
double FFd_QfB=0.0;
double FFd_TfB=0.0;
double FFT_pcS=0.0;
double FFQ_fC=0.0;
double FFT_fC=0.0;
double FFQ_cT=0.0;
double FFT_cT=0.0;
double FFd_TfE=0.0;
double FFd_QfE=0.0;
double FFa_w=0.0;
double FCz=0.0;
double FCw2=0.0;
double FCf1=0.0;
double FCf2=0.0;
double FCf3=0.0;
double FCf_ci=0.0;
double FCz_1=0.0;
double FCd_a=0.0;
double FCdaick_ditf=0.0;
double FCa=0.0;
double FCw=0.0;
double FCdw_daick=0.0;
double FCdfc_dw=0.0;
double FCdw_ditf=0.0;
double FCdfc_ditf=0.0;
double FCf_CT=0.0;
double FCdfCT_ditf=0.0;
double FCrt=0.0;
double FCln=0.0;
double FClnl=0.0;
double FClnb=0.0;
double FCda1_dw=0.0;
double FCdf1_dw=0.0;
double FCdf2_dw=0.0;
double FCdf3_dw=0.0;
double FCd_f=0.0;
double FCa1=0.0;
double FCa_ck=0.0;
double FCxl=0.0;
double FCxb=0.0;
double Dz_r=0.0;
double Dv_p=0.0;
double DV_f=0.0;
double DC_max=0.0;
double DC_c=0.0;
double Da=0.0;
double Dv_e=0.0;
double De=0.0;
double De_1=0.0;
double Dv_j1=0.0;
double Dv_r=0.0;
double De_2=0.0;
double Dv_j2=0.0;
double Dv_j4=0.0;
double DC_j1=0.0;
double DC_j2=0.0;
double DC_j3=0.0;
double DQ_j1=0.0;
double DQ_j2=0.0;
double DQ_j3=0.0;
double DCln1=0.0;
double DCln2=0.0;
double Dz1=0.0;
double Dzr1=0.0;
double DFV_f=0.0;
double DFC_max=0.0;
double DFa=0.0;
double DFv_e=0.0;
double DFv_j=0.0;
double DFb=0.0;
double DFC_j1=0.0;
double DFQ_j=0.0;
double DFdvj_dv=0.0;
double DFs_q=0.0;
double DFs_q2=0.0;
double z=0.0;
double a=0.0;
double a2=0.0;
double a3=0.0;
double r=0.0;
double x=0.0;
double FCdfCT_dw=0.0;
double f_QR=0.0;
double Qz=0.0;
double f_p=0.0;
double ETA=0.0;
double Q_fi=0.0;
double I_BI=0.0;
double a_eg=0.0;
double aa=0.0;
double ab=0.0;
double vve=0.0;
double cce=0.0;
double pocce=0.0;
double zex=0.0;
double czz=0.0;
double fourkt=0.0;
double twoq=0.0;
double flicker_Pwr=0.0;
double rbin=0.0;
Tnom=(tnom+273.15);
Tamb=_circuit_temp;
Tdev_Vtnode_GND=(+1.0);
Tdev=((Tamb+dt)+NP(tnode));
if ((Tdev<((-100.0)+273.15)))
{
Tdev=((-100.0)+273.15);
Tdev_Vtnode_GND=0.0;
}
else
{
if ((Tdev>(326.85+273.15)))
{
Tdev=(326.85+273.15);
Tdev_Vtnode_GND=0.0;
}
}
if (doAC)
{
vt0=_vt(Tnom);
}
VT_Vtnode_GND=Tdev_Vtnode_GND*_d_vt(Tdev);
VT=_vt(Tdev);
dT_Vtnode_GND=Tdev_Vtnode_GND;
dT=(Tdev-Tnom);
qtt0_Vtnode_GND=Tdev_Vtnode_GND/Tnom;
qtt0=(Tdev/Tnom);
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,(qtt0));
_logE(__logE_0,(qtt0));
ln_qtt0_Vtnode_GND=qtt0_Vtnode_GND*__d_logE_0;
ln_qtt0=__logE_0;
}
if (doAC)
{
avs=(alvs*Tnom);
}
V_gT_Vtnode_GND=((((3.0*VT_Vtnode_GND)*ln_qtt0)+((3.0*VT)*ln_qtt0_Vtnode_GND))+(vgb*qtt0_Vtnode_GND));
V_gT=(((3.0*VT)*ln_qtt0)+(vgb*(qtt0-1.0)));
r_VgVT_Vtnode_GND=(V_gT_Vtnode_GND*VT-V_gT*VT_Vtnode_GND)/(VT*VT);
r_VgVT=(V_gT/VT);
a_Vtnode_GND=((mcf*r_VgVT_Vtnode_GND)/mbei-(alb*dT_Vtnode_GND));
a=(((mcf*r_VgVT)/mbei)-(alb*dT));
a_Vci_ei=0.0;
a_Vbi_ei=0.0;
a_Vbi_ci=0.0;
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(a));
_exp(__exp_0,(a));
ibeis_t_Vtnode_GND=(ibeis*a_Vtnode_GND*__d_exp_0);
ibeis_t=(ibeis*__exp_0);
}
a_Vtnode_GND=((mcf*r_VgVT_Vtnode_GND)/mrei-(alb*dT_Vtnode_GND));
a=(((mcf*r_VgVT)/mrei)-(alb*dT));
a_Vci_ei=0.0;
a_Vbi_ei=0.0;
a_Vbi_ci=0.0;
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(a));
_exp(__exp_0,(a));
ireis_t_Vtnode_GND=(ireis*a_Vtnode_GND*__d_exp_0);
ireis_t=(ireis*__exp_0);
}
if ((cjei0>0.0))
{
vdj0_Vtnode_GND=((vdei*qtt0_Vtnode_GND)-V_gT_Vtnode_GND);
vdj0=((vdei*qtt0)-V_gT);
vdj1=(0.1*vdei);
vdjt_Vtnode_GND=(vdj0_Vtnode_GND*VT-(vdj0-vdj1)*VT_Vtnode_GND)/(VT*VT);
vdjt=((vdj0-vdj1)/VT);
if ((vdjt<11.0))
{
{
double __exp_0=0.0;
double __logE_1=0.0;
double __d_exp_0=0.0;
double __d_logE_1=0.0;
_d_exp(__exp_0,__d_exp_0,(vdjt));
_d_logE(__logE_1,__d_logE_1,((1.0+__exp_0)));
_exp(__exp_0,(vdjt));
_logE(__logE_1,((1.0+__exp_0)));
vdei_t_Vtnode_GND=(+((VT_Vtnode_GND*__logE_1)+(VT*(+vdjt_Vtnode_GND*__d_exp_0)*__d_logE_1)));
vdei_t=(vdj1+(VT*__logE_1));
}
}
else
{
vdei_t_Vtnode_GND=vdj0_Vtnode_GND;
vdei_t=vdj0;
}
{
double __logE_0=0.0;
double __exp_1=0.0;
double __d_logE_0=0.0;
double __d_exp_1=0.0;
_d_logE(__logE_0,__d_logE_0,((vdei/vdei_t)));
_d_exp(__exp_1,__d_exp_1,((zei*__logE_0)));
_logE(__logE_0,((vdei/vdei_t)));
_exp(__exp_1,((zei*__logE_0)));
cjei0_t_Vtnode_GND=(cjei0*(zei*(-(vdei*vdei_t_Vtnode_GND)/(vdei_t*vdei_t))*__d_logE_0)*__d_exp_1);
cjei0_t=(cjei0*__exp_1);
}
if ((1==1))
{
aljei_t_Vtnode_GND=(aljei*vdei_t_Vtnode_GND)/vdei;
aljei_t=((aljei*vdei_t)/vdei);
}
else
{
aljei_t=aljei;
aljei_t_Vtnode_GND=0.0;
}
}
else
{
cjei0_t=cjei0;
cjei0_t_Vtnode_GND=0.0;
vdei_t=vdei;
vdei_t_Vtnode_GND=0.0;
aljei_t=aljei;
aljei_t_Vtnode_GND=0.0;
}
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(r_VgVT));
_exp(__exp_0,(r_VgVT));
c10_t_Vtnode_GND=(c10*r_VgVT_Vtnode_GND*__d_exp_0);
c10_t=(c10*__exp_0);
}
a_Vtnode_GND=vdei_t_Vtnode_GND/vdei;
a=(vdei_t/vdei);
a_Vci_ei=0.0;
a_Vbi_ei=0.0;
a_Vbi_ci=0.0;
qp0_t_Vtnode_GND=(qp0*(+((0.5*zei)*(-a_Vtnode_GND))));
qp0_t=(qp0*(1.0+((0.5*zei)*(1.0-a))));
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((zetaci*ln_qtt0)));
_exp(__exp_0,((zetaci*ln_qtt0)));
qtt0_zci_Vtnode_GND=(zetaci*ln_qtt0_Vtnode_GND)*__d_exp_0;
qtt0_zci=__exp_0;
}
Orci0_t_Vtnode_GND=(-(rci0*qtt0_zci_Vtnode_GND)/((rci0*qtt0_zci)*(rci0*qtt0_zci)));
Orci0_t=(1.0/(rci0*qtt0_zci));
a_Vtnode_GND=(((vlim*qtt0_zci_Vtnode_GND)*(1.0-(alvs*dT)))+((vlim*qtt0_zci)*(-(alvs*dT_Vtnode_GND))));
a=((vlim*qtt0_zci)*(1.0-(alvs*dT)));
a_Vci_ei=0.0;
a_Vbi_ei=0.0;
a_Vbi_ci=0.0;
k_Vtnode_GND=((a_Vtnode_GND-VT_Vtnode_GND)*VT-(a-VT)*VT_Vtnode_GND)/(VT*VT);
k=((a-VT)/VT);
if ((k<11.0))
{
{
double __exp_0=0.0;
double __logE_1=0.0;
double __d_exp_0=0.0;
double __d_logE_1=0.0;
_d_exp(__exp_0,__d_exp_0,(k));
_d_logE(__logE_1,__d_logE_1,((1.0+__exp_0)));
_exp(__exp_0,(k));
_logE(__logE_1,((1.0+__exp_0)));
vlim_t_Vtnode_GND=(VT_Vtnode_GND+((VT_Vtnode_GND*__logE_1)+(VT*(+k_Vtnode_GND*__d_exp_0)*__d_logE_1)));
vlim_t=(VT+(VT*__logE_1));
}
}
else
{
vlim_t_Vtnode_GND=a_Vtnode_GND;
vlim_t=a;
}
vces_t_Vtnode_GND=(vces*(+(alces*dT_Vtnode_GND)));
vces_t=(vces*(1+(alces*dT)));
a_Vtnode_GND=r_VgVT_Vtnode_GND/mbci;
a=(r_VgVT/mbci);
a_Vci_ei=0.0;
a_Vbi_ei=0.0;
a_Vbi_ci=0.0;
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(a));
_exp(__exp_0,(a));
ibcis_t_Vtnode_GND=(ibcis*a_Vtnode_GND*__d_exp_0);
ibcis_t=(ibcis*__exp_0);
}
if ((cjci0>0.0))
{
vdj0_Vtnode_GND=((vdci*qtt0_Vtnode_GND)-V_gT_Vtnode_GND);
vdj0=((vdci*qtt0)-V_gT);
vdj1=(0.1*vdci);
vdjt_Vtnode_GND=(vdj0_Vtnode_GND*VT-(vdj0-vdj1)*VT_Vtnode_GND)/(VT*VT);
vdjt=((vdj0-vdj1)/VT);
if ((vdjt<11.0))
{
{
double __exp_0=0.0;
double __logE_1=0.0;
double __d_exp_0=0.0;
double __d_logE_1=0.0;
_d_exp(__exp_0,__d_exp_0,(vdjt));
_d_logE(__logE_1,__d_logE_1,((1.0+__exp_0)));
_exp(__exp_0,(vdjt));
_logE(__logE_1,((1.0+__exp_0)));
vdci_t_Vtnode_GND=(+((VT_Vtnode_GND*__logE_1)+(VT*(+vdjt_Vtnode_GND*__d_exp_0)*__d_logE_1)));
vdci_t=(vdj1+(VT*__logE_1));
}
}
else
{
vdci_t_Vtnode_GND=vdj0_Vtnode_GND;
vdci_t=vdj0;
}
{
double __logE_0=0.0;
double __exp_1=0.0;
double __d_logE_0=0.0;
double __d_exp_1=0.0;
_d_logE(__logE_0,__d_logE_0,((vdci/vdci_t)));
_d_exp(__exp_1,__d_exp_1,((zci*__logE_0)));
_logE(__logE_0,((vdci/vdci_t)));
_exp(__exp_1,((zci*__logE_0)));
cjci0_t_Vtnode_GND=(cjci0*(zci*(-(vdci*vdci_t_Vtnode_GND)/(vdci_t*vdci_t))*__d_logE_0)*__d_exp_1);
cjci0_t=(cjci0*__exp_1);
}
if ((0==1))
{
vptci_t_Vtnode_GND=(vptci*vdci_t_Vtnode_GND)/vdci;
vptci_t=((vptci*vdci_t)/vdci);
}
else
{
vptci_t=vptci;
vptci_t_Vtnode_GND=0.0;
}
}
else
{
cjci0_t=cjci0;
cjci0_t_Vtnode_GND=0.0;
vdci_t=vdci;
vdci_t_Vtnode_GND=0.0;
vptci_t=vptci;
vptci_t_Vtnode_GND=0.0;
}
t0_t_Vtnode_GND=(t0*((+(alt0*dT_Vtnode_GND))+(((kt0*dT_Vtnode_GND)*dT)+((kt0*dT)*dT_Vtnode_GND))));
t0_t=(t0*((1+(alt0*dT))+((kt0*dT)*dT)));
a_Vtnode_GND=(+(alb*dT_Vtnode_GND));
a=(1.0+(alb*dT));
a_Vci_ei=0.0;
a_Vbi_ei=0.0;
a_Vbi_ci=0.0;
{
double __sqrt_0=0.0;
double __d_sqrt_0=0.0;
_d_sqrt(__sqrt_0,__d_sqrt_0,(((a*a)+0.01)));
_sqrt(__sqrt_0,(((a*a)+0.01)));
k_Vtnode_GND=(0.5*(a_Vtnode_GND+((a_Vtnode_GND*a)+(a*a_Vtnode_GND))*__d_sqrt_0));
k=(0.5*(a+__sqrt_0));
}
tef0_t_Vtnode_GND=((tef0*qtt0_Vtnode_GND)*k-(tef0*qtt0)*k_Vtnode_GND)/(k*k);
tef0_t=((tef0*qtt0)/k);
thcs_t_Vtnode_GND=((thcs*qtt0_zci_Vtnode_GND)*qtt0-(thcs*qtt0_zci)*qtt0_Vtnode_GND)/(qtt0*qtt0);
thcs_t=((thcs*qtt0_zci)/qtt0);
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((alfav*dT)));
_exp(__exp_0,((alfav*dT)));
favl_t_Vtnode_GND=(favl*(alfav*dT_Vtnode_GND)*__d_exp_0);
favl_t=(favl*__exp_0);
}
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((alqav*dT)));
_exp(__exp_0,((alqav*dT)));
qavl_t_Vtnode_GND=(qavl*(alqav*dT_Vtnode_GND)*__d_exp_0);
qavl_t=(qavl*__exp_0);
}
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((zetarbi*ln_qtt0)));
_exp(__exp_0,((zetarbi*ln_qtt0)));
rbi0_t_Vtnode_GND=(rbi0*(zetarbi*ln_qtt0_Vtnode_GND)*__d_exp_0);
rbi0_t=(rbi0*__exp_0);
}
a_Vtnode_GND=((mcf*r_VgVT_Vtnode_GND)/mbep-(alb*dT_Vtnode_GND));
a=(((mcf*r_VgVT)/mbep)-(alb*dT));
a_Vci_ei=0.0;
a_Vbi_ei=0.0;
a_Vbi_ci=0.0;
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(a));
_exp(__exp_0,(a));
ibeps_t_Vtnode_GND=(ibeps*a_Vtnode_GND*__d_exp_0);
ibeps_t=(ibeps*__exp_0);
}
a_Vtnode_GND=((mcf*r_VgVT_Vtnode_GND)/mrep-(alb*dT_Vtnode_GND));
a=(((mcf*r_VgVT)/mrep)-(alb*dT));
a_Vci_ei=0.0;
a_Vbi_ei=0.0;
a_Vbi_ci=0.0;
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(a));
_exp(__exp_0,(a));
ireps_t_Vtnode_GND=(ireps*a_Vtnode_GND*__d_exp_0);
ireps_t=(ireps*__exp_0);
}
if ((cjep0>0.0))
{
vdj0_Vtnode_GND=((vdep*qtt0_Vtnode_GND)-V_gT_Vtnode_GND);
vdj0=((vdep*qtt0)-V_gT);
vdj1=(0.1*vdep);
vdjt_Vtnode_GND=(vdj0_Vtnode_GND*VT-(vdj0-vdj1)*VT_Vtnode_GND)/(VT*VT);
vdjt=((vdj0-vdj1)/VT);
if ((vdjt<11.0))
{
{
double __exp_0=0.0;
double __logE_1=0.0;
double __d_exp_0=0.0;
double __d_logE_1=0.0;
_d_exp(__exp_0,__d_exp_0,(vdjt));
_d_logE(__logE_1,__d_logE_1,((1.0+__exp_0)));
_exp(__exp_0,(vdjt));
_logE(__logE_1,((1.0+__exp_0)));
vdep_t_Vtnode_GND=(+((VT_Vtnode_GND*__logE_1)+(VT*(+vdjt_Vtnode_GND*__d_exp_0)*__d_logE_1)));
vdep_t=(vdj1+(VT*__logE_1));
}
}
else
{
vdep_t_Vtnode_GND=vdj0_Vtnode_GND;
vdep_t=vdj0;
}
{
double __logE_0=0.0;
double __exp_1=0.0;
double __d_logE_0=0.0;
double __d_exp_1=0.0;
_d_logE(__logE_0,__d_logE_0,((vdep/vdep_t)));
_d_exp(__exp_1,__d_exp_1,((zep*__logE_0)));
_logE(__logE_0,((vdep/vdep_t)));
_exp(__exp_1,((zep*__logE_0)));
cjep0_t_Vtnode_GND=(cjep0*(zep*(-(vdep*vdep_t_Vtnode_GND)/(vdep_t*vdep_t))*__d_logE_0)*__d_exp_1);
cjep0_t=(cjep0*__exp_1);
}
if ((1==1))
{
aljep_t_Vtnode_GND=(aljep*vdep_t_Vtnode_GND)/vdep;
aljep_t=((aljep*vdep_t)/vdep);
}
else
{
aljep_t=aljep;
aljep_t_Vtnode_GND=0.0;
}
}
else
{
cjep0_t=cjep0;
cjep0_t_Vtnode_GND=0.0;
vdep_t=vdep;
vdep_t_Vtnode_GND=0.0;
aljep_t=aljep;
aljep_t_Vtnode_GND=0.0;
}
if (doAC)
{
C_1=((1.0-fbc)*(cjcx0+ccox));
}
if ((C_1>=ccox))
{
if (doAC)
{
ccox1=ccox;
}
if (doAC)
{
ccox2=0;
}
if (doAC)
{
cjcx01=(C_1-ccox);
}
if (doAC)
{
cjcx02=(cjcx0-cjcx01);
}
}
else
{
if (doAC)
{
ccox1=C_1;
}
if (doAC)
{
ccox2=(ccox-ccox1);
}
if (doAC)
{
cjcx01=0.0;
}
if (doAC)
{
cjcx02=cjcx0;
}
}
if ((1.0>0.0))
{
vdj0_Vtnode_GND=((vdcx*qtt0_Vtnode_GND)-V_gT_Vtnode_GND);
if (doAC)
{
vdj0=((vdcx*qtt0)-V_gT);
}
if (doAC)
{
vdj1=(0.1*vdcx);
}
vdjt_Vtnode_GND=(vdj0_Vtnode_GND*VT-(vdj0-vdj1)*VT_Vtnode_GND)/(VT*VT);
if (doAC)
{
vdjt=((vdj0-vdj1)/VT);
}
if ((vdjt<11.0))
{
if (doAC)
{
{
double __exp_0=0.0;
double __logE_1=0.0;
double __d_exp_0=0.0;
double __d_logE_1=0.0;
_d_exp(__exp_0,__d_exp_0,(vdjt));
_d_logE(__logE_1,__d_logE_1,((1.0+__exp_0)));
_exp(__exp_0,(vdjt));
_logE(__logE_1,((1.0+__exp_0)));
vdcx_t_Vtnode_GND=(+((VT_Vtnode_GND*__logE_1)+(VT*(+vdjt_Vtnode_GND*__d_exp_0)*__d_logE_1)));
if (doAC)
{
vdcx_t=(vdj1+(VT*__logE_1));
}
}
}
}
else
{
vdcx_t_Vtnode_GND=vdj0_Vtnode_GND;
if (doAC)
{
vdcx_t=vdj0;
}
}
if (doAC)
{
{
double __logE_0=0.0;
double __exp_1=0.0;
double __d_logE_0=0.0;
double __d_exp_1=0.0;
_d_logE(__logE_0,__d_logE_0,((vdcx/vdcx_t)));
_d_exp(__exp_1,__d_exp_1,((zcx*__logE_0)));
_logE(__logE_0,((vdcx/vdcx_t)));
_exp(__exp_1,((zcx*__logE_0)));
cratio_t_Vtnode_GND=(1.0*(zcx*(-(vdcx*vdcx_t_Vtnode_GND)/(vdcx_t*vdcx_t))*__d_logE_0)*__d_exp_1);
if (doAC)
{
cratio_t=(1.0*__exp_1);
}
}
}
if ((0==1))
{
vptcx_t_Vtnode_GND=(vptcx*vdcx_t_Vtnode_GND)/vdcx;
if (doAC)
{
vptcx_t=((vptcx*vdcx_t)/vdcx);
}
}
else
{
if (doAC)
{
vptcx_t=vptcx;
}
vptcx_t_Vtnode_GND=0.0;
}
}
else
{
if (doAC)
{
cratio_t=1.0;
}
cratio_t_Vtnode_GND=0.0;
if (doAC)
{
vdcx_t=vdcx;
}
vdcx_t_Vtnode_GND=0.0;
if (doAC)
{
vptcx_t=vptcx;
}
vptcx_t_Vtnode_GND=0.0;
}
cjcx01_t_Vtnode_GND=cratio_t_Vtnode_GND*cjcx01;
if (doAC)
{
cjcx01_t=(cratio_t*cjcx01);
}
cjcx02_t_Vtnode_GND=cratio_t_Vtnode_GND*cjcx02;
if (doAC)
{
cjcx02_t=(cratio_t*cjcx02);
}
a_Vtnode_GND=r_VgVT_Vtnode_GND/mbcx;
a=(r_VgVT/mbcx);
a_Vci_ei=0.0;
a_Vbi_ei=0.0;
a_Vbi_ci=0.0;
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(a));
_exp(__exp_0,(a));
ibcxs_t_Vtnode_GND=(ibcxs*a_Vtnode_GND*__d_exp_0);
ibcxs_t=(ibcxs*__exp_0);
}
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((zetarcx*ln_qtt0)));
_exp(__exp_0,((zetarcx*ln_qtt0)));
rcx_t_Vtnode_GND=(rcx*(zetarcx*ln_qtt0_Vtnode_GND)*__d_exp_0);
rcx_t=(rcx*__exp_0);
}
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((zetarbx*ln_qtt0)));
_exp(__exp_0,((zetarbx*ln_qtt0)));
rbx_t_Vtnode_GND=(rbx*(zetarbx*ln_qtt0_Vtnode_GND)*__d_exp_0);
rbx_t=(rbx*__exp_0);
}
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((zetare*ln_qtt0)));
_exp(__exp_0,((zetare*ln_qtt0)));
re_t_Vtnode_GND=(re*(zetare*ln_qtt0_Vtnode_GND)*__d_exp_0);
re_t=(re*__exp_0);
}
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(((zetacx-1.0)*ln_qtt0)));
_exp(__exp_0,(((zetacx-1.0)*ln_qtt0)));
tsf_t_Vtnode_GND=(tsf*((zetacx-1.0)*ln_qtt0_Vtnode_GND)*__d_exp_0);
if (doAC)
{
tsf_t=(tsf*__exp_0);
}
}
}
a_Vtnode_GND=r_VgVT_Vtnode_GND/msf;
a=(r_VgVT/msf);
a_Vci_ei=0.0;
a_Vbi_ei=0.0;
a_Vbi_ci=0.0;
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(a));
_exp(__exp_0,(a));
itss_t_Vtnode_GND=(itss*a_Vtnode_GND*__d_exp_0);
itss_t=(itss*__exp_0);
}
a_Vtnode_GND=r_VgVT_Vtnode_GND*msc;
a=(r_VgVT*msc);
a_Vci_ei=0.0;
a_Vbi_ei=0.0;
a_Vbi_ci=0.0;
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(a));
_exp(__exp_0,(a));
iscs_t_Vtnode_GND=(iscs*a_Vtnode_GND*__d_exp_0);
iscs_t=(iscs*__exp_0);
}
if ((cjs0>0.0))
{
vdj0_Vtnode_GND=((vds*qtt0_Vtnode_GND)-V_gT_Vtnode_GND);
if (doAC)
{
vdj0=((vds*qtt0)-V_gT);
}
if (doAC)
{
vdj1=(0.1*vds);
}
vdjt_Vtnode_GND=(vdj0_Vtnode_GND*VT-(vdj0-vdj1)*VT_Vtnode_GND)/(VT*VT);
if (doAC)
{
vdjt=((vdj0-vdj1)/VT);
}
if ((vdjt<11.0))
{
if (doAC)
{
{
double __exp_0=0.0;
double __logE_1=0.0;
double __d_exp_0=0.0;
double __d_logE_1=0.0;
_d_exp(__exp_0,__d_exp_0,(vdjt));
_d_logE(__logE_1,__d_logE_1,((1.0+__exp_0)));
_exp(__exp_0,(vdjt));
_logE(__logE_1,((1.0+__exp_0)));
vds_t_Vtnode_GND=(+((VT_Vtnode_GND*__logE_1)+(VT*(+vdjt_Vtnode_GND*__d_exp_0)*__d_logE_1)));
if (doAC)
{
vds_t=(vdj1+(VT*__logE_1));
}
}
}
}
else
{
vds_t_Vtnode_GND=vdj0_Vtnode_GND;
if (doAC)
{
vds_t=vdj0;
}
}
if (doAC)
{
{
double __logE_0=0.0;
double __exp_1=0.0;
double __d_logE_0=0.0;
double __d_exp_1=0.0;
_d_logE(__logE_0,__d_logE_0,((vds/vds_t)));
_d_exp(__exp_1,__d_exp_1,((zs*__logE_0)));
_logE(__logE_0,((vds/vds_t)));
_exp(__exp_1,((zs*__logE_0)));
cjs0_t_Vtnode_GND=(cjs0*(zs*(-(vds*vds_t_Vtnode_GND)/(vds_t*vds_t))*__d_logE_0)*__d_exp_1);
if (doAC)
{
cjs0_t=(cjs0*__exp_1);
}
}
}
if ((0==1))
{
vpts_t_Vtnode_GND=(vpts*vds_t_Vtnode_GND)/vds;
if (doAC)
{
vpts_t=((vpts*vds_t)/vds);
}
}
else
{
if (doAC)
{
vpts_t=vpts;
}
vpts_t_Vtnode_GND=0.0;
}
}
else
{
if (doAC)
{
cjs0_t=cjs0;
}
cjs0_t_Vtnode_GND=0.0;
if (doAC)
{
vds_t=vds;
}
vds_t_Vtnode_GND=0.0;
if (doAC)
{
vpts_t=vpts;
}
vpts_t_Vtnode_GND=0.0;
}
DIOY_Vtnode_GND=(-(BP(bi,ei)*(mbei*VT_Vtnode_GND))/((mbei*VT)*(mbei*VT)));
DIOY_Vbi_ei=(1/(mbei*VT));
DIOY=(BP(bi,ei)/(mbei*VT));
DIOY_Vsi_ci=0.0;
DIOY_Vbp_ci=0.0;
DIOY_Vbp_ei=0.0;
DIOY_Vbi_ci=0.0;
if ((ibeis>0.0))
{
if ((DIOY>80.0))
{
le_Vtnode_GND=(+DIOY_Vtnode_GND);
le_Vbi_ei=(+DIOY_Vbi_ei);
le=(1+(DIOY-80.0));
le_Vsi_ci=0.0;
le_Vbp_ci=0.0;
le_Vbp_ei=0.0;
le_Vbi_ci=0.0;
DIOY=80.0;
DIOY_Vsi_ci=0.0;
DIOY_Vbp_ci=0.0;
DIOY_Vbp_ei=0.0;
DIOY_Vbi_ci=0.0;
DIOY_Vbi_ei=0.0;
DIOY_Vtnode_GND=0.0;
}
else
{
le=1;
le_Vsi_ci=0.0;
le_Vbp_ci=0.0;
le_Vbp_ei=0.0;
le_Vbi_ci=0.0;
le_Vbi_ei=0.0;
le_Vtnode_GND=0.0;
}
{
double __limexp_0=0.0;
double __d_limexp_0=0.0;
_d_limexp(__limexp_0,__d_limexp_0,(DIOY));
_limexp(__limexp_0,(DIOY));
le_Vtnode_GND=((le_Vtnode_GND*__limexp_0)+(le*DIOY_Vtnode_GND*__d_limexp_0));
le_Vbi_ei=((le_Vbi_ei*__limexp_0)+(le*DIOY_Vbi_ei*__d_limexp_0));
le=(le*__limexp_0);
le_Vsi_ci=0.0;
le_Vbp_ci=0.0;
le_Vbp_ei=0.0;
le_Vbi_ci=0.0;
}
ibei_Vbi_ei=(ibeis_t*le_Vbi_ei);
ibei_Vtnode_GND=((ibeis_t_Vtnode_GND*(le-1.0))+(ibeis_t*le_Vtnode_GND));
ibei=(ibeis_t*(le-1.0));
if ((DIOY<=(-14.0)))
{
ibei_Vtnode_GND=(-ibeis_t_Vtnode_GND);
ibei=(-ibeis_t);
ibei_Vbi_ei=0.0;
}
}
else
{
ibei=0.0;
ibei_Vtnode_GND=0.0;
ibei_Vbi_ei=0.0;
}
DIOY_Vtnode_GND=(-(BP(bi,ei)*(mrei*VT_Vtnode_GND))/((mrei*VT)*(mrei*VT)));
DIOY_Vbi_ei=(1/(mrei*VT));
DIOY=(BP(bi,ei)/(mrei*VT));
DIOY_Vsi_ci=0.0;
DIOY_Vbp_ci=0.0;
DIOY_Vbp_ei=0.0;
DIOY_Vbi_ci=0.0;
if ((ireis>0.0))
{
if ((DIOY>80.0))
{
le_Vtnode_GND=(+DIOY_Vtnode_GND);
le_Vbi_ei=(+DIOY_Vbi_ei);
le=(1+(DIOY-80.0));
le_Vsi_ci=0.0;
le_Vbp_ci=0.0;
le_Vbp_ei=0.0;
le_Vbi_ci=0.0;
DIOY=80.0;
DIOY_Vsi_ci=0.0;
DIOY_Vbp_ci=0.0;
DIOY_Vbp_ei=0.0;
DIOY_Vbi_ci=0.0;
DIOY_Vbi_ei=0.0;
DIOY_Vtnode_GND=0.0;
}
else
{
le=1;
le_Vsi_ci=0.0;
le_Vbp_ci=0.0;
le_Vbp_ei=0.0;
le_Vbi_ci=0.0;
le_Vbi_ei=0.0;
le_Vtnode_GND=0.0;
}
{
double __limexp_0=0.0;
double __d_limexp_0=0.0;
_d_limexp(__limexp_0,__d_limexp_0,(DIOY));
_limexp(__limexp_0,(DIOY));
le_Vtnode_GND=((le_Vtnode_GND*__limexp_0)+(le*DIOY_Vtnode_GND*__d_limexp_0));
le_Vbi_ei=((le_Vbi_ei*__limexp_0)+(le*DIOY_Vbi_ei*__d_limexp_0));
le=(le*__limexp_0);
le_Vsi_ci=0.0;
le_Vbp_ci=0.0;
le_Vbp_ei=0.0;
le_Vbi_ci=0.0;
}
irei_Vbi_ei=(ireis_t*le_Vbi_ei);
irei_Vtnode_GND=((ireis_t_Vtnode_GND*(le-1.0))+(ireis_t*le_Vtnode_GND));
irei=(ireis_t*(le-1.0));
if ((DIOY<=(-14.0)))
{
irei_Vtnode_GND=(-ireis_t_Vtnode_GND);
irei=(-ireis_t);
irei_Vbi_ei=0.0;
}
}
else
{
irei=0.0;
irei_Vtnode_GND=0.0;
irei_Vbi_ei=0.0;
}
if ((ich>0.0))
{
Oich=(1.0/ich);
}
else
{
Oich=0.0;
}
if ((vpt>0.0))
{
Ovpt=(1.0/vpt);
}
else
{
Ovpt=0.0;
}
Tr=tr;
VT_f_Vtnode_GND=(mcf*VT_Vtnode_GND);
VT_f=(mcf*VT);
{
double __limexp_0=0.0;
double __d_limexp_0=0.0;
_d_limexp(__limexp_0,__d_limexp_0,((BP(bi,ei)/VT_f)));
_limexp(__limexp_0,((BP(bi,ei)/VT_f)));
i_0f_Vbi_ei=(c10_t*(1/VT_f)*__d_limexp_0);
i_0f_Vtnode_GND=((c10_t_Vtnode_GND*__limexp_0)+(c10_t*(-(BP(bi,ei)*VT_f_Vtnode_GND)/(VT_f*VT_f))*__d_limexp_0));
i_0f=(c10_t*__limexp_0);
}
{
double __limexp_0=0.0;
double __d_limexp_0=0.0;
_d_limexp(__limexp_0,__d_limexp_0,((BP(bi,ci)/VT)));
_limexp(__limexp_0,((BP(bi,ci)/VT)));
i_0r_Vbi_ci=(c10_t*(1/VT)*__d_limexp_0);
i_0r_Vtnode_GND=((c10_t_Vtnode_GND*__limexp_0)+(c10_t*(-(BP(bi,ci)*VT_Vtnode_GND)/(VT*VT))*__d_limexp_0));
i_0r=(c10_t*__limexp_0);
}
if ((cjei0_t>0.0))
{
{
double __logE_0=0.0;
double __exp_1=0.0;
double __d_logE_0=0.0;
double __d_exp_1=0.0;
_d_logE(__logE_0,__d_logE_0,(aljei_t));
_d_exp(__exp_1,__d_exp_1,(((-__logE_0)/zei)));
_logE(__logE_0,(aljei_t));
_exp(__exp_1,(((-__logE_0)/zei)));
DFV_f_Vtnode_GND=((vdei_t_Vtnode_GND*(1.0-__exp_1))+(vdei_t*(-(-aljei_t_Vtnode_GND*__d_logE_0)/zei*__d_exp_1)));
DFV_f=(vdei_t*(1.0-__exp_1));
}
DFC_max_Vtnode_GND=((aljei_t_Vtnode_GND*cjei0_t)+(aljei_t*cjei0_t_Vtnode_GND));
DFC_max=(aljei_t*cjei0_t);
DFv_e_Vbi_ei=(-1.0)/VT;
DFv_e_Vtnode_GND=(DFV_f_Vtnode_GND*VT-(DFV_f-BP(bi,ei))*VT_Vtnode_GND)/(VT*VT);
DFv_e=((DFV_f-BP(bi,ei))/VT);
DFv_e_Vsi_ci=0.0;
DFv_e_Vb_ci=0.0;
DFv_e_Vbp_ci=0.0;
DFv_e_Vbp_ei=0.0;
DFv_e_Vbi_ci=0.0;
if ((DFv_e<80.0))
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(DFv_e));
_exp(__exp_0,(DFv_e));
DFe_Vbi_ei=DFv_e_Vbi_ei*__d_exp_0;
DFe_Vtnode_GND=DFv_e_Vtnode_GND*__d_exp_0;
DFe=__exp_0;
DFe_Vsi_ci=0.0;
DFe_Vb_ci=0.0;
DFe_Vbp_ci=0.0;
DFe_Vbp_ei=0.0;
DFe_Vbi_ci=0.0;
}
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0+DFe)));
_logE(__logE_0,((1.0+DFe)));
DFv_j_Vbi_ei=(-(VT*(+DFe_Vbi_ei)*__d_logE_0));
DFv_j_Vtnode_GND=(DFV_f_Vtnode_GND-((VT_Vtnode_GND*__logE_0)+(VT*(+DFe_Vtnode_GND)*__d_logE_0)));
DFv_j=(DFV_f-(VT*__logE_0));
DFv_j_Vsi_ci=0.0;
DFv_j_Vb_ci=0.0;
DFv_j_Vbp_ci=0.0;
DFv_j_Vbp_ei=0.0;
DFv_j_Vbi_ci=0.0;
}
DFdvj_dv_Vbi_ei=(DFe_Vbi_ei*(1.0+DFe)-DFe*(+DFe_Vbi_ei))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv_Vtnode_GND=(DFe_Vtnode_GND*(1.0+DFe)-DFe*(+DFe_Vtnode_GND))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv=(DFe/(1.0+DFe));
DFdvj_dv_Vsi_ci=0.0;
DFdvj_dv_Vb_ci=0.0;
DFdvj_dv_Vbp_ci=0.0;
DFdvj_dv_Vbp_ei=0.0;
DFdvj_dv_Vbi_ci=0.0;
}
else
{
DFv_j_Vbi_ei=1.0;
DFv_j=BP(bi,ei);
DFv_j_Vsi_ci=0.0;
DFv_j_Vb_ci=0.0;
DFv_j_Vbp_ci=0.0;
DFv_j_Vbp_ei=0.0;
DFv_j_Vbi_ci=0.0;
DFv_j_Vtnode_GND=0.0;
DFdvj_dv=1;
DFdvj_dv_Vsi_ci=0.0;
DFdvj_dv_Vb_ci=0.0;
DFdvj_dv_Vbp_ci=0.0;
DFdvj_dv_Vbp_ei=0.0;
DFdvj_dv_Vbi_ci=0.0;
DFdvj_dv_Vtnode_GND=0.0;
DFdvj_dv_Vbi_ei=0.0;
}
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0-(DFv_j/vdei_t))));
_logE(__logE_0,((1.0-(DFv_j/vdei_t))));
DFb_Vbi_ei=(-DFv_j_Vbi_ei/vdei_t)*__d_logE_0;
DFb_Vtnode_GND=(-(DFv_j_Vtnode_GND*vdei_t-DFv_j*vdei_t_Vtnode_GND)/(vdei_t*vdei_t))*__d_logE_0;
DFb=__logE_0;
DFb_Vsi_ci=0.0;
DFb_Vb_ci=0.0;
DFb_Vbp_ci=0.0;
DFb_Vbp_ei=0.0;
DFb_Vbi_ci=0.0;
}
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(((-zei)*DFb)));
_exp(__exp_0,(((-zei)*DFb)));
DFC_j1_Vbi_ei=(((cjei0_t*((-zei)*DFb_Vbi_ei)*__d_exp_0)*DFdvj_dv)+((cjei0_t*__exp_0)*DFdvj_dv_Vbi_ei));
DFC_j1_Vtnode_GND=((((cjei0_t_Vtnode_GND*__exp_0)+(cjei0_t*((-zei)*DFb_Vtnode_GND)*__d_exp_0))*DFdvj_dv)+((cjei0_t*__exp_0)*DFdvj_dv_Vtnode_GND));
DFC_j1=((cjei0_t*__exp_0)*DFdvj_dv);
DFC_j1_Vsi_ci=0.0;
DFC_j1_Vb_ci=0.0;
DFC_j1_Vbp_ci=0.0;
DFC_j1_Vbp_ei=0.0;
DFC_j1_Vbi_ci=0.0;
}
if (doAC)
{
Cjei=(DFC_j1+(DFC_max*(1.0-DFdvj_dv)));
}
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DFb*(1.0-zei))));
_exp(__exp_0,((DFb*(1.0-zei))));
DFQ_j_Vbi_ei=((cjei0_t*vdei_t)*(-DFb_Vbi_ei*(1.0-zei)*__d_exp_0))/(1.0-zei);
DFQ_j_Vtnode_GND=((((cjei0_t_Vtnode_GND*vdei_t)+(cjei0_t*vdei_t_Vtnode_GND))*(1.0-__exp_0))+((cjei0_t*vdei_t)*(-DFb_Vtnode_GND*(1.0-zei)*__d_exp_0)))/(1.0-zei);
DFQ_j=(((cjei0_t*vdei_t)*(1.0-__exp_0))/(1.0-zei));
DFQ_j_Vsi_ci=0.0;
DFQ_j_Vb_ci=0.0;
DFQ_j_Vbp_ci=0.0;
DFQ_j_Vbp_ei=0.0;
DFQ_j_Vbi_ci=0.0;
}
Qjei_Vbi_ei=(DFQ_j_Vbi_ei+(DFC_max*(1.0-DFv_j_Vbi_ei)));
Qjei_Vtnode_GND=(DFQ_j_Vtnode_GND+((DFC_max_Vtnode_GND*(BP(bi,ei)-DFv_j))+(DFC_max*(-DFv_j_Vtnode_GND))));
Qjei=(DFQ_j+(DFC_max*(BP(bi,ei)-DFv_j)));
}
else
{
if (doAC)
{
Cjei=0.0;
}
Qjei=0.0;
Qjei_Vtnode_GND=0.0;
Qjei_Vbi_ei=0.0;
}
if ((vptci_t<1.0e2))
{
if ((cjci0_t>0.0))
{
Dz_r=(zci/4.0);
Dv_p_Vtnode_GND=(vptci_t_Vtnode_GND-vdci_t_Vtnode_GND);
Dv_p=(vptci_t-vdci_t);
{
double __logE_0=0.0;
double __exp_1=0.0;
_logE(__logE_0,(2.4));
_exp(__exp_1,(((-__logE_0)/zci)));
DV_f_Vtnode_GND=vdci_t_Vtnode_GND*(1.0-__exp_1);
DV_f=(vdci_t*(1.0-__exp_1));
}
DC_max_Vtnode_GND=(2.4*cjci0_t_Vtnode_GND);
DC_max=(2.4*cjci0_t);
{
double __logE_0=0.0;
double __exp_1=0.0;
double __d_logE_0=0.0;
double __d_exp_1=0.0;
_d_logE(__logE_0,__d_logE_0,((vptci_t/vdci_t)));
_d_exp(__exp_1,__d_exp_1,((__logE_0*(Dz_r-zci))));
_logE(__logE_0,((vptci_t/vdci_t)));
_exp(__exp_1,((__logE_0*(Dz_r-zci))));
DC_c_Vtnode_GND=((cjci0_t_Vtnode_GND*__exp_1)+(cjci0_t*(vptci_t_Vtnode_GND*vdci_t-vptci_t*vdci_t_Vtnode_GND)/(vdci_t*vdci_t)*__d_logE_0*(Dz_r-zci)*__d_exp_1));
DC_c=(cjci0_t*__exp_1);
}
Da_Vtnode_GND=VT_Vtnode_GND;
Da=VT;
Dv_e_Vbi_ci=(-1.0)/Da;
Dv_e_Vtnode_GND=(DV_f_Vtnode_GND*Da-(DV_f-BP(bi,ci))*Da_Vtnode_GND)/(Da*Da);
Dv_e=((DV_f-BP(bi,ci))/Da);
Dv_e_Vsi_ci=0.0;
Dv_e_Vb_ci=0.0;
Dv_e_Vbp_ci=0.0;
if ((Dv_e<80.0))
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(Dv_e));
_exp(__exp_0,(Dv_e));
De_Vbi_ci=Dv_e_Vbi_ci*__d_exp_0;
De_Vtnode_GND=Dv_e_Vtnode_GND*__d_exp_0;
De=__exp_0;
De_Vsi_ci=0.0;
De_Vb_ci=0.0;
De_Vbp_ci=0.0;
}
De_1_Vbi_ci=(De_Vbi_ci*(1.0+De)-De*(+De_Vbi_ci))/((1.0+De)*(1.0+De));
De_1_Vtnode_GND=(De_Vtnode_GND*(1.0+De)-De*(+De_Vtnode_GND))/((1.0+De)*(1.0+De));
De_1=(De/(1.0+De));
De_1_Vsi_ci=0.0;
De_1_Vb_ci=0.0;
De_1_Vbp_ci=0.0;
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0+De)));
_logE(__logE_0,((1.0+De)));
Dv_j1_Vbi_ci=(-(Da*(+De_Vbi_ci)*__d_logE_0));
Dv_j1_Vtnode_GND=(DV_f_Vtnode_GND-((Da_Vtnode_GND*__logE_0)+(Da*(+De_Vtnode_GND)*__d_logE_0)));
Dv_j1=(DV_f-(Da*__logE_0));
Dv_j1_Vsi_ci=0.0;
Dv_j1_Vb_ci=0.0;
Dv_j1_Vbp_ci=0.0;
}
}
else
{
De_1=1.0;
De_1_Vsi_ci=0.0;
De_1_Vb_ci=0.0;
De_1_Vbp_ci=0.0;
De_1_Vtnode_GND=0.0;
De_1_Vbi_ci=0.0;
Dv_j1_Vbi_ci=1.0;
Dv_j1=BP(bi,ci);
Dv_j1_Vsi_ci=0.0;
Dv_j1_Vb_ci=0.0;
Dv_j1_Vbp_ci=0.0;
Dv_j1_Vtnode_GND=0.0;
}
Da_Vtnode_GND=((0.1*Dv_p_Vtnode_GND)+(4.0*VT_Vtnode_GND));
Da=((0.1*Dv_p)+(4.0*VT));
Dv_r_Vbi_ci=(+Dv_j1_Vbi_ci)/Da;
Dv_r_Vtnode_GND=((Dv_p_Vtnode_GND+Dv_j1_Vtnode_GND)*Da-(Dv_p+Dv_j1)*Da_Vtnode_GND)/(Da*Da);
Dv_r=((Dv_p+Dv_j1)/Da);
Dv_r_Vsi_ci=0.0;
Dv_r_Vb_ci=0.0;
Dv_r_Vbp_ci=0.0;
if ((Dv_r<80.0))
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(Dv_r));
_exp(__exp_0,(Dv_r));
De_Vbi_ci=Dv_r_Vbi_ci*__d_exp_0;
De_Vtnode_GND=Dv_r_Vtnode_GND*__d_exp_0;
De=__exp_0;
De_Vsi_ci=0.0;
De_Vb_ci=0.0;
De_Vbp_ci=0.0;
}
De_2_Vbi_ci=(De_Vbi_ci*(1.0+De)-De*(+De_Vbi_ci))/((1.0+De)*(1.0+De));
De_2_Vtnode_GND=(De_Vtnode_GND*(1.0+De)-De*(+De_Vtnode_GND))/((1.0+De)*(1.0+De));
De_2=(De/(1.0+De));
De_2_Vsi_ci=0.0;
De_2_Vb_ci=0.0;
De_2_Vbp_ci=0.0;
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0+De)));
_logE(__logE_0,((1.0+De)));
Dv_j2_Vbi_ci=(+(Da*(+De_Vbi_ci)*__d_logE_0));
Dv_j2_Vtnode_GND=((-Dv_p_Vtnode_GND)+((Da_Vtnode_GND*__logE_0)+(Da*(+De_Vtnode_GND)*__d_logE_0)));
Dv_j2=((-Dv_p)+(Da*__logE_0));
Dv_j2_Vsi_ci=0.0;
Dv_j2_Vb_ci=0.0;
Dv_j2_Vbp_ci=0.0;
}
}
else
{
De_2=1.0;
De_2_Vsi_ci=0.0;
De_2_Vb_ci=0.0;
De_2_Vbp_ci=0.0;
De_2_Vtnode_GND=0.0;
De_2_Vbi_ci=0.0;
Dv_j2_Vbi_ci=Dv_j1_Vbi_ci;
Dv_j2_Vtnode_GND=Dv_j1_Vtnode_GND;
Dv_j2=Dv_j1;
Dv_j2_Vsi_ci=0.0;
Dv_j2_Vb_ci=0.0;
Dv_j2_Vbp_ci=0.0;
}
Dv_j4_Vtnode_GND=(-Dv_j1_Vtnode_GND);
Dv_j4_Vbi_ci=(1.0-Dv_j1_Vbi_ci);
Dv_j4=(BP(bi,ci)-Dv_j1);
Dv_j4_Vsi_ci=0.0;
Dv_j4_Vb_ci=0.0;
Dv_j4_Vbp_ci=0.0;
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0-(Dv_j1/vdci_t))));
_logE(__logE_0,((1.0-(Dv_j1/vdci_t))));
DCln1_Vbi_ci=(-Dv_j1_Vbi_ci/vdci_t)*__d_logE_0;
DCln1_Vtnode_GND=(-(Dv_j1_Vtnode_GND*vdci_t-Dv_j1*vdci_t_Vtnode_GND)/(vdci_t*vdci_t))*__d_logE_0;
DCln1=__logE_0;
DCln1_Vsi_ci=0.0;
DCln1_Vb_ci=0.0;
DCln1_Vbp_ci=0.0;
}
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0-(Dv_j2/vdci_t))));
_logE(__logE_0,((1.0-(Dv_j2/vdci_t))));
DCln2_Vbi_ci=(-Dv_j2_Vbi_ci/vdci_t)*__d_logE_0;
DCln2_Vtnode_GND=(-(Dv_j2_Vtnode_GND*vdci_t-Dv_j2*vdci_t_Vtnode_GND)/(vdci_t*vdci_t))*__d_logE_0;
DCln2=__logE_0;
DCln2_Vsi_ci=0.0;
DCln2_Vb_ci=0.0;
DCln2_Vbp_ci=0.0;
}
Dz1=(1.0-zci);
Dzr1=(1.0-Dz_r);
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DCln2*(-zci))));
_exp(__exp_0,((DCln2*(-zci))));
DC_j1_Vbi_ci=(((((cjci0_t*DCln2_Vbi_ci*(-zci)*__d_exp_0)*De_1)+((cjci0_t*__exp_0)*De_1_Vbi_ci))*De_2)+(((cjci0_t*__exp_0)*De_1)*De_2_Vbi_ci));
DC_j1_Vtnode_GND=((((((cjci0_t_Vtnode_GND*__exp_0)+(cjci0_t*DCln2_Vtnode_GND*(-zci)*__d_exp_0))*De_1)+((cjci0_t*__exp_0)*De_1_Vtnode_GND))*De_2)+(((cjci0_t*__exp_0)*De_1)*De_2_Vtnode_GND));
DC_j1=(((cjci0_t*__exp_0)*De_1)*De_2);
DC_j1_Vsi_ci=0.0;
DC_j1_Vb_ci=0.0;
DC_j1_Vbp_ci=0.0;
}
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DCln1*(-Dz_r))));
_exp(__exp_0,((DCln1*(-Dz_r))));
DC_j2_Vbi_ci=(((DC_c*DCln1_Vbi_ci*(-Dz_r)*__d_exp_0)*(1.0-De_2))+((DC_c*__exp_0)*(-De_2_Vbi_ci)));
DC_j2_Vtnode_GND=((((DC_c_Vtnode_GND*__exp_0)+(DC_c*DCln1_Vtnode_GND*(-Dz_r)*__d_exp_0))*(1.0-De_2))+((DC_c*__exp_0)*(-De_2_Vtnode_GND)));
DC_j2=((DC_c*__exp_0)*(1.0-De_2));
DC_j2_Vsi_ci=0.0;
DC_j2_Vb_ci=0.0;
DC_j2_Vbp_ci=0.0;
}
DC_j3_Vbi_ci=(DC_max*(-De_1_Vbi_ci));
DC_j3_Vtnode_GND=((DC_max_Vtnode_GND*(1.0-De_1))+(DC_max*(-De_1_Vtnode_GND)));
DC_j3=(DC_max*(1.0-De_1));
DC_j3_Vsi_ci=0.0;
DC_j3_Vb_ci=0.0;
DC_j3_Vbp_ci=0.0;
Cjci_Vbi_ci=((DC_j1_Vbi_ci+DC_j2_Vbi_ci)+DC_j3_Vbi_ci);
Cjci_Vtnode_GND=((DC_j1_Vtnode_GND+DC_j2_Vtnode_GND)+DC_j3_Vtnode_GND);
Cjci=((DC_j1+DC_j2)+DC_j3);
Cjci_Vbi_ei=0.0;
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DCln2*Dz1)));
_exp(__exp_0,((DCln2*Dz1)));
DQ_j1_Vbi_ci=(cjci0_t*(-DCln2_Vbi_ci*Dz1*__d_exp_0))/Dz1;
DQ_j1_Vtnode_GND=((cjci0_t_Vtnode_GND*(1.0-__exp_0))+(cjci0_t*(-DCln2_Vtnode_GND*Dz1*__d_exp_0)))/Dz1;
DQ_j1=((cjci0_t*(1.0-__exp_0))/Dz1);
DQ_j1_Vsi_ci=0.0;
DQ_j1_Vb_ci=0.0;
DQ_j1_Vbp_ci=0.0;
}
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DCln1*Dzr1)));
_exp(__exp_0,((DCln1*Dzr1)));
DQ_j2_Vbi_ci=(DC_c*(-DCln1_Vbi_ci*Dzr1*__d_exp_0))/Dzr1;
DQ_j2_Vtnode_GND=((DC_c_Vtnode_GND*(1.0-__exp_0))+(DC_c*(-DCln1_Vtnode_GND*Dzr1*__d_exp_0)))/Dzr1;
DQ_j2=((DC_c*(1.0-__exp_0))/Dzr1);
DQ_j2_Vsi_ci=0.0;
DQ_j2_Vb_ci=0.0;
DQ_j2_Vbp_ci=0.0;
}
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DCln2*Dzr1)));
_exp(__exp_0,((DCln2*Dzr1)));
DQ_j3_Vbi_ci=(DC_c*(-DCln2_Vbi_ci*Dzr1*__d_exp_0))/Dzr1;
DQ_j3_Vtnode_GND=((DC_c_Vtnode_GND*(1.0-__exp_0))+(DC_c*(-DCln2_Vtnode_GND*Dzr1*__d_exp_0)))/Dzr1;
DQ_j3=((DC_c*(1.0-__exp_0))/Dzr1);
DQ_j3_Vsi_ci=0.0;
DQ_j3_Vb_ci=0.0;
DQ_j3_Vbp_ci=0.0;
}
Qjci_Vbi_ci=(((DQ_j1_Vbi_ci+DQ_j2_Vbi_ci)-DQ_j3_Vbi_ci)*vdci_t+(DC_max*Dv_j4_Vbi_ci));
Qjci_Vtnode_GND=(((((DQ_j1_Vtnode_GND+DQ_j2_Vtnode_GND)-DQ_j3_Vtnode_GND)*vdci_t)+(((DQ_j1+DQ_j2)-DQ_j3)*vdci_t_Vtnode_GND))+((DC_max_Vtnode_GND*Dv_j4)+(DC_max*Dv_j4_Vtnode_GND)));
Qjci=((((DQ_j1+DQ_j2)-DQ_j3)*vdci_t)+(DC_max*Dv_j4));
Qjci_Vbi_ei=0.0;
}
else
{
Cjci=0.0;
Cjci_Vbi_ei=0.0;
Cjci_Vtnode_GND=0.0;
Cjci_Vbi_ci=0.0;
Qjci=0.0;
Qjci_Vbi_ei=0.0;
Qjci_Vtnode_GND=0.0;
Qjci_Vbi_ci=0.0;
}
}
else
{
if ((cjci0_t>0.0))
{
{
double __logE_0=0.0;
double __exp_1=0.0;
_logE(__logE_0,(2.4));
_exp(__exp_1,(((-__logE_0)/zci)));
DFV_f_Vtnode_GND=vdci_t_Vtnode_GND*(1.0-__exp_1);
DFV_f=(vdci_t*(1.0-__exp_1));
}
DFC_max_Vtnode_GND=(2.4*cjci0_t_Vtnode_GND);
DFC_max=(2.4*cjci0_t);
DFv_e_Vbi_ci=(-1.0)/VT;
DFv_e_Vtnode_GND=(DFV_f_Vtnode_GND*VT-(DFV_f-BP(bi,ci))*VT_Vtnode_GND)/(VT*VT);
DFv_e=((DFV_f-BP(bi,ci))/VT);
DFv_e_Vsi_ci=0.0;
DFv_e_Vb_ci=0.0;
DFv_e_Vbp_ci=0.0;
DFv_e_Vbp_ei=0.0;
DFv_e_Vbi_ei=0.0;
if ((DFv_e<80.0))
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(DFv_e));
_exp(__exp_0,(DFv_e));
DFe_Vbi_ei=DFv_e_Vbi_ei*__d_exp_0;
DFe_Vtnode_GND=DFv_e_Vtnode_GND*__d_exp_0;
DFe_Vbi_ci=DFv_e_Vbi_ci*__d_exp_0;
DFe=__exp_0;
DFe_Vsi_ci=0.0;
DFe_Vb_ci=0.0;
DFe_Vbp_ci=0.0;
DFe_Vbp_ei=0.0;
}
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0+DFe)));
_logE(__logE_0,((1.0+DFe)));
DFv_j_Vbi_ei=(-(VT*(+DFe_Vbi_ei)*__d_logE_0));
DFv_j_Vbi_ci=(-(VT*(+DFe_Vbi_ci)*__d_logE_0));
DFv_j_Vtnode_GND=(DFV_f_Vtnode_GND-((VT_Vtnode_GND*__logE_0)+(VT*(+DFe_Vtnode_GND)*__d_logE_0)));
DFv_j=(DFV_f-(VT*__logE_0));
DFv_j_Vsi_ci=0.0;
DFv_j_Vb_ci=0.0;
DFv_j_Vbp_ci=0.0;
DFv_j_Vbp_ei=0.0;
}
DFdvj_dv_Vbi_ei=(DFe_Vbi_ei*(1.0+DFe)-DFe*(+DFe_Vbi_ei))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv_Vtnode_GND=(DFe_Vtnode_GND*(1.0+DFe)-DFe*(+DFe_Vtnode_GND))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv_Vbi_ci=(DFe_Vbi_ci*(1.0+DFe)-DFe*(+DFe_Vbi_ci))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv=(DFe/(1.0+DFe));
DFdvj_dv_Vsi_ci=0.0;
DFdvj_dv_Vb_ci=0.0;
DFdvj_dv_Vbp_ci=0.0;
DFdvj_dv_Vbp_ei=0.0;
}
else
{
DFv_j_Vbi_ci=1.0;
DFv_j=BP(bi,ci);
DFv_j_Vsi_ci=0.0;
DFv_j_Vb_ci=0.0;
DFv_j_Vbp_ci=0.0;
DFv_j_Vbp_ei=0.0;
DFv_j_Vtnode_GND=0.0;
DFv_j_Vbi_ei=0.0;
DFdvj_dv=1;
DFdvj_dv_Vsi_ci=0.0;
DFdvj_dv_Vb_ci=0.0;
DFdvj_dv_Vbp_ci=0.0;
DFdvj_dv_Vbp_ei=0.0;
DFdvj_dv_Vbi_ci=0.0;
DFdvj_dv_Vtnode_GND=0.0;
DFdvj_dv_Vbi_ei=0.0;
}
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0-(DFv_j/vdci_t))));
_logE(__logE_0,((1.0-(DFv_j/vdci_t))));
DFb_Vbi_ei=(-DFv_j_Vbi_ei/vdci_t)*__d_logE_0;
DFb_Vtnode_GND=(-(DFv_j_Vtnode_GND*vdci_t-DFv_j*vdci_t_Vtnode_GND)/(vdci_t*vdci_t))*__d_logE_0;
DFb_Vbi_ci=(-DFv_j_Vbi_ci/vdci_t)*__d_logE_0;
DFb=__logE_0;
DFb_Vsi_ci=0.0;
DFb_Vb_ci=0.0;
DFb_Vbp_ci=0.0;
DFb_Vbp_ei=0.0;
}
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(((-zci)*DFb)));
_exp(__exp_0,(((-zci)*DFb)));
DFC_j1_Vbi_ei=(((cjci0_t*((-zci)*DFb_Vbi_ei)*__d_exp_0)*DFdvj_dv)+((cjci0_t*__exp_0)*DFdvj_dv_Vbi_ei));
DFC_j1_Vbi_ci=(((cjci0_t*((-zci)*DFb_Vbi_ci)*__d_exp_0)*DFdvj_dv)+((cjci0_t*__exp_0)*DFdvj_dv_Vbi_ci));
DFC_j1_Vtnode_GND=((((cjci0_t_Vtnode_GND*__exp_0)+(cjci0_t*((-zci)*DFb_Vtnode_GND)*__d_exp_0))*DFdvj_dv)+((cjci0_t*__exp_0)*DFdvj_dv_Vtnode_GND));
DFC_j1=((cjci0_t*__exp_0)*DFdvj_dv);
DFC_j1_Vsi_ci=0.0;
DFC_j1_Vb_ci=0.0;
DFC_j1_Vbp_ci=0.0;
DFC_j1_Vbp_ei=0.0;
}
Cjci_Vbi_ei=(DFC_j1_Vbi_ei+(DFC_max*(-DFdvj_dv_Vbi_ei)));
Cjci_Vtnode_GND=(DFC_j1_Vtnode_GND+((DFC_max_Vtnode_GND*(1.0-DFdvj_dv))+(DFC_max*(-DFdvj_dv_Vtnode_GND))));
Cjci_Vbi_ci=(DFC_j1_Vbi_ci+(DFC_max*(-DFdvj_dv_Vbi_ci)));
Cjci=(DFC_j1+(DFC_max*(1.0-DFdvj_dv)));
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DFb*(1.0-zci))));
_exp(__exp_0,((DFb*(1.0-zci))));
DFQ_j_Vbi_ei=((cjci0_t*vdci_t)*(-DFb_Vbi_ei*(1.0-zci)*__d_exp_0))/(1.0-zci);
DFQ_j_Vbi_ci=((cjci0_t*vdci_t)*(-DFb_Vbi_ci*(1.0-zci)*__d_exp_0))/(1.0-zci);
DFQ_j_Vtnode_GND=((((cjci0_t_Vtnode_GND*vdci_t)+(cjci0_t*vdci_t_Vtnode_GND))*(1.0-__exp_0))+((cjci0_t*vdci_t)*(-DFb_Vtnode_GND*(1.0-zci)*__d_exp_0)))/(1.0-zci);
DFQ_j=(((cjci0_t*vdci_t)*(1.0-__exp_0))/(1.0-zci));
DFQ_j_Vsi_ci=0.0;
DFQ_j_Vb_ci=0.0;
DFQ_j_Vbp_ci=0.0;
DFQ_j_Vbp_ei=0.0;
}
Qjci_Vbi_ei=(DFQ_j_Vbi_ei+(DFC_max*(-DFv_j_Vbi_ei)));
Qjci_Vtnode_GND=(DFQ_j_Vtnode_GND+((DFC_max_Vtnode_GND*(BP(bi,ci)-DFv_j))+(DFC_max*(-DFv_j_Vtnode_GND))));
Qjci_Vbi_ci=(DFQ_j_Vbi_ci+(DFC_max*(1.0-DFv_j_Vbi_ci)));
Qjci=(DFQ_j+(DFC_max*(BP(bi,ci)-DFv_j)));
}
else
{
Cjci=0.0;
Cjci_Vbi_ei=0.0;
Cjci_Vtnode_GND=0.0;
Cjci_Vbi_ci=0.0;
Qjci=0.0;
Qjci_Vbi_ei=0.0;
Qjci_Vtnode_GND=0.0;
Qjci_Vbi_ci=0.0;
}
}
Q_0_Vbi_ci=(+(hjci*Qjci_Vbi_ci));
Q_0_Vbi_ei=((+(hjei*Qjei_Vbi_ei))+(hjci*Qjci_Vbi_ei));
Q_0_Vtnode_GND=((qp0_t_Vtnode_GND+(hjei*Qjei_Vtnode_GND))+(hjci*Qjci_Vtnode_GND));
Q_0=((qp0_t+(hjei*Qjei))+(hjci*Qjci));
if ((Q_0<(0.6*qp0_t)))
{
a_bpt=0.05;
Q_bpt_Vtnode_GND=(a_bpt*qp0_t_Vtnode_GND);
Q_bpt=(a_bpt*qp0_t);
b_q_Vbi_ci=Q_0_Vbi_ci/Q_bpt;
b_q_Vbi_ei=Q_0_Vbi_ei/Q_bpt;
b_q_Vtnode_GND=(Q_0_Vtnode_GND*Q_bpt-Q_0*Q_bpt_Vtnode_GND)/(Q_bpt*Q_bpt);
b_q=((Q_0/Q_bpt)-1.0);
{
double __exp_0=0.0;
double __logE_1=0.0;
double __d_exp_0=0.0;
double __d_logE_1=0.0;
_d_exp(__exp_0,__d_exp_0,(b_q));
_d_logE(__logE_1,__d_logE_1,((1+__exp_0)));
_exp(__exp_0,(b_q));
_logE(__logE_1,((1+__exp_0)));
Q_0_Vbi_ci=(Q_bpt*(+(+b_q_Vbi_ci*__d_exp_0)*__d_logE_1));
Q_0_Vbi_ei=(Q_bpt*(+(+b_q_Vbi_ei*__d_exp_0)*__d_logE_1));
Q_0_Vtnode_GND=((Q_bpt_Vtnode_GND*(1+__logE_1))+(Q_bpt*(+(+b_q_Vtnode_GND*__d_exp_0)*__d_logE_1)));
Q_0=(Q_bpt*(1+__logE_1));
}
}
if ((cjci0_t>0.0))
{
{
double __logE_0=0.0;
double __exp_1=0.0;
_logE(__logE_0,(2.4));
_exp(__exp_1,(((-__logE_0)/zci)));
DFV_f_Vtnode_GND=vdci_t_Vtnode_GND*(1.0-__exp_1);
DFV_f=(vdci_t*(1.0-__exp_1));
}
DFC_max_Vtnode_GND=(2.4*cjci0_t_Vtnode_GND);
DFC_max=(2.4*cjci0_t);
DFv_e_Vbi_ci=(-1.0)/VT;
DFv_e_Vtnode_GND=(DFV_f_Vtnode_GND*VT-(DFV_f-BP(bi,ci))*VT_Vtnode_GND)/(VT*VT);
DFv_e=((DFV_f-BP(bi,ci))/VT);
DFv_e_Vsi_ci=0.0;
DFv_e_Vb_ci=0.0;
DFv_e_Vbp_ci=0.0;
DFv_e_Vbp_ei=0.0;
DFv_e_Vbi_ei=0.0;
if ((DFv_e<80.0))
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(DFv_e));
_exp(__exp_0,(DFv_e));
DFe_Vbi_ei=DFv_e_Vbi_ei*__d_exp_0;
DFe_Vtnode_GND=DFv_e_Vtnode_GND*__d_exp_0;
DFe_Vbi_ci=DFv_e_Vbi_ci*__d_exp_0;
DFe=__exp_0;
DFe_Vsi_ci=0.0;
DFe_Vb_ci=0.0;
DFe_Vbp_ci=0.0;
DFe_Vbp_ei=0.0;
}
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0+DFe)));
_logE(__logE_0,((1.0+DFe)));
DFv_j_Vbi_ei=(-(VT*(+DFe_Vbi_ei)*__d_logE_0));
DFv_j_Vbi_ci=(-(VT*(+DFe_Vbi_ci)*__d_logE_0));
DFv_j_Vtnode_GND=(DFV_f_Vtnode_GND-((VT_Vtnode_GND*__logE_0)+(VT*(+DFe_Vtnode_GND)*__d_logE_0)));
DFv_j=(DFV_f-(VT*__logE_0));
DFv_j_Vsi_ci=0.0;
DFv_j_Vb_ci=0.0;
DFv_j_Vbp_ci=0.0;
DFv_j_Vbp_ei=0.0;
}
DFdvj_dv_Vbi_ei=(DFe_Vbi_ei*(1.0+DFe)-DFe*(+DFe_Vbi_ei))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv_Vtnode_GND=(DFe_Vtnode_GND*(1.0+DFe)-DFe*(+DFe_Vtnode_GND))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv_Vbi_ci=(DFe_Vbi_ci*(1.0+DFe)-DFe*(+DFe_Vbi_ci))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv=(DFe/(1.0+DFe));
DFdvj_dv_Vsi_ci=0.0;
DFdvj_dv_Vb_ci=0.0;
DFdvj_dv_Vbp_ci=0.0;
DFdvj_dv_Vbp_ei=0.0;
}
else
{
DFv_j_Vbi_ci=1.0;
DFv_j=BP(bi,ci);
DFv_j_Vsi_ci=0.0;
DFv_j_Vb_ci=0.0;
DFv_j_Vbp_ci=0.0;
DFv_j_Vbp_ei=0.0;
DFv_j_Vtnode_GND=0.0;
DFv_j_Vbi_ei=0.0;
DFdvj_dv=1;
DFdvj_dv_Vsi_ci=0.0;
DFdvj_dv_Vb_ci=0.0;
DFdvj_dv_Vbp_ci=0.0;
DFdvj_dv_Vbp_ei=0.0;
DFdvj_dv_Vbi_ci=0.0;
DFdvj_dv_Vtnode_GND=0.0;
DFdvj_dv_Vbi_ei=0.0;
}
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0-(DFv_j/vdci_t))));
_logE(__logE_0,((1.0-(DFv_j/vdci_t))));
DFb_Vbi_ei=(-DFv_j_Vbi_ei/vdci_t)*__d_logE_0;
DFb_Vtnode_GND=(-(DFv_j_Vtnode_GND*vdci_t-DFv_j*vdci_t_Vtnode_GND)/(vdci_t*vdci_t))*__d_logE_0;
DFb_Vbi_ci=(-DFv_j_Vbi_ci/vdci_t)*__d_logE_0;
DFb=__logE_0;
DFb_Vsi_ci=0.0;
DFb_Vb_ci=0.0;
DFb_Vbp_ci=0.0;
DFb_Vbp_ei=0.0;
}
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(((-zci)*DFb)));
_exp(__exp_0,(((-zci)*DFb)));
DFC_j1_Vbi_ei=(((cjci0_t*((-zci)*DFb_Vbi_ei)*__d_exp_0)*DFdvj_dv)+((cjci0_t*__exp_0)*DFdvj_dv_Vbi_ei));
DFC_j1_Vbi_ci=(((cjci0_t*((-zci)*DFb_Vbi_ci)*__d_exp_0)*DFdvj_dv)+((cjci0_t*__exp_0)*DFdvj_dv_Vbi_ci));
DFC_j1_Vtnode_GND=((((cjci0_t_Vtnode_GND*__exp_0)+(cjci0_t*((-zci)*DFb_Vtnode_GND)*__d_exp_0))*DFdvj_dv)+((cjci0_t*__exp_0)*DFdvj_dv_Vtnode_GND));
DFC_j1=((cjci0_t*__exp_0)*DFdvj_dv);
DFC_j1_Vsi_ci=0.0;
DFC_j1_Vb_ci=0.0;
DFC_j1_Vbp_ci=0.0;
DFC_j1_Vbp_ei=0.0;
}
Cjcit_Vbi_ei=(DFC_j1_Vbi_ei+(DFC_max*(-DFdvj_dv_Vbi_ei)));
Cjcit_Vtnode_GND=(DFC_j1_Vtnode_GND+((DFC_max_Vtnode_GND*(1.0-DFdvj_dv))+(DFC_max*(-DFdvj_dv_Vtnode_GND))));
Cjcit_Vbi_ci=(DFC_j1_Vbi_ci+(DFC_max*(-DFdvj_dv_Vbi_ci)));
Cjcit=(DFC_j1+(DFC_max*(1.0-DFdvj_dv)));
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DFb*(1.0-zci))));
_exp(__exp_0,((DFb*(1.0-zci))));
DFQ_j_Vbi_ei=((cjci0_t*vdci_t)*(-DFb_Vbi_ei*(1.0-zci)*__d_exp_0))/(1.0-zci);
DFQ_j_Vbi_ci=((cjci0_t*vdci_t)*(-DFb_Vbi_ci*(1.0-zci)*__d_exp_0))/(1.0-zci);
DFQ_j_Vtnode_GND=((((cjci0_t_Vtnode_GND*vdci_t)+(cjci0_t*vdci_t_Vtnode_GND))*(1.0-__exp_0))+((cjci0_t*vdci_t)*(-DFb_Vtnode_GND*(1.0-zci)*__d_exp_0)))/(1.0-zci);
if (doAC)
{
DFQ_j=(((cjci0_t*vdci_t)*(1.0-__exp_0))/(1.0-zci));
}
DFQ_j_Vsi_ci=0.0;
DFQ_j_Vb_ci=0.0;
DFQ_j_Vbp_ci=0.0;
DFQ_j_Vbp_ei=0.0;
}
}
if (doAC)
{
d1=(DFQ_j+(DFC_max*(BP(bi,ci)-DFv_j)));
}
}
else
{
Cjcit=0.0;
Cjcit_Vbi_ci=0.0;
Cjcit_Vtnode_GND=0.0;
Cjcit_Vbi_ei=0.0;
if (doAC)
{
d1=0.0;
}
}
if ((Cjcit>0.0))
{
cc_Vbi_ei=(-(cjci0_t*Cjcit_Vbi_ei)/(Cjcit*Cjcit));
cc_Vbi_ci=(-(cjci0_t*Cjcit_Vbi_ci)/(Cjcit*Cjcit));
cc_Vtnode_GND=(cjci0_t_Vtnode_GND*Cjcit-cjci0_t*Cjcit_Vtnode_GND)/(Cjcit*Cjcit);
cc=(cjci0_t/Cjcit);
}
else
{
cc=1.0;
cc_Vtnode_GND=0.0;
cc_Vbi_ci=0.0;
cc_Vbi_ei=0.0;
}
T_f0_Vbi_ei=((+(dt0h*cc_Vbi_ei))+(tbvl*(-(1*cc_Vbi_ei)/(cc*cc))));
T_f0_Vbi_ci=((+(dt0h*cc_Vbi_ci))+(tbvl*(-(1*cc_Vbi_ci)/(cc*cc))));
T_f0_Vtnode_GND=((t0_t_Vtnode_GND+(dt0h*cc_Vtnode_GND))+(tbvl*(-(1*cc_Vtnode_GND)/(cc*cc))));
T_f0=((t0_t+(dt0h*(cc-1.0)))+(tbvl*((1/cc)-1.0)));
vc_Vtnode_GND=(-vces_t_Vtnode_GND);
vc_Vci_ei=1.0;
vc=(BP(ci,ei)-vces_t);
ICKv_Vtnode_GND=(vc_Vtnode_GND*VT-vc*VT_Vtnode_GND)/(VT*VT);
ICKv_Vci_ei=vc_Vci_ei/VT;
ICKv=(vc/VT);
if ((ICKv<30.0))
{
{
double __exp_0=0.0;
double __logE_1=0.0;
double __d_exp_0=0.0;
double __d_logE_1=0.0;
_d_exp(__exp_0,__d_exp_0,((ICKv-1.0)));
_d_logE(__logE_1,__d_logE_1,((1+__exp_0)));
_exp(__exp_0,((ICKv-1.0)));
_logE(__logE_1,((1+__exp_0)));
vceff_Vtnode_GND=(((+(+ICKv_Vtnode_GND*__d_exp_0)*__d_logE_1)*VT)+((1.0+__logE_1)*VT_Vtnode_GND));
vceff_Vci_ei=(+(+ICKv_Vci_ei*__d_exp_0)*__d_logE_1)*VT;
vceff=((1.0+__logE_1)*VT);
}
}
else
{
vceff_Vtnode_GND=vc_Vtnode_GND;
vceff_Vci_ei=vc_Vci_ei;
vceff=vc;
}
ICKv_Vtnode_GND=(vceff_Vtnode_GND*vlim_t-vceff*vlim_t_Vtnode_GND)/(vlim_t*vlim_t);
ICKv_Vci_ei=vceff_Vci_ei/vlim_t;
ICKv=(vceff/vlim_t);
{
double __sqrt_0=0.0;
double __d_sqrt_0=0.0;
_d_sqrt(__sqrt_0,__d_sqrt_0,((1.0+(ICKv*ICKv))));
_sqrt(__sqrt_0,((1.0+(ICKv*ICKv))));
ick_Vtnode_GND=(((vceff_Vtnode_GND*Orci0_t)+(vceff*Orci0_t_Vtnode_GND))*__sqrt_0-(vceff*Orci0_t)*(+((ICKv_Vtnode_GND*ICKv)+(ICKv*ICKv_Vtnode_GND)))*__d_sqrt_0)/(__sqrt_0*__sqrt_0);
ick_Vci_ei=(vceff_Vci_ei*Orci0_t*__sqrt_0-(vceff*Orci0_t)*(+((ICKv_Vci_ei*ICKv)+(ICKv*ICKv_Vci_ei)))*__d_sqrt_0)/(__sqrt_0*__sqrt_0);
ick=((vceff*Orci0_t)/__sqrt_0);
}
ICKa_Vtnode_GND=(vceff_Vtnode_GND-vlim_t_Vtnode_GND)*Ovpt;
ICKa_Vci_ei=vceff_Vci_ei*Ovpt;
ICKa=((vceff-vlim_t)*Ovpt);
{
double __sqrt_0=0.0;
double __d_sqrt_0=0.0;
_d_sqrt(__sqrt_0,__d_sqrt_0,(((ICKa*ICKa)+1.0e-3)));
_sqrt(__sqrt_0,(((ICKa*ICKa)+1.0e-3)));
ick_Vtnode_GND=((ick_Vtnode_GND*(1.0+(0.5*(ICKa+__sqrt_0))))+(ick*(+(0.5*(ICKa_Vtnode_GND+((ICKa_Vtnode_GND*ICKa)+(ICKa*ICKa_Vtnode_GND))*__d_sqrt_0)))));
ick_Vci_ei=((ick_Vci_ei*(1.0+(0.5*(ICKa+__sqrt_0))))+(ick*(+(0.5*(ICKa_Vci_ei+((ICKa_Vci_ei*ICKa)+(ICKa*ICKa_Vci_ei))*__d_sqrt_0)))));
ick=(ick*(1.0+(0.5*(ICKa+__sqrt_0))));
}
if (((T_f0>0.0)||(Tr>0.0)))
{
A_Vbi_ci=(0.5*Q_0_Vbi_ci);
A_Vbi_ei=(0.5*Q_0_Vbi_ei);
A_Vtnode_GND=(0.5*Q_0_Vtnode_GND);
A=(0.5*Q_0);
{
double __sqrt_0=0.0;
double __d_sqrt_0=0.0;
_d_sqrt(__sqrt_0,__d_sqrt_0,((((A*A)+(T_f0*i_0f))+(Tr*i_0r))));
_sqrt(__sqrt_0,((((A*A)+(T_f0*i_0f))+(Tr*i_0r))));
Q_p_Vbi_ci=(A_Vbi_ci+((((A_Vbi_ci*A)+(A*A_Vbi_ci))+T_f0_Vbi_ci*i_0f)+(Tr*i_0r_Vbi_ci))*__d_sqrt_0);
Q_p_Vbi_ei=(A_Vbi_ei+(((A_Vbi_ei*A)+(A*A_Vbi_ei))+((T_f0_Vbi_ei*i_0f)+(T_f0*i_0f_Vbi_ei)))*__d_sqrt_0);
Q_p_Vtnode_GND=(A_Vtnode_GND+((((A_Vtnode_GND*A)+(A*A_Vtnode_GND))+((T_f0_Vtnode_GND*i_0f)+(T_f0*i_0f_Vtnode_GND)))+(Tr*i_0r_Vtnode_GND))*__d_sqrt_0);
Q_p=(A+__sqrt_0);
}
}
else
{
Q_p_Vbi_ci=Q_0_Vbi_ci;
Q_p_Vbi_ei=Q_0_Vbi_ei;
Q_p_Vtnode_GND=Q_0_Vtnode_GND;
Q_p=Q_0;
}
I_Tf1_Vbi_ci=(-(i_0f*Q_p_Vbi_ci)/(Q_p*Q_p));
I_Tf1_Vbi_ei=(i_0f_Vbi_ei*Q_p-i_0f*Q_p_Vbi_ei)/(Q_p*Q_p);
I_Tf1_Vtnode_GND=(i_0f_Vtnode_GND*Q_p-i_0f*Q_p_Vtnode_GND)/(Q_p*Q_p);
I_Tf1=(i_0f/Q_p);
I_Tf1_Vci_ei=0.0;
a_h_Vbi_ci=(Oich*I_Tf1_Vbi_ci);
a_h_Vbi_ei=(Oich*I_Tf1_Vbi_ei);
a_h_Vtnode_GND=(Oich*I_Tf1_Vtnode_GND);
a_h=(Oich*I_Tf1);
a_h_Vci_ei=0.0;
itf_Vbi_ci=((I_Tf1_Vbi_ci*(1.0+a_h))+(I_Tf1*(+a_h_Vbi_ci)));
itf_Vbi_ei=((I_Tf1_Vbi_ei*(1.0+a_h))+(I_Tf1*(+a_h_Vbi_ei)));
itf_Vtnode_GND=((I_Tf1_Vtnode_GND*(1.0+a_h))+(I_Tf1*(+a_h_Vtnode_GND)));
itf=(I_Tf1*(1.0+a_h));
itf_Vci_ei=0.0;
itr_Vbi_ei=(-(i_0r*Q_p_Vbi_ei)/(Q_p*Q_p));
itr_Vbi_ci=(i_0r_Vbi_ci*Q_p-i_0r*Q_p_Vbi_ci)/(Q_p*Q_p);
itr_Vtnode_GND=(i_0r_Vtnode_GND*Q_p-i_0r*Q_p_Vtnode_GND)/(Q_p*Q_p);
itr=(i_0r/Q_p);
itr_Vci_ei=0.0;
Tf_Vbi_ei=T_f0_Vbi_ei;
Tf_Vbi_ci=T_f0_Vbi_ci;
Tf_Vtnode_GND=T_f0_Vtnode_GND;
Tf=T_f0;
Tf_Vci_ei=0.0;
Qf_Vbi_ei=((T_f0_Vbi_ei*itf)+(T_f0*itf_Vbi_ei));
Qf_Vbi_ci=((T_f0_Vbi_ci*itf)+(T_f0*itf_Vbi_ci));
Qf_Vtnode_GND=((T_f0_Vtnode_GND*itf)+(T_f0*itf_Vtnode_GND));
Qf=(T_f0*itf);
Qf_Vci_ei=0.0;
if ((itf<(1.0e-6*ick)))
{
Q_fT_Vbi_ei=Qf_Vbi_ei;
Q_fT_Vbi_ci=Qf_Vbi_ci;
Q_fT_Vtnode_GND=Qf_Vtnode_GND;
Q_fT=Qf;
Q_fT_Vci_ei=0.0;
T_fT_Vbi_ei=Tf_Vbi_ei;
T_fT_Vbi_ci=Tf_Vbi_ci;
T_fT_Vtnode_GND=Tf_Vtnode_GND;
T_fT=Tf;
T_fT_Vci_ei=0.0;
}
else
{
FFa_Vbi_ci=(-(ick*itf_Vbi_ci)/(itf*itf));
FFa_Vbi_ei=(-(ick*itf_Vbi_ei)/(itf*itf));
FFa_Vtnode_GND=(ick_Vtnode_GND*itf-ick*itf_Vtnode_GND)/(itf*itf);
FFa_Vci_ei=(ick_Vci_ei*itf-ick*itf_Vci_ei)/(itf*itf);
FFa=(ick/itf);
{
double __logE_0=0.0;
double __exp_1=0.0;
double __d_logE_0=0.0;
double __d_exp_1=0.0;
_d_logE(__logE_0,__d_logE_0,(FFa));
_d_exp(__exp_1,__d_exp_1,(((-gtfe)*__logE_0)));
_logE(__logE_0,(FFa));
_exp(__exp_1,(((-gtfe)*__logE_0)));
FFd_TfE_Vbi_ci=(tef0_t*((-gtfe)*FFa_Vbi_ci*__d_logE_0)*__d_exp_1);
FFd_TfE_Vbi_ei=(tef0_t*((-gtfe)*FFa_Vbi_ei*__d_logE_0)*__d_exp_1);
FFd_TfE_Vci_ei=(tef0_t*((-gtfe)*FFa_Vci_ei*__d_logE_0)*__d_exp_1);
FFd_TfE_Vtnode_GND=((tef0_t_Vtnode_GND*__exp_1)+(tef0_t*((-gtfe)*FFa_Vtnode_GND*__d_logE_0)*__d_exp_1));
FFd_TfE=(tef0_t*__exp_1);
}
FFd_QfE_Vbi_ci=((FFd_TfE_Vbi_ci*itf)+(FFd_TfE*itf_Vbi_ci))/(gtfe+1.0);
FFd_QfE_Vbi_ei=((FFd_TfE_Vbi_ei*itf)+(FFd_TfE*itf_Vbi_ei))/(gtfe+1.0);
FFd_QfE_Vci_ei=((FFd_TfE_Vci_ei*itf)+(FFd_TfE*itf_Vci_ei))/(gtfe+1.0);
FFd_QfE_Vtnode_GND=((FFd_TfE_Vtnode_GND*itf)+(FFd_TfE*itf_Vtnode_GND))/(gtfe+1.0);
FFd_QfE=((FFd_TfE*itf)/(gtfe+1.0));
FFT_fbS_Vtnode_GND=((1.0-fthc)*thcs_t_Vtnode_GND);
FFT_fbS=((1.0-fthc)*thcs_t);
FFx_Vbi_ci=(-FFa_Vbi_ci);
FFx_Vbi_ei=(-FFa_Vbi_ei);
FFx_Vtnode_GND=(-FFa_Vtnode_GND);
FFx_Vci_ei=(-FFa_Vci_ei);
FFx=(1.0-FFa);
{
double __sqrt_0=0.0;
double __d_sqrt_0=0.0;
_d_sqrt(__sqrt_0,__d_sqrt_0,(((FFx*FFx)+alhc)));
_sqrt(__sqrt_0,(((FFx*FFx)+alhc)));
FFs_Vbi_ci=((FFx_Vbi_ci*FFx)+(FFx*FFx_Vbi_ci))*__d_sqrt_0;
FFs_Vbi_ei=((FFx_Vbi_ei*FFx)+(FFx*FFx_Vbi_ei))*__d_sqrt_0;
FFs_Vtnode_GND=((FFx_Vtnode_GND*FFx)+(FFx*FFx_Vtnode_GND))*__d_sqrt_0;
FFs_Vci_ei=((FFx_Vci_ei*FFx)+(FFx*FFx_Vci_ei))*__d_sqrt_0;
FFs=__sqrt_0;
}
{
double __sqrt_0=0.0;
_sqrt(__sqrt_0,((1.0+alhc)));
FFw_Vbi_ci=(FFx_Vbi_ci+FFs_Vbi_ci)/(1.0+__sqrt_0);
FFw_Vbi_ei=(FFx_Vbi_ei+FFs_Vbi_ei)/(1.0+__sqrt_0);
FFw_Vtnode_GND=(FFx_Vtnode_GND+FFs_Vtnode_GND)/(1.0+__sqrt_0);
FFw_Vci_ei=(FFx_Vci_ei+FFs_Vci_ei)/(1.0+__sqrt_0);
FFw=((FFx+FFs)/(1.0+__sqrt_0));
}
FFw_2_Vbi_ci=((FFw_Vbi_ci*FFw)+(FFw*FFw_Vbi_ci));
FFw_2_Vbi_ei=((FFw_Vbi_ei*FFw)+(FFw*FFw_Vbi_ei));
FFw_2_Vtnode_GND=((FFw_Vtnode_GND*FFw)+(FFw*FFw_Vtnode_GND));
FFw_2_Vci_ei=((FFw_Vci_ei*FFw)+(FFw*FFw_Vci_ei));
FFw_2=(FFw*FFw);
FFd_QfB_Vci_ei=(((FFT_fbS*itf_Vci_ei)*FFw_2)+((FFT_fbS*itf)*FFw_2_Vci_ei));
FFd_QfB_Vbi_ci=(((FFT_fbS*itf_Vbi_ci)*FFw_2)+((FFT_fbS*itf)*FFw_2_Vbi_ci));
FFd_QfB_Vbi_ei=(((FFT_fbS*itf_Vbi_ei)*FFw_2)+((FFT_fbS*itf)*FFw_2_Vbi_ei));
FFd_QfB_Vtnode_GND=((((FFT_fbS_Vtnode_GND*itf)+(FFT_fbS*itf_Vtnode_GND))*FFw_2)+((FFT_fbS*itf)*FFw_2_Vtnode_GND));
FFd_QfB=((FFT_fbS*itf)*FFw_2);
FFa_w_Vbi_ci=((FFw_2_Vbi_ci*(1.0+((2.0*FFa)/FFs)))+(FFw_2*(+((2.0*FFa_Vbi_ci)*FFs-(2.0*FFa)*FFs_Vbi_ci)/(FFs*FFs))));
FFa_w_Vbi_ei=((FFw_2_Vbi_ei*(1.0+((2.0*FFa)/FFs)))+(FFw_2*(+((2.0*FFa_Vbi_ei)*FFs-(2.0*FFa)*FFs_Vbi_ei)/(FFs*FFs))));
FFa_w_Vtnode_GND=((FFw_2_Vtnode_GND*(1.0+((2.0*FFa)/FFs)))+(FFw_2*(+((2.0*FFa_Vtnode_GND)*FFs-(2.0*FFa)*FFs_Vtnode_GND)/(FFs*FFs))));
FFa_w_Vci_ei=((FFw_2_Vci_ei*(1.0+((2.0*FFa)/FFs)))+(FFw_2*(+((2.0*FFa_Vci_ei)*FFs-(2.0*FFa)*FFs_Vci_ei)/(FFs*FFs))));
FFa_w=(FFw_2*(1.0+((2.0*FFa)/FFs)));
FFd_TfB_Vbi_ci=(FFT_fbS*FFa_w_Vbi_ci);
FFd_TfB_Vbi_ei=(FFT_fbS*FFa_w_Vbi_ei);
FFd_TfB_Vci_ei=(FFT_fbS*FFa_w_Vci_ei);
FFd_TfB_Vtnode_GND=((FFT_fbS_Vtnode_GND*FFa_w)+(FFT_fbS*FFa_w_Vtnode_GND));
FFd_TfB=(FFT_fbS*FFa_w);
FFT_pcS_Vtnode_GND=(fthc*thcs_t_Vtnode_GND);
FFT_pcS=(fthc*thcs_t);
if (((latb<=0.0)&&(latl<=0.0)))
{
FFQ_fC_Vci_ei=(((FFT_pcS*itf_Vci_ei)*FFw_2)+((FFT_pcS*itf)*FFw_2_Vci_ei));
FFQ_fC_Vbi_ci=(((FFT_pcS*itf_Vbi_ci)*FFw_2)+((FFT_pcS*itf)*FFw_2_Vbi_ci));
FFQ_fC_Vbi_ei=(((FFT_pcS*itf_Vbi_ei)*FFw_2)+((FFT_pcS*itf)*FFw_2_Vbi_ei));
FFQ_fC_Vtnode_GND=((((FFT_pcS_Vtnode_GND*itf)+(FFT_pcS*itf_Vtnode_GND))*FFw_2)+((FFT_pcS*itf)*FFw_2_Vtnode_GND));
FFQ_fC=((FFT_pcS*itf)*FFw_2);
FFT_fC_Vbi_ci=(FFT_pcS*FFa_w_Vbi_ci);
FFT_fC_Vbi_ei=(FFT_pcS*FFa_w_Vbi_ei);
FFT_fC_Vci_ei=(FFT_pcS*FFa_w_Vci_ei);
FFT_fC_Vtnode_GND=((FFT_pcS_Vtnode_GND*FFa_w)+(FFT_pcS*FFa_w_Vtnode_GND));
FFT_fC=(FFT_pcS*FFa_w);
FFQ_cT_Vci_ei=FFQ_fC_Vci_ei;
FFQ_cT_Vbi_ci=FFQ_fC_Vbi_ci;
FFQ_cT_Vbi_ei=FFQ_fC_Vbi_ei;
FFQ_cT_Vtnode_GND=FFQ_fC_Vtnode_GND;
FFQ_cT=FFQ_fC;
FFT_cT_Vbi_ci=FFT_fC_Vbi_ci;
FFT_cT_Vbi_ei=FFT_fC_Vbi_ei;
FFT_cT_Vci_ei=FFT_fC_Vci_ei;
FFT_cT_Vtnode_GND=FFT_fC_Vtnode_GND;
FFT_cT=FFT_fC;
}
else
{
FFQ_fC_Vbi_ci=(FFT_pcS*itf_Vbi_ci);
FFQ_fC_Vbi_ei=(FFT_pcS*itf_Vbi_ei);
FFQ_fC_Vtnode_GND=((FFT_pcS_Vtnode_GND*itf)+(FFT_pcS*itf_Vtnode_GND));
FFQ_fC=(FFT_pcS*itf);
FFQ_fC_Vci_ei=0.0;
FCa_Vbi_ci=(-(-(ick*itf_Vbi_ci)/(itf*itf)));
FCa_Vbi_ei=(-(-(ick*itf_Vbi_ei)/(itf*itf)));
FCa_Vtnode_GND=(-(ick_Vtnode_GND*itf-ick*itf_Vtnode_GND)/(itf*itf));
FCa_Vci_ei=(-(ick_Vci_ei*itf-ick*itf_Vci_ei)/(itf*itf));
FCa=(1.0-(ick/itf));
{
double __sqrt_0=0.0;
double __d_sqrt_0=0.0;
_d_sqrt(__sqrt_0,__d_sqrt_0,(((FCa*FCa)+alhc)));
_sqrt(__sqrt_0,(((FCa*FCa)+alhc)));
FCrt_Vbi_ci=((FCa_Vbi_ci*FCa)+(FCa*FCa_Vbi_ci))*__d_sqrt_0;
FCrt_Vbi_ei=((FCa_Vbi_ei*FCa)+(FCa*FCa_Vbi_ei))*__d_sqrt_0;
FCrt_Vtnode_GND=((FCa_Vtnode_GND*FCa)+(FCa*FCa_Vtnode_GND))*__d_sqrt_0;
FCrt_Vci_ei=((FCa_Vci_ei*FCa)+(FCa*FCa_Vci_ei))*__d_sqrt_0;
FCrt=__sqrt_0;
}
{
double __sqrt_0=0.0;
_sqrt(__sqrt_0,((1.0+alhc)));
FCa_ck_Vbi_ci=(-(FCa_Vbi_ci+FCrt_Vbi_ci)/(1.0+__sqrt_0));
FCa_ck_Vbi_ei=(-(FCa_Vbi_ei+FCrt_Vbi_ei)/(1.0+__sqrt_0));
FCa_ck_Vtnode_GND=(-(FCa_Vtnode_GND+FCrt_Vtnode_GND)/(1.0+__sqrt_0));
FCa_ck_Vci_ei=(-(FCa_Vci_ei+FCrt_Vci_ei)/(1.0+__sqrt_0));
FCa_ck=(1.0-((FCa+FCrt)/(1.0+__sqrt_0)));
}
FCdaick_ditf_Vbi_ci=(((FCa_ck_Vbi_ci*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ci)))*(FCrt*itf)-((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci)))/((FCrt*itf)*(FCrt*itf));
FCdaick_ditf_Vbi_ei=(((FCa_ck_Vbi_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ei)))*(FCrt*itf)-((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei)))/((FCrt*itf)*(FCrt*itf));
FCdaick_ditf_Vtnode_GND=(((FCa_ck_Vtnode_GND*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vtnode_GND)))*(FCrt*itf)-((FCa_ck-1.0)*(1-FCa))*((FCrt_Vtnode_GND*itf)+(FCrt*itf_Vtnode_GND)))/((FCrt*itf)*(FCrt*itf));
FCdaick_ditf_Vci_ei=(((FCa_ck_Vci_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vci_ei)))*(FCrt*itf)-((FCa_ck-1.0)*(1-FCa))*((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei)))/((FCrt*itf)*(FCrt*itf));
FCdaick_ditf=(((FCa_ck-1.0)*(1-FCa))/(FCrt*itf));
if ((latb>latl))
{
FCz=(latb-latl);
FCz_Vci_ei=0.0;
FCz_Vtnode_GND=0.0;
FCz_Vbi_ei=0.0;
FCz_Vbi_ci=0.0;
FCxl=(1.0+latl);
FCxb=(1.0+latb);
if ((latb>0.01))
{
{
double __logE_0=0.0;
_logE(__logE_0,((FCxb/FCxl)));
FCln=__logE_0;
}
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(((FCa_ck-1.0)*FCln)));
_exp(__exp_0,(((FCa_ck-1.0)*FCln)));
FCa1_Vbi_ci=FCa_ck_Vbi_ci*FCln*__d_exp_0;
FCa1_Vbi_ei=FCa_ck_Vbi_ei*FCln*__d_exp_0;
FCa1_Vtnode_GND=FCa_ck_Vtnode_GND*FCln*__d_exp_0;
FCa1_Vci_ei=FCa_ck_Vci_ei*FCln*__d_exp_0;
FCa1=__exp_0;
}
FCd_a_Vbi_ci=(-(-FCa1_Vbi_ci*latb)/((latl-(FCa1*latb))*(latl-(FCa1*latb))));
FCd_a_Vbi_ei=(-(-FCa1_Vbi_ei*latb)/((latl-(FCa1*latb))*(latl-(FCa1*latb))));
FCd_a_Vtnode_GND=(-(-FCa1_Vtnode_GND*latb)/((latl-(FCa1*latb))*(latl-(FCa1*latb))));
FCd_a_Vci_ei=(-(-FCa1_Vci_ei*latb)/((latl-(FCa1*latb))*(latl-(FCa1*latb))));
FCd_a=(1.0/(latl-(FCa1*latb)));
FCw_Vbi_ci=((FCa1_Vbi_ci*FCd_a)+((FCa1-1.0)*FCd_a_Vbi_ci));
FCw_Vbi_ei=((FCa1_Vbi_ei*FCd_a)+((FCa1-1.0)*FCd_a_Vbi_ei));
FCw_Vtnode_GND=((FCa1_Vtnode_GND*FCd_a)+((FCa1-1.0)*FCd_a_Vtnode_GND));
FCw_Vci_ei=((FCa1_Vci_ei*FCd_a)+((FCa1-1.0)*FCd_a_Vci_ei));
FCw=((FCa1-1.0)*FCd_a);
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,(((1.0+(latb*FCw))/(1.0+(latl*FCw)))));
_logE(__logE_0,(((1.0+(latb*FCw))/(1.0+(latl*FCw)))));
FCa_Vbi_ci=((+(latb*FCw_Vbi_ci))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(+(latl*FCw_Vbi_ci)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))*__d_logE_0;
FCa_Vbi_ei=((+(latb*FCw_Vbi_ei))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(+(latl*FCw_Vbi_ei)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))*__d_logE_0;
FCa_Vtnode_GND=((+(latb*FCw_Vtnode_GND))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(+(latl*FCw_Vtnode_GND)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))*__d_logE_0;
FCa_Vci_ei=((+(latb*FCw_Vci_ei))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(+(latl*FCw_Vci_ei)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))*__d_logE_0;
FCa=__logE_0;
}
FCdw_daick_Vbi_ci=(((((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci))*FCd_a)+(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ci));
FCdw_daick_Vbi_ei=(((((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei))*FCd_a)+(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ei));
FCdw_daick_Vtnode_GND=(((((((-FCz_Vtnode_GND)*FCa1)+((-FCz)*FCa1_Vtnode_GND))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vtnode_GND))*FCd_a)+(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vtnode_GND));
FCdw_daick_Vci_ei=(((((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei))*FCd_a)+(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vci_ei));
FCdw_daick=(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a);
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0+(latb*FCw))));
_logE(__logE_0,((1.0+(latb*FCw))));
FClnb_Vbi_ci=(+(latb*FCw_Vbi_ci))*__d_logE_0;
FClnb_Vbi_ei=(+(latb*FCw_Vbi_ei))*__d_logE_0;
FClnb_Vtnode_GND=(+(latb*FCw_Vtnode_GND))*__d_logE_0;
FClnb_Vci_ei=(+(latb*FCw_Vci_ei))*__d_logE_0;
FClnb=__logE_0;
}
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0+(latl*FCw))));
_logE(__logE_0,((1.0+(latl*FCw))));
FClnl_Vbi_ci=(+(latl*FCw_Vbi_ci))*__d_logE_0;
FClnl_Vbi_ei=(+(latl*FCw_Vbi_ei))*__d_logE_0;
FClnl_Vtnode_GND=(+(latl*FCw_Vtnode_GND))*__d_logE_0;
FClnl_Vci_ei=(+(latl*FCw_Vci_ei))*__d_logE_0;
FClnl=__logE_0;
}
FCa1_Vbi_ci=(FClnb_Vbi_ci-FClnl_Vbi_ci);
FCa1_Vbi_ei=(FClnb_Vbi_ei-FClnl_Vbi_ei);
FCa1_Vtnode_GND=(FClnb_Vtnode_GND-FClnl_Vtnode_GND);
FCa1_Vci_ei=(FClnb_Vci_ei-FClnl_Vci_ei);
FCa1=(FClnb-FClnl);
FCda1_dw_Vbi_ci=((-(latb*(+(latb*FCw_Vbi_ci)))/((1.0+(latb*FCw))*(1.0+(latb*FCw))))-(-(latl*(+(latl*FCw_Vbi_ci)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))));
FCda1_dw_Vbi_ei=((-(latb*(+(latb*FCw_Vbi_ei)))/((1.0+(latb*FCw))*(1.0+(latb*FCw))))-(-(latl*(+(latl*FCw_Vbi_ei)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))));
FCda1_dw_Vtnode_GND=((-(latb*(+(latb*FCw_Vtnode_GND)))/((1.0+(latb*FCw))*(1.0+(latb*FCw))))-(-(latl*(+(latl*FCw_Vtnode_GND)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))));
FCda1_dw_Vci_ei=((-(latb*(+(latb*FCw_Vci_ei)))/((1.0+(latb*FCw))*(1.0+(latb*FCw))))-(-(latl*(+(latl*FCw_Vci_ei)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))));
FCda1_dw=((latb/(1.0+(latb*FCw)))-(latl/(1.0+(latl*FCw))));
}
else
{
FCf1_Vbi_ci=(-FCa_ck_Vbi_ci);
FCf1_Vbi_ei=(-FCa_ck_Vbi_ei);
FCf1_Vtnode_GND=(-FCa_ck_Vtnode_GND);
FCf1_Vci_ei=(-FCa_ck_Vci_ei);
FCf1=(1.0-FCa_ck);
FCd_a_Vbi_ci=(-(-FCf1_Vbi_ci*latb)/((1.0-(FCf1*latb))*(1.0-(FCf1*latb))));
FCd_a_Vbi_ei=(-(-FCf1_Vbi_ei*latb)/((1.0-(FCf1*latb))*(1.0-(FCf1*latb))));
FCd_a_Vtnode_GND=(-(-FCf1_Vtnode_GND*latb)/((1.0-(FCf1*latb))*(1.0-(FCf1*latb))));
FCd_a_Vci_ei=(-(-FCf1_Vci_ei*latb)/((1.0-(FCf1*latb))*(1.0-(FCf1*latb))));
FCd_a=(1.0/(1.0-(FCf1*latb)));
FCw_Vbi_ci=((FCf1_Vbi_ci*FCd_a)+(FCf1*FCd_a_Vbi_ci));
FCw_Vbi_ei=((FCf1_Vbi_ei*FCd_a)+(FCf1*FCd_a_Vbi_ei));
FCw_Vtnode_GND=((FCf1_Vtnode_GND*FCd_a)+(FCf1*FCd_a_Vtnode_GND));
FCw_Vci_ei=((FCf1_Vci_ei*FCd_a)+(FCf1*FCd_a_Vci_ei));
FCw=(FCf1*FCd_a);
FCa_Vbi_ci=((FCz_Vbi_ci*FCw)+(FCz*FCw_Vbi_ci));
FCa_Vbi_ei=((FCz_Vbi_ei*FCw)+(FCz*FCw_Vbi_ei));
FCa_Vtnode_GND=((FCz_Vtnode_GND*FCw)+(FCz*FCw_Vtnode_GND));
FCa_Vci_ei=((FCz_Vci_ei*FCw)+(FCz*FCw_Vci_ei));
FCa=(FCz*FCw);
FCdw_daick_Vbi_ci=((((-1.0)*FCd_a_Vbi_ci)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci));
FCdw_daick_Vbi_ei=((((-1.0)*FCd_a_Vbi_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei));
FCdw_daick_Vtnode_GND=((((-1.0)*FCd_a_Vtnode_GND)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vtnode_GND));
FCdw_daick_Vci_ei=((((-1.0)*FCd_a_Vci_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei));
FCdw_daick=(((-1.0)*FCd_a)*FCd_a);
FClnb_Vbi_ci=(latb*FCw_Vbi_ci);
FClnb_Vbi_ei=(latb*FCw_Vbi_ei);
FClnb_Vtnode_GND=(latb*FCw_Vtnode_GND);
FClnb_Vci_ei=(latb*FCw_Vci_ei);
FClnb=(latb*FCw);
FClnl_Vbi_ci=(latl*FCw_Vbi_ci);
FClnl_Vbi_ei=(latl*FCw_Vbi_ei);
FClnl_Vtnode_GND=(latl*FCw_Vtnode_GND);
FClnl_Vci_ei=(latl*FCw_Vci_ei);
FClnl=(latl*FCw);
FCa1_Vbi_ci=((FCz_Vbi_ci*FCw)+(FCz*FCw_Vbi_ci));
FCa1_Vbi_ei=((FCz_Vbi_ei*FCw)+(FCz*FCw_Vbi_ei));
FCa1_Vtnode_GND=((FCz_Vtnode_GND*FCw)+(FCz*FCw_Vtnode_GND));
FCa1_Vci_ei=((FCz_Vci_ei*FCw)+(FCz*FCw_Vci_ei));
FCa1=(FCz*FCw);
FCda1_dw=FCz;
FCda1_dw_Vci_ei=0.0;
FCda1_dw_Vtnode_GND=0.0;
FCda1_dw_Vbi_ei=0.0;
FCda1_dw_Vbi_ci=0.0;
}
FCf_CT=(2.0/FCz);
FCf_CT_Vci_ei=0.0;
FCf_CT_Vbi_ei=0.0;
FCf_CT_Vbi_ci=0.0;
FCf_CT_Vtnode_GND=0.0;
FCw2_Vbi_ci=((FCw_Vbi_ci*FCw)+(FCw*FCw_Vbi_ci));
FCw2_Vbi_ei=((FCw_Vbi_ei*FCw)+(FCw*FCw_Vbi_ei));
FCw2_Vtnode_GND=((FCw_Vtnode_GND*FCw)+(FCw*FCw_Vtnode_GND));
FCw2_Vci_ei=((FCw_Vci_ei*FCw)+(FCw*FCw_Vci_ei));
FCw2=(FCw*FCw);
FCf1_Vbi_ci=((((((latb*latl)*FCw_Vbi_ci)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ci))/3.0+((latb+latl)*FCw2_Vbi_ci)/2.0)+FCw_Vbi_ci);
FCf1_Vbi_ei=((((((latb*latl)*FCw_Vbi_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ei))/3.0+((latb+latl)*FCw2_Vbi_ei)/2.0)+FCw_Vbi_ei);
FCf1_Vtnode_GND=((((((latb*latl)*FCw_Vtnode_GND)*FCw2)+(((latb*latl)*FCw)*FCw2_Vtnode_GND))/3.0+((latb+latl)*FCw2_Vtnode_GND)/2.0)+FCw_Vtnode_GND);
FCf1_Vci_ei=((((((latb*latl)*FCw_Vci_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vci_ei))/3.0+((latb+latl)*FCw2_Vci_ei)/2.0)+FCw_Vci_ei);
FCf1=((((((latb*latl)*FCw)*FCw2)/3.0)+(((latb+latl)*FCw2)/2.0))+FCw);
FCdf1_dw_Vbi_ci=(((latb*latl)*FCw2_Vbi_ci)+((latb+latl)*FCw_Vbi_ci));
FCdf1_dw_Vbi_ei=(((latb*latl)*FCw2_Vbi_ei)+((latb+latl)*FCw_Vbi_ei));
FCdf1_dw_Vtnode_GND=(((latb*latl)*FCw2_Vtnode_GND)+((latb+latl)*FCw_Vtnode_GND));
FCdf1_dw_Vci_ei=(((latb*latl)*FCw2_Vci_ei)+((latb+latl)*FCw_Vci_ei));
FCdf1_dw=((((latb*latl)*FCw2)+((latb+latl)*FCw))+1.0);
z_Vbi_ci=(latb*FCw_Vbi_ci);
z_Vbi_ei=(latb*FCw_Vbi_ei);
z_Vtnode_GND=(latb*FCw_Vtnode_GND);
z_Vci_ei=(latb*FCw_Vci_ei);
z=(latb*FCw);
if ((z>1.0e-6))
{
x_Vbi_ci=(+z_Vbi_ci);
x_Vbi_ei=(+z_Vbi_ei);
x_Vtnode_GND=(+z_Vtnode_GND);
x_Vci_ei=(+z_Vci_ei);
x=(1.0+z);
a_Vbi_ci=((x_Vbi_ci*x)+(x*x_Vbi_ci));
a_Vbi_ei=((x_Vbi_ei*x)+(x*x_Vbi_ei));
a_Vtnode_GND=((x_Vtnode_GND*x)+(x*x_Vtnode_GND));
a_Vci_ei=((x_Vci_ei*x)+(x*x_Vci_ei));
a=(x*x);
a2_Vtnode_GND=(0.250*((a_Vtnode_GND*((2.0*FClnb)-1.0))+(a*(2.0*FClnb_Vtnode_GND))));
a2_Vbi_ci=(0.250*((a_Vbi_ci*((2.0*FClnb)-1.0))+(a*(2.0*FClnb_Vbi_ci))));
a2_Vbi_ei=(0.250*((a_Vbi_ei*((2.0*FClnb)-1.0))+(a*(2.0*FClnb_Vbi_ei))));
a2_Vci_ei=(0.250*((a_Vci_ei*((2.0*FClnb)-1.0))+(a*(2.0*FClnb_Vci_ei))));
a2=(0.250*((a*((2.0*FClnb)-1.0))+1.0));
a3_Vtnode_GND=((((a_Vtnode_GND*x)+(a*x_Vtnode_GND))*((3.0*FClnb)-1.0))+((a*x)*(3.0*FClnb_Vtnode_GND)))/9.0;
a3_Vbi_ci=((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*FClnb)-1.0))+((a*x)*(3.0*FClnb_Vbi_ci)))/9.0;
a3_Vbi_ei=((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*FClnb)-1.0))+((a*x)*(3.0*FClnb_Vbi_ei)))/9.0;
a3_Vci_ei=((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*FClnb)-1.0))+((a*x)*(3.0*FClnb_Vci_ei)))/9.0;
a3=((((a*x)*((3.0*FClnb)-1.0))+1.0)/9.0);
r=(latl/latb);
FCf2_Vtnode_GND=(((1.0-r)*a2_Vtnode_GND)+(r*a3_Vtnode_GND))/latb;
FCf2_Vbi_ci=(((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))/latb;
FCf2_Vbi_ei=(((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))/latb;
FCf2_Vci_ei=(((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))/latb;
FCf2=((((1.0-r)*a2)+(r*a3))/latb);
FCdf2_dw_Vbi_ci=(((((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*FClnb)+((((1.0-r)*x)+(r*a))*FClnb_Vbi_ci));
FCdf2_dw_Vbi_ei=(((((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*FClnb)+((((1.0-r)*x)+(r*a))*FClnb_Vbi_ei));
FCdf2_dw_Vtnode_GND=(((((1.0-r)*x_Vtnode_GND)+(r*a_Vtnode_GND))*FClnb)+((((1.0-r)*x)+(r*a))*FClnb_Vtnode_GND));
FCdf2_dw_Vci_ei=(((((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*FClnb)+((((1.0-r)*x)+(r*a))*FClnb_Vci_ei));
FCdf2_dw=((((1.0-r)*x)+(r*a))*FClnb);
}
else
{
a_Vbi_ci=((z_Vbi_ci*z)+(z*z_Vbi_ci));
a_Vbi_ei=((z_Vbi_ei*z)+(z*z_Vbi_ei));
a_Vtnode_GND=((z_Vtnode_GND*z)+(z*z_Vtnode_GND));
a_Vci_ei=((z_Vci_ei*z)+(z*z_Vci_ei));
a=(z*z);
a2_Vbi_ci=(((+z_Vbi_ci)-(0.5*a_Vbi_ci))+((z_Vbi_ci*a)+(z*a_Vbi_ci)));
a2_Vbi_ei=(((+z_Vbi_ei)-(0.5*a_Vbi_ei))+((z_Vbi_ei*a)+(z*a_Vbi_ei)));
a2_Vtnode_GND=(((+z_Vtnode_GND)-(0.5*a_Vtnode_GND))+((z_Vtnode_GND*a)+(z*a_Vtnode_GND)));
a2_Vci_ei=(((+z_Vci_ei)-(0.5*a_Vci_ei))+((z_Vci_ei*a)+(z*a_Vci_ei)));
a2=(((3.0+z)-(0.5*a))+(z*a));
a3_Vbi_ci=((((-2.0)*z_Vbi_ci)+(1.5*a_Vbi_ci))+(((2.0*a_Vbi_ci)*a)+((2.0*a)*a_Vbi_ci))/3.0);
a3_Vbi_ei=((((-2.0)*z_Vbi_ei)+(1.5*a_Vbi_ei))+(((2.0*a_Vbi_ei)*a)+((2.0*a)*a_Vbi_ei))/3.0);
a3_Vtnode_GND=((((-2.0)*z_Vtnode_GND)+(1.5*a_Vtnode_GND))+(((2.0*a_Vtnode_GND)*a)+((2.0*a)*a_Vtnode_GND))/3.0);
a3_Vci_ei=((((-2.0)*z_Vci_ei)+(1.5*a_Vci_ei))+(((2.0*a_Vci_ei)*a)+((2.0*a)*a_Vci_ei))/3.0);
a3=((((-2.0)*z)+(1.5*a))+(((2.0*a)*a)/3.0));
FCf2_Vtnode_GND=((((((latb*a2_Vtnode_GND)+(latl*a3_Vtnode_GND))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vtnode_GND))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vtnode_GND))/6.0;
FCf2_Vbi_ci=((((((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci))/6.0;
FCf2_Vbi_ei=((((((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei))/6.0;
FCf2_Vci_ei=((((((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei))/6.0;
FCf2=(((((latb*a2)+(latl*a3))*FCw)*FCw)/6.0);
FCdf2_dw_Vbi_ci=((((z_Vbi_ci+(0.5*a_Vbi_ci))-((a_Vbi_ci*z)+(a*z_Vbi_ci))/3.0)+(((5.0*a_Vbi_ci)*a)+((5.0*a)*a_Vbi_ci))/6.0)+(((latl*FCw_Vbi_ci)*((a-z)+(((2.0*a)*a)/3.0)))+((latl*FCw)*((a_Vbi_ci-z_Vbi_ci)+(((2.0*a_Vbi_ci)*a)+((2.0*a)*a_Vbi_ci))/3.0))));
FCdf2_dw_Vbi_ei=((((z_Vbi_ei+(0.5*a_Vbi_ei))-((a_Vbi_ei*z)+(a*z_Vbi_ei))/3.0)+(((5.0*a_Vbi_ei)*a)+((5.0*a)*a_Vbi_ei))/6.0)+(((latl*FCw_Vbi_ei)*((a-z)+(((2.0*a)*a)/3.0)))+((latl*FCw)*((a_Vbi_ei-z_Vbi_ei)+(((2.0*a_Vbi_ei)*a)+((2.0*a)*a_Vbi_ei))/3.0))));
FCdf2_dw_Vtnode_GND=((((z_Vtnode_GND+(0.5*a_Vtnode_GND))-((a_Vtnode_GND*z)+(a*z_Vtnode_GND))/3.0)+(((5.0*a_Vtnode_GND)*a)+((5.0*a)*a_Vtnode_GND))/6.0)+(((latl*FCw_Vtnode_GND)*((a-z)+(((2.0*a)*a)/3.0)))+((latl*FCw)*((a_Vtnode_GND-z_Vtnode_GND)+(((2.0*a_Vtnode_GND)*a)+((2.0*a)*a_Vtnode_GND))/3.0))));
FCdf2_dw_Vci_ei=((((z_Vci_ei+(0.5*a_Vci_ei))-((a_Vci_ei*z)+(a*z_Vci_ei))/3.0)+(((5.0*a_Vci_ei)*a)+((5.0*a)*a_Vci_ei))/6.0)+(((latl*FCw_Vci_ei)*((a-z)+(((2.0*a)*a)/3.0)))+((latl*FCw)*((a_Vci_ei-z_Vci_ei)+(((2.0*a_Vci_ei)*a)+((2.0*a)*a_Vci_ei))/3.0))));
FCdf2_dw=((((z+(0.5*a))-((a*z)/3.0))+(((5.0*a)*a)/6.0))+((latl*FCw)*((a-z)+(((2.0*a)*a)/3.0))));
}
z_Vbi_ci=(latl*FCw_Vbi_ci);
z_Vbi_ei=(latl*FCw_Vbi_ei);
z_Vtnode_GND=(latl*FCw_Vtnode_GND);
z_Vci_ei=(latl*FCw_Vci_ei);
z=(latl*FCw);
if ((z>1.0e-6))
{
x_Vbi_ci=(+z_Vbi_ci);
x_Vbi_ei=(+z_Vbi_ei);
x_Vtnode_GND=(+z_Vtnode_GND);
x_Vci_ei=(+z_Vci_ei);
x=(1.0+z);
a_Vbi_ci=((x_Vbi_ci*x)+(x*x_Vbi_ci));
a_Vbi_ei=((x_Vbi_ei*x)+(x*x_Vbi_ei));
a_Vtnode_GND=((x_Vtnode_GND*x)+(x*x_Vtnode_GND));
a_Vci_ei=((x_Vci_ei*x)+(x*x_Vci_ei));
a=(x*x);
a2_Vtnode_GND=(0.250*((a_Vtnode_GND*((2.0*FClnl)-1.0))+(a*(2.0*FClnl_Vtnode_GND))));
a2_Vbi_ci=(0.250*((a_Vbi_ci*((2.0*FClnl)-1.0))+(a*(2.0*FClnl_Vbi_ci))));
a2_Vbi_ei=(0.250*((a_Vbi_ei*((2.0*FClnl)-1.0))+(a*(2.0*FClnl_Vbi_ei))));
a2_Vci_ei=(0.250*((a_Vci_ei*((2.0*FClnl)-1.0))+(a*(2.0*FClnl_Vci_ei))));
a2=(0.250*((a*((2.0*FClnl)-1.0))+1.0));
a3_Vtnode_GND=((((a_Vtnode_GND*x)+(a*x_Vtnode_GND))*((3.0*FClnl)-1.0))+((a*x)*(3.0*FClnl_Vtnode_GND)))/9.0;
a3_Vbi_ci=((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*FClnl)-1.0))+((a*x)*(3.0*FClnl_Vbi_ci)))/9.0;
a3_Vbi_ei=((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*FClnl)-1.0))+((a*x)*(3.0*FClnl_Vbi_ei)))/9.0;
a3_Vci_ei=((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*FClnl)-1.0))+((a*x)*(3.0*FClnl_Vci_ei)))/9.0;
a3=((((a*x)*((3.0*FClnl)-1.0))+1.0)/9.0);
r=(latb/latl);
FCf3_Vtnode_GND=(((1.0-r)*a2_Vtnode_GND)+(r*a3_Vtnode_GND))/latl;
FCf3_Vbi_ci=(((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))/latl;
FCf3_Vbi_ei=(((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))/latl;
FCf3_Vci_ei=(((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))/latl;
FCf3=((((1.0-r)*a2)+(r*a3))/latl);
FCdf3_dw_Vbi_ci=(((((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*FClnl)+((((1.0-r)*x)+(r*a))*FClnl_Vbi_ci));
FCdf3_dw_Vbi_ei=(((((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*FClnl)+((((1.0-r)*x)+(r*a))*FClnl_Vbi_ei));
FCdf3_dw_Vtnode_GND=(((((1.0-r)*x_Vtnode_GND)+(r*a_Vtnode_GND))*FClnl)+((((1.0-r)*x)+(r*a))*FClnl_Vtnode_GND));
FCdf3_dw_Vci_ei=(((((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*FClnl)+((((1.0-r)*x)+(r*a))*FClnl_Vci_ei));
FCdf3_dw=((((1.0-r)*x)+(r*a))*FClnl);
}
else
{
a_Vbi_ci=((z_Vbi_ci*z)+(z*z_Vbi_ci));
a_Vbi_ei=((z_Vbi_ei*z)+(z*z_Vbi_ei));
a_Vtnode_GND=((z_Vtnode_GND*z)+(z*z_Vtnode_GND));
a_Vci_ei=((z_Vci_ei*z)+(z*z_Vci_ei));
a=(z*z);
a2_Vbi_ci=(((+z_Vbi_ci)-(0.5*a_Vbi_ci))+((z_Vbi_ci*a)+(z*a_Vbi_ci)));
a2_Vbi_ei=(((+z_Vbi_ei)-(0.5*a_Vbi_ei))+((z_Vbi_ei*a)+(z*a_Vbi_ei)));
a2_Vtnode_GND=(((+z_Vtnode_GND)-(0.5*a_Vtnode_GND))+((z_Vtnode_GND*a)+(z*a_Vtnode_GND)));
a2_Vci_ei=(((+z_Vci_ei)-(0.5*a_Vci_ei))+((z_Vci_ei*a)+(z*a_Vci_ei)));
a2=(((3.0+z)-(0.5*a))+(z*a));
a3_Vbi_ci=((((-2.0)*z_Vbi_ci)+(1.5*a_Vbi_ci))+(((2.0*a_Vbi_ci)*a)+((2.0*a)*a_Vbi_ci))/3.0);
a3_Vbi_ei=((((-2.0)*z_Vbi_ei)+(1.5*a_Vbi_ei))+(((2.0*a_Vbi_ei)*a)+((2.0*a)*a_Vbi_ei))/3.0);
a3_Vtnode_GND=((((-2.0)*z_Vtnode_GND)+(1.5*a_Vtnode_GND))+(((2.0*a_Vtnode_GND)*a)+((2.0*a)*a_Vtnode_GND))/3.0);
a3_Vci_ei=((((-2.0)*z_Vci_ei)+(1.5*a_Vci_ei))+(((2.0*a_Vci_ei)*a)+((2.0*a)*a_Vci_ei))/3.0);
a3=((((-2.0)*z)+(1.5*a))+(((2.0*a)*a)/3.0));
FCf3_Vtnode_GND=((((((latl*a2_Vtnode_GND)+(latb*a3_Vtnode_GND))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vtnode_GND))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vtnode_GND))/6.0;
FCf3_Vbi_ci=((((((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci))/6.0;
FCf3_Vbi_ei=((((((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei))/6.0;
FCf3_Vci_ei=((((((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei))/6.0;
FCf3=(((((latl*a2)+(latb*a3))*FCw)*FCw)/6.0);
FCdf3_dw_Vbi_ci=((((z_Vbi_ci+(0.5*a_Vbi_ci))-((a_Vbi_ci*z)+(a*z_Vbi_ci))/3.0)+(((5.0*a_Vbi_ci)*a)+((5.0*a)*a_Vbi_ci))/6.0)+(((latb*FCw_Vbi_ci)*((a-z)+(((2.0*a)*a)/3.0)))+((latb*FCw)*((a_Vbi_ci-z_Vbi_ci)+(((2.0*a_Vbi_ci)*a)+((2.0*a)*a_Vbi_ci))/3.0))));
FCdf3_dw_Vbi_ei=((((z_Vbi_ei+(0.5*a_Vbi_ei))-((a_Vbi_ei*z)+(a*z_Vbi_ei))/3.0)+(((5.0*a_Vbi_ei)*a)+((5.0*a)*a_Vbi_ei))/6.0)+(((latb*FCw_Vbi_ei)*((a-z)+(((2.0*a)*a)/3.0)))+((latb*FCw)*((a_Vbi_ei-z_Vbi_ei)+(((2.0*a_Vbi_ei)*a)+((2.0*a)*a_Vbi_ei))/3.0))));
FCdf3_dw_Vtnode_GND=((((z_Vtnode_GND+(0.5*a_Vtnode_GND))-((a_Vtnode_GND*z)+(a*z_Vtnode_GND))/3.0)+(((5.0*a_Vtnode_GND)*a)+((5.0*a)*a_Vtnode_GND))/6.0)+(((latb*FCw_Vtnode_GND)*((a-z)+(((2.0*a)*a)/3.0)))+((latb*FCw)*((a_Vtnode_GND-z_Vtnode_GND)+(((2.0*a_Vtnode_GND)*a)+((2.0*a)*a_Vtnode_GND))/3.0))));
FCdf3_dw_Vci_ei=((((z_Vci_ei+(0.5*a_Vci_ei))-((a_Vci_ei*z)+(a*z_Vci_ei))/3.0)+(((5.0*a_Vci_ei)*a)+((5.0*a)*a_Vci_ei))/6.0)+(((latb*FCw_Vci_ei)*((a-z)+(((2.0*a)*a)/3.0)))+((latb*FCw)*((a_Vci_ei-z_Vci_ei)+(((2.0*a_Vci_ei)*a)+((2.0*a)*a_Vci_ei))/3.0))));
FCdf3_dw=((((z+(0.5*a))-((a*z)/3.0))+(((5.0*a)*a)/6.0))+((latb*FCw)*((a-z)+(((2.0*a)*a)/3.0))));
}
FCf_ci_Vbi_ci=((FCf_CT_Vbi_ci*(((FCa*FCf1)-FCf2)+FCf3))+(FCf_CT*((((FCa_Vbi_ci*FCf1)+(FCa*FCf1_Vbi_ci))-FCf2_Vbi_ci)+FCf3_Vbi_ci)));
FCf_ci_Vbi_ei=((FCf_CT_Vbi_ei*(((FCa*FCf1)-FCf2)+FCf3))+(FCf_CT*((((FCa_Vbi_ei*FCf1)+(FCa*FCf1_Vbi_ei))-FCf2_Vbi_ei)+FCf3_Vbi_ei)));
FCf_ci_Vtnode_GND=((FCf_CT_Vtnode_GND*(((FCa*FCf1)-FCf2)+FCf3))+(FCf_CT*((((FCa_Vtnode_GND*FCf1)+(FCa*FCf1_Vtnode_GND))-FCf2_Vtnode_GND)+FCf3_Vtnode_GND)));
FCf_ci_Vci_ei=((FCf_CT_Vci_ei*(((FCa*FCf1)-FCf2)+FCf3))+(FCf_CT*((((FCa_Vci_ei*FCf1)+(FCa*FCf1_Vci_ei))-FCf2_Vci_ei)+FCf3_Vci_ei)));
FCf_ci=(FCf_CT*(((FCa*FCf1)-FCf2)+FCf3));
FCdfc_dw_Vbi_ci=((FCf_CT_Vbi_ci*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw))+(FCf_CT*(((((FCa1_Vbi_ci*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ci))+((FCda1_dw_Vbi_ci*FCf1)+(FCda1_dw*FCf1_Vbi_ci)))-FCdf2_dw_Vbi_ci)+FCdf3_dw_Vbi_ci)));
FCdfc_dw_Vbi_ei=((FCf_CT_Vbi_ei*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw))+(FCf_CT*(((((FCa1_Vbi_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ei))+((FCda1_dw_Vbi_ei*FCf1)+(FCda1_dw*FCf1_Vbi_ei)))-FCdf2_dw_Vbi_ei)+FCdf3_dw_Vbi_ei)));
FCdfc_dw_Vtnode_GND=((FCf_CT_Vtnode_GND*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw))+(FCf_CT*(((((FCa1_Vtnode_GND*FCdf1_dw)+(FCa1*FCdf1_dw_Vtnode_GND))+((FCda1_dw_Vtnode_GND*FCf1)+(FCda1_dw*FCf1_Vtnode_GND)))-FCdf2_dw_Vtnode_GND)+FCdf3_dw_Vtnode_GND)));
FCdfc_dw_Vci_ei=((FCf_CT_Vci_ei*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw))+(FCf_CT*(((((FCa1_Vci_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vci_ei))+((FCda1_dw_Vci_ei*FCf1)+(FCda1_dw*FCf1_Vci_ei)))-FCdf2_dw_Vci_ei)+FCdf3_dw_Vci_ei)));
FCdfc_dw=(FCf_CT*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw));
FCdw_ditf_Vbi_ci=((FCdw_daick_Vbi_ci*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vbi_ci));
FCdw_ditf_Vbi_ei=((FCdw_daick_Vbi_ei*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vbi_ei));
FCdw_ditf_Vtnode_GND=((FCdw_daick_Vtnode_GND*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vtnode_GND));
FCdw_ditf_Vci_ei=((FCdw_daick_Vci_ei*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vci_ei));
FCdw_ditf=(FCdw_daick*FCdaick_ditf);
FCdfc_ditf_Vbi_ci=((FCdfc_dw_Vbi_ci*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vbi_ci));
FCdfc_ditf_Vbi_ei=((FCdfc_dw_Vbi_ei*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vbi_ei));
FCdfc_ditf_Vtnode_GND=((FCdfc_dw_Vtnode_GND*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vtnode_GND));
FCdfc_ditf_Vci_ei=((FCdfc_dw_Vci_ei*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vci_ei));
FCdfc_ditf=(FCdfc_dw*FCdw_ditf);
a_Vbi_ci=(latb*FCw_Vbi_ci);
a_Vbi_ei=(latb*FCw_Vbi_ei);
a_Vtnode_GND=(latb*FCw_Vtnode_GND);
a_Vci_ei=(latb*FCw_Vci_ei);
a=(latb*FCw);
if ((a>1.0e-6))
{
FCf2_Vtnode_GND=(a_Vtnode_GND-FClnb_Vtnode_GND)/latb;
FCf2_Vbi_ci=(a_Vbi_ci-FClnb_Vbi_ci)/latb;
FCf2_Vbi_ei=(a_Vbi_ei-FClnb_Vbi_ei)/latb;
FCf2_Vci_ei=(a_Vci_ei-FClnb_Vci_ei)/latb;
FCf2=((a-FClnb)/latb);
FCdf2_dw_Vtnode_GND=(a_Vtnode_GND*(1.0+a)-a*(+a_Vtnode_GND))/((1.0+a)*(1.0+a));
FCdf2_dw_Vbi_ci=(a_Vbi_ci*(1.0+a)-a*(+a_Vbi_ci))/((1.0+a)*(1.0+a));
FCdf2_dw_Vbi_ei=(a_Vbi_ei*(1.0+a)-a*(+a_Vbi_ei))/((1.0+a)*(1.0+a));
FCdf2_dw_Vci_ei=(a_Vci_ei*(1.0+a)-a*(+a_Vci_ei))/((1.0+a)*(1.0+a));
FCdf2_dw=(a/(1.0+a));
}
else
{
FCf2_Vtnode_GND=(((0.5*a_Vtnode_GND)*FCw)+((0.5*a)*FCw_Vtnode_GND));
FCf2_Vbi_ci=(((0.5*a_Vbi_ci)*FCw)+((0.5*a)*FCw_Vbi_ci));
FCf2_Vbi_ei=(((0.5*a_Vbi_ei)*FCw)+((0.5*a)*FCw_Vbi_ei));
FCf2_Vci_ei=(((0.5*a_Vci_ei)*FCw)+((0.5*a)*FCw_Vci_ei));
FCf2=((0.5*a)*FCw);
FCdf2_dw_Vtnode_GND=a_Vtnode_GND;
FCdf2_dw_Vbi_ci=a_Vbi_ci;
FCdf2_dw_Vbi_ei=a_Vbi_ei;
FCdf2_dw_Vci_ei=a_Vci_ei;
FCdf2_dw=a;
}
a_Vbi_ci=(latl*FCw_Vbi_ci);
a_Vbi_ei=(latl*FCw_Vbi_ei);
a_Vtnode_GND=(latl*FCw_Vtnode_GND);
a_Vci_ei=(latl*FCw_Vci_ei);
a=(latl*FCw);
if ((a>1.0e-6))
{
FCf3_Vtnode_GND=(a_Vtnode_GND-FClnl_Vtnode_GND)/latl;
FCf3_Vbi_ci=(a_Vbi_ci-FClnl_Vbi_ci)/latl;
FCf3_Vbi_ei=(a_Vbi_ei-FClnl_Vbi_ei)/latl;
FCf3_Vci_ei=(a_Vci_ei-FClnl_Vci_ei)/latl;
FCf3=((a-FClnl)/latl);
FCdf3_dw_Vtnode_GND=(a_Vtnode_GND*(1.0+a)-a*(+a_Vtnode_GND))/((1.0+a)*(1.0+a));
FCdf3_dw_Vbi_ci=(a_Vbi_ci*(1.0+a)-a*(+a_Vbi_ci))/((1.0+a)*(1.0+a));
FCdf3_dw_Vbi_ei=(a_Vbi_ei*(1.0+a)-a*(+a_Vbi_ei))/((1.0+a)*(1.0+a));
FCdf3_dw_Vci_ei=(a_Vci_ei*(1.0+a)-a*(+a_Vci_ei))/((1.0+a)*(1.0+a));
FCdf3_dw=(a/(1.0+a));
}
else
{
FCf3_Vtnode_GND=(((0.5*a_Vtnode_GND)*FCw)+((0.5*a)*FCw_Vtnode_GND));
FCf3_Vbi_ci=(((0.5*a_Vbi_ci)*FCw)+((0.5*a)*FCw_Vbi_ci));
FCf3_Vbi_ei=(((0.5*a_Vbi_ei)*FCw)+((0.5*a)*FCw_Vbi_ei));
FCf3_Vci_ei=(((0.5*a_Vci_ei)*FCw)+((0.5*a)*FCw_Vci_ei));
FCf3=((0.5*a)*FCw);
FCdf3_dw_Vtnode_GND=a_Vtnode_GND;
FCdf3_dw_Vbi_ci=a_Vbi_ci;
FCdf3_dw_Vbi_ei=a_Vbi_ei;
FCdf3_dw_Vci_ei=a_Vci_ei;
FCdf3_dw=a;
}
FCf_CT_Vtnode_GND=((FCf_CT_Vtnode_GND*(FCf2-FCf3))+(FCf_CT*(FCf2_Vtnode_GND-FCf3_Vtnode_GND)));
FCf_CT_Vbi_ci=((FCf_CT_Vbi_ci*(FCf2-FCf3))+(FCf_CT*(FCf2_Vbi_ci-FCf3_Vbi_ci)));
FCf_CT_Vbi_ei=((FCf_CT_Vbi_ei*(FCf2-FCf3))+(FCf_CT*(FCf2_Vbi_ei-FCf3_Vbi_ei)));
FCf_CT_Vci_ei=((FCf_CT_Vci_ei*(FCf2-FCf3))+(FCf_CT*(FCf2_Vci_ei-FCf3_Vci_ei)));
FCf_CT=(FCf_CT*(FCf2-FCf3));
FCdfCT_dw_Vtnode_GND=((FCf_CT_Vtnode_GND*(FCdf2_dw-FCdf3_dw))+(FCf_CT*(FCdf2_dw_Vtnode_GND-FCdf3_dw_Vtnode_GND)));
FCdfCT_dw_Vbi_ci=((FCf_CT_Vbi_ci*(FCdf2_dw-FCdf3_dw))+(FCf_CT*(FCdf2_dw_Vbi_ci-FCdf3_dw_Vbi_ci)));
FCdfCT_dw_Vbi_ei=((FCf_CT_Vbi_ei*(FCdf2_dw-FCdf3_dw))+(FCf_CT*(FCdf2_dw_Vbi_ei-FCdf3_dw_Vbi_ei)));
FCdfCT_dw_Vci_ei=((FCf_CT_Vci_ei*(FCdf2_dw-FCdf3_dw))+(FCf_CT*(FCdf2_dw_Vci_ei-FCdf3_dw_Vci_ei)));
FCdfCT_dw=(FCf_CT*(FCdf2_dw-FCdf3_dw));
FCdfCT_ditf_Vtnode_GND=((FCdfCT_dw_Vtnode_GND*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vtnode_GND));
FCdfCT_ditf_Vbi_ci=((FCdfCT_dw_Vbi_ci*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vbi_ci));
FCdfCT_ditf_Vbi_ei=((FCdfCT_dw_Vbi_ei*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vbi_ei));
FCdfCT_ditf_Vci_ei=((FCdfCT_dw_Vci_ei*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vci_ei));
FCdfCT_ditf=(FCdfCT_dw*FCdw_ditf);
}
else
{
if ((latb>0.01))
{
FCd_a_Vbi_ci=(-(+FCa_ck_Vbi_ci*latb)/((1.0+(FCa_ck*latb))*(1.0+(FCa_ck*latb))));
FCd_a_Vbi_ei=(-(+FCa_ck_Vbi_ei*latb)/((1.0+(FCa_ck*latb))*(1.0+(FCa_ck*latb))));
FCd_a_Vtnode_GND=(-(+FCa_ck_Vtnode_GND*latb)/((1.0+(FCa_ck*latb))*(1.0+(FCa_ck*latb))));
FCd_a_Vci_ei=(-(+FCa_ck_Vci_ei*latb)/((1.0+(FCa_ck*latb))*(1.0+(FCa_ck*latb))));
FCd_a=(1.0/(1.0+(FCa_ck*latb)));
FCw_Vbi_ci=(((-FCa_ck_Vbi_ci)*FCd_a)+((1.0-FCa_ck)*FCd_a_Vbi_ci));
FCw_Vbi_ei=(((-FCa_ck_Vbi_ei)*FCd_a)+((1.0-FCa_ck)*FCd_a_Vbi_ei));
FCw_Vtnode_GND=(((-FCa_ck_Vtnode_GND)*FCd_a)+((1.0-FCa_ck)*FCd_a_Vtnode_GND));
FCw_Vci_ei=(((-FCa_ck_Vci_ei)*FCd_a)+((1.0-FCa_ck)*FCd_a_Vci_ei));
FCw=((1.0-FCa_ck)*FCd_a);
FCdw_daick_Vbi_ci=((((-(1.0+latb))*FCd_a_Vbi_ci)*FCd_a)+(((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ci));
FCdw_daick_Vbi_ei=((((-(1.0+latb))*FCd_a_Vbi_ei)*FCd_a)+(((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ei));
FCdw_daick_Vtnode_GND=((((-(1.0+latb))*FCd_a_Vtnode_GND)*FCd_a)+(((-(1.0+latb))*FCd_a)*FCd_a_Vtnode_GND));
FCdw_daick_Vci_ei=((((-(1.0+latb))*FCd_a_Vci_ei)*FCd_a)+(((-(1.0+latb))*FCd_a)*FCd_a_Vci_ei));
FCdw_daick=(((-(1.0+latb))*FCd_a)*FCd_a);
}
else
{
FCw_Vbi_ci=((-FCa_ck_Vbi_ci)-FCa_ck_Vbi_ci*latb);
FCw_Vbi_ei=((-FCa_ck_Vbi_ei)-FCa_ck_Vbi_ei*latb);
FCw_Vtnode_GND=((-FCa_ck_Vtnode_GND)-FCa_ck_Vtnode_GND*latb);
FCw_Vci_ei=((-FCa_ck_Vci_ei)-FCa_ck_Vci_ei*latb);
FCw=((1.0-FCa_ck)-(FCa_ck*latb));
FCdw_daick=(-(1.0+latb));
FCdw_daick_Vci_ei=0.0;
FCdw_daick_Vtnode_GND=0.0;
FCdw_daick_Vbi_ei=0.0;
FCdw_daick_Vbi_ci=0.0;
}
FCw2_Vbi_ci=((FCw_Vbi_ci*FCw)+(FCw*FCw_Vbi_ci));
FCw2_Vbi_ei=((FCw_Vbi_ei*FCw)+(FCw*FCw_Vbi_ei));
FCw2_Vtnode_GND=((FCw_Vtnode_GND*FCw)+(FCw*FCw_Vtnode_GND));
FCw2_Vci_ei=((FCw_Vci_ei*FCw)+(FCw*FCw_Vci_ei));
FCw2=(FCw*FCw);
FCz_Vbi_ci=(latb*FCw_Vbi_ci);
FCz_Vbi_ei=(latb*FCw_Vbi_ei);
FCz_Vtnode_GND=(latb*FCw_Vtnode_GND);
FCz_Vci_ei=(latb*FCw_Vci_ei);
FCz=(latb*FCw);
FCz_1_Vbi_ci=(+FCz_Vbi_ci);
FCz_1_Vbi_ei=(+FCz_Vbi_ei);
FCz_1_Vtnode_GND=(+FCz_Vtnode_GND);
FCz_1_Vci_ei=(+FCz_Vci_ei);
FCz_1=(1.0+FCz);
FCd_f_Vbi_ci=(-FCz_1_Vbi_ci/(FCz_1*FCz_1));
FCd_f_Vbi_ei=(-FCz_1_Vbi_ei/(FCz_1*FCz_1));
FCd_f_Vtnode_GND=(-FCz_1_Vtnode_GND/(FCz_1*FCz_1));
FCd_f_Vci_ei=(-FCz_1_Vci_ei/(FCz_1*FCz_1));
FCd_f=(1.0/FCz_1);
FCf_ci_Vbi_ci=((((FCw2_Vbi_ci*(1.0+(FCz/3.0)))+(FCw2*(+FCz_Vbi_ci/3.0)))*FCd_f)+((FCw2*(1.0+(FCz/3.0)))*FCd_f_Vbi_ci));
FCf_ci_Vbi_ei=((((FCw2_Vbi_ei*(1.0+(FCz/3.0)))+(FCw2*(+FCz_Vbi_ei/3.0)))*FCd_f)+((FCw2*(1.0+(FCz/3.0)))*FCd_f_Vbi_ei));
FCf_ci_Vtnode_GND=((((FCw2_Vtnode_GND*(1.0+(FCz/3.0)))+(FCw2*(+FCz_Vtnode_GND/3.0)))*FCd_f)+((FCw2*(1.0+(FCz/3.0)))*FCd_f_Vtnode_GND));
FCf_ci_Vci_ei=((((FCw2_Vci_ei*(1.0+(FCz/3.0)))+(FCw2*(+FCz_Vci_ei/3.0)))*FCd_f)+((FCw2*(1.0+(FCz/3.0)))*FCd_f_Vci_ei));
FCf_ci=((FCw2*(1.0+(FCz/3.0)))*FCd_f);
FCdfc_dw_Vbi_ci=(((((((2.0*FCw_Vbi_ci)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ci+((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0)))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ci))*FCd_f)+((((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ci));
FCdfc_dw_Vbi_ei=(((((((2.0*FCw_Vbi_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ei+((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0)))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ei))*FCd_f)+((((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ei));
FCdfc_dw_Vtnode_GND=(((((((2.0*FCw_Vtnode_GND)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vtnode_GND+((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND))/3.0)))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vtnode_GND))*FCd_f)+((((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vtnode_GND));
FCdfc_dw_Vci_ei=(((((((2.0*FCw_Vci_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vci_ei+((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0)))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vci_ei))*FCd_f)+((((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vci_ei));
FCdfc_dw=((((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f);
FCdw_ditf_Vbi_ci=((FCdw_daick_Vbi_ci*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vbi_ci));
FCdw_ditf_Vbi_ei=((FCdw_daick_Vbi_ei*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vbi_ei));
FCdw_ditf_Vtnode_GND=((FCdw_daick_Vtnode_GND*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vtnode_GND));
FCdw_ditf_Vci_ei=((FCdw_daick_Vci_ei*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vci_ei));
FCdw_ditf=(FCdw_daick*FCdaick_ditf);
FCdfc_ditf_Vbi_ci=((FCdfc_dw_Vbi_ci*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vbi_ci));
FCdfc_ditf_Vbi_ei=((FCdfc_dw_Vbi_ei*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vbi_ei));
FCdfc_ditf_Vtnode_GND=((FCdfc_dw_Vtnode_GND*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vtnode_GND));
FCdfc_ditf_Vci_ei=((FCdfc_dw_Vci_ei*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vci_ei));
FCdfc_ditf=(FCdfc_dw*FCdw_ditf);
if ((FCz>0.001))
{
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,(FCz_1));
_logE(__logE_0,(FCz_1));
FCf_CT_Vbi_ci=((2.0*(((FCz_1_Vbi_ci*__logE_0)+(FCz_1*FCz_1_Vbi_ci*__d_logE_0))-FCz_Vbi_ci))*((latb*latb)*FCz_1)-(2.0*((FCz_1*__logE_0)-FCz))*((latb*latb)*FCz_1_Vbi_ci))/(((latb*latb)*FCz_1)*((latb*latb)*FCz_1));
FCf_CT_Vbi_ei=((2.0*(((FCz_1_Vbi_ei*__logE_0)+(FCz_1*FCz_1_Vbi_ei*__d_logE_0))-FCz_Vbi_ei))*((latb*latb)*FCz_1)-(2.0*((FCz_1*__logE_0)-FCz))*((latb*latb)*FCz_1_Vbi_ei))/(((latb*latb)*FCz_1)*((latb*latb)*FCz_1));
FCf_CT_Vtnode_GND=((2.0*(((FCz_1_Vtnode_GND*__logE_0)+(FCz_1*FCz_1_Vtnode_GND*__d_logE_0))-FCz_Vtnode_GND))*((latb*latb)*FCz_1)-(2.0*((FCz_1*__logE_0)-FCz))*((latb*latb)*FCz_1_Vtnode_GND))/(((latb*latb)*FCz_1)*((latb*latb)*FCz_1));
FCf_CT_Vci_ei=((2.0*(((FCz_1_Vci_ei*__logE_0)+(FCz_1*FCz_1_Vci_ei*__d_logE_0))-FCz_Vci_ei))*((latb*latb)*FCz_1)-(2.0*((FCz_1*__logE_0)-FCz))*((latb*latb)*FCz_1_Vci_ei))/(((latb*latb)*FCz_1)*((latb*latb)*FCz_1));
FCf_CT=((2.0*((FCz_1*__logE_0)-FCz))/((latb*latb)*FCz_1));
}
FCdfCT_dw_Vbi_ci=(((((2.0*FCw_Vbi_ci)*FCd_f)+((2.0*FCw)*FCd_f_Vbi_ci))*FCd_f)+(((2.0*FCw)*FCd_f)*FCd_f_Vbi_ci));
FCdfCT_dw_Vbi_ei=(((((2.0*FCw_Vbi_ei)*FCd_f)+((2.0*FCw)*FCd_f_Vbi_ei))*FCd_f)+(((2.0*FCw)*FCd_f)*FCd_f_Vbi_ei));
FCdfCT_dw_Vtnode_GND=(((((2.0*FCw_Vtnode_GND)*FCd_f)+((2.0*FCw)*FCd_f_Vtnode_GND))*FCd_f)+(((2.0*FCw)*FCd_f)*FCd_f_Vtnode_GND));
FCdfCT_dw_Vci_ei=(((((2.0*FCw_Vci_ei)*FCd_f)+((2.0*FCw)*FCd_f_Vci_ei))*FCd_f)+(((2.0*FCw)*FCd_f)*FCd_f_Vci_ei));
FCdfCT_dw=(((2.0*FCw)*FCd_f)*FCd_f);
}
else
{
FCf_CT_Vbi_ci=((((FCw2_Vbi_ci*(1.0-(FCz/3.0)))+(FCw2*(-FCz_Vbi_ci/3.0)))*FCd_f)+((FCw2*(1.0-(FCz/3.0)))*FCd_f_Vbi_ci));
FCf_CT_Vbi_ei=((((FCw2_Vbi_ei*(1.0-(FCz/3.0)))+(FCw2*(-FCz_Vbi_ei/3.0)))*FCd_f)+((FCw2*(1.0-(FCz/3.0)))*FCd_f_Vbi_ei));
FCf_CT_Vtnode_GND=((((FCw2_Vtnode_GND*(1.0-(FCz/3.0)))+(FCw2*(-FCz_Vtnode_GND/3.0)))*FCd_f)+((FCw2*(1.0-(FCz/3.0)))*FCd_f_Vtnode_GND));
FCf_CT_Vci_ei=((((FCw2_Vci_ei*(1.0-(FCz/3.0)))+(FCw2*(-FCz_Vci_ei/3.0)))*FCd_f)+((FCw2*(1.0-(FCz/3.0)))*FCd_f_Vci_ei));
FCf_CT=((FCw2*(1.0-(FCz/3.0)))*FCd_f);
FCdfCT_dw_Vbi_ci=(((((((2.0*FCw_Vbi_ci)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0)))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ci))*FCd_f)+((((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ci));
FCdfCT_dw_Vbi_ei=(((((((2.0*FCw_Vbi_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0)))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ei))*FCd_f)+((((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ei));
FCdfCT_dw_Vtnode_GND=(((((((2.0*FCw_Vtnode_GND)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND))/3.0)))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vtnode_GND))*FCd_f)+((((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vtnode_GND));
FCdfCT_dw_Vci_ei=(((((((2.0*FCw_Vci_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0)))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vci_ei))*FCd_f)+((((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vci_ei));
FCdfCT_dw=((((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f);
}
FCdfCT_ditf_Vtnode_GND=((FCdfCT_dw_Vtnode_GND*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vtnode_GND));
FCdfCT_ditf_Vbi_ci=((FCdfCT_dw_Vbi_ci*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vbi_ci));
FCdfCT_ditf_Vbi_ei=((FCdfCT_dw_Vbi_ei*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vbi_ei));
FCdfCT_ditf_Vci_ei=((FCdfCT_dw_Vci_ei*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vci_ei));
FCdfCT_ditf=(FCdfCT_dw*FCdw_ditf);
}
FFQ_cT_Vci_ei=((FFQ_fC_Vci_ei*FCf_CT)+(FFQ_fC*FCf_CT_Vci_ei));
FFQ_cT_Vbi_ci=((FFQ_fC_Vbi_ci*FCf_CT)+(FFQ_fC*FCf_CT_Vbi_ci));
FFQ_cT_Vbi_ei=((FFQ_fC_Vbi_ei*FCf_CT)+(FFQ_fC*FCf_CT_Vbi_ei));
FFQ_cT_Vtnode_GND=((FFQ_fC_Vtnode_GND*FCf_CT)+(FFQ_fC*FCf_CT_Vtnode_GND));
FFQ_cT=(FFQ_fC*FCf_CT);
FFQ_fC_Vci_ei=((FFQ_fC_Vci_ei*FCf_ci)+(FFQ_fC*FCf_ci_Vci_ei));
FFQ_fC_Vbi_ci=((FFQ_fC_Vbi_ci*FCf_ci)+(FFQ_fC*FCf_ci_Vbi_ci));
FFQ_fC_Vbi_ei=((FFQ_fC_Vbi_ei*FCf_ci)+(FFQ_fC*FCf_ci_Vbi_ei));
FFQ_fC_Vtnode_GND=((FFQ_fC_Vtnode_GND*FCf_ci)+(FFQ_fC*FCf_ci_Vtnode_GND));
FFQ_fC=(FFQ_fC*FCf_ci);
FFT_fC_Vbi_ci=(FFT_pcS*(FCf_ci_Vbi_ci+((itf_Vbi_ci*FCdfc_ditf)+(itf*FCdfc_ditf_Vbi_ci))));
FFT_fC_Vbi_ei=(FFT_pcS*(FCf_ci_Vbi_ei+((itf_Vbi_ei*FCdfc_ditf)+(itf*FCdfc_ditf_Vbi_ei))));
FFT_fC_Vci_ei=(FFT_pcS*(FCf_ci_Vci_ei+((itf_Vci_ei*FCdfc_ditf)+(itf*FCdfc_ditf_Vci_ei))));
FFT_fC_Vtnode_GND=((FFT_pcS_Vtnode_GND*(FCf_ci+(itf*FCdfc_ditf)))+(FFT_pcS*(FCf_ci_Vtnode_GND+((itf_Vtnode_GND*FCdfc_ditf)+(itf*FCdfc_ditf_Vtnode_GND)))));
FFT_fC=(FFT_pcS*(FCf_ci+(itf*FCdfc_ditf)));
FFT_cT_Vbi_ci=(FFT_pcS*(FCf_CT_Vbi_ci+((itf_Vbi_ci*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vbi_ci))));
FFT_cT_Vbi_ei=(FFT_pcS*(FCf_CT_Vbi_ei+((itf_Vbi_ei*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vbi_ei))));
FFT_cT_Vci_ei=(FFT_pcS*(FCf_CT_Vci_ei+((itf_Vci_ei*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vci_ei))));
FFT_cT_Vtnode_GND=((FFT_pcS_Vtnode_GND*(FCf_CT+(itf*FCdfCT_ditf)))+(FFT_pcS*(FCf_CT_Vtnode_GND+((itf_Vtnode_GND*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vtnode_GND)))));
FFT_cT=(FFT_pcS*(FCf_CT+(itf*FCdfCT_ditf)));
}
Qf_Vci_ei=(Qf_Vci_ei+FFd_QfB_Vci_ei);
Qf_Vbi_ei=(Qf_Vbi_ei+FFd_QfB_Vbi_ei);
Qf_Vbi_ci=(Qf_Vbi_ci+FFd_QfB_Vbi_ci);
Qf_Vtnode_GND=(Qf_Vtnode_GND+FFd_QfB_Vtnode_GND);
Qf=(Qf+FFd_QfB);
Tf_Vci_ei=(Tf_Vci_ei+FFd_TfB_Vci_ei);
Tf_Vbi_ei=(Tf_Vbi_ei+FFd_TfB_Vbi_ei);
Tf_Vbi_ci=(Tf_Vbi_ci+FFd_TfB_Vbi_ci);
Tf_Vtnode_GND=(Tf_Vtnode_GND+FFd_TfB_Vtnode_GND);
Tf=(Tf+FFd_TfB);
Q_fT_Vbi_ei=((Qf_Vbi_ei+(hfe*FFd_QfE_Vbi_ei))+(hfc*FFQ_cT_Vbi_ei));
Q_fT_Vbi_ci=((Qf_Vbi_ci+(hfe*FFd_QfE_Vbi_ci))+(hfc*FFQ_cT_Vbi_ci));
Q_fT_Vtnode_GND=((Qf_Vtnode_GND+(hfe*FFd_QfE_Vtnode_GND))+(hfc*FFQ_cT_Vtnode_GND));
Q_fT_Vci_ei=((Qf_Vci_ei+(hfe*FFd_QfE_Vci_ei))+(hfc*FFQ_cT_Vci_ei));
Q_fT=((Qf+(hfe*FFd_QfE))+(hfc*FFQ_cT));
T_fT_Vbi_ei=((Tf_Vbi_ei+(hfe*FFd_TfE_Vbi_ei))+(hfc*FFT_cT_Vbi_ei));
T_fT_Vbi_ci=((Tf_Vbi_ci+(hfe*FFd_TfE_Vbi_ci))+(hfc*FFT_cT_Vbi_ci));
T_fT_Vtnode_GND=((Tf_Vtnode_GND+(hfe*FFd_TfE_Vtnode_GND))+(hfc*FFT_cT_Vtnode_GND));
T_fT_Vci_ei=((Tf_Vci_ei+(hfe*FFd_TfE_Vci_ei))+(hfc*FFT_cT_Vci_ei));
T_fT=((Tf+(hfe*FFd_TfE))+(hfc*FFT_cT));
Qf_Vbi_ei=((Qf_Vbi_ei+FFd_QfE_Vbi_ei)+FFQ_fC_Vbi_ei);
Qf_Vbi_ci=((Qf_Vbi_ci+FFd_QfE_Vbi_ci)+FFQ_fC_Vbi_ci);
Qf_Vtnode_GND=((Qf_Vtnode_GND+FFd_QfE_Vtnode_GND)+FFQ_fC_Vtnode_GND);
Qf_Vci_ei=((Qf_Vci_ei+FFd_QfE_Vci_ei)+FFQ_fC_Vci_ei);
Qf=((Qf+FFd_QfE)+FFQ_fC);
Tf_Vbi_ei=((Tf_Vbi_ei+FFd_TfE_Vbi_ei)+FFT_fC_Vbi_ei);
Tf_Vbi_ci=((Tf_Vbi_ci+FFd_TfE_Vbi_ci)+FFT_fC_Vbi_ci);
Tf_Vtnode_GND=((Tf_Vtnode_GND+FFd_TfE_Vtnode_GND)+FFT_fC_Vtnode_GND);
Tf_Vci_ei=((Tf_Vci_ei+FFd_TfE_Vci_ei)+FFT_fC_Vci_ei);
Tf=((Tf+FFd_TfE)+FFT_fC);
}
Qr_Vbi_ei=(Tr*itr_Vbi_ei);
Qr_Vbi_ci=(Tr*itr_Vbi_ci);
Qr_Vtnode_GND=(Tr*itr_Vtnode_GND);
Qr=(Tr*itr);
Qr_Vci_ei=0.0;
if (doAC)
{
l_it=0;
}
if (((Qf>(1.0e-5*Q_p))||(a_h>1.0e-5)))
{
{
double __sqrt_0=0.0;
double __d_sqrt_0=0.0;
_d_sqrt(__sqrt_0,__d_sqrt_0,(((T_f0*itf)*Q_fT)));
_sqrt(__sqrt_0,(((T_f0*itf)*Q_fT)));
Qf_Vci_ei=(((T_f0*itf_Vci_ei)*Q_fT)+((T_f0*itf)*Q_fT_Vci_ei))*__d_sqrt_0;
Qf_Vbi_ei=((((T_f0_Vbi_ei*itf)+(T_f0*itf_Vbi_ei))*Q_fT)+((T_f0*itf)*Q_fT_Vbi_ei))*__d_sqrt_0;
Qf_Vbi_ci=((((T_f0_Vbi_ci*itf)+(T_f0*itf_Vbi_ci))*Q_fT)+((T_f0*itf)*Q_fT_Vbi_ci))*__d_sqrt_0;
Qf_Vtnode_GND=((((T_f0_Vtnode_GND*itf)+(T_f0*itf_Vtnode_GND))*Q_fT)+((T_f0*itf)*Q_fT_Vtnode_GND))*__d_sqrt_0;
Qf=__sqrt_0;
}
Q_pT_Vci_ei=((+Qf_Vci_ei)+Qr_Vci_ei);
Q_pT_Vbi_ci=((Q_0_Vbi_ci+Qf_Vbi_ci)+Qr_Vbi_ci);
Q_pT_Vbi_ei=((Q_0_Vbi_ei+Qf_Vbi_ei)+Qr_Vbi_ei);
Q_pT_Vtnode_GND=((Q_0_Vtnode_GND+Qf_Vtnode_GND)+Qr_Vtnode_GND);
Q_pT=((Q_0+Qf)+Qr);
d_Q_Vci_ei=Q_pT_Vci_ei;
d_Q_Vbi_ci=Q_pT_Vbi_ci;
d_Q_Vbi_ei=Q_pT_Vbi_ei;
d_Q_Vtnode_GND=Q_pT_Vtnode_GND;
d_Q=Q_pT;
{
double __fabs_0=0.0;
double __fabs_1=0.0;
_fabs(__fabs_0,(d_Q));
_fabs(__fabs_1,(Q_pT));
while (((__fabs_0>=(1.0e-5*__fabs_1))&&(l_it<=100)))
{
if (doAC)
{
d_Q0=d_Q;
}
I_Tf1_Vci_ei=(-(i_0f*Q_pT_Vci_ei)/(Q_pT*Q_pT));
I_Tf1_Vbi_ci=(-(i_0f*Q_pT_Vbi_ci)/(Q_pT*Q_pT));
I_Tf1_Vbi_ei=(i_0f_Vbi_ei*Q_pT-i_0f*Q_pT_Vbi_ei)/(Q_pT*Q_pT);
I_Tf1_Vtnode_GND=(i_0f_Vtnode_GND*Q_pT-i_0f*Q_pT_Vtnode_GND)/(Q_pT*Q_pT);
I_Tf1=(i_0f/Q_pT);
a_h_Vbi_ci=(Oich*I_Tf1_Vbi_ci);
a_h_Vbi_ei=(Oich*I_Tf1_Vbi_ei);
a_h_Vtnode_GND=(Oich*I_Tf1_Vtnode_GND);
a_h_Vci_ei=(Oich*I_Tf1_Vci_ei);
a_h=(Oich*I_Tf1);
itf_Vbi_ci=((I_Tf1_Vbi_ci*(1.0+a_h))+(I_Tf1*(+a_h_Vbi_ci)));
itf_Vbi_ei=((I_Tf1_Vbi_ei*(1.0+a_h))+(I_Tf1*(+a_h_Vbi_ei)));
itf_Vtnode_GND=((I_Tf1_Vtnode_GND*(1.0+a_h))+(I_Tf1*(+a_h_Vtnode_GND)));
itf_Vci_ei=((I_Tf1_Vci_ei*(1.0+a_h))+(I_Tf1*(+a_h_Vci_ei)));
itf=(I_Tf1*(1.0+a_h));
itr_Vci_ei=(-(i_0r*Q_pT_Vci_ei)/(Q_pT*Q_pT));
itr_Vbi_ei=(-(i_0r*Q_pT_Vbi_ei)/(Q_pT*Q_pT));
itr_Vbi_ci=(i_0r_Vbi_ci*Q_pT-i_0r*Q_pT_Vbi_ci)/(Q_pT*Q_pT);
itr_Vtnode_GND=(i_0r_Vtnode_GND*Q_pT-i_0r*Q_pT_Vtnode_GND)/(Q_pT*Q_pT);
itr=(i_0r/Q_pT);
Tf_Vbi_ei=T_f0_Vbi_ei;
Tf_Vbi_ci=T_f0_Vbi_ci;
Tf_Vtnode_GND=T_f0_Vtnode_GND;
Tf=T_f0;
Tf_Vci_ei=0.0;
Qf_Vci_ei=(T_f0*itf_Vci_ei);
Qf_Vbi_ei=((T_f0_Vbi_ei*itf)+(T_f0*itf_Vbi_ei));
Qf_Vbi_ci=((T_f0_Vbi_ci*itf)+(T_f0*itf_Vbi_ci));
Qf_Vtnode_GND=((T_f0_Vtnode_GND*itf)+(T_f0*itf_Vtnode_GND));
Qf=(T_f0*itf);
if ((itf<(1.0e-6*ick)))
{
Q_fT_Vbi_ei=Qf_Vbi_ei;
Q_fT_Vbi_ci=Qf_Vbi_ci;
Q_fT_Vtnode_GND=Qf_Vtnode_GND;
Q_fT_Vci_ei=Qf_Vci_ei;
Q_fT=Qf;
T_fT_Vbi_ei=Tf_Vbi_ei;
T_fT_Vbi_ci=Tf_Vbi_ci;
T_fT_Vtnode_GND=Tf_Vtnode_GND;
T_fT_Vci_ei=Tf_Vci_ei;
T_fT=Tf;
}
else
{
FFa_Vbi_ci=(-(ick*itf_Vbi_ci)/(itf*itf));
FFa_Vbi_ei=(-(ick*itf_Vbi_ei)/(itf*itf));
FFa_Vtnode_GND=(ick_Vtnode_GND*itf-ick*itf_Vtnode_GND)/(itf*itf);
FFa_Vci_ei=(ick_Vci_ei*itf-ick*itf_Vci_ei)/(itf*itf);
FFa=(ick/itf);
{
double __logE_0=0.0;
double __exp_1=0.0;
double __d_logE_0=0.0;
double __d_exp_1=0.0;
_d_logE(__logE_0,__d_logE_0,(FFa));
_d_exp(__exp_1,__d_exp_1,(((-gtfe)*__logE_0)));
_logE(__logE_0,(FFa));
_exp(__exp_1,(((-gtfe)*__logE_0)));
FFd_TfE_Vbi_ci=(tef0_t*((-gtfe)*FFa_Vbi_ci*__d_logE_0)*__d_exp_1);
FFd_TfE_Vbi_ei=(tef0_t*((-gtfe)*FFa_Vbi_ei*__d_logE_0)*__d_exp_1);
FFd_TfE_Vci_ei=(tef0_t*((-gtfe)*FFa_Vci_ei*__d_logE_0)*__d_exp_1);
FFd_TfE_Vtnode_GND=((tef0_t_Vtnode_GND*__exp_1)+(tef0_t*((-gtfe)*FFa_Vtnode_GND*__d_logE_0)*__d_exp_1));
FFd_TfE=(tef0_t*__exp_1);
}
FFd_QfE_Vbi_ci=((FFd_TfE_Vbi_ci*itf)+(FFd_TfE*itf_Vbi_ci))/(gtfe+1.0);
FFd_QfE_Vbi_ei=((FFd_TfE_Vbi_ei*itf)+(FFd_TfE*itf_Vbi_ei))/(gtfe+1.0);
FFd_QfE_Vci_ei=((FFd_TfE_Vci_ei*itf)+(FFd_TfE*itf_Vci_ei))/(gtfe+1.0);
FFd_QfE_Vtnode_GND=((FFd_TfE_Vtnode_GND*itf)+(FFd_TfE*itf_Vtnode_GND))/(gtfe+1.0);
FFd_QfE=((FFd_TfE*itf)/(gtfe+1.0));
FFT_fbS_Vtnode_GND=((1.0-fthc)*thcs_t_Vtnode_GND);
FFT_fbS=((1.0-fthc)*thcs_t);
FFx_Vbi_ci=(-FFa_Vbi_ci);
FFx_Vbi_ei=(-FFa_Vbi_ei);
FFx_Vtnode_GND=(-FFa_Vtnode_GND);
FFx_Vci_ei=(-FFa_Vci_ei);
FFx=(1.0-FFa);
{
double __sqrt_0=0.0;
double __d_sqrt_0=0.0;
_d_sqrt(__sqrt_0,__d_sqrt_0,(((FFx*FFx)+alhc)));
_sqrt(__sqrt_0,(((FFx*FFx)+alhc)));
FFs_Vbi_ci=((FFx_Vbi_ci*FFx)+(FFx*FFx_Vbi_ci))*__d_sqrt_0;
FFs_Vbi_ei=((FFx_Vbi_ei*FFx)+(FFx*FFx_Vbi_ei))*__d_sqrt_0;
FFs_Vtnode_GND=((FFx_Vtnode_GND*FFx)+(FFx*FFx_Vtnode_GND))*__d_sqrt_0;
FFs_Vci_ei=((FFx_Vci_ei*FFx)+(FFx*FFx_Vci_ei))*__d_sqrt_0;
FFs=__sqrt_0;
}
{
double __sqrt_0=0.0;
_sqrt(__sqrt_0,((1.0+alhc)));
FFw_Vbi_ci=(FFx_Vbi_ci+FFs_Vbi_ci)/(1.0+__sqrt_0);
FFw_Vbi_ei=(FFx_Vbi_ei+FFs_Vbi_ei)/(1.0+__sqrt_0);
FFw_Vtnode_GND=(FFx_Vtnode_GND+FFs_Vtnode_GND)/(1.0+__sqrt_0);
FFw_Vci_ei=(FFx_Vci_ei+FFs_Vci_ei)/(1.0+__sqrt_0);
FFw=((FFx+FFs)/(1.0+__sqrt_0));
}
FFw_2_Vbi_ci=((FFw_Vbi_ci*FFw)+(FFw*FFw_Vbi_ci));
FFw_2_Vbi_ei=((FFw_Vbi_ei*FFw)+(FFw*FFw_Vbi_ei));
FFw_2_Vtnode_GND=((FFw_Vtnode_GND*FFw)+(FFw*FFw_Vtnode_GND));
FFw_2_Vci_ei=((FFw_Vci_ei*FFw)+(FFw*FFw_Vci_ei));
FFw_2=(FFw*FFw);
FFd_QfB_Vbi_ci=(((FFT_fbS*itf_Vbi_ci)*FFw_2)+((FFT_fbS*itf)*FFw_2_Vbi_ci));
FFd_QfB_Vbi_ei=(((FFT_fbS*itf_Vbi_ei)*FFw_2)+((FFT_fbS*itf)*FFw_2_Vbi_ei));
FFd_QfB_Vci_ei=(((FFT_fbS*itf_Vci_ei)*FFw_2)+((FFT_fbS*itf)*FFw_2_Vci_ei));
FFd_QfB_Vtnode_GND=((((FFT_fbS_Vtnode_GND*itf)+(FFT_fbS*itf_Vtnode_GND))*FFw_2)+((FFT_fbS*itf)*FFw_2_Vtnode_GND));
FFd_QfB=((FFT_fbS*itf)*FFw_2);
FFa_w_Vbi_ci=((FFw_2_Vbi_ci*(1.0+((2.0*FFa)/FFs)))+(FFw_2*(+((2.0*FFa_Vbi_ci)*FFs-(2.0*FFa)*FFs_Vbi_ci)/(FFs*FFs))));
FFa_w_Vbi_ei=((FFw_2_Vbi_ei*(1.0+((2.0*FFa)/FFs)))+(FFw_2*(+((2.0*FFa_Vbi_ei)*FFs-(2.0*FFa)*FFs_Vbi_ei)/(FFs*FFs))));
FFa_w_Vtnode_GND=((FFw_2_Vtnode_GND*(1.0+((2.0*FFa)/FFs)))+(FFw_2*(+((2.0*FFa_Vtnode_GND)*FFs-(2.0*FFa)*FFs_Vtnode_GND)/(FFs*FFs))));
FFa_w_Vci_ei=((FFw_2_Vci_ei*(1.0+((2.0*FFa)/FFs)))+(FFw_2*(+((2.0*FFa_Vci_ei)*FFs-(2.0*FFa)*FFs_Vci_ei)/(FFs*FFs))));
FFa_w=(FFw_2*(1.0+((2.0*FFa)/FFs)));
FFd_TfB_Vbi_ci=(FFT_fbS*FFa_w_Vbi_ci);
FFd_TfB_Vbi_ei=(FFT_fbS*FFa_w_Vbi_ei);
FFd_TfB_Vci_ei=(FFT_fbS*FFa_w_Vci_ei);
FFd_TfB_Vtnode_GND=((FFT_fbS_Vtnode_GND*FFa_w)+(FFT_fbS*FFa_w_Vtnode_GND));
FFd_TfB=(FFT_fbS*FFa_w);
FFT_pcS_Vtnode_GND=(fthc*thcs_t_Vtnode_GND);
FFT_pcS=(fthc*thcs_t);
if (((latb<=0.0)&&(latl<=0.0)))
{
FFQ_fC_Vbi_ci=(((FFT_pcS*itf_Vbi_ci)*FFw_2)+((FFT_pcS*itf)*FFw_2_Vbi_ci));
FFQ_fC_Vbi_ei=(((FFT_pcS*itf_Vbi_ei)*FFw_2)+((FFT_pcS*itf)*FFw_2_Vbi_ei));
FFQ_fC_Vci_ei=(((FFT_pcS*itf_Vci_ei)*FFw_2)+((FFT_pcS*itf)*FFw_2_Vci_ei));
FFQ_fC_Vtnode_GND=((((FFT_pcS_Vtnode_GND*itf)+(FFT_pcS*itf_Vtnode_GND))*FFw_2)+((FFT_pcS*itf)*FFw_2_Vtnode_GND));
FFQ_fC=((FFT_pcS*itf)*FFw_2);
FFT_fC_Vbi_ci=(FFT_pcS*FFa_w_Vbi_ci);
FFT_fC_Vbi_ei=(FFT_pcS*FFa_w_Vbi_ei);
FFT_fC_Vci_ei=(FFT_pcS*FFa_w_Vci_ei);
FFT_fC_Vtnode_GND=((FFT_pcS_Vtnode_GND*FFa_w)+(FFT_pcS*FFa_w_Vtnode_GND));
FFT_fC=(FFT_pcS*FFa_w);
FFQ_cT_Vci_ei=FFQ_fC_Vci_ei;
FFQ_cT_Vbi_ci=FFQ_fC_Vbi_ci;
FFQ_cT_Vbi_ei=FFQ_fC_Vbi_ei;
FFQ_cT_Vtnode_GND=FFQ_fC_Vtnode_GND;
FFQ_cT=FFQ_fC;
FFT_cT_Vbi_ci=FFT_fC_Vbi_ci;
FFT_cT_Vbi_ei=FFT_fC_Vbi_ei;
FFT_cT_Vci_ei=FFT_fC_Vci_ei;
FFT_cT_Vtnode_GND=FFT_fC_Vtnode_GND;
FFT_cT=FFT_fC;
}
else
{
FFQ_fC_Vbi_ci=(FFT_pcS*itf_Vbi_ci);
FFQ_fC_Vbi_ei=(FFT_pcS*itf_Vbi_ei);
FFQ_fC_Vci_ei=(FFT_pcS*itf_Vci_ei);
FFQ_fC_Vtnode_GND=((FFT_pcS_Vtnode_GND*itf)+(FFT_pcS*itf_Vtnode_GND));
FFQ_fC=(FFT_pcS*itf);
FCa_Vbi_ci=(-(-(ick*itf_Vbi_ci)/(itf*itf)));
FCa_Vbi_ei=(-(-(ick*itf_Vbi_ei)/(itf*itf)));
FCa_Vtnode_GND=(-(ick_Vtnode_GND*itf-ick*itf_Vtnode_GND)/(itf*itf));
FCa_Vci_ei=(-(ick_Vci_ei*itf-ick*itf_Vci_ei)/(itf*itf));
FCa=(1.0-(ick/itf));
{
double __sqrt_0=0.0;
double __d_sqrt_0=0.0;
_d_sqrt(__sqrt_0,__d_sqrt_0,(((FCa*FCa)+alhc)));
_sqrt(__sqrt_0,(((FCa*FCa)+alhc)));
FCrt_Vbi_ci=((FCa_Vbi_ci*FCa)+(FCa*FCa_Vbi_ci))*__d_sqrt_0;
FCrt_Vbi_ei=((FCa_Vbi_ei*FCa)+(FCa*FCa_Vbi_ei))*__d_sqrt_0;
FCrt_Vtnode_GND=((FCa_Vtnode_GND*FCa)+(FCa*FCa_Vtnode_GND))*__d_sqrt_0;
FCrt_Vci_ei=((FCa_Vci_ei*FCa)+(FCa*FCa_Vci_ei))*__d_sqrt_0;
FCrt=__sqrt_0;
}
{
double __sqrt_0=0.0;
_sqrt(__sqrt_0,((1.0+alhc)));
FCa_ck_Vbi_ci=(-(FCa_Vbi_ci+FCrt_Vbi_ci)/(1.0+__sqrt_0));
FCa_ck_Vbi_ei=(-(FCa_Vbi_ei+FCrt_Vbi_ei)/(1.0+__sqrt_0));
FCa_ck_Vtnode_GND=(-(FCa_Vtnode_GND+FCrt_Vtnode_GND)/(1.0+__sqrt_0));
FCa_ck_Vci_ei=(-(FCa_Vci_ei+FCrt_Vci_ei)/(1.0+__sqrt_0));
FCa_ck=(1.0-((FCa+FCrt)/(1.0+__sqrt_0)));
}
FCdaick_ditf_Vbi_ci=(((FCa_ck_Vbi_ci*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ci)))*(FCrt*itf)-((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci)))/((FCrt*itf)*(FCrt*itf));
FCdaick_ditf_Vbi_ei=(((FCa_ck_Vbi_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ei)))*(FCrt*itf)-((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei)))/((FCrt*itf)*(FCrt*itf));
FCdaick_ditf_Vtnode_GND=(((FCa_ck_Vtnode_GND*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vtnode_GND)))*(FCrt*itf)-((FCa_ck-1.0)*(1-FCa))*((FCrt_Vtnode_GND*itf)+(FCrt*itf_Vtnode_GND)))/((FCrt*itf)*(FCrt*itf));
FCdaick_ditf_Vci_ei=(((FCa_ck_Vci_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vci_ei)))*(FCrt*itf)-((FCa_ck-1.0)*(1-FCa))*((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei)))/((FCrt*itf)*(FCrt*itf));
FCdaick_ditf=(((FCa_ck-1.0)*(1-FCa))/(FCrt*itf));
if ((latb>latl))
{
FCz=(latb-latl);
FCz_Vci_ei=0.0;
FCz_Vtnode_GND=0.0;
FCz_Vbi_ei=0.0;
FCz_Vbi_ci=0.0;
FCxl=(1.0+latl);
FCxb=(1.0+latb);
if ((latb>0.01))
{
{
double __logE_0=0.0;
_logE(__logE_0,((FCxb/FCxl)));
FCln=__logE_0;
}
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(((FCa_ck-1.0)*FCln)));
_exp(__exp_0,(((FCa_ck-1.0)*FCln)));
FCa1_Vbi_ci=FCa_ck_Vbi_ci*FCln*__d_exp_0;
FCa1_Vbi_ei=FCa_ck_Vbi_ei*FCln*__d_exp_0;
FCa1_Vtnode_GND=FCa_ck_Vtnode_GND*FCln*__d_exp_0;
FCa1_Vci_ei=FCa_ck_Vci_ei*FCln*__d_exp_0;
FCa1=__exp_0;
}
FCd_a_Vbi_ci=(-(-FCa1_Vbi_ci*latb)/((latl-(FCa1*latb))*(latl-(FCa1*latb))));
FCd_a_Vbi_ei=(-(-FCa1_Vbi_ei*latb)/((latl-(FCa1*latb))*(latl-(FCa1*latb))));
FCd_a_Vtnode_GND=(-(-FCa1_Vtnode_GND*latb)/((latl-(FCa1*latb))*(latl-(FCa1*latb))));
FCd_a_Vci_ei=(-(-FCa1_Vci_ei*latb)/((latl-(FCa1*latb))*(latl-(FCa1*latb))));
FCd_a=(1.0/(latl-(FCa1*latb)));
FCw_Vbi_ci=((FCa1_Vbi_ci*FCd_a)+((FCa1-1.0)*FCd_a_Vbi_ci));
FCw_Vbi_ei=((FCa1_Vbi_ei*FCd_a)+((FCa1-1.0)*FCd_a_Vbi_ei));
FCw_Vtnode_GND=((FCa1_Vtnode_GND*FCd_a)+((FCa1-1.0)*FCd_a_Vtnode_GND));
FCw_Vci_ei=((FCa1_Vci_ei*FCd_a)+((FCa1-1.0)*FCd_a_Vci_ei));
FCw=((FCa1-1.0)*FCd_a);
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,(((1.0+(latb*FCw))/(1.0+(latl*FCw)))));
_logE(__logE_0,(((1.0+(latb*FCw))/(1.0+(latl*FCw)))));
FCa_Vbi_ci=((+(latb*FCw_Vbi_ci))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(+(latl*FCw_Vbi_ci)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))*__d_logE_0;
FCa_Vbi_ei=((+(latb*FCw_Vbi_ei))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(+(latl*FCw_Vbi_ei)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))*__d_logE_0;
FCa_Vtnode_GND=((+(latb*FCw_Vtnode_GND))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(+(latl*FCw_Vtnode_GND)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))*__d_logE_0;
FCa_Vci_ei=((+(latb*FCw_Vci_ei))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(+(latl*FCw_Vci_ei)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))*__d_logE_0;
FCa=__logE_0;
}
FCdw_daick_Vbi_ci=(((((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci))*FCd_a)+(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ci));
FCdw_daick_Vbi_ei=(((((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei))*FCd_a)+(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ei));
FCdw_daick_Vtnode_GND=(((((((-FCz_Vtnode_GND)*FCa1)+((-FCz)*FCa1_Vtnode_GND))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vtnode_GND))*FCd_a)+(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vtnode_GND));
FCdw_daick_Vci_ei=(((((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei))*FCd_a)+(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vci_ei));
FCdw_daick=(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a);
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0+(latb*FCw))));
_logE(__logE_0,((1.0+(latb*FCw))));
FClnb_Vbi_ci=(+(latb*FCw_Vbi_ci))*__d_logE_0;
FClnb_Vbi_ei=(+(latb*FCw_Vbi_ei))*__d_logE_0;
FClnb_Vtnode_GND=(+(latb*FCw_Vtnode_GND))*__d_logE_0;
FClnb_Vci_ei=(+(latb*FCw_Vci_ei))*__d_logE_0;
FClnb=__logE_0;
}
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0+(latl*FCw))));
_logE(__logE_0,((1.0+(latl*FCw))));
FClnl_Vbi_ci=(+(latl*FCw_Vbi_ci))*__d_logE_0;
FClnl_Vbi_ei=(+(latl*FCw_Vbi_ei))*__d_logE_0;
FClnl_Vtnode_GND=(+(latl*FCw_Vtnode_GND))*__d_logE_0;
FClnl_Vci_ei=(+(latl*FCw_Vci_ei))*__d_logE_0;
FClnl=__logE_0;
}
FCa1_Vbi_ci=(FClnb_Vbi_ci-FClnl_Vbi_ci);
FCa1_Vbi_ei=(FClnb_Vbi_ei-FClnl_Vbi_ei);
FCa1_Vtnode_GND=(FClnb_Vtnode_GND-FClnl_Vtnode_GND);
FCa1_Vci_ei=(FClnb_Vci_ei-FClnl_Vci_ei);
FCa1=(FClnb-FClnl);
FCda1_dw_Vbi_ci=((-(latb*(+(latb*FCw_Vbi_ci)))/((1.0+(latb*FCw))*(1.0+(latb*FCw))))-(-(latl*(+(latl*FCw_Vbi_ci)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))));
FCda1_dw_Vbi_ei=((-(latb*(+(latb*FCw_Vbi_ei)))/((1.0+(latb*FCw))*(1.0+(latb*FCw))))-(-(latl*(+(latl*FCw_Vbi_ei)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))));
FCda1_dw_Vtnode_GND=((-(latb*(+(latb*FCw_Vtnode_GND)))/((1.0+(latb*FCw))*(1.0+(latb*FCw))))-(-(latl*(+(latl*FCw_Vtnode_GND)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))));
FCda1_dw_Vci_ei=((-(latb*(+(latb*FCw_Vci_ei)))/((1.0+(latb*FCw))*(1.0+(latb*FCw))))-(-(latl*(+(latl*FCw_Vci_ei)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))));
if (doAC)
{
FCda1_dw=((latb/(1.0+(latb*FCw)))-(latl/(1.0+(latl*FCw))));
}
}
else
{
FCf1_Vbi_ci=(-FCa_ck_Vbi_ci);
FCf1_Vbi_ei=(-FCa_ck_Vbi_ei);
FCf1_Vtnode_GND=(-FCa_ck_Vtnode_GND);
FCf1_Vci_ei=(-FCa_ck_Vci_ei);
FCf1=(1.0-FCa_ck);
FCd_a_Vbi_ci=(-(-FCf1_Vbi_ci*latb)/((1.0-(FCf1*latb))*(1.0-(FCf1*latb))));
FCd_a_Vbi_ei=(-(-FCf1_Vbi_ei*latb)/((1.0-(FCf1*latb))*(1.0-(FCf1*latb))));
FCd_a_Vtnode_GND=(-(-FCf1_Vtnode_GND*latb)/((1.0-(FCf1*latb))*(1.0-(FCf1*latb))));
FCd_a_Vci_ei=(-(-FCf1_Vci_ei*latb)/((1.0-(FCf1*latb))*(1.0-(FCf1*latb))));
FCd_a=(1.0/(1.0-(FCf1*latb)));
FCw_Vbi_ci=((FCf1_Vbi_ci*FCd_a)+(FCf1*FCd_a_Vbi_ci));
FCw_Vbi_ei=((FCf1_Vbi_ei*FCd_a)+(FCf1*FCd_a_Vbi_ei));
FCw_Vtnode_GND=((FCf1_Vtnode_GND*FCd_a)+(FCf1*FCd_a_Vtnode_GND));
FCw_Vci_ei=((FCf1_Vci_ei*FCd_a)+(FCf1*FCd_a_Vci_ei));
FCw=(FCf1*FCd_a);
FCa_Vbi_ci=((FCz_Vbi_ci*FCw)+(FCz*FCw_Vbi_ci));
FCa_Vbi_ei=((FCz_Vbi_ei*FCw)+(FCz*FCw_Vbi_ei));
FCa_Vtnode_GND=((FCz_Vtnode_GND*FCw)+(FCz*FCw_Vtnode_GND));
FCa_Vci_ei=((FCz_Vci_ei*FCw)+(FCz*FCw_Vci_ei));
FCa=(FCz*FCw);
FCdw_daick_Vbi_ci=((((-1.0)*FCd_a_Vbi_ci)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci));
FCdw_daick_Vbi_ei=((((-1.0)*FCd_a_Vbi_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei));
FCdw_daick_Vtnode_GND=((((-1.0)*FCd_a_Vtnode_GND)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vtnode_GND));
FCdw_daick_Vci_ei=((((-1.0)*FCd_a_Vci_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei));
FCdw_daick=(((-1.0)*FCd_a)*FCd_a);
FClnb_Vbi_ci=(latb*FCw_Vbi_ci);
FClnb_Vbi_ei=(latb*FCw_Vbi_ei);
FClnb_Vtnode_GND=(latb*FCw_Vtnode_GND);
FClnb_Vci_ei=(latb*FCw_Vci_ei);
FClnb=(latb*FCw);
FClnl_Vbi_ci=(latl*FCw_Vbi_ci);
FClnl_Vbi_ei=(latl*FCw_Vbi_ei);
FClnl_Vtnode_GND=(latl*FCw_Vtnode_GND);
FClnl_Vci_ei=(latl*FCw_Vci_ei);
FClnl=(latl*FCw);
FCa1_Vbi_ci=((FCz_Vbi_ci*FCw)+(FCz*FCw_Vbi_ci));
FCa1_Vbi_ei=((FCz_Vbi_ei*FCw)+(FCz*FCw_Vbi_ei));
FCa1_Vtnode_GND=((FCz_Vtnode_GND*FCw)+(FCz*FCw_Vtnode_GND));
FCa1_Vci_ei=((FCz_Vci_ei*FCw)+(FCz*FCw_Vci_ei));
FCa1=(FCz*FCw);
FCda1_dw_Vbi_ci=FCz_Vbi_ci;
FCda1_dw_Vbi_ei=FCz_Vbi_ei;
FCda1_dw_Vtnode_GND=FCz_Vtnode_GND;
FCda1_dw_Vci_ei=FCz_Vci_ei;
if (doAC)
{
FCda1_dw=FCz;
}
}
FCf_CT_Vbi_ci=(-(2.0*FCz_Vbi_ci)/(FCz*FCz));
FCf_CT_Vbi_ei=(-(2.0*FCz_Vbi_ei)/(FCz*FCz));
FCf_CT_Vtnode_GND=(-(2.0*FCz_Vtnode_GND)/(FCz*FCz));
FCf_CT_Vci_ei=(-(2.0*FCz_Vci_ei)/(FCz*FCz));
FCf_CT=(2.0/FCz);
FCw2_Vbi_ci=((FCw_Vbi_ci*FCw)+(FCw*FCw_Vbi_ci));
FCw2_Vbi_ei=((FCw_Vbi_ei*FCw)+(FCw*FCw_Vbi_ei));
FCw2_Vtnode_GND=((FCw_Vtnode_GND*FCw)+(FCw*FCw_Vtnode_GND));
FCw2_Vci_ei=((FCw_Vci_ei*FCw)+(FCw*FCw_Vci_ei));
FCw2=(FCw*FCw);
FCf1_Vbi_ci=((((((latb*latl)*FCw_Vbi_ci)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ci))/3.0+((latb+latl)*FCw2_Vbi_ci)/2.0)+FCw_Vbi_ci);
FCf1_Vbi_ei=((((((latb*latl)*FCw_Vbi_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ei))/3.0+((latb+latl)*FCw2_Vbi_ei)/2.0)+FCw_Vbi_ei);
FCf1_Vtnode_GND=((((((latb*latl)*FCw_Vtnode_GND)*FCw2)+(((latb*latl)*FCw)*FCw2_Vtnode_GND))/3.0+((latb+latl)*FCw2_Vtnode_GND)/2.0)+FCw_Vtnode_GND);
FCf1_Vci_ei=((((((latb*latl)*FCw_Vci_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vci_ei))/3.0+((latb+latl)*FCw2_Vci_ei)/2.0)+FCw_Vci_ei);
FCf1=((((((latb*latl)*FCw)*FCw2)/3.0)+(((latb+latl)*FCw2)/2.0))+FCw);
FCdf1_dw_Vbi_ci=(((latb*latl)*FCw2_Vbi_ci)+((latb+latl)*FCw_Vbi_ci));
FCdf1_dw_Vbi_ei=(((latb*latl)*FCw2_Vbi_ei)+((latb+latl)*FCw_Vbi_ei));
FCdf1_dw_Vtnode_GND=(((latb*latl)*FCw2_Vtnode_GND)+((latb+latl)*FCw_Vtnode_GND));
FCdf1_dw_Vci_ei=(((latb*latl)*FCw2_Vci_ei)+((latb+latl)*FCw_Vci_ei));
if (doAC)
{
FCdf1_dw=((((latb*latl)*FCw2)+((latb+latl)*FCw))+1.0);
}
z_Vbi_ci=(latb*FCw_Vbi_ci);
z_Vbi_ei=(latb*FCw_Vbi_ei);
z_Vtnode_GND=(latb*FCw_Vtnode_GND);
z_Vci_ei=(latb*FCw_Vci_ei);
z=(latb*FCw);
if ((z>1.0e-6))
{
x_Vbi_ci=(+z_Vbi_ci);
x_Vbi_ei=(+z_Vbi_ei);
x_Vtnode_GND=(+z_Vtnode_GND);
x_Vci_ei=(+z_Vci_ei);
x=(1.0+z);
a_Vbi_ci=((x_Vbi_ci*x)+(x*x_Vbi_ci));
a_Vbi_ei=((x_Vbi_ei*x)+(x*x_Vbi_ei));
a_Vtnode_GND=((x_Vtnode_GND*x)+(x*x_Vtnode_GND));
a_Vci_ei=((x_Vci_ei*x)+(x*x_Vci_ei));
a=(x*x);
a2_Vtnode_GND=(0.250*((a_Vtnode_GND*((2.0*FClnb)-1.0))+(a*(2.0*FClnb_Vtnode_GND))));
a2_Vbi_ci=(0.250*((a_Vbi_ci*((2.0*FClnb)-1.0))+(a*(2.0*FClnb_Vbi_ci))));
a2_Vbi_ei=(0.250*((a_Vbi_ei*((2.0*FClnb)-1.0))+(a*(2.0*FClnb_Vbi_ei))));
a2_Vci_ei=(0.250*((a_Vci_ei*((2.0*FClnb)-1.0))+(a*(2.0*FClnb_Vci_ei))));
a2=(0.250*((a*((2.0*FClnb)-1.0))+1.0));
a3_Vtnode_GND=((((a_Vtnode_GND*x)+(a*x_Vtnode_GND))*((3.0*FClnb)-1.0))+((a*x)*(3.0*FClnb_Vtnode_GND)))/9.0;
a3_Vbi_ci=((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*FClnb)-1.0))+((a*x)*(3.0*FClnb_Vbi_ci)))/9.0;
a3_Vbi_ei=((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*FClnb)-1.0))+((a*x)*(3.0*FClnb_Vbi_ei)))/9.0;
a3_Vci_ei=((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*FClnb)-1.0))+((a*x)*(3.0*FClnb_Vci_ei)))/9.0;
a3=((((a*x)*((3.0*FClnb)-1.0))+1.0)/9.0);
r=(latl/latb);
FCf2_Vtnode_GND=(((1.0-r)*a2_Vtnode_GND)+(r*a3_Vtnode_GND))/latb;
FCf2_Vbi_ci=(((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))/latb;
FCf2_Vbi_ei=(((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))/latb;
FCf2_Vci_ei=(((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))/latb;
FCf2=((((1.0-r)*a2)+(r*a3))/latb);
FCdf2_dw_Vbi_ci=(((((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*FClnb)+((((1.0-r)*x)+(r*a))*FClnb_Vbi_ci));
FCdf2_dw_Vbi_ei=(((((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*FClnb)+((((1.0-r)*x)+(r*a))*FClnb_Vbi_ei));
FCdf2_dw_Vtnode_GND=(((((1.0-r)*x_Vtnode_GND)+(r*a_Vtnode_GND))*FClnb)+((((1.0-r)*x)+(r*a))*FClnb_Vtnode_GND));
FCdf2_dw_Vci_ei=(((((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*FClnb)+((((1.0-r)*x)+(r*a))*FClnb_Vci_ei));
FCdf2_dw=((((1.0-r)*x)+(r*a))*FClnb);
}
else
{
a_Vbi_ci=((z_Vbi_ci*z)+(z*z_Vbi_ci));
a_Vbi_ei=((z_Vbi_ei*z)+(z*z_Vbi_ei));
a_Vtnode_GND=((z_Vtnode_GND*z)+(z*z_Vtnode_GND));
a_Vci_ei=((z_Vci_ei*z)+(z*z_Vci_ei));
a=(z*z);
a2_Vbi_ci=(((+z_Vbi_ci)-(0.5*a_Vbi_ci))+((z_Vbi_ci*a)+(z*a_Vbi_ci)));
a2_Vbi_ei=(((+z_Vbi_ei)-(0.5*a_Vbi_ei))+((z_Vbi_ei*a)+(z*a_Vbi_ei)));
a2_Vtnode_GND=(((+z_Vtnode_GND)-(0.5*a_Vtnode_GND))+((z_Vtnode_GND*a)+(z*a_Vtnode_GND)));
a2_Vci_ei=(((+z_Vci_ei)-(0.5*a_Vci_ei))+((z_Vci_ei*a)+(z*a_Vci_ei)));
a2=(((3.0+z)-(0.5*a))+(z*a));
a3_Vbi_ci=((((-2.0)*z_Vbi_ci)+(1.5*a_Vbi_ci))+(((2.0*a_Vbi_ci)*a)+((2.0*a)*a_Vbi_ci))/3.0);
a3_Vbi_ei=((((-2.0)*z_Vbi_ei)+(1.5*a_Vbi_ei))+(((2.0*a_Vbi_ei)*a)+((2.0*a)*a_Vbi_ei))/3.0);
a3_Vtnode_GND=((((-2.0)*z_Vtnode_GND)+(1.5*a_Vtnode_GND))+(((2.0*a_Vtnode_GND)*a)+((2.0*a)*a_Vtnode_GND))/3.0);
a3_Vci_ei=((((-2.0)*z_Vci_ei)+(1.5*a_Vci_ei))+(((2.0*a_Vci_ei)*a)+((2.0*a)*a_Vci_ei))/3.0);
a3=((((-2.0)*z)+(1.5*a))+(((2.0*a)*a)/3.0));
FCf2_Vtnode_GND=((((((latb*a2_Vtnode_GND)+(latl*a3_Vtnode_GND))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vtnode_GND))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vtnode_GND))/6.0;
FCf2_Vbi_ci=((((((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci))/6.0;
FCf2_Vbi_ei=((((((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei))/6.0;
FCf2_Vci_ei=((((((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei))/6.0;
FCf2=(((((latb*a2)+(latl*a3))*FCw)*FCw)/6.0);
FCdf2_dw_Vbi_ci=((((z_Vbi_ci+(0.5*a_Vbi_ci))-((a_Vbi_ci*z)+(a*z_Vbi_ci))/3.0)+(((5.0*a_Vbi_ci)*a)+((5.0*a)*a_Vbi_ci))/6.0)+(((latl*FCw_Vbi_ci)*((a-z)+(((2.0*a)*a)/3.0)))+((latl*FCw)*((a_Vbi_ci-z_Vbi_ci)+(((2.0*a_Vbi_ci)*a)+((2.0*a)*a_Vbi_ci))/3.0))));
FCdf2_dw_Vbi_ei=((((z_Vbi_ei+(0.5*a_Vbi_ei))-((a_Vbi_ei*z)+(a*z_Vbi_ei))/3.0)+(((5.0*a_Vbi_ei)*a)+((5.0*a)*a_Vbi_ei))/6.0)+(((latl*FCw_Vbi_ei)*((a-z)+(((2.0*a)*a)/3.0)))+((latl*FCw)*((a_Vbi_ei-z_Vbi_ei)+(((2.0*a_Vbi_ei)*a)+((2.0*a)*a_Vbi_ei))/3.0))));
FCdf2_dw_Vtnode_GND=((((z_Vtnode_GND+(0.5*a_Vtnode_GND))-((a_Vtnode_GND*z)+(a*z_Vtnode_GND))/3.0)+(((5.0*a_Vtnode_GND)*a)+((5.0*a)*a_Vtnode_GND))/6.0)+(((latl*FCw_Vtnode_GND)*((a-z)+(((2.0*a)*a)/3.0)))+((latl*FCw)*((a_Vtnode_GND-z_Vtnode_GND)+(((2.0*a_Vtnode_GND)*a)+((2.0*a)*a_Vtnode_GND))/3.0))));
FCdf2_dw_Vci_ei=((((z_Vci_ei+(0.5*a_Vci_ei))-((a_Vci_ei*z)+(a*z_Vci_ei))/3.0)+(((5.0*a_Vci_ei)*a)+((5.0*a)*a_Vci_ei))/6.0)+(((latl*FCw_Vci_ei)*((a-z)+(((2.0*a)*a)/3.0)))+((latl*FCw)*((a_Vci_ei-z_Vci_ei)+(((2.0*a_Vci_ei)*a)+((2.0*a)*a_Vci_ei))/3.0))));
FCdf2_dw=((((z+(0.5*a))-((a*z)/3.0))+(((5.0*a)*a)/6.0))+((latl*FCw)*((a-z)+(((2.0*a)*a)/3.0))));
}
z_Vbi_ci=(latl*FCw_Vbi_ci);
z_Vbi_ei=(latl*FCw_Vbi_ei);
z_Vtnode_GND=(latl*FCw_Vtnode_GND);
z_Vci_ei=(latl*FCw_Vci_ei);
z=(latl*FCw);
if ((z>1.0e-6))
{
x_Vbi_ci=(+z_Vbi_ci);
x_Vbi_ei=(+z_Vbi_ei);
x_Vtnode_GND=(+z_Vtnode_GND);
x_Vci_ei=(+z_Vci_ei);
x=(1.0+z);
a_Vbi_ci=((x_Vbi_ci*x)+(x*x_Vbi_ci));
a_Vbi_ei=((x_Vbi_ei*x)+(x*x_Vbi_ei));
a_Vtnode_GND=((x_Vtnode_GND*x)+(x*x_Vtnode_GND));
a_Vci_ei=((x_Vci_ei*x)+(x*x_Vci_ei));
a=(x*x);
a2_Vtnode_GND=(0.250*((a_Vtnode_GND*((2.0*FClnl)-1.0))+(a*(2.0*FClnl_Vtnode_GND))));
a2_Vbi_ci=(0.250*((a_Vbi_ci*((2.0*FClnl)-1.0))+(a*(2.0*FClnl_Vbi_ci))));
a2_Vbi_ei=(0.250*((a_Vbi_ei*((2.0*FClnl)-1.0))+(a*(2.0*FClnl_Vbi_ei))));
a2_Vci_ei=(0.250*((a_Vci_ei*((2.0*FClnl)-1.0))+(a*(2.0*FClnl_Vci_ei))));
a2=(0.250*((a*((2.0*FClnl)-1.0))+1.0));
a3_Vtnode_GND=((((a_Vtnode_GND*x)+(a*x_Vtnode_GND))*((3.0*FClnl)-1.0))+((a*x)*(3.0*FClnl_Vtnode_GND)))/9.0;
a3_Vbi_ci=((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*FClnl)-1.0))+((a*x)*(3.0*FClnl_Vbi_ci)))/9.0;
a3_Vbi_ei=((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*FClnl)-1.0))+((a*x)*(3.0*FClnl_Vbi_ei)))/9.0;
a3_Vci_ei=((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*FClnl)-1.0))+((a*x)*(3.0*FClnl_Vci_ei)))/9.0;
a3=((((a*x)*((3.0*FClnl)-1.0))+1.0)/9.0);
r=(latb/latl);
FCf3_Vtnode_GND=(((1.0-r)*a2_Vtnode_GND)+(r*a3_Vtnode_GND))/latl;
FCf3_Vbi_ci=(((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))/latl;
FCf3_Vbi_ei=(((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))/latl;
FCf3_Vci_ei=(((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))/latl;
FCf3=((((1.0-r)*a2)+(r*a3))/latl);
FCdf3_dw_Vbi_ci=(((((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*FClnl)+((((1.0-r)*x)+(r*a))*FClnl_Vbi_ci));
FCdf3_dw_Vbi_ei=(((((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*FClnl)+((((1.0-r)*x)+(r*a))*FClnl_Vbi_ei));
FCdf3_dw_Vtnode_GND=(((((1.0-r)*x_Vtnode_GND)+(r*a_Vtnode_GND))*FClnl)+((((1.0-r)*x)+(r*a))*FClnl_Vtnode_GND));
FCdf3_dw_Vci_ei=(((((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*FClnl)+((((1.0-r)*x)+(r*a))*FClnl_Vci_ei));
FCdf3_dw=((((1.0-r)*x)+(r*a))*FClnl);
}
else
{
a_Vbi_ci=((z_Vbi_ci*z)+(z*z_Vbi_ci));
a_Vbi_ei=((z_Vbi_ei*z)+(z*z_Vbi_ei));
a_Vtnode_GND=((z_Vtnode_GND*z)+(z*z_Vtnode_GND));
a_Vci_ei=((z_Vci_ei*z)+(z*z_Vci_ei));
a=(z*z);
a2_Vbi_ci=(((+z_Vbi_ci)-(0.5*a_Vbi_ci))+((z_Vbi_ci*a)+(z*a_Vbi_ci)));
a2_Vbi_ei=(((+z_Vbi_ei)-(0.5*a_Vbi_ei))+((z_Vbi_ei*a)+(z*a_Vbi_ei)));
a2_Vtnode_GND=(((+z_Vtnode_GND)-(0.5*a_Vtnode_GND))+((z_Vtnode_GND*a)+(z*a_Vtnode_GND)));
a2_Vci_ei=(((+z_Vci_ei)-(0.5*a_Vci_ei))+((z_Vci_ei*a)+(z*a_Vci_ei)));
a2=(((3.0+z)-(0.5*a))+(z*a));
a3_Vbi_ci=((((-2.0)*z_Vbi_ci)+(1.5*a_Vbi_ci))+(((2.0*a_Vbi_ci)*a)+((2.0*a)*a_Vbi_ci))/3.0);
a3_Vbi_ei=((((-2.0)*z_Vbi_ei)+(1.5*a_Vbi_ei))+(((2.0*a_Vbi_ei)*a)+((2.0*a)*a_Vbi_ei))/3.0);
a3_Vtnode_GND=((((-2.0)*z_Vtnode_GND)+(1.5*a_Vtnode_GND))+(((2.0*a_Vtnode_GND)*a)+((2.0*a)*a_Vtnode_GND))/3.0);
a3_Vci_ei=((((-2.0)*z_Vci_ei)+(1.5*a_Vci_ei))+(((2.0*a_Vci_ei)*a)+((2.0*a)*a_Vci_ei))/3.0);
a3=((((-2.0)*z)+(1.5*a))+(((2.0*a)*a)/3.0));
FCf3_Vtnode_GND=((((((latl*a2_Vtnode_GND)+(latb*a3_Vtnode_GND))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vtnode_GND))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vtnode_GND))/6.0;
FCf3_Vbi_ci=((((((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci))/6.0;
FCf3_Vbi_ei=((((((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei))/6.0;
FCf3_Vci_ei=((((((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei))/6.0;
FCf3=(((((latl*a2)+(latb*a3))*FCw)*FCw)/6.0);
FCdf3_dw_Vbi_ci=((((z_Vbi_ci+(0.5*a_Vbi_ci))-((a_Vbi_ci*z)+(a*z_Vbi_ci))/3.0)+(((5.0*a_Vbi_ci)*a)+((5.0*a)*a_Vbi_ci))/6.0)+(((latb*FCw_Vbi_ci)*((a-z)+(((2.0*a)*a)/3.0)))+((latb*FCw)*((a_Vbi_ci-z_Vbi_ci)+(((2.0*a_Vbi_ci)*a)+((2.0*a)*a_Vbi_ci))/3.0))));
FCdf3_dw_Vbi_ei=((((z_Vbi_ei+(0.5*a_Vbi_ei))-((a_Vbi_ei*z)+(a*z_Vbi_ei))/3.0)+(((5.0*a_Vbi_ei)*a)+((5.0*a)*a_Vbi_ei))/6.0)+(((latb*FCw_Vbi_ei)*((a-z)+(((2.0*a)*a)/3.0)))+((latb*FCw)*((a_Vbi_ei-z_Vbi_ei)+(((2.0*a_Vbi_ei)*a)+((2.0*a)*a_Vbi_ei))/3.0))));
FCdf3_dw_Vtnode_GND=((((z_Vtnode_GND+(0.5*a_Vtnode_GND))-((a_Vtnode_GND*z)+(a*z_Vtnode_GND))/3.0)+(((5.0*a_Vtnode_GND)*a)+((5.0*a)*a_Vtnode_GND))/6.0)+(((latb*FCw_Vtnode_GND)*((a-z)+(((2.0*a)*a)/3.0)))+((latb*FCw)*((a_Vtnode_GND-z_Vtnode_GND)+(((2.0*a_Vtnode_GND)*a)+((2.0*a)*a_Vtnode_GND))/3.0))));
FCdf3_dw_Vci_ei=((((z_Vci_ei+(0.5*a_Vci_ei))-((a_Vci_ei*z)+(a*z_Vci_ei))/3.0)+(((5.0*a_Vci_ei)*a)+((5.0*a)*a_Vci_ei))/6.0)+(((latb*FCw_Vci_ei)*((a-z)+(((2.0*a)*a)/3.0)))+((latb*FCw)*((a_Vci_ei-z_Vci_ei)+(((2.0*a_Vci_ei)*a)+((2.0*a)*a_Vci_ei))/3.0))));
FCdf3_dw=((((z+(0.5*a))-((a*z)/3.0))+(((5.0*a)*a)/6.0))+((latb*FCw)*((a-z)+(((2.0*a)*a)/3.0))));
}
FCf_ci_Vtnode_GND=((FCf_CT_Vtnode_GND*(((FCa*FCf1)-FCf2)+FCf3))+(FCf_CT*((((FCa_Vtnode_GND*FCf1)+(FCa*FCf1_Vtnode_GND))-FCf2_Vtnode_GND)+FCf3_Vtnode_GND)));
FCf_ci_Vbi_ci=((FCf_CT_Vbi_ci*(((FCa*FCf1)-FCf2)+FCf3))+(FCf_CT*((((FCa_Vbi_ci*FCf1)+(FCa*FCf1_Vbi_ci))-FCf2_Vbi_ci)+FCf3_Vbi_ci)));
FCf_ci_Vbi_ei=((FCf_CT_Vbi_ei*(((FCa*FCf1)-FCf2)+FCf3))+(FCf_CT*((((FCa_Vbi_ei*FCf1)+(FCa*FCf1_Vbi_ei))-FCf2_Vbi_ei)+FCf3_Vbi_ei)));
FCf_ci_Vci_ei=((FCf_CT_Vci_ei*(((FCa*FCf1)-FCf2)+FCf3))+(FCf_CT*((((FCa_Vci_ei*FCf1)+(FCa*FCf1_Vci_ei))-FCf2_Vci_ei)+FCf3_Vci_ei)));
FCf_ci=(FCf_CT*(((FCa*FCf1)-FCf2)+FCf3));
FCdfc_dw_Vtnode_GND=((FCf_CT_Vtnode_GND*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw))+(FCf_CT*(((((FCa1_Vtnode_GND*FCdf1_dw)+(FCa1*FCdf1_dw_Vtnode_GND))+((FCda1_dw_Vtnode_GND*FCf1)+(FCda1_dw*FCf1_Vtnode_GND)))-FCdf2_dw_Vtnode_GND)+FCdf3_dw_Vtnode_GND)));
FCdfc_dw_Vbi_ci=((FCf_CT_Vbi_ci*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw))+(FCf_CT*(((((FCa1_Vbi_ci*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ci))+((FCda1_dw_Vbi_ci*FCf1)+(FCda1_dw*FCf1_Vbi_ci)))-FCdf2_dw_Vbi_ci)+FCdf3_dw_Vbi_ci)));
FCdfc_dw_Vbi_ei=((FCf_CT_Vbi_ei*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw))+(FCf_CT*(((((FCa1_Vbi_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ei))+((FCda1_dw_Vbi_ei*FCf1)+(FCda1_dw*FCf1_Vbi_ei)))-FCdf2_dw_Vbi_ei)+FCdf3_dw_Vbi_ei)));
FCdfc_dw_Vci_ei=((FCf_CT_Vci_ei*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw))+(FCf_CT*(((((FCa1_Vci_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vci_ei))+((FCda1_dw_Vci_ei*FCf1)+(FCda1_dw*FCf1_Vci_ei)))-FCdf2_dw_Vci_ei)+FCdf3_dw_Vci_ei)));
if (doAC)
{
FCdfc_dw=(FCf_CT*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw));
}
FCdw_ditf_Vbi_ci=((FCdw_daick_Vbi_ci*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vbi_ci));
FCdw_ditf_Vbi_ei=((FCdw_daick_Vbi_ei*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vbi_ei));
FCdw_ditf_Vtnode_GND=((FCdw_daick_Vtnode_GND*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vtnode_GND));
FCdw_ditf_Vci_ei=((FCdw_daick_Vci_ei*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vci_ei));
FCdw_ditf=(FCdw_daick*FCdaick_ditf);
FCdfc_ditf_Vbi_ci=((FCdfc_dw_Vbi_ci*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vbi_ci));
FCdfc_ditf_Vbi_ei=((FCdfc_dw_Vbi_ei*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vbi_ei));
FCdfc_ditf_Vtnode_GND=((FCdfc_dw_Vtnode_GND*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vtnode_GND));
FCdfc_ditf_Vci_ei=((FCdfc_dw_Vci_ei*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vci_ei));
if (doAC)
{
FCdfc_ditf=(FCdfc_dw*FCdw_ditf);
}
a_Vbi_ci=(latb*FCw_Vbi_ci);
a_Vbi_ei=(latb*FCw_Vbi_ei);
a_Vtnode_GND=(latb*FCw_Vtnode_GND);
a_Vci_ei=(latb*FCw_Vci_ei);
a=(latb*FCw);
if ((a>1.0e-6))
{
FCf2_Vtnode_GND=(a_Vtnode_GND-FClnb_Vtnode_GND)/latb;
FCf2_Vbi_ci=(a_Vbi_ci-FClnb_Vbi_ci)/latb;
FCf2_Vbi_ei=(a_Vbi_ei-FClnb_Vbi_ei)/latb;
FCf2_Vci_ei=(a_Vci_ei-FClnb_Vci_ei)/latb;
FCf2=((a-FClnb)/latb);
FCdf2_dw_Vtnode_GND=(a_Vtnode_GND*(1.0+a)-a*(+a_Vtnode_GND))/((1.0+a)*(1.0+a));
FCdf2_dw_Vbi_ci=(a_Vbi_ci*(1.0+a)-a*(+a_Vbi_ci))/((1.0+a)*(1.0+a));
FCdf2_dw_Vbi_ei=(a_Vbi_ei*(1.0+a)-a*(+a_Vbi_ei))/((1.0+a)*(1.0+a));
FCdf2_dw_Vci_ei=(a_Vci_ei*(1.0+a)-a*(+a_Vci_ei))/((1.0+a)*(1.0+a));
FCdf2_dw=(a/(1.0+a));
}
else
{
FCf2_Vtnode_GND=(((0.5*a_Vtnode_GND)*FCw)+((0.5*a)*FCw_Vtnode_GND));
FCf2_Vbi_ci=(((0.5*a_Vbi_ci)*FCw)+((0.5*a)*FCw_Vbi_ci));
FCf2_Vbi_ei=(((0.5*a_Vbi_ei)*FCw)+((0.5*a)*FCw_Vbi_ei));
FCf2_Vci_ei=(((0.5*a_Vci_ei)*FCw)+((0.5*a)*FCw_Vci_ei));
FCf2=((0.5*a)*FCw);
FCdf2_dw_Vtnode_GND=a_Vtnode_GND;
FCdf2_dw_Vbi_ci=a_Vbi_ci;
FCdf2_dw_Vbi_ei=a_Vbi_ei;
FCdf2_dw_Vci_ei=a_Vci_ei;
FCdf2_dw=a;
}
a_Vbi_ci=(latl*FCw_Vbi_ci);
a_Vbi_ei=(latl*FCw_Vbi_ei);
a_Vtnode_GND=(latl*FCw_Vtnode_GND);
a_Vci_ei=(latl*FCw_Vci_ei);
a=(latl*FCw);
if ((a>1.0e-6))
{
FCf3_Vtnode_GND=(a_Vtnode_GND-FClnl_Vtnode_GND)/latl;
FCf3_Vbi_ci=(a_Vbi_ci-FClnl_Vbi_ci)/latl;
FCf3_Vbi_ei=(a_Vbi_ei-FClnl_Vbi_ei)/latl;
FCf3_Vci_ei=(a_Vci_ei-FClnl_Vci_ei)/latl;
FCf3=((a-FClnl)/latl);
FCdf3_dw_Vtnode_GND=(a_Vtnode_GND*(1.0+a)-a*(+a_Vtnode_GND))/((1.0+a)*(1.0+a));
FCdf3_dw_Vbi_ci=(a_Vbi_ci*(1.0+a)-a*(+a_Vbi_ci))/((1.0+a)*(1.0+a));
FCdf3_dw_Vbi_ei=(a_Vbi_ei*(1.0+a)-a*(+a_Vbi_ei))/((1.0+a)*(1.0+a));
FCdf3_dw_Vci_ei=(a_Vci_ei*(1.0+a)-a*(+a_Vci_ei))/((1.0+a)*(1.0+a));
FCdf3_dw=(a/(1.0+a));
}
else
{
FCf3_Vtnode_GND=(((0.5*a_Vtnode_GND)*FCw)+((0.5*a)*FCw_Vtnode_GND));
FCf3_Vbi_ci=(((0.5*a_Vbi_ci)*FCw)+((0.5*a)*FCw_Vbi_ci));
FCf3_Vbi_ei=(((0.5*a_Vbi_ei)*FCw)+((0.5*a)*FCw_Vbi_ei));
FCf3_Vci_ei=(((0.5*a_Vci_ei)*FCw)+((0.5*a)*FCw_Vci_ei));
FCf3=((0.5*a)*FCw);
FCdf3_dw_Vtnode_GND=a_Vtnode_GND;
FCdf3_dw_Vbi_ci=a_Vbi_ci;
FCdf3_dw_Vbi_ei=a_Vbi_ei;
FCdf3_dw_Vci_ei=a_Vci_ei;
FCdf3_dw=a;
}
FCf_CT_Vtnode_GND=((FCf_CT_Vtnode_GND*(FCf2-FCf3))+(FCf_CT*(FCf2_Vtnode_GND-FCf3_Vtnode_GND)));
FCf_CT_Vbi_ci=((FCf_CT_Vbi_ci*(FCf2-FCf3))+(FCf_CT*(FCf2_Vbi_ci-FCf3_Vbi_ci)));
FCf_CT_Vbi_ei=((FCf_CT_Vbi_ei*(FCf2-FCf3))+(FCf_CT*(FCf2_Vbi_ei-FCf3_Vbi_ei)));
FCf_CT_Vci_ei=((FCf_CT_Vci_ei*(FCf2-FCf3))+(FCf_CT*(FCf2_Vci_ei-FCf3_Vci_ei)));
FCf_CT=(FCf_CT*(FCf2-FCf3));
FCdfCT_dw_Vtnode_GND=((FCf_CT_Vtnode_GND*(FCdf2_dw-FCdf3_dw))+(FCf_CT*(FCdf2_dw_Vtnode_GND-FCdf3_dw_Vtnode_GND)));
FCdfCT_dw_Vbi_ci=((FCf_CT_Vbi_ci*(FCdf2_dw-FCdf3_dw))+(FCf_CT*(FCdf2_dw_Vbi_ci-FCdf3_dw_Vbi_ci)));
FCdfCT_dw_Vbi_ei=((FCf_CT_Vbi_ei*(FCdf2_dw-FCdf3_dw))+(FCf_CT*(FCdf2_dw_Vbi_ei-FCdf3_dw_Vbi_ei)));
FCdfCT_dw_Vci_ei=((FCf_CT_Vci_ei*(FCdf2_dw-FCdf3_dw))+(FCf_CT*(FCdf2_dw_Vci_ei-FCdf3_dw_Vci_ei)));
FCdfCT_dw=(FCf_CT*(FCdf2_dw-FCdf3_dw));
FCdfCT_ditf_Vtnode_GND=((FCdfCT_dw_Vtnode_GND*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vtnode_GND));
FCdfCT_ditf_Vbi_ci=((FCdfCT_dw_Vbi_ci*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vbi_ci));
FCdfCT_ditf_Vbi_ei=((FCdfCT_dw_Vbi_ei*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vbi_ei));
FCdfCT_ditf_Vci_ei=((FCdfCT_dw_Vci_ei*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vci_ei));
FCdfCT_ditf=(FCdfCT_dw*FCdw_ditf);
}
else
{
if ((latb>0.01))
{
FCd_a_Vbi_ci=(-(+FCa_ck_Vbi_ci*latb)/((1.0+(FCa_ck*latb))*(1.0+(FCa_ck*latb))));
FCd_a_Vbi_ei=(-(+FCa_ck_Vbi_ei*latb)/((1.0+(FCa_ck*latb))*(1.0+(FCa_ck*latb))));
FCd_a_Vtnode_GND=(-(+FCa_ck_Vtnode_GND*latb)/((1.0+(FCa_ck*latb))*(1.0+(FCa_ck*latb))));
FCd_a_Vci_ei=(-(+FCa_ck_Vci_ei*latb)/((1.0+(FCa_ck*latb))*(1.0+(FCa_ck*latb))));
FCd_a=(1.0/(1.0+(FCa_ck*latb)));
FCw_Vbi_ci=(((-FCa_ck_Vbi_ci)*FCd_a)+((1.0-FCa_ck)*FCd_a_Vbi_ci));
FCw_Vbi_ei=(((-FCa_ck_Vbi_ei)*FCd_a)+((1.0-FCa_ck)*FCd_a_Vbi_ei));
FCw_Vtnode_GND=(((-FCa_ck_Vtnode_GND)*FCd_a)+((1.0-FCa_ck)*FCd_a_Vtnode_GND));
FCw_Vci_ei=(((-FCa_ck_Vci_ei)*FCd_a)+((1.0-FCa_ck)*FCd_a_Vci_ei));
FCw=((1.0-FCa_ck)*FCd_a);
FCdw_daick_Vbi_ci=((((-(1.0+latb))*FCd_a_Vbi_ci)*FCd_a)+(((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ci));
FCdw_daick_Vbi_ei=((((-(1.0+latb))*FCd_a_Vbi_ei)*FCd_a)+(((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ei));
FCdw_daick_Vtnode_GND=((((-(1.0+latb))*FCd_a_Vtnode_GND)*FCd_a)+(((-(1.0+latb))*FCd_a)*FCd_a_Vtnode_GND));
FCdw_daick_Vci_ei=((((-(1.0+latb))*FCd_a_Vci_ei)*FCd_a)+(((-(1.0+latb))*FCd_a)*FCd_a_Vci_ei));
FCdw_daick=(((-(1.0+latb))*FCd_a)*FCd_a);
}
else
{
FCw_Vbi_ci=((-FCa_ck_Vbi_ci)-FCa_ck_Vbi_ci*latb);
FCw_Vbi_ei=((-FCa_ck_Vbi_ei)-FCa_ck_Vbi_ei*latb);
FCw_Vtnode_GND=((-FCa_ck_Vtnode_GND)-FCa_ck_Vtnode_GND*latb);
FCw_Vci_ei=((-FCa_ck_Vci_ei)-FCa_ck_Vci_ei*latb);
FCw=((1.0-FCa_ck)-(FCa_ck*latb));
FCdw_daick=(-(1.0+latb));
FCdw_daick_Vci_ei=0.0;
FCdw_daick_Vtnode_GND=0.0;
FCdw_daick_Vbi_ei=0.0;
FCdw_daick_Vbi_ci=0.0;
}
FCw2_Vbi_ci=((FCw_Vbi_ci*FCw)+(FCw*FCw_Vbi_ci));
FCw2_Vbi_ei=((FCw_Vbi_ei*FCw)+(FCw*FCw_Vbi_ei));
FCw2_Vtnode_GND=((FCw_Vtnode_GND*FCw)+(FCw*FCw_Vtnode_GND));
FCw2_Vci_ei=((FCw_Vci_ei*FCw)+(FCw*FCw_Vci_ei));
FCw2=(FCw*FCw);
FCz_Vbi_ci=(latb*FCw_Vbi_ci);
FCz_Vbi_ei=(latb*FCw_Vbi_ei);
FCz_Vtnode_GND=(latb*FCw_Vtnode_GND);
FCz_Vci_ei=(latb*FCw_Vci_ei);
FCz=(latb*FCw);
FCz_1_Vbi_ci=(+FCz_Vbi_ci);
FCz_1_Vbi_ei=(+FCz_Vbi_ei);
FCz_1_Vtnode_GND=(+FCz_Vtnode_GND);
FCz_1_Vci_ei=(+FCz_Vci_ei);
FCz_1=(1.0+FCz);
FCd_f_Vbi_ci=(-FCz_1_Vbi_ci/(FCz_1*FCz_1));
FCd_f_Vbi_ei=(-FCz_1_Vbi_ei/(FCz_1*FCz_1));
FCd_f_Vtnode_GND=(-FCz_1_Vtnode_GND/(FCz_1*FCz_1));
FCd_f_Vci_ei=(-FCz_1_Vci_ei/(FCz_1*FCz_1));
FCd_f=(1.0/FCz_1);
FCf_ci_Vbi_ci=((((FCw2_Vbi_ci*(1.0+(FCz/3.0)))+(FCw2*(+FCz_Vbi_ci/3.0)))*FCd_f)+((FCw2*(1.0+(FCz/3.0)))*FCd_f_Vbi_ci));
FCf_ci_Vbi_ei=((((FCw2_Vbi_ei*(1.0+(FCz/3.0)))+(FCw2*(+FCz_Vbi_ei/3.0)))*FCd_f)+((FCw2*(1.0+(FCz/3.0)))*FCd_f_Vbi_ei));
FCf_ci_Vtnode_GND=((((FCw2_Vtnode_GND*(1.0+(FCz/3.0)))+(FCw2*(+FCz_Vtnode_GND/3.0)))*FCd_f)+((FCw2*(1.0+(FCz/3.0)))*FCd_f_Vtnode_GND));
FCf_ci_Vci_ei=((((FCw2_Vci_ei*(1.0+(FCz/3.0)))+(FCw2*(+FCz_Vci_ei/3.0)))*FCd_f)+((FCw2*(1.0+(FCz/3.0)))*FCd_f_Vci_ei));
FCf_ci=((FCw2*(1.0+(FCz/3.0)))*FCd_f);
FCdfc_dw_Vbi_ci=(((((((2.0*FCw_Vbi_ci)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ci+((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0)))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ci))*FCd_f)+((((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ci));
FCdfc_dw_Vbi_ei=(((((((2.0*FCw_Vbi_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ei+((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0)))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ei))*FCd_f)+((((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ei));
FCdfc_dw_Vtnode_GND=(((((((2.0*FCw_Vtnode_GND)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vtnode_GND+((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND))/3.0)))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vtnode_GND))*FCd_f)+((((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vtnode_GND));
FCdfc_dw_Vci_ei=(((((((2.0*FCw_Vci_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vci_ei+((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0)))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vci_ei))*FCd_f)+((((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vci_ei));
if (doAC)
{
FCdfc_dw=((((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f);
}
FCdw_ditf_Vbi_ci=((FCdw_daick_Vbi_ci*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vbi_ci));
FCdw_ditf_Vbi_ei=((FCdw_daick_Vbi_ei*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vbi_ei));
FCdw_ditf_Vtnode_GND=((FCdw_daick_Vtnode_GND*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vtnode_GND));
FCdw_ditf_Vci_ei=((FCdw_daick_Vci_ei*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vci_ei));
FCdw_ditf=(FCdw_daick*FCdaick_ditf);
FCdfc_ditf_Vbi_ci=((FCdfc_dw_Vbi_ci*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vbi_ci));
FCdfc_ditf_Vbi_ei=((FCdfc_dw_Vbi_ei*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vbi_ei));
FCdfc_ditf_Vtnode_GND=((FCdfc_dw_Vtnode_GND*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vtnode_GND));
FCdfc_ditf_Vci_ei=((FCdfc_dw_Vci_ei*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vci_ei));
if (doAC)
{
FCdfc_ditf=(FCdfc_dw*FCdw_ditf);
}
if ((FCz>0.001))
{
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,(FCz_1));
_logE(__logE_0,(FCz_1));
FCf_CT_Vbi_ci=((2.0*(((FCz_1_Vbi_ci*__logE_0)+(FCz_1*FCz_1_Vbi_ci*__d_logE_0))-FCz_Vbi_ci))*((latb*latb)*FCz_1)-(2.0*((FCz_1*__logE_0)-FCz))*((latb*latb)*FCz_1_Vbi_ci))/(((latb*latb)*FCz_1)*((latb*latb)*FCz_1));
FCf_CT_Vbi_ei=((2.0*(((FCz_1_Vbi_ei*__logE_0)+(FCz_1*FCz_1_Vbi_ei*__d_logE_0))-FCz_Vbi_ei))*((latb*latb)*FCz_1)-(2.0*((FCz_1*__logE_0)-FCz))*((latb*latb)*FCz_1_Vbi_ei))/(((latb*latb)*FCz_1)*((latb*latb)*FCz_1));
FCf_CT_Vtnode_GND=((2.0*(((FCz_1_Vtnode_GND*__logE_0)+(FCz_1*FCz_1_Vtnode_GND*__d_logE_0))-FCz_Vtnode_GND))*((latb*latb)*FCz_1)-(2.0*((FCz_1*__logE_0)-FCz))*((latb*latb)*FCz_1_Vtnode_GND))/(((latb*latb)*FCz_1)*((latb*latb)*FCz_1));
FCf_CT_Vci_ei=((2.0*(((FCz_1_Vci_ei*__logE_0)+(FCz_1*FCz_1_Vci_ei*__d_logE_0))-FCz_Vci_ei))*((latb*latb)*FCz_1)-(2.0*((FCz_1*__logE_0)-FCz))*((latb*latb)*FCz_1_Vci_ei))/(((latb*latb)*FCz_1)*((latb*latb)*FCz_1));
FCf_CT=((2.0*((FCz_1*__logE_0)-FCz))/((latb*latb)*FCz_1));
}
FCdfCT_dw_Vbi_ci=(((((2.0*FCw_Vbi_ci)*FCd_f)+((2.0*FCw)*FCd_f_Vbi_ci))*FCd_f)+(((2.0*FCw)*FCd_f)*FCd_f_Vbi_ci));
FCdfCT_dw_Vbi_ei=(((((2.0*FCw_Vbi_ei)*FCd_f)+((2.0*FCw)*FCd_f_Vbi_ei))*FCd_f)+(((2.0*FCw)*FCd_f)*FCd_f_Vbi_ei));
FCdfCT_dw_Vtnode_GND=(((((2.0*FCw_Vtnode_GND)*FCd_f)+((2.0*FCw)*FCd_f_Vtnode_GND))*FCd_f)+(((2.0*FCw)*FCd_f)*FCd_f_Vtnode_GND));
FCdfCT_dw_Vci_ei=(((((2.0*FCw_Vci_ei)*FCd_f)+((2.0*FCw)*FCd_f_Vci_ei))*FCd_f)+(((2.0*FCw)*FCd_f)*FCd_f_Vci_ei));
FCdfCT_dw=(((2.0*FCw)*FCd_f)*FCd_f);
}
else
{
FCf_CT_Vbi_ci=((((FCw2_Vbi_ci*(1.0-(FCz/3.0)))+(FCw2*(-FCz_Vbi_ci/3.0)))*FCd_f)+((FCw2*(1.0-(FCz/3.0)))*FCd_f_Vbi_ci));
FCf_CT_Vbi_ei=((((FCw2_Vbi_ei*(1.0-(FCz/3.0)))+(FCw2*(-FCz_Vbi_ei/3.0)))*FCd_f)+((FCw2*(1.0-(FCz/3.0)))*FCd_f_Vbi_ei));
FCf_CT_Vtnode_GND=((((FCw2_Vtnode_GND*(1.0-(FCz/3.0)))+(FCw2*(-FCz_Vtnode_GND/3.0)))*FCd_f)+((FCw2*(1.0-(FCz/3.0)))*FCd_f_Vtnode_GND));
FCf_CT_Vci_ei=((((FCw2_Vci_ei*(1.0-(FCz/3.0)))+(FCw2*(-FCz_Vci_ei/3.0)))*FCd_f)+((FCw2*(1.0-(FCz/3.0)))*FCd_f_Vci_ei));
FCf_CT=((FCw2*(1.0-(FCz/3.0)))*FCd_f);
FCdfCT_dw_Vbi_ci=(((((((2.0*FCw_Vbi_ci)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0)))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ci))*FCd_f)+((((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ci));
FCdfCT_dw_Vbi_ei=(((((((2.0*FCw_Vbi_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0)))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ei))*FCd_f)+((((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ei));
FCdfCT_dw_Vtnode_GND=(((((((2.0*FCw_Vtnode_GND)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND))/3.0)))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vtnode_GND))*FCd_f)+((((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vtnode_GND));
FCdfCT_dw_Vci_ei=(((((((2.0*FCw_Vci_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0)))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vci_ei))*FCd_f)+((((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vci_ei));
FCdfCT_dw=((((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f);
}
FCdfCT_ditf_Vtnode_GND=((FCdfCT_dw_Vtnode_GND*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vtnode_GND));
FCdfCT_ditf_Vbi_ci=((FCdfCT_dw_Vbi_ci*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vbi_ci));
FCdfCT_ditf_Vbi_ei=((FCdfCT_dw_Vbi_ei*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vbi_ei));
FCdfCT_ditf_Vci_ei=((FCdfCT_dw_Vci_ei*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vci_ei));
FCdfCT_ditf=(FCdfCT_dw*FCdw_ditf);
}
FFQ_cT_Vci_ei=((FFQ_fC_Vci_ei*FCf_CT)+(FFQ_fC*FCf_CT_Vci_ei));
FFQ_cT_Vbi_ci=((FFQ_fC_Vbi_ci*FCf_CT)+(FFQ_fC*FCf_CT_Vbi_ci));
FFQ_cT_Vbi_ei=((FFQ_fC_Vbi_ei*FCf_CT)+(FFQ_fC*FCf_CT_Vbi_ei));
FFQ_cT_Vtnode_GND=((FFQ_fC_Vtnode_GND*FCf_CT)+(FFQ_fC*FCf_CT_Vtnode_GND));
FFQ_cT=(FFQ_fC*FCf_CT);
FFQ_fC_Vci_ei=((FFQ_fC_Vci_ei*FCf_ci)+(FFQ_fC*FCf_ci_Vci_ei));
FFQ_fC_Vbi_ci=((FFQ_fC_Vbi_ci*FCf_ci)+(FFQ_fC*FCf_ci_Vbi_ci));
FFQ_fC_Vbi_ei=((FFQ_fC_Vbi_ei*FCf_ci)+(FFQ_fC*FCf_ci_Vbi_ei));
FFQ_fC_Vtnode_GND=((FFQ_fC_Vtnode_GND*FCf_ci)+(FFQ_fC*FCf_ci_Vtnode_GND));
FFQ_fC=(FFQ_fC*FCf_ci);
FFT_fC_Vbi_ci=(FFT_pcS*(FCf_ci_Vbi_ci+((itf_Vbi_ci*FCdfc_ditf)+(itf*FCdfc_ditf_Vbi_ci))));
FFT_fC_Vbi_ei=(FFT_pcS*(FCf_ci_Vbi_ei+((itf_Vbi_ei*FCdfc_ditf)+(itf*FCdfc_ditf_Vbi_ei))));
FFT_fC_Vci_ei=(FFT_pcS*(FCf_ci_Vci_ei+((itf_Vci_ei*FCdfc_ditf)+(itf*FCdfc_ditf_Vci_ei))));
FFT_fC_Vtnode_GND=((FFT_pcS_Vtnode_GND*(FCf_ci+(itf*FCdfc_ditf)))+(FFT_pcS*(FCf_ci_Vtnode_GND+((itf_Vtnode_GND*FCdfc_ditf)+(itf*FCdfc_ditf_Vtnode_GND)))));
if (doAC)
{
FFT_fC=(FFT_pcS*(FCf_ci+(itf*FCdfc_ditf)));
}
FFT_cT_Vbi_ci=(FFT_pcS*(FCf_CT_Vbi_ci+((itf_Vbi_ci*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vbi_ci))));
FFT_cT_Vbi_ei=(FFT_pcS*(FCf_CT_Vbi_ei+((itf_Vbi_ei*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vbi_ei))));
FFT_cT_Vci_ei=(FFT_pcS*(FCf_CT_Vci_ei+((itf_Vci_ei*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vci_ei))));
FFT_cT_Vtnode_GND=((FFT_pcS_Vtnode_GND*(FCf_CT+(itf*FCdfCT_ditf)))+(FFT_pcS*(FCf_CT_Vtnode_GND+((itf_Vtnode_GND*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vtnode_GND)))));
FFT_cT=(FFT_pcS*(FCf_CT+(itf*FCdfCT_ditf)));
}
Qf_Vbi_ei=(Qf_Vbi_ei+FFd_QfB_Vbi_ei);
Qf_Vbi_ci=(Qf_Vbi_ci+FFd_QfB_Vbi_ci);
Qf_Vtnode_GND=(Qf_Vtnode_GND+FFd_QfB_Vtnode_GND);
Qf_Vci_ei=(Qf_Vci_ei+FFd_QfB_Vci_ei);
Qf=(Qf+FFd_QfB);
Tf_Vbi_ei=(Tf_Vbi_ei+FFd_TfB_Vbi_ei);
Tf_Vbi_ci=(Tf_Vbi_ci+FFd_TfB_Vbi_ci);
Tf_Vtnode_GND=(Tf_Vtnode_GND+FFd_TfB_Vtnode_GND);
Tf_Vci_ei=(Tf_Vci_ei+FFd_TfB_Vci_ei);
Tf=(Tf+FFd_TfB);
Q_fT_Vbi_ei=((Qf_Vbi_ei+(hfe*FFd_QfE_Vbi_ei))+(hfc*FFQ_cT_Vbi_ei));
Q_fT_Vbi_ci=((Qf_Vbi_ci+(hfe*FFd_QfE_Vbi_ci))+(hfc*FFQ_cT_Vbi_ci));
Q_fT_Vtnode_GND=((Qf_Vtnode_GND+(hfe*FFd_QfE_Vtnode_GND))+(hfc*FFQ_cT_Vtnode_GND));
Q_fT_Vci_ei=((Qf_Vci_ei+(hfe*FFd_QfE_Vci_ei))+(hfc*FFQ_cT_Vci_ei));
Q_fT=((Qf+(hfe*FFd_QfE))+(hfc*FFQ_cT));
T_fT_Vbi_ei=((Tf_Vbi_ei+(hfe*FFd_TfE_Vbi_ei))+(hfc*FFT_cT_Vbi_ei));
T_fT_Vbi_ci=((Tf_Vbi_ci+(hfe*FFd_TfE_Vbi_ci))+(hfc*FFT_cT_Vbi_ci));
T_fT_Vtnode_GND=((Tf_Vtnode_GND+(hfe*FFd_TfE_Vtnode_GND))+(hfc*FFT_cT_Vtnode_GND));
T_fT_Vci_ei=((Tf_Vci_ei+(hfe*FFd_TfE_Vci_ei))+(hfc*FFT_cT_Vci_ei));
T_fT=((Tf+(hfe*FFd_TfE))+(hfc*FFT_cT));
Qf_Vbi_ei=((Qf_Vbi_ei+FFd_QfE_Vbi_ei)+FFQ_fC_Vbi_ei);
Qf_Vbi_ci=((Qf_Vbi_ci+FFd_QfE_Vbi_ci)+FFQ_fC_Vbi_ci);
Qf_Vtnode_GND=((Qf_Vtnode_GND+FFd_QfE_Vtnode_GND)+FFQ_fC_Vtnode_GND);
Qf_Vci_ei=((Qf_Vci_ei+FFd_QfE_Vci_ei)+FFQ_fC_Vci_ei);
Qf=((Qf+FFd_QfE)+FFQ_fC);
Tf_Vbi_ei=((Tf_Vbi_ei+FFd_TfE_Vbi_ei)+FFT_fC_Vbi_ei);
Tf_Vbi_ci=((Tf_Vbi_ci+FFd_TfE_Vbi_ci)+FFT_fC_Vbi_ci);
Tf_Vtnode_GND=((Tf_Vtnode_GND+FFd_TfE_Vtnode_GND)+FFT_fC_Vtnode_GND);
Tf_Vci_ei=((Tf_Vci_ei+FFd_TfE_Vci_ei)+FFT_fC_Vci_ei);
if (doAC)
{
Tf=((Tf+FFd_TfE)+FFT_fC);
}
}
Qr_Vbi_ei=(Tr*itr_Vbi_ei);
Qr_Vbi_ci=(Tr*itr_Vbi_ci);
Qr_Vtnode_GND=(Tr*itr_Vtnode_GND);
Qr_Vci_ei=(Tr*itr_Vci_ei);
Qr=(Tr*itr);
if ((Oich==0.0))
{
a_Vbi_ei=(+((((T_fT_Vbi_ei*itf)+(T_fT*itf_Vbi_ei))+Qr_Vbi_ei)*Q_pT-((T_fT*itf)+Qr)*Q_pT_Vbi_ei)/(Q_pT*Q_pT));
a_Vbi_ci=(+((((T_fT_Vbi_ci*itf)+(T_fT*itf_Vbi_ci))+Qr_Vbi_ci)*Q_pT-((T_fT*itf)+Qr)*Q_pT_Vbi_ci)/(Q_pT*Q_pT));
a_Vtnode_GND=(+((((T_fT_Vtnode_GND*itf)+(T_fT*itf_Vtnode_GND))+Qr_Vtnode_GND)*Q_pT-((T_fT*itf)+Qr)*Q_pT_Vtnode_GND)/(Q_pT*Q_pT));
a_Vci_ei=(+((((T_fT_Vci_ei*itf)+(T_fT*itf_Vci_ei))+Qr_Vci_ei)*Q_pT-((T_fT*itf)+Qr)*Q_pT_Vci_ei)/(Q_pT*Q_pT));
a=(1.0+(((T_fT*itf)+Qr)/Q_pT));
}
else
{
a_Vbi_ei=(+((((((T_fT_Vbi_ei*I_Tf1)+(T_fT*I_Tf1_Vbi_ei))*(1.0+(2.0*a_h)))+((T_fT*I_Tf1)*(+(2.0*a_h_Vbi_ei))))+Qr_Vbi_ei)*Q_pT-(((T_fT*I_Tf1)*(1.0+(2.0*a_h)))+Qr)*Q_pT_Vbi_ei)/(Q_pT*Q_pT));
a_Vbi_ci=(+((((((T_fT_Vbi_ci*I_Tf1)+(T_fT*I_Tf1_Vbi_ci))*(1.0+(2.0*a_h)))+((T_fT*I_Tf1)*(+(2.0*a_h_Vbi_ci))))+Qr_Vbi_ci)*Q_pT-(((T_fT*I_Tf1)*(1.0+(2.0*a_h)))+Qr)*Q_pT_Vbi_ci)/(Q_pT*Q_pT));
a_Vtnode_GND=(+((((((T_fT_Vtnode_GND*I_Tf1)+(T_fT*I_Tf1_Vtnode_GND))*(1.0+(2.0*a_h)))+((T_fT*I_Tf1)*(+(2.0*a_h_Vtnode_GND))))+Qr_Vtnode_GND)*Q_pT-(((T_fT*I_Tf1)*(1.0+(2.0*a_h)))+Qr)*Q_pT_Vtnode_GND)/(Q_pT*Q_pT));
a_Vci_ei=(+((((((T_fT_Vci_ei*I_Tf1)+(T_fT*I_Tf1_Vci_ei))*(1.0+(2.0*a_h)))+((T_fT*I_Tf1)*(+(2.0*a_h_Vci_ei))))+Qr_Vci_ei)*Q_pT-(((T_fT*I_Tf1)*(1.0+(2.0*a_h)))+Qr)*Q_pT_Vci_ei)/(Q_pT*Q_pT));
a=(1.0+((((T_fT*I_Tf1)*(1.0+(2.0*a_h)))+Qr)/Q_pT));
}
d_Q_Vci_ei=((-(Q_pT_Vci_ei-((+Q_fT_Vci_ei)+Qr_Vci_ei)))*a-(-(Q_pT-((Q_0+Q_fT)+Qr)))*a_Vci_ei)/(a*a);
d_Q_Vbi_ci=((-(Q_pT_Vbi_ci-((Q_0_Vbi_ci+Q_fT_Vbi_ci)+Qr_Vbi_ci)))*a-(-(Q_pT-((Q_0+Q_fT)+Qr)))*a_Vbi_ci)/(a*a);
d_Q_Vbi_ei=((-(Q_pT_Vbi_ei-((Q_0_Vbi_ei+Q_fT_Vbi_ei)+Qr_Vbi_ei)))*a-(-(Q_pT-((Q_0+Q_fT)+Qr)))*a_Vbi_ei)/(a*a);
d_Q_Vtnode_GND=((-(Q_pT_Vtnode_GND-((Q_0_Vtnode_GND+Q_fT_Vtnode_GND)+Qr_Vtnode_GND)))*a-(-(Q_pT-((Q_0+Q_fT)+Qr)))*a_Vtnode_GND)/(a*a);
d_Q=((-(Q_pT-((Q_0+Q_fT)+Qr)))/a);
{
double __fabs_0=0.0;
double __d_fabs_0=0.0;
_d_fabs(__fabs_0,__d_fabs_0,((0.3*Q_pT)));
_fabs(__fabs_0,((0.3*Q_pT)));
a_Vci_ei=(0.3*Q_pT_Vci_ei)*__d_fabs_0;
a_Vbi_ci=(0.3*Q_pT_Vbi_ci)*__d_fabs_0;
a_Vbi_ei=(0.3*Q_pT_Vbi_ei)*__d_fabs_0;
a_Vtnode_GND=(0.3*Q_pT_Vtnode_GND)*__d_fabs_0;
a=__fabs_0;
}
{
double __fabs_0=0.0;
_fabs(__fabs_0,(d_Q));
if ((__fabs_0>a))
{
if ((d_Q>=0))
{
d_Q_Vtnode_GND=a_Vtnode_GND;
d_Q_Vbi_ci=a_Vbi_ci;
d_Q_Vbi_ei=a_Vbi_ei;
d_Q_Vci_ei=a_Vci_ei;
d_Q=a;
}
else
{
d_Q_Vtnode_GND=(-a_Vtnode_GND);
d_Q_Vbi_ci=(-a_Vbi_ci);
d_Q_Vbi_ei=(-a_Vbi_ei);
d_Q_Vci_ei=(-a_Vci_ei);
d_Q=(-a);
}
}
}
Q_pT_Vci_ei=(Q_pT_Vci_ei+d_Q_Vci_ei);
Q_pT_Vbi_ci=(Q_pT_Vbi_ci+d_Q_Vbi_ci);
Q_pT_Vbi_ei=(Q_pT_Vbi_ei+d_Q_Vbi_ei);
Q_pT_Vtnode_GND=(Q_pT_Vtnode_GND+d_Q_Vtnode_GND);
Q_pT=(Q_pT+d_Q);
if (doAC)
{
l_it=(l_it+1);
}
}
}
I_Tf1_Vci_ei=(-(i_0f*Q_pT_Vci_ei)/(Q_pT*Q_pT));
I_Tf1_Vbi_ci=(-(i_0f*Q_pT_Vbi_ci)/(Q_pT*Q_pT));
I_Tf1_Vbi_ei=(i_0f_Vbi_ei*Q_pT-i_0f*Q_pT_Vbi_ei)/(Q_pT*Q_pT);
I_Tf1_Vtnode_GND=(i_0f_Vtnode_GND*Q_pT-i_0f*Q_pT_Vtnode_GND)/(Q_pT*Q_pT);
I_Tf1=(i_0f/Q_pT);
a_h_Vbi_ci=(Oich*I_Tf1_Vbi_ci);
a_h_Vbi_ei=(Oich*I_Tf1_Vbi_ei);
a_h_Vtnode_GND=(Oich*I_Tf1_Vtnode_GND);
a_h_Vci_ei=(Oich*I_Tf1_Vci_ei);
a_h=(Oich*I_Tf1);
itf_Vbi_ci=((I_Tf1_Vbi_ci*(1.0+a_h))+(I_Tf1*(+a_h_Vbi_ci)));
itf_Vbi_ei=((I_Tf1_Vbi_ei*(1.0+a_h))+(I_Tf1*(+a_h_Vbi_ei)));
itf_Vtnode_GND=((I_Tf1_Vtnode_GND*(1.0+a_h))+(I_Tf1*(+a_h_Vtnode_GND)));
itf_Vci_ei=((I_Tf1_Vci_ei*(1.0+a_h))+(I_Tf1*(+a_h_Vci_ei)));
itf=(I_Tf1*(1.0+a_h));
itr_Vci_ei=(-(i_0r*Q_pT_Vci_ei)/(Q_pT*Q_pT));
itr_Vbi_ei=(-(i_0r*Q_pT_Vbi_ei)/(Q_pT*Q_pT));
itr_Vbi_ci=(i_0r_Vbi_ci*Q_pT-i_0r*Q_pT_Vbi_ci)/(Q_pT*Q_pT);
itr_Vtnode_GND=(i_0r_Vtnode_GND*Q_pT-i_0r*Q_pT_Vtnode_GND)/(Q_pT*Q_pT);
itr=(i_0r/Q_pT);
Tf_Vbi_ei=T_f0_Vbi_ei;
Tf_Vbi_ci=T_f0_Vbi_ci;
Tf_Vtnode_GND=T_f0_Vtnode_GND;
if (doAC)
{
Tf=T_f0;
}
Tf_Vci_ei=0.0;
Qf_Vci_ei=(T_f0*itf_Vci_ei);
Qf_Vbi_ei=((T_f0_Vbi_ei*itf)+(T_f0*itf_Vbi_ei));
Qf_Vbi_ci=((T_f0_Vbi_ci*itf)+(T_f0*itf_Vbi_ci));
Qf_Vtnode_GND=((T_f0_Vtnode_GND*itf)+(T_f0*itf_Vtnode_GND));
Qf=(T_f0*itf);
if ((itf<(1.0e-6*ick)))
{
Q_fT_Vbi_ei=Qf_Vbi_ei;
Q_fT_Vbi_ci=Qf_Vbi_ci;
Q_fT_Vtnode_GND=Qf_Vtnode_GND;
Q_fT_Vci_ei=Qf_Vci_ei;
if (doAC)
{
Q_fT=Qf;
}
T_fT_Vbi_ei=Tf_Vbi_ei;
T_fT_Vbi_ci=Tf_Vbi_ci;
T_fT_Vtnode_GND=Tf_Vtnode_GND;
T_fT_Vci_ei=Tf_Vci_ei;
if (doAC)
{
T_fT=Tf;
}
}
else
{
FFa_Vbi_ci=(-(ick*itf_Vbi_ci)/(itf*itf));
FFa_Vbi_ei=(-(ick*itf_Vbi_ei)/(itf*itf));
FFa_Vtnode_GND=(ick_Vtnode_GND*itf-ick*itf_Vtnode_GND)/(itf*itf);
FFa_Vci_ei=(ick_Vci_ei*itf-ick*itf_Vci_ei)/(itf*itf);
FFa=(ick/itf);
{
double __logE_0=0.0;
double __exp_1=0.0;
double __d_logE_0=0.0;
double __d_exp_1=0.0;
_d_logE(__logE_0,__d_logE_0,(FFa));
_d_exp(__exp_1,__d_exp_1,(((-gtfe)*__logE_0)));
_logE(__logE_0,(FFa));
_exp(__exp_1,(((-gtfe)*__logE_0)));
FFd_TfE_Vbi_ci=(tef0_t*((-gtfe)*FFa_Vbi_ci*__d_logE_0)*__d_exp_1);
FFd_TfE_Vbi_ei=(tef0_t*((-gtfe)*FFa_Vbi_ei*__d_logE_0)*__d_exp_1);
FFd_TfE_Vci_ei=(tef0_t*((-gtfe)*FFa_Vci_ei*__d_logE_0)*__d_exp_1);
FFd_TfE_Vtnode_GND=((tef0_t_Vtnode_GND*__exp_1)+(tef0_t*((-gtfe)*FFa_Vtnode_GND*__d_logE_0)*__d_exp_1));
FFd_TfE=(tef0_t*__exp_1);
}
FFd_QfE_Vbi_ci=((FFd_TfE_Vbi_ci*itf)+(FFd_TfE*itf_Vbi_ci))/(gtfe+1.0);
FFd_QfE_Vbi_ei=((FFd_TfE_Vbi_ei*itf)+(FFd_TfE*itf_Vbi_ei))/(gtfe+1.0);
FFd_QfE_Vci_ei=((FFd_TfE_Vci_ei*itf)+(FFd_TfE*itf_Vci_ei))/(gtfe+1.0);
FFd_QfE_Vtnode_GND=((FFd_TfE_Vtnode_GND*itf)+(FFd_TfE*itf_Vtnode_GND))/(gtfe+1.0);
FFd_QfE=((FFd_TfE*itf)/(gtfe+1.0));
FFT_fbS_Vtnode_GND=((1.0-fthc)*thcs_t_Vtnode_GND);
FFT_fbS=((1.0-fthc)*thcs_t);
FFx_Vbi_ci=(-FFa_Vbi_ci);
FFx_Vbi_ei=(-FFa_Vbi_ei);
FFx_Vtnode_GND=(-FFa_Vtnode_GND);
FFx_Vci_ei=(-FFa_Vci_ei);
FFx=(1.0-FFa);
{
double __sqrt_0=0.0;
double __d_sqrt_0=0.0;
_d_sqrt(__sqrt_0,__d_sqrt_0,(((FFx*FFx)+alhc)));
_sqrt(__sqrt_0,(((FFx*FFx)+alhc)));
FFs_Vbi_ci=((FFx_Vbi_ci*FFx)+(FFx*FFx_Vbi_ci))*__d_sqrt_0;
FFs_Vbi_ei=((FFx_Vbi_ei*FFx)+(FFx*FFx_Vbi_ei))*__d_sqrt_0;
FFs_Vtnode_GND=((FFx_Vtnode_GND*FFx)+(FFx*FFx_Vtnode_GND))*__d_sqrt_0;
FFs_Vci_ei=((FFx_Vci_ei*FFx)+(FFx*FFx_Vci_ei))*__d_sqrt_0;
FFs=__sqrt_0;
}
{
double __sqrt_0=0.0;
_sqrt(__sqrt_0,((1.0+alhc)));
FFw_Vbi_ci=(FFx_Vbi_ci+FFs_Vbi_ci)/(1.0+__sqrt_0);
FFw_Vbi_ei=(FFx_Vbi_ei+FFs_Vbi_ei)/(1.0+__sqrt_0);
FFw_Vtnode_GND=(FFx_Vtnode_GND+FFs_Vtnode_GND)/(1.0+__sqrt_0);
FFw_Vci_ei=(FFx_Vci_ei+FFs_Vci_ei)/(1.0+__sqrt_0);
FFw=((FFx+FFs)/(1.0+__sqrt_0));
}
FFw_2_Vbi_ci=((FFw_Vbi_ci*FFw)+(FFw*FFw_Vbi_ci));
FFw_2_Vbi_ei=((FFw_Vbi_ei*FFw)+(FFw*FFw_Vbi_ei));
FFw_2_Vtnode_GND=((FFw_Vtnode_GND*FFw)+(FFw*FFw_Vtnode_GND));
FFw_2_Vci_ei=((FFw_Vci_ei*FFw)+(FFw*FFw_Vci_ei));
FFw_2=(FFw*FFw);
FFd_QfB_Vbi_ci=(((FFT_fbS*itf_Vbi_ci)*FFw_2)+((FFT_fbS*itf)*FFw_2_Vbi_ci));
FFd_QfB_Vbi_ei=(((FFT_fbS*itf_Vbi_ei)*FFw_2)+((FFT_fbS*itf)*FFw_2_Vbi_ei));
FFd_QfB_Vci_ei=(((FFT_fbS*itf_Vci_ei)*FFw_2)+((FFT_fbS*itf)*FFw_2_Vci_ei));
FFd_QfB_Vtnode_GND=((((FFT_fbS_Vtnode_GND*itf)+(FFT_fbS*itf_Vtnode_GND))*FFw_2)+((FFT_fbS*itf)*FFw_2_Vtnode_GND));
FFd_QfB=((FFT_fbS*itf)*FFw_2);
FFa_w_Vbi_ci=((FFw_2_Vbi_ci*(1.0+((2.0*FFa)/FFs)))+(FFw_2*(+((2.0*FFa_Vbi_ci)*FFs-(2.0*FFa)*FFs_Vbi_ci)/(FFs*FFs))));
FFa_w_Vbi_ei=((FFw_2_Vbi_ei*(1.0+((2.0*FFa)/FFs)))+(FFw_2*(+((2.0*FFa_Vbi_ei)*FFs-(2.0*FFa)*FFs_Vbi_ei)/(FFs*FFs))));
FFa_w_Vtnode_GND=((FFw_2_Vtnode_GND*(1.0+((2.0*FFa)/FFs)))+(FFw_2*(+((2.0*FFa_Vtnode_GND)*FFs-(2.0*FFa)*FFs_Vtnode_GND)/(FFs*FFs))));
FFa_w_Vci_ei=((FFw_2_Vci_ei*(1.0+((2.0*FFa)/FFs)))+(FFw_2*(+((2.0*FFa_Vci_ei)*FFs-(2.0*FFa)*FFs_Vci_ei)/(FFs*FFs))));
if (doAC)
{
FFa_w=(FFw_2*(1.0+((2.0*FFa)/FFs)));
}
FFd_TfB_Vbi_ci=(FFT_fbS*FFa_w_Vbi_ci);
FFd_TfB_Vbi_ei=(FFT_fbS*FFa_w_Vbi_ei);
FFd_TfB_Vci_ei=(FFT_fbS*FFa_w_Vci_ei);
FFd_TfB_Vtnode_GND=((FFT_fbS_Vtnode_GND*FFa_w)+(FFT_fbS*FFa_w_Vtnode_GND));
if (doAC)
{
FFd_TfB=(FFT_fbS*FFa_w);
}
FFT_pcS_Vtnode_GND=(fthc*thcs_t_Vtnode_GND);
FFT_pcS=(fthc*thcs_t);
if (((latb<=0.0)&&(latl<=0.0)))
{
FFQ_fC_Vbi_ci=(((FFT_pcS*itf_Vbi_ci)*FFw_2)+((FFT_pcS*itf)*FFw_2_Vbi_ci));
FFQ_fC_Vbi_ei=(((FFT_pcS*itf_Vbi_ei)*FFw_2)+((FFT_pcS*itf)*FFw_2_Vbi_ei));
FFQ_fC_Vci_ei=(((FFT_pcS*itf_Vci_ei)*FFw_2)+((FFT_pcS*itf)*FFw_2_Vci_ei));
FFQ_fC_Vtnode_GND=((((FFT_pcS_Vtnode_GND*itf)+(FFT_pcS*itf_Vtnode_GND))*FFw_2)+((FFT_pcS*itf)*FFw_2_Vtnode_GND));
FFQ_fC=((FFT_pcS*itf)*FFw_2);
FFT_fC_Vbi_ci=(FFT_pcS*FFa_w_Vbi_ci);
FFT_fC_Vbi_ei=(FFT_pcS*FFa_w_Vbi_ei);
FFT_fC_Vci_ei=(FFT_pcS*FFa_w_Vci_ei);
FFT_fC_Vtnode_GND=((FFT_pcS_Vtnode_GND*FFa_w)+(FFT_pcS*FFa_w_Vtnode_GND));
if (doAC)
{
FFT_fC=(FFT_pcS*FFa_w);
}
FFQ_cT_Vci_ei=FFQ_fC_Vci_ei;
FFQ_cT_Vbi_ci=FFQ_fC_Vbi_ci;
FFQ_cT_Vbi_ei=FFQ_fC_Vbi_ei;
FFQ_cT_Vtnode_GND=FFQ_fC_Vtnode_GND;
if (doAC)
{
FFQ_cT=FFQ_fC;
}
FFT_cT_Vbi_ci=FFT_fC_Vbi_ci;
FFT_cT_Vbi_ei=FFT_fC_Vbi_ei;
FFT_cT_Vci_ei=FFT_fC_Vci_ei;
FFT_cT_Vtnode_GND=FFT_fC_Vtnode_GND;
if (doAC)
{
FFT_cT=FFT_fC;
}
}
else
{
FFQ_fC_Vbi_ci=(FFT_pcS*itf_Vbi_ci);
FFQ_fC_Vbi_ei=(FFT_pcS*itf_Vbi_ei);
FFQ_fC_Vci_ei=(FFT_pcS*itf_Vci_ei);
FFQ_fC_Vtnode_GND=((FFT_pcS_Vtnode_GND*itf)+(FFT_pcS*itf_Vtnode_GND));
FFQ_fC=(FFT_pcS*itf);
FCa_Vbi_ci=(-(-(ick*itf_Vbi_ci)/(itf*itf)));
FCa_Vbi_ei=(-(-(ick*itf_Vbi_ei)/(itf*itf)));
FCa_Vtnode_GND=(-(ick_Vtnode_GND*itf-ick*itf_Vtnode_GND)/(itf*itf));
FCa_Vci_ei=(-(ick_Vci_ei*itf-ick*itf_Vci_ei)/(itf*itf));
FCa=(1.0-(ick/itf));
{
double __sqrt_0=0.0;
double __d_sqrt_0=0.0;
_d_sqrt(__sqrt_0,__d_sqrt_0,(((FCa*FCa)+alhc)));
_sqrt(__sqrt_0,(((FCa*FCa)+alhc)));
FCrt_Vbi_ci=((FCa_Vbi_ci*FCa)+(FCa*FCa_Vbi_ci))*__d_sqrt_0;
FCrt_Vbi_ei=((FCa_Vbi_ei*FCa)+(FCa*FCa_Vbi_ei))*__d_sqrt_0;
FCrt_Vtnode_GND=((FCa_Vtnode_GND*FCa)+(FCa*FCa_Vtnode_GND))*__d_sqrt_0;
FCrt_Vci_ei=((FCa_Vci_ei*FCa)+(FCa*FCa_Vci_ei))*__d_sqrt_0;
FCrt=__sqrt_0;
}
{
double __sqrt_0=0.0;
_sqrt(__sqrt_0,((1.0+alhc)));
FCa_ck_Vbi_ci=(-(FCa_Vbi_ci+FCrt_Vbi_ci)/(1.0+__sqrt_0));
FCa_ck_Vbi_ei=(-(FCa_Vbi_ei+FCrt_Vbi_ei)/(1.0+__sqrt_0));
FCa_ck_Vtnode_GND=(-(FCa_Vtnode_GND+FCrt_Vtnode_GND)/(1.0+__sqrt_0));
FCa_ck_Vci_ei=(-(FCa_Vci_ei+FCrt_Vci_ei)/(1.0+__sqrt_0));
FCa_ck=(1.0-((FCa+FCrt)/(1.0+__sqrt_0)));
}
FCdaick_ditf_Vbi_ci=(((FCa_ck_Vbi_ci*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ci)))*(FCrt*itf)-((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci)))/((FCrt*itf)*(FCrt*itf));
FCdaick_ditf_Vbi_ei=(((FCa_ck_Vbi_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ei)))*(FCrt*itf)-((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei)))/((FCrt*itf)*(FCrt*itf));
FCdaick_ditf_Vtnode_GND=(((FCa_ck_Vtnode_GND*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vtnode_GND)))*(FCrt*itf)-((FCa_ck-1.0)*(1-FCa))*((FCrt_Vtnode_GND*itf)+(FCrt*itf_Vtnode_GND)))/((FCrt*itf)*(FCrt*itf));
FCdaick_ditf_Vci_ei=(((FCa_ck_Vci_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vci_ei)))*(FCrt*itf)-((FCa_ck-1.0)*(1-FCa))*((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei)))/((FCrt*itf)*(FCrt*itf));
if (doAC)
{
FCdaick_ditf=(((FCa_ck-1.0)*(1-FCa))/(FCrt*itf));
}
if ((latb>latl))
{
FCz=(latb-latl);
FCz_Vci_ei=0.0;
FCz_Vtnode_GND=0.0;
FCz_Vbi_ei=0.0;
FCz_Vbi_ci=0.0;
FCxl=(1.0+latl);
FCxb=(1.0+latb);
if ((latb>0.01))
{
{
double __logE_0=0.0;
_logE(__logE_0,((FCxb/FCxl)));
FCln=__logE_0;
}
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(((FCa_ck-1.0)*FCln)));
_exp(__exp_0,(((FCa_ck-1.0)*FCln)));
FCa1_Vbi_ci=FCa_ck_Vbi_ci*FCln*__d_exp_0;
FCa1_Vbi_ei=FCa_ck_Vbi_ei*FCln*__d_exp_0;
FCa1_Vtnode_GND=FCa_ck_Vtnode_GND*FCln*__d_exp_0;
FCa1_Vci_ei=FCa_ck_Vci_ei*FCln*__d_exp_0;
FCa1=__exp_0;
}
FCd_a_Vbi_ci=(-(-FCa1_Vbi_ci*latb)/((latl-(FCa1*latb))*(latl-(FCa1*latb))));
FCd_a_Vbi_ei=(-(-FCa1_Vbi_ei*latb)/((latl-(FCa1*latb))*(latl-(FCa1*latb))));
FCd_a_Vtnode_GND=(-(-FCa1_Vtnode_GND*latb)/((latl-(FCa1*latb))*(latl-(FCa1*latb))));
FCd_a_Vci_ei=(-(-FCa1_Vci_ei*latb)/((latl-(FCa1*latb))*(latl-(FCa1*latb))));
FCd_a=(1.0/(latl-(FCa1*latb)));
FCw_Vbi_ci=((FCa1_Vbi_ci*FCd_a)+((FCa1-1.0)*FCd_a_Vbi_ci));
FCw_Vbi_ei=((FCa1_Vbi_ei*FCd_a)+((FCa1-1.0)*FCd_a_Vbi_ei));
FCw_Vtnode_GND=((FCa1_Vtnode_GND*FCd_a)+((FCa1-1.0)*FCd_a_Vtnode_GND));
FCw_Vci_ei=((FCa1_Vci_ei*FCd_a)+((FCa1-1.0)*FCd_a_Vci_ei));
FCw=((FCa1-1.0)*FCd_a);
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,(((1.0+(latb*FCw))/(1.0+(latl*FCw)))));
_logE(__logE_0,(((1.0+(latb*FCw))/(1.0+(latl*FCw)))));
FCa_Vbi_ci=((+(latb*FCw_Vbi_ci))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(+(latl*FCw_Vbi_ci)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))*__d_logE_0;
FCa_Vbi_ei=((+(latb*FCw_Vbi_ei))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(+(latl*FCw_Vbi_ei)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))*__d_logE_0;
FCa_Vtnode_GND=((+(latb*FCw_Vtnode_GND))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(+(latl*FCw_Vtnode_GND)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))*__d_logE_0;
FCa_Vci_ei=((+(latb*FCw_Vci_ei))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(+(latl*FCw_Vci_ei)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))*__d_logE_0;
FCa=__logE_0;
}
FCdw_daick_Vbi_ci=(((((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci))*FCd_a)+(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ci));
FCdw_daick_Vbi_ei=(((((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei))*FCd_a)+(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ei));
FCdw_daick_Vtnode_GND=(((((((-FCz_Vtnode_GND)*FCa1)+((-FCz)*FCa1_Vtnode_GND))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vtnode_GND))*FCd_a)+(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vtnode_GND));
FCdw_daick_Vci_ei=(((((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei))*FCd_a)+(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vci_ei));
if (doAC)
{
FCdw_daick=(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a);
}
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0+(latb*FCw))));
_logE(__logE_0,((1.0+(latb*FCw))));
FClnb_Vbi_ci=(+(latb*FCw_Vbi_ci))*__d_logE_0;
FClnb_Vbi_ei=(+(latb*FCw_Vbi_ei))*__d_logE_0;
FClnb_Vtnode_GND=(+(latb*FCw_Vtnode_GND))*__d_logE_0;
FClnb_Vci_ei=(+(latb*FCw_Vci_ei))*__d_logE_0;
FClnb=__logE_0;
}
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0+(latl*FCw))));
_logE(__logE_0,((1.0+(latl*FCw))));
FClnl_Vbi_ci=(+(latl*FCw_Vbi_ci))*__d_logE_0;
FClnl_Vbi_ei=(+(latl*FCw_Vbi_ei))*__d_logE_0;
FClnl_Vtnode_GND=(+(latl*FCw_Vtnode_GND))*__d_logE_0;
FClnl_Vci_ei=(+(latl*FCw_Vci_ei))*__d_logE_0;
FClnl=__logE_0;
}
FCa1_Vbi_ci=(FClnb_Vbi_ci-FClnl_Vbi_ci);
FCa1_Vbi_ei=(FClnb_Vbi_ei-FClnl_Vbi_ei);
FCa1_Vtnode_GND=(FClnb_Vtnode_GND-FClnl_Vtnode_GND);
FCa1_Vci_ei=(FClnb_Vci_ei-FClnl_Vci_ei);
if (doAC)
{
FCa1=(FClnb-FClnl);
}
FCda1_dw_Vbi_ci=((-(latb*(+(latb*FCw_Vbi_ci)))/((1.0+(latb*FCw))*(1.0+(latb*FCw))))-(-(latl*(+(latl*FCw_Vbi_ci)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))));
FCda1_dw_Vbi_ei=((-(latb*(+(latb*FCw_Vbi_ei)))/((1.0+(latb*FCw))*(1.0+(latb*FCw))))-(-(latl*(+(latl*FCw_Vbi_ei)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))));
FCda1_dw_Vtnode_GND=((-(latb*(+(latb*FCw_Vtnode_GND)))/((1.0+(latb*FCw))*(1.0+(latb*FCw))))-(-(latl*(+(latl*FCw_Vtnode_GND)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))));
FCda1_dw_Vci_ei=((-(latb*(+(latb*FCw_Vci_ei)))/((1.0+(latb*FCw))*(1.0+(latb*FCw))))-(-(latl*(+(latl*FCw_Vci_ei)))/((1.0+(latl*FCw))*(1.0+(latl*FCw)))));
if (doAC)
{
FCda1_dw=((latb/(1.0+(latb*FCw)))-(latl/(1.0+(latl*FCw))));
}
}
else
{
FCf1_Vbi_ci=(-FCa_ck_Vbi_ci);
FCf1_Vbi_ei=(-FCa_ck_Vbi_ei);
FCf1_Vtnode_GND=(-FCa_ck_Vtnode_GND);
FCf1_Vci_ei=(-FCa_ck_Vci_ei);
FCf1=(1.0-FCa_ck);
FCd_a_Vbi_ci=(-(-FCf1_Vbi_ci*latb)/((1.0-(FCf1*latb))*(1.0-(FCf1*latb))));
FCd_a_Vbi_ei=(-(-FCf1_Vbi_ei*latb)/((1.0-(FCf1*latb))*(1.0-(FCf1*latb))));
FCd_a_Vtnode_GND=(-(-FCf1_Vtnode_GND*latb)/((1.0-(FCf1*latb))*(1.0-(FCf1*latb))));
FCd_a_Vci_ei=(-(-FCf1_Vci_ei*latb)/((1.0-(FCf1*latb))*(1.0-(FCf1*latb))));
FCd_a=(1.0/(1.0-(FCf1*latb)));
FCw_Vbi_ci=((FCf1_Vbi_ci*FCd_a)+(FCf1*FCd_a_Vbi_ci));
FCw_Vbi_ei=((FCf1_Vbi_ei*FCd_a)+(FCf1*FCd_a_Vbi_ei));
FCw_Vtnode_GND=((FCf1_Vtnode_GND*FCd_a)+(FCf1*FCd_a_Vtnode_GND));
FCw_Vci_ei=((FCf1_Vci_ei*FCd_a)+(FCf1*FCd_a_Vci_ei));
FCw=(FCf1*FCd_a);
FCa_Vbi_ci=((FCz_Vbi_ci*FCw)+(FCz*FCw_Vbi_ci));
FCa_Vbi_ei=((FCz_Vbi_ei*FCw)+(FCz*FCw_Vbi_ei));
FCa_Vtnode_GND=((FCz_Vtnode_GND*FCw)+(FCz*FCw_Vtnode_GND));
FCa_Vci_ei=((FCz_Vci_ei*FCw)+(FCz*FCw_Vci_ei));
FCa=(FCz*FCw);
FCdw_daick_Vbi_ci=((((-1.0)*FCd_a_Vbi_ci)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci));
FCdw_daick_Vbi_ei=((((-1.0)*FCd_a_Vbi_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei));
FCdw_daick_Vtnode_GND=((((-1.0)*FCd_a_Vtnode_GND)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vtnode_GND));
FCdw_daick_Vci_ei=((((-1.0)*FCd_a_Vci_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei));
if (doAC)
{
FCdw_daick=(((-1.0)*FCd_a)*FCd_a);
}
FClnb_Vbi_ci=(latb*FCw_Vbi_ci);
FClnb_Vbi_ei=(latb*FCw_Vbi_ei);
FClnb_Vtnode_GND=(latb*FCw_Vtnode_GND);
FClnb_Vci_ei=(latb*FCw_Vci_ei);
FClnb=(latb*FCw);
FClnl_Vbi_ci=(latl*FCw_Vbi_ci);
FClnl_Vbi_ei=(latl*FCw_Vbi_ei);
FClnl_Vtnode_GND=(latl*FCw_Vtnode_GND);
FClnl_Vci_ei=(latl*FCw_Vci_ei);
FClnl=(latl*FCw);
FCa1_Vbi_ci=((FCz_Vbi_ci*FCw)+(FCz*FCw_Vbi_ci));
FCa1_Vbi_ei=((FCz_Vbi_ei*FCw)+(FCz*FCw_Vbi_ei));
FCa1_Vtnode_GND=((FCz_Vtnode_GND*FCw)+(FCz*FCw_Vtnode_GND));
FCa1_Vci_ei=((FCz_Vci_ei*FCw)+(FCz*FCw_Vci_ei));
if (doAC)
{
FCa1=(FCz*FCw);
}
FCda1_dw_Vbi_ci=FCz_Vbi_ci;
FCda1_dw_Vbi_ei=FCz_Vbi_ei;
FCda1_dw_Vtnode_GND=FCz_Vtnode_GND;
FCda1_dw_Vci_ei=FCz_Vci_ei;
if (doAC)
{
FCda1_dw=FCz;
}
}
FCf_CT_Vbi_ci=(-(2.0*FCz_Vbi_ci)/(FCz*FCz));
FCf_CT_Vbi_ei=(-(2.0*FCz_Vbi_ei)/(FCz*FCz));
FCf_CT_Vtnode_GND=(-(2.0*FCz_Vtnode_GND)/(FCz*FCz));
FCf_CT_Vci_ei=(-(2.0*FCz_Vci_ei)/(FCz*FCz));
FCf_CT=(2.0/FCz);
FCw2_Vbi_ci=((FCw_Vbi_ci*FCw)+(FCw*FCw_Vbi_ci));
FCw2_Vbi_ei=((FCw_Vbi_ei*FCw)+(FCw*FCw_Vbi_ei));
FCw2_Vtnode_GND=((FCw_Vtnode_GND*FCw)+(FCw*FCw_Vtnode_GND));
FCw2_Vci_ei=((FCw_Vci_ei*FCw)+(FCw*FCw_Vci_ei));
FCw2=(FCw*FCw);
FCf1_Vbi_ci=((((((latb*latl)*FCw_Vbi_ci)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ci))/3.0+((latb+latl)*FCw2_Vbi_ci)/2.0)+FCw_Vbi_ci);
FCf1_Vbi_ei=((((((latb*latl)*FCw_Vbi_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ei))/3.0+((latb+latl)*FCw2_Vbi_ei)/2.0)+FCw_Vbi_ei);
FCf1_Vtnode_GND=((((((latb*latl)*FCw_Vtnode_GND)*FCw2)+(((latb*latl)*FCw)*FCw2_Vtnode_GND))/3.0+((latb+latl)*FCw2_Vtnode_GND)/2.0)+FCw_Vtnode_GND);
FCf1_Vci_ei=((((((latb*latl)*FCw_Vci_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vci_ei))/3.0+((latb+latl)*FCw2_Vci_ei)/2.0)+FCw_Vci_ei);
FCf1=((((((latb*latl)*FCw)*FCw2)/3.0)+(((latb+latl)*FCw2)/2.0))+FCw);
FCdf1_dw_Vbi_ci=(((latb*latl)*FCw2_Vbi_ci)+((latb+latl)*FCw_Vbi_ci));
FCdf1_dw_Vbi_ei=(((latb*latl)*FCw2_Vbi_ei)+((latb+latl)*FCw_Vbi_ei));
FCdf1_dw_Vtnode_GND=(((latb*latl)*FCw2_Vtnode_GND)+((latb+latl)*FCw_Vtnode_GND));
FCdf1_dw_Vci_ei=(((latb*latl)*FCw2_Vci_ei)+((latb+latl)*FCw_Vci_ei));
if (doAC)
{
FCdf1_dw=((((latb*latl)*FCw2)+((latb+latl)*FCw))+1.0);
}
z_Vbi_ci=(latb*FCw_Vbi_ci);
z_Vbi_ei=(latb*FCw_Vbi_ei);
z_Vtnode_GND=(latb*FCw_Vtnode_GND);
z_Vci_ei=(latb*FCw_Vci_ei);
z=(latb*FCw);
if ((z>1.0e-6))
{
x_Vbi_ci=(+z_Vbi_ci);
x_Vbi_ei=(+z_Vbi_ei);
x_Vtnode_GND=(+z_Vtnode_GND);
x_Vci_ei=(+z_Vci_ei);
x=(1.0+z);
a_Vbi_ci=((x_Vbi_ci*x)+(x*x_Vbi_ci));
a_Vbi_ei=((x_Vbi_ei*x)+(x*x_Vbi_ei));
a_Vtnode_GND=((x_Vtnode_GND*x)+(x*x_Vtnode_GND));
a_Vci_ei=((x_Vci_ei*x)+(x*x_Vci_ei));
a=(x*x);
a2_Vtnode_GND=(0.250*((a_Vtnode_GND*((2.0*FClnb)-1.0))+(a*(2.0*FClnb_Vtnode_GND))));
a2_Vbi_ci=(0.250*((a_Vbi_ci*((2.0*FClnb)-1.0))+(a*(2.0*FClnb_Vbi_ci))));
a2_Vbi_ei=(0.250*((a_Vbi_ei*((2.0*FClnb)-1.0))+(a*(2.0*FClnb_Vbi_ei))));
a2_Vci_ei=(0.250*((a_Vci_ei*((2.0*FClnb)-1.0))+(a*(2.0*FClnb_Vci_ei))));
a2=(0.250*((a*((2.0*FClnb)-1.0))+1.0));
a3_Vtnode_GND=((((a_Vtnode_GND*x)+(a*x_Vtnode_GND))*((3.0*FClnb)-1.0))+((a*x)*(3.0*FClnb_Vtnode_GND)))/9.0;
a3_Vbi_ci=((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*FClnb)-1.0))+((a*x)*(3.0*FClnb_Vbi_ci)))/9.0;
a3_Vbi_ei=((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*FClnb)-1.0))+((a*x)*(3.0*FClnb_Vbi_ei)))/9.0;
a3_Vci_ei=((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*FClnb)-1.0))+((a*x)*(3.0*FClnb_Vci_ei)))/9.0;
a3=((((a*x)*((3.0*FClnb)-1.0))+1.0)/9.0);
r=(latl/latb);
FCf2_Vtnode_GND=(((1.0-r)*a2_Vtnode_GND)+(r*a3_Vtnode_GND))/latb;
FCf2_Vbi_ci=(((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))/latb;
FCf2_Vbi_ei=(((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))/latb;
FCf2_Vci_ei=(((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))/latb;
FCf2=((((1.0-r)*a2)+(r*a3))/latb);
FCdf2_dw_Vbi_ci=(((((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*FClnb)+((((1.0-r)*x)+(r*a))*FClnb_Vbi_ci));
FCdf2_dw_Vbi_ei=(((((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*FClnb)+((((1.0-r)*x)+(r*a))*FClnb_Vbi_ei));
FCdf2_dw_Vtnode_GND=(((((1.0-r)*x_Vtnode_GND)+(r*a_Vtnode_GND))*FClnb)+((((1.0-r)*x)+(r*a))*FClnb_Vtnode_GND));
FCdf2_dw_Vci_ei=(((((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*FClnb)+((((1.0-r)*x)+(r*a))*FClnb_Vci_ei));
if (doAC)
{
FCdf2_dw=((((1.0-r)*x)+(r*a))*FClnb);
}
}
else
{
a_Vbi_ci=((z_Vbi_ci*z)+(z*z_Vbi_ci));
a_Vbi_ei=((z_Vbi_ei*z)+(z*z_Vbi_ei));
a_Vtnode_GND=((z_Vtnode_GND*z)+(z*z_Vtnode_GND));
a_Vci_ei=((z_Vci_ei*z)+(z*z_Vci_ei));
a=(z*z);
a2_Vbi_ci=(((+z_Vbi_ci)-(0.5*a_Vbi_ci))+((z_Vbi_ci*a)+(z*a_Vbi_ci)));
a2_Vbi_ei=(((+z_Vbi_ei)-(0.5*a_Vbi_ei))+((z_Vbi_ei*a)+(z*a_Vbi_ei)));
a2_Vtnode_GND=(((+z_Vtnode_GND)-(0.5*a_Vtnode_GND))+((z_Vtnode_GND*a)+(z*a_Vtnode_GND)));
a2_Vci_ei=(((+z_Vci_ei)-(0.5*a_Vci_ei))+((z_Vci_ei*a)+(z*a_Vci_ei)));
a2=(((3.0+z)-(0.5*a))+(z*a));
a3_Vbi_ci=((((-2.0)*z_Vbi_ci)+(1.5*a_Vbi_ci))+(((2.0*a_Vbi_ci)*a)+((2.0*a)*a_Vbi_ci))/3.0);
a3_Vbi_ei=((((-2.0)*z_Vbi_ei)+(1.5*a_Vbi_ei))+(((2.0*a_Vbi_ei)*a)+((2.0*a)*a_Vbi_ei))/3.0);
a3_Vtnode_GND=((((-2.0)*z_Vtnode_GND)+(1.5*a_Vtnode_GND))+(((2.0*a_Vtnode_GND)*a)+((2.0*a)*a_Vtnode_GND))/3.0);
a3_Vci_ei=((((-2.0)*z_Vci_ei)+(1.5*a_Vci_ei))+(((2.0*a_Vci_ei)*a)+((2.0*a)*a_Vci_ei))/3.0);
a3=((((-2.0)*z)+(1.5*a))+(((2.0*a)*a)/3.0));
FCf2_Vtnode_GND=((((((latb*a2_Vtnode_GND)+(latl*a3_Vtnode_GND))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vtnode_GND))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vtnode_GND))/6.0;
FCf2_Vbi_ci=((((((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci))/6.0;
FCf2_Vbi_ei=((((((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei))/6.0;
FCf2_Vci_ei=((((((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei))/6.0;
FCf2=(((((latb*a2)+(latl*a3))*FCw)*FCw)/6.0);
FCdf2_dw_Vbi_ci=((((z_Vbi_ci+(0.5*a_Vbi_ci))-((a_Vbi_ci*z)+(a*z_Vbi_ci))/3.0)+(((5.0*a_Vbi_ci)*a)+((5.0*a)*a_Vbi_ci))/6.0)+(((latl*FCw_Vbi_ci)*((a-z)+(((2.0*a)*a)/3.0)))+((latl*FCw)*((a_Vbi_ci-z_Vbi_ci)+(((2.0*a_Vbi_ci)*a)+((2.0*a)*a_Vbi_ci))/3.0))));
FCdf2_dw_Vbi_ei=((((z_Vbi_ei+(0.5*a_Vbi_ei))-((a_Vbi_ei*z)+(a*z_Vbi_ei))/3.0)+(((5.0*a_Vbi_ei)*a)+((5.0*a)*a_Vbi_ei))/6.0)+(((latl*FCw_Vbi_ei)*((a-z)+(((2.0*a)*a)/3.0)))+((latl*FCw)*((a_Vbi_ei-z_Vbi_ei)+(((2.0*a_Vbi_ei)*a)+((2.0*a)*a_Vbi_ei))/3.0))));
FCdf2_dw_Vtnode_GND=((((z_Vtnode_GND+(0.5*a_Vtnode_GND))-((a_Vtnode_GND*z)+(a*z_Vtnode_GND))/3.0)+(((5.0*a_Vtnode_GND)*a)+((5.0*a)*a_Vtnode_GND))/6.0)+(((latl*FCw_Vtnode_GND)*((a-z)+(((2.0*a)*a)/3.0)))+((latl*FCw)*((a_Vtnode_GND-z_Vtnode_GND)+(((2.0*a_Vtnode_GND)*a)+((2.0*a)*a_Vtnode_GND))/3.0))));
FCdf2_dw_Vci_ei=((((z_Vci_ei+(0.5*a_Vci_ei))-((a_Vci_ei*z)+(a*z_Vci_ei))/3.0)+(((5.0*a_Vci_ei)*a)+((5.0*a)*a_Vci_ei))/6.0)+(((latl*FCw_Vci_ei)*((a-z)+(((2.0*a)*a)/3.0)))+((latl*FCw)*((a_Vci_ei-z_Vci_ei)+(((2.0*a_Vci_ei)*a)+((2.0*a)*a_Vci_ei))/3.0))));
if (doAC)
{
FCdf2_dw=((((z+(0.5*a))-((a*z)/3.0))+(((5.0*a)*a)/6.0))+((latl*FCw)*((a-z)+(((2.0*a)*a)/3.0))));
}
}
z_Vbi_ci=(latl*FCw_Vbi_ci);
z_Vbi_ei=(latl*FCw_Vbi_ei);
z_Vtnode_GND=(latl*FCw_Vtnode_GND);
z_Vci_ei=(latl*FCw_Vci_ei);
z=(latl*FCw);
if ((z>1.0e-6))
{
x_Vbi_ci=(+z_Vbi_ci);
x_Vbi_ei=(+z_Vbi_ei);
x_Vtnode_GND=(+z_Vtnode_GND);
x_Vci_ei=(+z_Vci_ei);
x=(1.0+z);
a_Vbi_ci=((x_Vbi_ci*x)+(x*x_Vbi_ci));
a_Vbi_ei=((x_Vbi_ei*x)+(x*x_Vbi_ei));
a_Vtnode_GND=((x_Vtnode_GND*x)+(x*x_Vtnode_GND));
a_Vci_ei=((x_Vci_ei*x)+(x*x_Vci_ei));
a=(x*x);
a2_Vtnode_GND=(0.250*((a_Vtnode_GND*((2.0*FClnl)-1.0))+(a*(2.0*FClnl_Vtnode_GND))));
a2_Vbi_ci=(0.250*((a_Vbi_ci*((2.0*FClnl)-1.0))+(a*(2.0*FClnl_Vbi_ci))));
a2_Vbi_ei=(0.250*((a_Vbi_ei*((2.0*FClnl)-1.0))+(a*(2.0*FClnl_Vbi_ei))));
a2_Vci_ei=(0.250*((a_Vci_ei*((2.0*FClnl)-1.0))+(a*(2.0*FClnl_Vci_ei))));
a2=(0.250*((a*((2.0*FClnl)-1.0))+1.0));
a3_Vtnode_GND=((((a_Vtnode_GND*x)+(a*x_Vtnode_GND))*((3.0*FClnl)-1.0))+((a*x)*(3.0*FClnl_Vtnode_GND)))/9.0;
a3_Vbi_ci=((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*FClnl)-1.0))+((a*x)*(3.0*FClnl_Vbi_ci)))/9.0;
a3_Vbi_ei=((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*FClnl)-1.0))+((a*x)*(3.0*FClnl_Vbi_ei)))/9.0;
a3_Vci_ei=((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*FClnl)-1.0))+((a*x)*(3.0*FClnl_Vci_ei)))/9.0;
a3=((((a*x)*((3.0*FClnl)-1.0))+1.0)/9.0);
r=(latb/latl);
FCf3_Vtnode_GND=(((1.0-r)*a2_Vtnode_GND)+(r*a3_Vtnode_GND))/latl;
FCf3_Vbi_ci=(((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))/latl;
FCf3_Vbi_ei=(((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))/latl;
FCf3_Vci_ei=(((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))/latl;
FCf3=((((1.0-r)*a2)+(r*a3))/latl);
FCdf3_dw_Vbi_ci=(((((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*FClnl)+((((1.0-r)*x)+(r*a))*FClnl_Vbi_ci));
FCdf3_dw_Vbi_ei=(((((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*FClnl)+((((1.0-r)*x)+(r*a))*FClnl_Vbi_ei));
FCdf3_dw_Vtnode_GND=(((((1.0-r)*x_Vtnode_GND)+(r*a_Vtnode_GND))*FClnl)+((((1.0-r)*x)+(r*a))*FClnl_Vtnode_GND));
FCdf3_dw_Vci_ei=(((((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*FClnl)+((((1.0-r)*x)+(r*a))*FClnl_Vci_ei));
if (doAC)
{
FCdf3_dw=((((1.0-r)*x)+(r*a))*FClnl);
}
}
else
{
a_Vbi_ci=((z_Vbi_ci*z)+(z*z_Vbi_ci));
a_Vbi_ei=((z_Vbi_ei*z)+(z*z_Vbi_ei));
a_Vtnode_GND=((z_Vtnode_GND*z)+(z*z_Vtnode_GND));
a_Vci_ei=((z_Vci_ei*z)+(z*z_Vci_ei));
a=(z*z);
a2_Vbi_ci=(((+z_Vbi_ci)-(0.5*a_Vbi_ci))+((z_Vbi_ci*a)+(z*a_Vbi_ci)));
a2_Vbi_ei=(((+z_Vbi_ei)-(0.5*a_Vbi_ei))+((z_Vbi_ei*a)+(z*a_Vbi_ei)));
a2_Vtnode_GND=(((+z_Vtnode_GND)-(0.5*a_Vtnode_GND))+((z_Vtnode_GND*a)+(z*a_Vtnode_GND)));
a2_Vci_ei=(((+z_Vci_ei)-(0.5*a_Vci_ei))+((z_Vci_ei*a)+(z*a_Vci_ei)));
a2=(((3.0+z)-(0.5*a))+(z*a));
a3_Vbi_ci=((((-2.0)*z_Vbi_ci)+(1.5*a_Vbi_ci))+(((2.0*a_Vbi_ci)*a)+((2.0*a)*a_Vbi_ci))/3.0);
a3_Vbi_ei=((((-2.0)*z_Vbi_ei)+(1.5*a_Vbi_ei))+(((2.0*a_Vbi_ei)*a)+((2.0*a)*a_Vbi_ei))/3.0);
a3_Vtnode_GND=((((-2.0)*z_Vtnode_GND)+(1.5*a_Vtnode_GND))+(((2.0*a_Vtnode_GND)*a)+((2.0*a)*a_Vtnode_GND))/3.0);
a3_Vci_ei=((((-2.0)*z_Vci_ei)+(1.5*a_Vci_ei))+(((2.0*a_Vci_ei)*a)+((2.0*a)*a_Vci_ei))/3.0);
a3=((((-2.0)*z)+(1.5*a))+(((2.0*a)*a)/3.0));
FCf3_Vtnode_GND=((((((latl*a2_Vtnode_GND)+(latb*a3_Vtnode_GND))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vtnode_GND))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vtnode_GND))/6.0;
FCf3_Vbi_ci=((((((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci))/6.0;
FCf3_Vbi_ei=((((((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei))/6.0;
FCf3_Vci_ei=((((((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei))/6.0;
FCf3=(((((latl*a2)+(latb*a3))*FCw)*FCw)/6.0);
FCdf3_dw_Vbi_ci=((((z_Vbi_ci+(0.5*a_Vbi_ci))-((a_Vbi_ci*z)+(a*z_Vbi_ci))/3.0)+(((5.0*a_Vbi_ci)*a)+((5.0*a)*a_Vbi_ci))/6.0)+(((latb*FCw_Vbi_ci)*((a-z)+(((2.0*a)*a)/3.0)))+((latb*FCw)*((a_Vbi_ci-z_Vbi_ci)+(((2.0*a_Vbi_ci)*a)+((2.0*a)*a_Vbi_ci))/3.0))));
FCdf3_dw_Vbi_ei=((((z_Vbi_ei+(0.5*a_Vbi_ei))-((a_Vbi_ei*z)+(a*z_Vbi_ei))/3.0)+(((5.0*a_Vbi_ei)*a)+((5.0*a)*a_Vbi_ei))/6.0)+(((latb*FCw_Vbi_ei)*((a-z)+(((2.0*a)*a)/3.0)))+((latb*FCw)*((a_Vbi_ei-z_Vbi_ei)+(((2.0*a_Vbi_ei)*a)+((2.0*a)*a_Vbi_ei))/3.0))));
FCdf3_dw_Vtnode_GND=((((z_Vtnode_GND+(0.5*a_Vtnode_GND))-((a_Vtnode_GND*z)+(a*z_Vtnode_GND))/3.0)+(((5.0*a_Vtnode_GND)*a)+((5.0*a)*a_Vtnode_GND))/6.0)+(((latb*FCw_Vtnode_GND)*((a-z)+(((2.0*a)*a)/3.0)))+((latb*FCw)*((a_Vtnode_GND-z_Vtnode_GND)+(((2.0*a_Vtnode_GND)*a)+((2.0*a)*a_Vtnode_GND))/3.0))));
FCdf3_dw_Vci_ei=((((z_Vci_ei+(0.5*a_Vci_ei))-((a_Vci_ei*z)+(a*z_Vci_ei))/3.0)+(((5.0*a_Vci_ei)*a)+((5.0*a)*a_Vci_ei))/6.0)+(((latb*FCw_Vci_ei)*((a-z)+(((2.0*a)*a)/3.0)))+((latb*FCw)*((a_Vci_ei-z_Vci_ei)+(((2.0*a_Vci_ei)*a)+((2.0*a)*a_Vci_ei))/3.0))));
if (doAC)
{
FCdf3_dw=((((z+(0.5*a))-((a*z)/3.0))+(((5.0*a)*a)/6.0))+((latb*FCw)*((a-z)+(((2.0*a)*a)/3.0))));
}
}
FCf_ci_Vtnode_GND=((FCf_CT_Vtnode_GND*(((FCa*FCf1)-FCf2)+FCf3))+(FCf_CT*((((FCa_Vtnode_GND*FCf1)+(FCa*FCf1_Vtnode_GND))-FCf2_Vtnode_GND)+FCf3_Vtnode_GND)));
FCf_ci_Vbi_ci=((FCf_CT_Vbi_ci*(((FCa*FCf1)-FCf2)+FCf3))+(FCf_CT*((((FCa_Vbi_ci*FCf1)+(FCa*FCf1_Vbi_ci))-FCf2_Vbi_ci)+FCf3_Vbi_ci)));
FCf_ci_Vbi_ei=((FCf_CT_Vbi_ei*(((FCa*FCf1)-FCf2)+FCf3))+(FCf_CT*((((FCa_Vbi_ei*FCf1)+(FCa*FCf1_Vbi_ei))-FCf2_Vbi_ei)+FCf3_Vbi_ei)));
FCf_ci_Vci_ei=((FCf_CT_Vci_ei*(((FCa*FCf1)-FCf2)+FCf3))+(FCf_CT*((((FCa_Vci_ei*FCf1)+(FCa*FCf1_Vci_ei))-FCf2_Vci_ei)+FCf3_Vci_ei)));
FCf_ci=(FCf_CT*(((FCa*FCf1)-FCf2)+FCf3));
FCdfc_dw_Vtnode_GND=((FCf_CT_Vtnode_GND*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw))+(FCf_CT*(((((FCa1_Vtnode_GND*FCdf1_dw)+(FCa1*FCdf1_dw_Vtnode_GND))+((FCda1_dw_Vtnode_GND*FCf1)+(FCda1_dw*FCf1_Vtnode_GND)))-FCdf2_dw_Vtnode_GND)+FCdf3_dw_Vtnode_GND)));
FCdfc_dw_Vbi_ci=((FCf_CT_Vbi_ci*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw))+(FCf_CT*(((((FCa1_Vbi_ci*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ci))+((FCda1_dw_Vbi_ci*FCf1)+(FCda1_dw*FCf1_Vbi_ci)))-FCdf2_dw_Vbi_ci)+FCdf3_dw_Vbi_ci)));
FCdfc_dw_Vbi_ei=((FCf_CT_Vbi_ei*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw))+(FCf_CT*(((((FCa1_Vbi_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ei))+((FCda1_dw_Vbi_ei*FCf1)+(FCda1_dw*FCf1_Vbi_ei)))-FCdf2_dw_Vbi_ei)+FCdf3_dw_Vbi_ei)));
FCdfc_dw_Vci_ei=((FCf_CT_Vci_ei*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw))+(FCf_CT*(((((FCa1_Vci_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vci_ei))+((FCda1_dw_Vci_ei*FCf1)+(FCda1_dw*FCf1_Vci_ei)))-FCdf2_dw_Vci_ei)+FCdf3_dw_Vci_ei)));
if (doAC)
{
FCdfc_dw=(FCf_CT*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw));
}
FCdw_ditf_Vbi_ci=((FCdw_daick_Vbi_ci*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vbi_ci));
FCdw_ditf_Vbi_ei=((FCdw_daick_Vbi_ei*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vbi_ei));
FCdw_ditf_Vtnode_GND=((FCdw_daick_Vtnode_GND*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vtnode_GND));
FCdw_ditf_Vci_ei=((FCdw_daick_Vci_ei*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vci_ei));
if (doAC)
{
FCdw_ditf=(FCdw_daick*FCdaick_ditf);
}
FCdfc_ditf_Vbi_ci=((FCdfc_dw_Vbi_ci*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vbi_ci));
FCdfc_ditf_Vbi_ei=((FCdfc_dw_Vbi_ei*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vbi_ei));
FCdfc_ditf_Vtnode_GND=((FCdfc_dw_Vtnode_GND*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vtnode_GND));
FCdfc_ditf_Vci_ei=((FCdfc_dw_Vci_ei*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vci_ei));
if (doAC)
{
FCdfc_ditf=(FCdfc_dw*FCdw_ditf);
}
a_Vbi_ci=(latb*FCw_Vbi_ci);
a_Vbi_ei=(latb*FCw_Vbi_ei);
a_Vtnode_GND=(latb*FCw_Vtnode_GND);
a_Vci_ei=(latb*FCw_Vci_ei);
if (doAC)
{
a=(latb*FCw);
}
if ((a>1.0e-6))
{
FCf2_Vtnode_GND=(a_Vtnode_GND-FClnb_Vtnode_GND)/latb;
FCf2_Vbi_ci=(a_Vbi_ci-FClnb_Vbi_ci)/latb;
FCf2_Vbi_ei=(a_Vbi_ei-FClnb_Vbi_ei)/latb;
FCf2_Vci_ei=(a_Vci_ei-FClnb_Vci_ei)/latb;
if (doAC)
{
FCf2=((a-FClnb)/latb);
}
FCdf2_dw_Vtnode_GND=(a_Vtnode_GND*(1.0+a)-a*(+a_Vtnode_GND))/((1.0+a)*(1.0+a));
FCdf2_dw_Vbi_ci=(a_Vbi_ci*(1.0+a)-a*(+a_Vbi_ci))/((1.0+a)*(1.0+a));
FCdf2_dw_Vbi_ei=(a_Vbi_ei*(1.0+a)-a*(+a_Vbi_ei))/((1.0+a)*(1.0+a));
FCdf2_dw_Vci_ei=(a_Vci_ei*(1.0+a)-a*(+a_Vci_ei))/((1.0+a)*(1.0+a));
if (doAC)
{
FCdf2_dw=(a/(1.0+a));
}
}
else
{
FCf2_Vtnode_GND=(((0.5*a_Vtnode_GND)*FCw)+((0.5*a)*FCw_Vtnode_GND));
FCf2_Vbi_ci=(((0.5*a_Vbi_ci)*FCw)+((0.5*a)*FCw_Vbi_ci));
FCf2_Vbi_ei=(((0.5*a_Vbi_ei)*FCw)+((0.5*a)*FCw_Vbi_ei));
FCf2_Vci_ei=(((0.5*a_Vci_ei)*FCw)+((0.5*a)*FCw_Vci_ei));
if (doAC)
{
FCf2=((0.5*a)*FCw);
}
FCdf2_dw_Vtnode_GND=a_Vtnode_GND;
FCdf2_dw_Vbi_ci=a_Vbi_ci;
FCdf2_dw_Vbi_ei=a_Vbi_ei;
FCdf2_dw_Vci_ei=a_Vci_ei;
if (doAC)
{
FCdf2_dw=a;
}
}
a_Vbi_ci=(latl*FCw_Vbi_ci);
a_Vbi_ei=(latl*FCw_Vbi_ei);
a_Vtnode_GND=(latl*FCw_Vtnode_GND);
a_Vci_ei=(latl*FCw_Vci_ei);
if (doAC)
{
a=(latl*FCw);
}
if ((a>1.0e-6))
{
FCf3_Vtnode_GND=(a_Vtnode_GND-FClnl_Vtnode_GND)/latl;
FCf3_Vbi_ci=(a_Vbi_ci-FClnl_Vbi_ci)/latl;
FCf3_Vbi_ei=(a_Vbi_ei-FClnl_Vbi_ei)/latl;
FCf3_Vci_ei=(a_Vci_ei-FClnl_Vci_ei)/latl;
if (doAC)
{
FCf3=((a-FClnl)/latl);
}
FCdf3_dw_Vtnode_GND=(a_Vtnode_GND*(1.0+a)-a*(+a_Vtnode_GND))/((1.0+a)*(1.0+a));
FCdf3_dw_Vbi_ci=(a_Vbi_ci*(1.0+a)-a*(+a_Vbi_ci))/((1.0+a)*(1.0+a));
FCdf3_dw_Vbi_ei=(a_Vbi_ei*(1.0+a)-a*(+a_Vbi_ei))/((1.0+a)*(1.0+a));
FCdf3_dw_Vci_ei=(a_Vci_ei*(1.0+a)-a*(+a_Vci_ei))/((1.0+a)*(1.0+a));
if (doAC)
{
FCdf3_dw=(a/(1.0+a));
}
}
else
{
FCf3_Vtnode_GND=(((0.5*a_Vtnode_GND)*FCw)+((0.5*a)*FCw_Vtnode_GND));
FCf3_Vbi_ci=(((0.5*a_Vbi_ci)*FCw)+((0.5*a)*FCw_Vbi_ci));
FCf3_Vbi_ei=(((0.5*a_Vbi_ei)*FCw)+((0.5*a)*FCw_Vbi_ei));
FCf3_Vci_ei=(((0.5*a_Vci_ei)*FCw)+((0.5*a)*FCw_Vci_ei));
if (doAC)
{
FCf3=((0.5*a)*FCw);
}
FCdf3_dw_Vtnode_GND=a_Vtnode_GND;
FCdf3_dw_Vbi_ci=a_Vbi_ci;
FCdf3_dw_Vbi_ei=a_Vbi_ei;
FCdf3_dw_Vci_ei=a_Vci_ei;
if (doAC)
{
FCdf3_dw=a;
}
}
FCf_CT_Vtnode_GND=((FCf_CT_Vtnode_GND*(FCf2-FCf3))+(FCf_CT*(FCf2_Vtnode_GND-FCf3_Vtnode_GND)));
FCf_CT_Vbi_ci=((FCf_CT_Vbi_ci*(FCf2-FCf3))+(FCf_CT*(FCf2_Vbi_ci-FCf3_Vbi_ci)));
FCf_CT_Vbi_ei=((FCf_CT_Vbi_ei*(FCf2-FCf3))+(FCf_CT*(FCf2_Vbi_ei-FCf3_Vbi_ei)));
FCf_CT_Vci_ei=((FCf_CT_Vci_ei*(FCf2-FCf3))+(FCf_CT*(FCf2_Vci_ei-FCf3_Vci_ei)));
if (doAC)
{
FCf_CT=(FCf_CT*(FCf2-FCf3));
}
FCdfCT_dw_Vtnode_GND=((FCf_CT_Vtnode_GND*(FCdf2_dw-FCdf3_dw))+(FCf_CT*(FCdf2_dw_Vtnode_GND-FCdf3_dw_Vtnode_GND)));
FCdfCT_dw_Vbi_ci=((FCf_CT_Vbi_ci*(FCdf2_dw-FCdf3_dw))+(FCf_CT*(FCdf2_dw_Vbi_ci-FCdf3_dw_Vbi_ci)));
FCdfCT_dw_Vbi_ei=((FCf_CT_Vbi_ei*(FCdf2_dw-FCdf3_dw))+(FCf_CT*(FCdf2_dw_Vbi_ei-FCdf3_dw_Vbi_ei)));
FCdfCT_dw_Vci_ei=((FCf_CT_Vci_ei*(FCdf2_dw-FCdf3_dw))+(FCf_CT*(FCdf2_dw_Vci_ei-FCdf3_dw_Vci_ei)));
if (doAC)
{
FCdfCT_dw=(FCf_CT*(FCdf2_dw-FCdf3_dw));
}
FCdfCT_ditf_Vtnode_GND=((FCdfCT_dw_Vtnode_GND*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vtnode_GND));
FCdfCT_ditf_Vbi_ci=((FCdfCT_dw_Vbi_ci*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vbi_ci));
FCdfCT_ditf_Vbi_ei=((FCdfCT_dw_Vbi_ei*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vbi_ei));
FCdfCT_ditf_Vci_ei=((FCdfCT_dw_Vci_ei*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vci_ei));
if (doAC)
{
FCdfCT_ditf=(FCdfCT_dw*FCdw_ditf);
}
}
else
{
if ((latb>0.01))
{
FCd_a_Vbi_ci=(-(+FCa_ck_Vbi_ci*latb)/((1.0+(FCa_ck*latb))*(1.0+(FCa_ck*latb))));
FCd_a_Vbi_ei=(-(+FCa_ck_Vbi_ei*latb)/((1.0+(FCa_ck*latb))*(1.0+(FCa_ck*latb))));
FCd_a_Vtnode_GND=(-(+FCa_ck_Vtnode_GND*latb)/((1.0+(FCa_ck*latb))*(1.0+(FCa_ck*latb))));
FCd_a_Vci_ei=(-(+FCa_ck_Vci_ei*latb)/((1.0+(FCa_ck*latb))*(1.0+(FCa_ck*latb))));
FCd_a=(1.0/(1.0+(FCa_ck*latb)));
FCw_Vbi_ci=(((-FCa_ck_Vbi_ci)*FCd_a)+((1.0-FCa_ck)*FCd_a_Vbi_ci));
FCw_Vbi_ei=(((-FCa_ck_Vbi_ei)*FCd_a)+((1.0-FCa_ck)*FCd_a_Vbi_ei));
FCw_Vtnode_GND=(((-FCa_ck_Vtnode_GND)*FCd_a)+((1.0-FCa_ck)*FCd_a_Vtnode_GND));
FCw_Vci_ei=(((-FCa_ck_Vci_ei)*FCd_a)+((1.0-FCa_ck)*FCd_a_Vci_ei));
FCw=((1.0-FCa_ck)*FCd_a);
FCdw_daick_Vbi_ci=((((-(1.0+latb))*FCd_a_Vbi_ci)*FCd_a)+(((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ci));
FCdw_daick_Vbi_ei=((((-(1.0+latb))*FCd_a_Vbi_ei)*FCd_a)+(((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ei));
FCdw_daick_Vtnode_GND=((((-(1.0+latb))*FCd_a_Vtnode_GND)*FCd_a)+(((-(1.0+latb))*FCd_a)*FCd_a_Vtnode_GND));
FCdw_daick_Vci_ei=((((-(1.0+latb))*FCd_a_Vci_ei)*FCd_a)+(((-(1.0+latb))*FCd_a)*FCd_a_Vci_ei));
if (doAC)
{
FCdw_daick=(((-(1.0+latb))*FCd_a)*FCd_a);
}
}
else
{
FCw_Vbi_ci=((-FCa_ck_Vbi_ci)-FCa_ck_Vbi_ci*latb);
FCw_Vbi_ei=((-FCa_ck_Vbi_ei)-FCa_ck_Vbi_ei*latb);
FCw_Vtnode_GND=((-FCa_ck_Vtnode_GND)-FCa_ck_Vtnode_GND*latb);
FCw_Vci_ei=((-FCa_ck_Vci_ei)-FCa_ck_Vci_ei*latb);
FCw=((1.0-FCa_ck)-(FCa_ck*latb));
if (doAC)
{
FCdw_daick=(-(1.0+latb));
}
FCdw_daick_Vci_ei=0.0;
FCdw_daick_Vtnode_GND=0.0;
FCdw_daick_Vbi_ei=0.0;
FCdw_daick_Vbi_ci=0.0;
}
FCw2_Vbi_ci=((FCw_Vbi_ci*FCw)+(FCw*FCw_Vbi_ci));
FCw2_Vbi_ei=((FCw_Vbi_ei*FCw)+(FCw*FCw_Vbi_ei));
FCw2_Vtnode_GND=((FCw_Vtnode_GND*FCw)+(FCw*FCw_Vtnode_GND));
FCw2_Vci_ei=((FCw_Vci_ei*FCw)+(FCw*FCw_Vci_ei));
FCw2=(FCw*FCw);
FCz_Vbi_ci=(latb*FCw_Vbi_ci);
FCz_Vbi_ei=(latb*FCw_Vbi_ei);
FCz_Vtnode_GND=(latb*FCw_Vtnode_GND);
FCz_Vci_ei=(latb*FCw_Vci_ei);
FCz=(latb*FCw);
FCz_1_Vbi_ci=(+FCz_Vbi_ci);
FCz_1_Vbi_ei=(+FCz_Vbi_ei);
FCz_1_Vtnode_GND=(+FCz_Vtnode_GND);
FCz_1_Vci_ei=(+FCz_Vci_ei);
FCz_1=(1.0+FCz);
FCd_f_Vbi_ci=(-FCz_1_Vbi_ci/(FCz_1*FCz_1));
FCd_f_Vbi_ei=(-FCz_1_Vbi_ei/(FCz_1*FCz_1));
FCd_f_Vtnode_GND=(-FCz_1_Vtnode_GND/(FCz_1*FCz_1));
FCd_f_Vci_ei=(-FCz_1_Vci_ei/(FCz_1*FCz_1));
FCd_f=(1.0/FCz_1);
FCf_ci_Vbi_ci=((((FCw2_Vbi_ci*(1.0+(FCz/3.0)))+(FCw2*(+FCz_Vbi_ci/3.0)))*FCd_f)+((FCw2*(1.0+(FCz/3.0)))*FCd_f_Vbi_ci));
FCf_ci_Vbi_ei=((((FCw2_Vbi_ei*(1.0+(FCz/3.0)))+(FCw2*(+FCz_Vbi_ei/3.0)))*FCd_f)+((FCw2*(1.0+(FCz/3.0)))*FCd_f_Vbi_ei));
FCf_ci_Vtnode_GND=((((FCw2_Vtnode_GND*(1.0+(FCz/3.0)))+(FCw2*(+FCz_Vtnode_GND/3.0)))*FCd_f)+((FCw2*(1.0+(FCz/3.0)))*FCd_f_Vtnode_GND));
FCf_ci_Vci_ei=((((FCw2_Vci_ei*(1.0+(FCz/3.0)))+(FCw2*(+FCz_Vci_ei/3.0)))*FCd_f)+((FCw2*(1.0+(FCz/3.0)))*FCd_f_Vci_ei));
FCf_ci=((FCw2*(1.0+(FCz/3.0)))*FCd_f);
FCdfc_dw_Vbi_ci=(((((((2.0*FCw_Vbi_ci)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ci+((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0)))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ci))*FCd_f)+((((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ci));
FCdfc_dw_Vbi_ei=(((((((2.0*FCw_Vbi_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ei+((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0)))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ei))*FCd_f)+((((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ei));
FCdfc_dw_Vtnode_GND=(((((((2.0*FCw_Vtnode_GND)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vtnode_GND+((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND))/3.0)))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vtnode_GND))*FCd_f)+((((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vtnode_GND));
FCdfc_dw_Vci_ei=(((((((2.0*FCw_Vci_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vci_ei+((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0)))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vci_ei))*FCd_f)+((((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vci_ei));
if (doAC)
{
FCdfc_dw=((((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f);
}
FCdw_ditf_Vbi_ci=((FCdw_daick_Vbi_ci*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vbi_ci));
FCdw_ditf_Vbi_ei=((FCdw_daick_Vbi_ei*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vbi_ei));
FCdw_ditf_Vtnode_GND=((FCdw_daick_Vtnode_GND*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vtnode_GND));
FCdw_ditf_Vci_ei=((FCdw_daick_Vci_ei*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vci_ei));
if (doAC)
{
FCdw_ditf=(FCdw_daick*FCdaick_ditf);
}
FCdfc_ditf_Vbi_ci=((FCdfc_dw_Vbi_ci*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vbi_ci));
FCdfc_ditf_Vbi_ei=((FCdfc_dw_Vbi_ei*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vbi_ei));
FCdfc_ditf_Vtnode_GND=((FCdfc_dw_Vtnode_GND*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vtnode_GND));
FCdfc_ditf_Vci_ei=((FCdfc_dw_Vci_ei*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vci_ei));
if (doAC)
{
FCdfc_ditf=(FCdfc_dw*FCdw_ditf);
}
if ((FCz>0.001))
{
if (doAC)
{
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,(FCz_1));
_logE(__logE_0,(FCz_1));
FCf_CT_Vbi_ci=((2.0*(((FCz_1_Vbi_ci*__logE_0)+(FCz_1*FCz_1_Vbi_ci*__d_logE_0))-FCz_Vbi_ci))*((latb*latb)*FCz_1)-(2.0*((FCz_1*__logE_0)-FCz))*((latb*latb)*FCz_1_Vbi_ci))/(((latb*latb)*FCz_1)*((latb*latb)*FCz_1));
FCf_CT_Vbi_ei=((2.0*(((FCz_1_Vbi_ei*__logE_0)+(FCz_1*FCz_1_Vbi_ei*__d_logE_0))-FCz_Vbi_ei))*((latb*latb)*FCz_1)-(2.0*((FCz_1*__logE_0)-FCz))*((latb*latb)*FCz_1_Vbi_ei))/(((latb*latb)*FCz_1)*((latb*latb)*FCz_1));
FCf_CT_Vtnode_GND=((2.0*(((FCz_1_Vtnode_GND*__logE_0)+(FCz_1*FCz_1_Vtnode_GND*__d_logE_0))-FCz_Vtnode_GND))*((latb*latb)*FCz_1)-(2.0*((FCz_1*__logE_0)-FCz))*((latb*latb)*FCz_1_Vtnode_GND))/(((latb*latb)*FCz_1)*((latb*latb)*FCz_1));
FCf_CT_Vci_ei=((2.0*(((FCz_1_Vci_ei*__logE_0)+(FCz_1*FCz_1_Vci_ei*__d_logE_0))-FCz_Vci_ei))*((latb*latb)*FCz_1)-(2.0*((FCz_1*__logE_0)-FCz))*((latb*latb)*FCz_1_Vci_ei))/(((latb*latb)*FCz_1)*((latb*latb)*FCz_1));
if (doAC)
{
FCf_CT=((2.0*((FCz_1*__logE_0)-FCz))/((latb*latb)*FCz_1));
}
}
}
FCdfCT_dw_Vbi_ci=(((((2.0*FCw_Vbi_ci)*FCd_f)+((2.0*FCw)*FCd_f_Vbi_ci))*FCd_f)+(((2.0*FCw)*FCd_f)*FCd_f_Vbi_ci));
FCdfCT_dw_Vbi_ei=(((((2.0*FCw_Vbi_ei)*FCd_f)+((2.0*FCw)*FCd_f_Vbi_ei))*FCd_f)+(((2.0*FCw)*FCd_f)*FCd_f_Vbi_ei));
FCdfCT_dw_Vtnode_GND=(((((2.0*FCw_Vtnode_GND)*FCd_f)+((2.0*FCw)*FCd_f_Vtnode_GND))*FCd_f)+(((2.0*FCw)*FCd_f)*FCd_f_Vtnode_GND));
FCdfCT_dw_Vci_ei=(((((2.0*FCw_Vci_ei)*FCd_f)+((2.0*FCw)*FCd_f_Vci_ei))*FCd_f)+(((2.0*FCw)*FCd_f)*FCd_f_Vci_ei));
if (doAC)
{
FCdfCT_dw=(((2.0*FCw)*FCd_f)*FCd_f);
}
}
else
{
FCf_CT_Vbi_ci=((((FCw2_Vbi_ci*(1.0-(FCz/3.0)))+(FCw2*(-FCz_Vbi_ci/3.0)))*FCd_f)+((FCw2*(1.0-(FCz/3.0)))*FCd_f_Vbi_ci));
FCf_CT_Vbi_ei=((((FCw2_Vbi_ei*(1.0-(FCz/3.0)))+(FCw2*(-FCz_Vbi_ei/3.0)))*FCd_f)+((FCw2*(1.0-(FCz/3.0)))*FCd_f_Vbi_ei));
FCf_CT_Vtnode_GND=((((FCw2_Vtnode_GND*(1.0-(FCz/3.0)))+(FCw2*(-FCz_Vtnode_GND/3.0)))*FCd_f)+((FCw2*(1.0-(FCz/3.0)))*FCd_f_Vtnode_GND));
FCf_CT_Vci_ei=((((FCw2_Vci_ei*(1.0-(FCz/3.0)))+(FCw2*(-FCz_Vci_ei/3.0)))*FCd_f)+((FCw2*(1.0-(FCz/3.0)))*FCd_f_Vci_ei));
if (doAC)
{
FCf_CT=((FCw2*(1.0-(FCz/3.0)))*FCd_f);
}
FCdfCT_dw_Vbi_ci=(((((((2.0*FCw_Vbi_ci)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0)))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ci))*FCd_f)+((((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ci));
FCdfCT_dw_Vbi_ei=(((((((2.0*FCw_Vbi_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0)))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ei))*FCd_f)+((((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ei));
FCdfCT_dw_Vtnode_GND=(((((((2.0*FCw_Vtnode_GND)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND))/3.0)))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vtnode_GND))*FCd_f)+((((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vtnode_GND));
FCdfCT_dw_Vci_ei=(((((((2.0*FCw_Vci_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0)))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vci_ei))*FCd_f)+((((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vci_ei));
if (doAC)
{
FCdfCT_dw=((((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f);
}
}
FCdfCT_ditf_Vtnode_GND=((FCdfCT_dw_Vtnode_GND*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vtnode_GND));
FCdfCT_ditf_Vbi_ci=((FCdfCT_dw_Vbi_ci*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vbi_ci));
FCdfCT_ditf_Vbi_ei=((FCdfCT_dw_Vbi_ei*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vbi_ei));
FCdfCT_ditf_Vci_ei=((FCdfCT_dw_Vci_ei*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vci_ei));
if (doAC)
{
FCdfCT_ditf=(FCdfCT_dw*FCdw_ditf);
}
}
FFQ_cT_Vci_ei=((FFQ_fC_Vci_ei*FCf_CT)+(FFQ_fC*FCf_CT_Vci_ei));
FFQ_cT_Vbi_ci=((FFQ_fC_Vbi_ci*FCf_CT)+(FFQ_fC*FCf_CT_Vbi_ci));
FFQ_cT_Vbi_ei=((FFQ_fC_Vbi_ei*FCf_CT)+(FFQ_fC*FCf_CT_Vbi_ei));
FFQ_cT_Vtnode_GND=((FFQ_fC_Vtnode_GND*FCf_CT)+(FFQ_fC*FCf_CT_Vtnode_GND));
if (doAC)
{
FFQ_cT=(FFQ_fC*FCf_CT);
}
FFQ_fC_Vci_ei=((FFQ_fC_Vci_ei*FCf_ci)+(FFQ_fC*FCf_ci_Vci_ei));
FFQ_fC_Vbi_ci=((FFQ_fC_Vbi_ci*FCf_ci)+(FFQ_fC*FCf_ci_Vbi_ci));
FFQ_fC_Vbi_ei=((FFQ_fC_Vbi_ei*FCf_ci)+(FFQ_fC*FCf_ci_Vbi_ei));
FFQ_fC_Vtnode_GND=((FFQ_fC_Vtnode_GND*FCf_ci)+(FFQ_fC*FCf_ci_Vtnode_GND));
FFQ_fC=(FFQ_fC*FCf_ci);
FFT_fC_Vbi_ci=(FFT_pcS*(FCf_ci_Vbi_ci+((itf_Vbi_ci*FCdfc_ditf)+(itf*FCdfc_ditf_Vbi_ci))));
FFT_fC_Vbi_ei=(FFT_pcS*(FCf_ci_Vbi_ei+((itf_Vbi_ei*FCdfc_ditf)+(itf*FCdfc_ditf_Vbi_ei))));
FFT_fC_Vci_ei=(FFT_pcS*(FCf_ci_Vci_ei+((itf_Vci_ei*FCdfc_ditf)+(itf*FCdfc_ditf_Vci_ei))));
FFT_fC_Vtnode_GND=((FFT_pcS_Vtnode_GND*(FCf_ci+(itf*FCdfc_ditf)))+(FFT_pcS*(FCf_ci_Vtnode_GND+((itf_Vtnode_GND*FCdfc_ditf)+(itf*FCdfc_ditf_Vtnode_GND)))));
if (doAC)
{
FFT_fC=(FFT_pcS*(FCf_ci+(itf*FCdfc_ditf)));
}
FFT_cT_Vbi_ci=(FFT_pcS*(FCf_CT_Vbi_ci+((itf_Vbi_ci*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vbi_ci))));
FFT_cT_Vbi_ei=(FFT_pcS*(FCf_CT_Vbi_ei+((itf_Vbi_ei*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vbi_ei))));
FFT_cT_Vci_ei=(FFT_pcS*(FCf_CT_Vci_ei+((itf_Vci_ei*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vci_ei))));
FFT_cT_Vtnode_GND=((FFT_pcS_Vtnode_GND*(FCf_CT+(itf*FCdfCT_ditf)))+(FFT_pcS*(FCf_CT_Vtnode_GND+((itf_Vtnode_GND*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vtnode_GND)))));
if (doAC)
{
FFT_cT=(FFT_pcS*(FCf_CT+(itf*FCdfCT_ditf)));
}
}
Qf_Vbi_ei=(Qf_Vbi_ei+FFd_QfB_Vbi_ei);
Qf_Vbi_ci=(Qf_Vbi_ci+FFd_QfB_Vbi_ci);
Qf_Vtnode_GND=(Qf_Vtnode_GND+FFd_QfB_Vtnode_GND);
Qf_Vci_ei=(Qf_Vci_ei+FFd_QfB_Vci_ei);
Qf=(Qf+FFd_QfB);
Tf_Vbi_ei=(Tf_Vbi_ei+FFd_TfB_Vbi_ei);
Tf_Vbi_ci=(Tf_Vbi_ci+FFd_TfB_Vbi_ci);
Tf_Vtnode_GND=(Tf_Vtnode_GND+FFd_TfB_Vtnode_GND);
Tf_Vci_ei=(Tf_Vci_ei+FFd_TfB_Vci_ei);
if (doAC)
{
Tf=(Tf+FFd_TfB);
}
Q_fT_Vbi_ei=((Qf_Vbi_ei+(hfe*FFd_QfE_Vbi_ei))+(hfc*FFQ_cT_Vbi_ei));
Q_fT_Vbi_ci=((Qf_Vbi_ci+(hfe*FFd_QfE_Vbi_ci))+(hfc*FFQ_cT_Vbi_ci));
Q_fT_Vtnode_GND=((Qf_Vtnode_GND+(hfe*FFd_QfE_Vtnode_GND))+(hfc*FFQ_cT_Vtnode_GND));
Q_fT_Vci_ei=((Qf_Vci_ei+(hfe*FFd_QfE_Vci_ei))+(hfc*FFQ_cT_Vci_ei));
if (doAC)
{
Q_fT=((Qf+(hfe*FFd_QfE))+(hfc*FFQ_cT));
}
T_fT_Vbi_ei=((Tf_Vbi_ei+(hfe*FFd_TfE_Vbi_ei))+(hfc*FFT_cT_Vbi_ei));
T_fT_Vbi_ci=((Tf_Vbi_ci+(hfe*FFd_TfE_Vbi_ci))+(hfc*FFT_cT_Vbi_ci));
T_fT_Vtnode_GND=((Tf_Vtnode_GND+(hfe*FFd_TfE_Vtnode_GND))+(hfc*FFT_cT_Vtnode_GND));
T_fT_Vci_ei=((Tf_Vci_ei+(hfe*FFd_TfE_Vci_ei))+(hfc*FFT_cT_Vci_ei));
if (doAC)
{
T_fT=((Tf+(hfe*FFd_TfE))+(hfc*FFT_cT));
}
Qf_Vbi_ei=((Qf_Vbi_ei+FFd_QfE_Vbi_ei)+FFQ_fC_Vbi_ei);
Qf_Vbi_ci=((Qf_Vbi_ci+FFd_QfE_Vbi_ci)+FFQ_fC_Vbi_ci);
Qf_Vtnode_GND=((Qf_Vtnode_GND+FFd_QfE_Vtnode_GND)+FFQ_fC_Vtnode_GND);
Qf_Vci_ei=((Qf_Vci_ei+FFd_QfE_Vci_ei)+FFQ_fC_Vci_ei);
Qf=((Qf+FFd_QfE)+FFQ_fC);
Tf_Vbi_ei=((Tf_Vbi_ei+FFd_TfE_Vbi_ei)+FFT_fC_Vbi_ei);
Tf_Vbi_ci=((Tf_Vbi_ci+FFd_TfE_Vbi_ci)+FFT_fC_Vbi_ci);
Tf_Vtnode_GND=((Tf_Vtnode_GND+FFd_TfE_Vtnode_GND)+FFT_fC_Vtnode_GND);
Tf_Vci_ei=((Tf_Vci_ei+FFd_TfE_Vci_ei)+FFT_fC_Vci_ei);
if (doAC)
{
Tf=((Tf+FFd_TfE)+FFT_fC);
}
}
Qr_Vbi_ei=(Tr*itr_Vbi_ei);
Qr_Vbi_ci=(Tr*itr_Vbi_ci);
Qr_Vtnode_GND=(Tr*itr_Vtnode_GND);
Qr_Vci_ei=(Tr*itr_Vci_ei);
if (doAC)
{
Qr=(Tr*itr);
}
}
it_Vbi_ci=(itf_Vbi_ci-itr_Vbi_ci);
it_Vbi_ei=(itf_Vbi_ei-itr_Vbi_ei);
it_Vtnode_GND=(itf_Vtnode_GND-itr_Vtnode_GND);
it_Vci_ei=(itf_Vci_ei-itr_Vci_ei);
it=(itf-itr);
Qdei_Vbi_ei=Qf_Vbi_ei;
Qdei_Vbi_ci=Qf_Vbi_ci;
Qdei_Vtnode_GND=Qf_Vtnode_GND;
Qdei_Vci_ei=Qf_Vci_ei;
if (doAC)
{
Qdei=Qf;
}
Qdci_Vbi_ei=Qr_Vbi_ei;
Qdci_Vbi_ci=Qr_Vbi_ci;
Qdci_Vtnode_GND=Qr_Vtnode_GND;
Qdci_Vci_ei=Qr_Vci_ei;
if (doAC)
{
Qdci=Qr;
}
qrbi_Vbi_ci=(fcrbi*(((+Qdei_Vbi_ci)+Qjci_Vbi_ci)+Qdci_Vbi_ci));
qrbi_Vci_ei=(fcrbi*((+Qdei_Vci_ei)+Qdci_Vci_ei));
qrbi_Vbi_ei=(fcrbi*(((Qjei_Vbi_ei+Qdei_Vbi_ei)+Qjci_Vbi_ei)+Qdci_Vbi_ei));
qrbi_Vtnode_GND=(fcrbi*(((Qjei_Vtnode_GND+Qdei_Vtnode_GND)+Qjci_Vtnode_GND)+Qdci_Vtnode_GND));
if (doAC)
{
qrbi=(fcrbi*(((Qjei+Qdei)+Qjci)+Qdci));
}
DIOY_Vtnode_GND=(-(BP(bi,ci)*(mbci*VT_Vtnode_GND))/((mbci*VT)*(mbci*VT)));
DIOY_Vbi_ci=(1/(mbci*VT));
DIOY=(BP(bi,ci)/(mbci*VT));
DIOY_Vsi_ci=0.0;
DIOY_Vbp_ci=0.0;
DIOY_Vbp_ei=0.0;
DIOY_Vbi_ei=0.0;
if ((ibcis>0.0))
{
if ((DIOY>80.0))
{
le_Vtnode_GND=(+DIOY_Vtnode_GND);
le_Vbi_ei=(+DIOY_Vbi_ei);
le_Vbi_ci=(+DIOY_Vbi_ci);
le=(1+(DIOY-80.0));
le_Vsi_ci=0.0;
le_Vbp_ci=0.0;
le_Vbp_ei=0.0;
DIOY=80.0;
DIOY_Vsi_ci=0.0;
DIOY_Vbp_ci=0.0;
DIOY_Vbp_ei=0.0;
DIOY_Vbi_ci=0.0;
DIOY_Vbi_ei=0.0;
DIOY_Vtnode_GND=0.0;
}
else
{
le=1;
le_Vsi_ci=0.0;
le_Vbp_ci=0.0;
le_Vbp_ei=0.0;
le_Vbi_ci=0.0;
le_Vbi_ei=0.0;
le_Vtnode_GND=0.0;
}
{
double __limexp_0=0.0;
double __d_limexp_0=0.0;
_d_limexp(__limexp_0,__d_limexp_0,(DIOY));
_limexp(__limexp_0,(DIOY));
le_Vtnode_GND=((le_Vtnode_GND*__limexp_0)+(le*DIOY_Vtnode_GND*__d_limexp_0));
le_Vbi_ei=((le_Vbi_ei*__limexp_0)+(le*DIOY_Vbi_ei*__d_limexp_0));
le_Vbi_ci=((le_Vbi_ci*__limexp_0)+(le*DIOY_Vbi_ci*__d_limexp_0));
le=(le*__limexp_0);
le_Vsi_ci=0.0;
le_Vbp_ci=0.0;
le_Vbp_ei=0.0;
}
ibci_Vbi_ei=(ibcis_t*le_Vbi_ei);
ibci_Vbi_ci=(ibcis_t*le_Vbi_ci);
ibci_Vtnode_GND=((ibcis_t_Vtnode_GND*(le-1.0))+(ibcis_t*le_Vtnode_GND));
ibci=(ibcis_t*(le-1.0));
if ((DIOY<=(-14.0)))
{
ibci_Vtnode_GND=(-ibcis_t_Vtnode_GND);
ibci=(-ibcis_t);
ibci_Vbi_ci=0.0;
ibci_Vbi_ei=0.0;
}
}
else
{
ibci=0.0;
ibci_Vtnode_GND=0.0;
ibci_Vbi_ci=0.0;
ibci_Vbi_ei=0.0;
}
if ((((BP(bi,ci)<0.0)&&(favl_t>0.0))&&(cjci0_t>0.0)))
{
AVLv_bord_Vbi_ci=(-1.0);
AVLv_bord_Vtnode_GND=vdci_t_Vtnode_GND;
AVLv_bord=(vdci_t-BP(bi,ci));
AVLv_q_Vbi_ci=(-(qavl_t*Cjci_Vbi_ci)/(Cjci*Cjci));
AVLv_q_Vbi_ei=(-(qavl_t*Cjci_Vbi_ei)/(Cjci*Cjci));
AVLv_q_Vtnode_GND=(qavl_t_Vtnode_GND*Cjci-qavl_t*Cjci_Vtnode_GND)/(Cjci*Cjci);
AVLv_q=(qavl_t/Cjci);
AVLU0_Vtnode_GND=(qavl_t_Vtnode_GND*cjci0_t-qavl_t*cjci0_t_Vtnode_GND)/(cjci0_t*cjci0_t);
AVLU0=(qavl_t/cjci0_t);
if ((AVLv_bord>AVLU0))
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(((-AVLv_q)/AVLU0)));
_exp(__exp_0,(((-AVLv_q)/AVLU0)));
AVLa_Vbi_ci=(favl_t*(-AVLv_q_Vbi_ci)/AVLU0*__d_exp_0);
AVLa_Vbi_ei=(favl_t*(-AVLv_q_Vbi_ei)/AVLU0*__d_exp_0);
AVLa_Vtnode_GND=((favl_t_Vtnode_GND*__exp_0)+(favl_t*((-AVLv_q_Vtnode_GND)*AVLU0-(-AVLv_q)*AVLU0_Vtnode_GND)/(AVLU0*AVLU0)*__d_exp_0));
AVLa=(favl_t*__exp_0);
}
AVLS_avl_Vbi_ci=((AVLa_Vbi_ci*(AVLU0+((1.0+(AVLv_q/AVLU0))*(AVLv_bord-AVLU0))))+(AVLa*(+(((+AVLv_q_Vbi_ci/AVLU0)*(AVLv_bord-AVLU0))+((1.0+(AVLv_q/AVLU0))*AVLv_bord_Vbi_ci)))));
AVLS_avl_Vbi_ei=((AVLa_Vbi_ei*(AVLU0+((1.0+(AVLv_q/AVLU0))*(AVLv_bord-AVLU0))))+(AVLa*(+(+AVLv_q_Vbi_ei/AVLU0)*(AVLv_bord-AVLU0))));
AVLS_avl_Vtnode_GND=((AVLa_Vtnode_GND*(AVLU0+((1.0+(AVLv_q/AVLU0))*(AVLv_bord-AVLU0))))+(AVLa*(AVLU0_Vtnode_GND+(((+(AVLv_q_Vtnode_GND*AVLU0-AVLv_q*AVLU0_Vtnode_GND)/(AVLU0*AVLU0))*(AVLv_bord-AVLU0))+((1.0+(AVLv_q/AVLU0))*(AVLv_bord_Vtnode_GND-AVLU0_Vtnode_GND))))));
AVLS_avl=(AVLa*(AVLU0+((1.0+(AVLv_q/AVLU0))*(AVLv_bord-AVLU0))));
}
else
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(((-AVLv_q)/AVLv_bord)));
_exp(__exp_0,(((-AVLv_q)/AVLv_bord)));
AVLS_avl_Vbi_ei=((favl_t*AVLv_bord)*(-AVLv_q_Vbi_ei)/AVLv_bord*__d_exp_0);
AVLS_avl_Vbi_ci=(((favl_t*AVLv_bord_Vbi_ci)*__exp_0)+((favl_t*AVLv_bord)*((-AVLv_q_Vbi_ci)*AVLv_bord-(-AVLv_q)*AVLv_bord_Vbi_ci)/(AVLv_bord*AVLv_bord)*__d_exp_0));
AVLS_avl_Vtnode_GND=((((favl_t_Vtnode_GND*AVLv_bord)+(favl_t*AVLv_bord_Vtnode_GND))*__exp_0)+((favl_t*AVLv_bord)*((-AVLv_q_Vtnode_GND)*AVLv_bord-(-AVLv_q)*AVLv_bord_Vtnode_GND)/(AVLv_bord*AVLv_bord)*__d_exp_0));
AVLS_avl=((favl_t*AVLv_bord)*__exp_0);
}
}
iavl_Vbi_ci=((itf_Vbi_ci*AVLS_avl)+(itf*AVLS_avl_Vbi_ci));
iavl_Vbi_ei=((itf_Vbi_ei*AVLS_avl)+(itf*AVLS_avl_Vbi_ei));
iavl_Vtnode_GND=((itf_Vtnode_GND*AVLS_avl)+(itf*AVLS_avl_Vtnode_GND));
iavl_Vci_ei=itf_Vci_ei*AVLS_avl;
iavl=(itf*AVLS_avl);
}
else
{
iavl=0.0;
iavl_Vci_ei=0.0;
iavl_Vtnode_GND=0.0;
iavl_Vbi_ei=0.0;
iavl_Vbi_ci=0.0;
}
if ((rbi0_t>0.0))
{
f_QR_Vtnode_GND=((1+fdqr0)*qp0_t_Vtnode_GND);
f_QR=((1+fdqr0)*qp0_t);
Qz_Vbi_ci=(+Qf_Vbi_ci);
Qz_Vci_ei=(+Qf_Vci_ei);
Qz_Vbi_ei=(Qjei_Vbi_ei+Qf_Vbi_ei);
Qz_Vtnode_GND=(Qjei_Vtnode_GND+Qf_Vtnode_GND);
Qz=(Qjei+Qf);
if ((Qf>0.0))
{
Q_fi_Vbi_ei=Qf_Vbi_ei*fqi;
Q_fi_Vbi_ci=Qf_Vbi_ci*fqi;
Q_fi_Vtnode_GND=Qf_Vtnode_GND*fqi;
Q_fi_Vci_ei=Qf_Vci_ei*fqi;
Q_fi=(Qf*fqi);
f_p_Vbi_ci=((+Q_fi_Vbi_ci)*Qz-(Qjei+Q_fi)*Qz_Vbi_ci)/(Qz*Qz);
f_p_Vci_ei=((+Q_fi_Vci_ei)*Qz-(Qjei+Q_fi)*Qz_Vci_ei)/(Qz*Qz);
f_p_Vbi_ei=((Qjei_Vbi_ei+Q_fi_Vbi_ei)*Qz-(Qjei+Q_fi)*Qz_Vbi_ei)/(Qz*Qz);
f_p_Vtnode_GND=((Qjei_Vtnode_GND+Q_fi_Vtnode_GND)*Qz-(Qjei+Q_fi)*Qz_Vtnode_GND)/(Qz*Qz);
f_p=((Qjei+Q_fi)/Qz);
}
else
{
f_p=1.0;
f_p_Vtnode_GND=0.0;
f_p_Vbi_ei=0.0;
f_p_Vci_ei=0.0;
f_p_Vbi_ci=0.0;
}
rbi_Vbi_ci=(-((rbi0_t*f_QR)*(+Qz_Vbi_ci))/((f_QR+Qz)*(f_QR+Qz)));
rbi_Vci_ei=(-((rbi0_t*f_QR)*(+Qz_Vci_ei))/((f_QR+Qz)*(f_QR+Qz)));
rbi_Vbi_ei=(-((rbi0_t*f_QR)*(+Qz_Vbi_ei))/((f_QR+Qz)*(f_QR+Qz)));
rbi_Vtnode_GND=(((rbi0_t_Vtnode_GND*f_QR)+(rbi0_t*f_QR_Vtnode_GND))*(f_QR+Qz)-(rbi0_t*f_QR)*(f_QR_Vtnode_GND+Qz_Vtnode_GND))/((f_QR+Qz)*(f_QR+Qz));
rbi=((rbi0_t*f_QR)/(f_QR+Qz));
I_BI_Vbi_ei=ibei_Vbi_ei;
I_BI_Vtnode_GND=ibei_Vtnode_GND;
I_BI=ibei;
if ((I_BI>=1.0e-20))
{
ETA_Vbi_ci=rbi_Vbi_ci*I_BI*fgeo/VT;
ETA_Vci_ei=rbi_Vci_ei*I_BI*fgeo/VT;
ETA_Vbi_ei=((rbi_Vbi_ei*I_BI)+(rbi*I_BI_Vbi_ei))*fgeo/VT;
ETA_Vtnode_GND=(((rbi_Vtnode_GND*I_BI)+(rbi*I_BI_Vtnode_GND))*fgeo*VT-((rbi*I_BI)*fgeo)*VT_Vtnode_GND)/(VT*VT);
ETA=(((rbi*I_BI)*fgeo)/VT);
if ((ETA>=1.0e-3))
{
if ((ETA<0.02))
{
rbi_Vbi_ci=((rbi_Vbi_ci*(1.0-(0.5*ETA)))+(rbi*(-(0.5*ETA_Vbi_ci))));
rbi_Vci_ei=((rbi_Vci_ei*(1.0-(0.5*ETA)))+(rbi*(-(0.5*ETA_Vci_ei))));
rbi_Vbi_ei=((rbi_Vbi_ei*(1.0-(0.5*ETA)))+(rbi*(-(0.5*ETA_Vbi_ei))));
rbi_Vtnode_GND=((rbi_Vtnode_GND*(1.0-(0.5*ETA)))+(rbi*(-(0.5*ETA_Vtnode_GND))));
rbi=(rbi*(1.0-(0.5*ETA)));
}
else
{
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0+ETA)));
_logE(__logE_0,((1.0+ETA)));
rbi_Vbi_ci=(((rbi_Vbi_ci*__logE_0)+(rbi*(+ETA_Vbi_ci)*__d_logE_0))*ETA-(rbi*__logE_0)*ETA_Vbi_ci)/(ETA*ETA);
rbi_Vci_ei=(((rbi_Vci_ei*__logE_0)+(rbi*(+ETA_Vci_ei)*__d_logE_0))*ETA-(rbi*__logE_0)*ETA_Vci_ei)/(ETA*ETA);
rbi_Vbi_ei=(((rbi_Vbi_ei*__logE_0)+(rbi*(+ETA_Vbi_ei)*__d_logE_0))*ETA-(rbi*__logE_0)*ETA_Vbi_ei)/(ETA*ETA);
rbi_Vtnode_GND=(((rbi_Vtnode_GND*__logE_0)+(rbi*(+ETA_Vtnode_GND)*__d_logE_0))*ETA-(rbi*__logE_0)*ETA_Vtnode_GND)/(ETA*ETA);
rbi=((rbi*__logE_0)/ETA);
}
}
}
}
rbi_Vbi_ci=((rbi_Vbi_ci*f_p)+(rbi*f_p_Vbi_ci));
rbi_Vci_ei=((rbi_Vci_ei*f_p)+(rbi*f_p_Vci_ei));
rbi_Vbi_ei=((rbi_Vbi_ei*f_p)+(rbi*f_p_Vbi_ei));
rbi_Vtnode_GND=((rbi_Vtnode_GND*f_p)+(rbi*f_p_Vtnode_GND));
rbi=(rbi*f_p);
}
else
{
rbi=0.0;
rbi_Vtnode_GND=0.0;
rbi_Vbi_ei=0.0;
rbi_Vci_ei=0.0;
rbi_Vbi_ci=0.0;
}
DIOY_Vtnode_GND=(-(BP(bp,ei)*(mbep*VT_Vtnode_GND))/((mbep*VT)*(mbep*VT)));
DIOY_Vbp_ei=(1/(mbep*VT));
DIOY=(BP(bp,ei)/(mbep*VT));
DIOY_Vsi_ci=0.0;
DIOY_Vbp_ci=0.0;
DIOY_Vbi_ci=0.0;
DIOY_Vbi_ei=0.0;
if ((ibeps>0.0))
{
if ((DIOY>80.0))
{
le_Vtnode_GND=(+DIOY_Vtnode_GND);
le_Vbi_ei=(+DIOY_Vbi_ei);
le_Vbi_ci=(+DIOY_Vbi_ci);
le_Vbp_ei=(+DIOY_Vbp_ei);
le=(1+(DIOY-80.0));
le_Vsi_ci=0.0;
le_Vbp_ci=0.0;
DIOY=80.0;
DIOY_Vsi_ci=0.0;
DIOY_Vbp_ci=0.0;
DIOY_Vbp_ei=0.0;
DIOY_Vbi_ci=0.0;
DIOY_Vbi_ei=0.0;
DIOY_Vtnode_GND=0.0;
}
else
{
le=1;
le_Vsi_ci=0.0;
le_Vbp_ci=0.0;
le_Vbp_ei=0.0;
le_Vbi_ci=0.0;
le_Vbi_ei=0.0;
le_Vtnode_GND=0.0;
}
{
double __limexp_0=0.0;
double __d_limexp_0=0.0;
_d_limexp(__limexp_0,__d_limexp_0,(DIOY));
_limexp(__limexp_0,(DIOY));
le_Vtnode_GND=((le_Vtnode_GND*__limexp_0)+(le*DIOY_Vtnode_GND*__d_limexp_0));
le_Vbi_ei=((le_Vbi_ei*__limexp_0)+(le*DIOY_Vbi_ei*__d_limexp_0));
le_Vbi_ci=((le_Vbi_ci*__limexp_0)+(le*DIOY_Vbi_ci*__d_limexp_0));
le_Vbp_ei=((le_Vbp_ei*__limexp_0)+(le*DIOY_Vbp_ei*__d_limexp_0));
le=(le*__limexp_0);
le_Vsi_ci=0.0;
le_Vbp_ci=0.0;
}
ibep_Vbi_ei=(ibeps_t*le_Vbi_ei);
ibep_Vbi_ci=(ibeps_t*le_Vbi_ci);
ibep_Vbp_ei=(ibeps_t*le_Vbp_ei);
ibep_Vtnode_GND=((ibeps_t_Vtnode_GND*(le-1.0))+(ibeps_t*le_Vtnode_GND));
ibep=(ibeps_t*(le-1.0));
if ((DIOY<=(-14.0)))
{
ibep_Vtnode_GND=(-ibeps_t_Vtnode_GND);
ibep=(-ibeps_t);
ibep_Vbp_ei=0.0;
ibep_Vbi_ci=0.0;
ibep_Vbi_ei=0.0;
}
}
else
{
ibep=0.0;
ibep_Vtnode_GND=0.0;
ibep_Vbp_ei=0.0;
ibep_Vbi_ci=0.0;
ibep_Vbi_ei=0.0;
}
DIOY_Vtnode_GND=(-(BP(bp,ei)*(mrep*VT_Vtnode_GND))/((mrep*VT)*(mrep*VT)));
DIOY_Vbp_ei=(1/(mrep*VT));
DIOY=(BP(bp,ei)/(mrep*VT));
DIOY_Vsi_ci=0.0;
DIOY_Vbp_ci=0.0;
DIOY_Vbi_ci=0.0;
DIOY_Vbi_ei=0.0;
if ((ireps>0.0))
{
if ((DIOY>80.0))
{
le_Vtnode_GND=(+DIOY_Vtnode_GND);
le_Vbi_ei=(+DIOY_Vbi_ei);
le_Vbi_ci=(+DIOY_Vbi_ci);
le_Vbp_ei=(+DIOY_Vbp_ei);
le=(1+(DIOY-80.0));
le_Vsi_ci=0.0;
le_Vbp_ci=0.0;
DIOY=80.0;
DIOY_Vsi_ci=0.0;
DIOY_Vbp_ci=0.0;
DIOY_Vbp_ei=0.0;
DIOY_Vbi_ci=0.0;
DIOY_Vbi_ei=0.0;
DIOY_Vtnode_GND=0.0;
}
else
{
le=1;
le_Vsi_ci=0.0;
le_Vbp_ci=0.0;
le_Vbp_ei=0.0;
le_Vbi_ci=0.0;
le_Vbi_ei=0.0;
le_Vtnode_GND=0.0;
}
{
double __limexp_0=0.0;
double __d_limexp_0=0.0;
_d_limexp(__limexp_0,__d_limexp_0,(DIOY));
_limexp(__limexp_0,(DIOY));
le_Vtnode_GND=((le_Vtnode_GND*__limexp_0)+(le*DIOY_Vtnode_GND*__d_limexp_0));
le_Vbi_ei=((le_Vbi_ei*__limexp_0)+(le*DIOY_Vbi_ei*__d_limexp_0));
le_Vbi_ci=((le_Vbi_ci*__limexp_0)+(le*DIOY_Vbi_ci*__d_limexp_0));
le_Vbp_ei=((le_Vbp_ei*__limexp_0)+(le*DIOY_Vbp_ei*__d_limexp_0));
le=(le*__limexp_0);
le_Vsi_ci=0.0;
le_Vbp_ci=0.0;
}
irep_Vbi_ei=(ireps_t*le_Vbi_ei);
irep_Vbi_ci=(ireps_t*le_Vbi_ci);
irep_Vbp_ei=(ireps_t*le_Vbp_ei);
irep_Vtnode_GND=((ireps_t_Vtnode_GND*(le-1.0))+(ireps_t*le_Vtnode_GND));
irep=(ireps_t*(le-1.0));
if ((DIOY<=(-14.0)))
{
irep_Vtnode_GND=(-ireps_t_Vtnode_GND);
irep=(-ireps_t);
irep_Vbp_ei=0.0;
irep_Vbi_ci=0.0;
irep_Vbi_ei=0.0;
}
}
else
{
irep=0.0;
irep_Vtnode_GND=0.0;
irep_Vbp_ei=0.0;
irep_Vbi_ci=0.0;
irep_Vbi_ei=0.0;
}
if ((cjep0_t>0.0))
{
{
double __logE_0=0.0;
double __exp_1=0.0;
double __d_logE_0=0.0;
double __d_exp_1=0.0;
_d_logE(__logE_0,__d_logE_0,(aljep_t));
_d_exp(__exp_1,__d_exp_1,(((-__logE_0)/zep)));
_logE(__logE_0,(aljep_t));
_exp(__exp_1,(((-__logE_0)/zep)));
DFV_f_Vtnode_GND=((vdep_t_Vtnode_GND*(1.0-__exp_1))+(vdep_t*(-(-aljep_t_Vtnode_GND*__d_logE_0)/zep*__d_exp_1)));
DFV_f=(vdep_t*(1.0-__exp_1));
}
DFC_max_Vtnode_GND=((aljep_t_Vtnode_GND*cjep0_t)+(aljep_t*cjep0_t_Vtnode_GND));
DFC_max=(aljep_t*cjep0_t);
DFv_e_Vbp_ei=(-1.0)/VT;
DFv_e_Vtnode_GND=(DFV_f_Vtnode_GND*VT-(DFV_f-BP(bp,ei))*VT_Vtnode_GND)/(VT*VT);
DFv_e=((DFV_f-BP(bp,ei))/VT);
DFv_e_Vsi_ci=0.0;
DFv_e_Vb_ci=0.0;
DFv_e_Vbp_ci=0.0;
DFv_e_Vbi_ci=0.0;
DFv_e_Vbi_ei=0.0;
if ((DFv_e<80.0))
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(DFv_e));
_exp(__exp_0,(DFv_e));
DFe_Vbi_ei=DFv_e_Vbi_ei*__d_exp_0;
DFe_Vtnode_GND=DFv_e_Vtnode_GND*__d_exp_0;
DFe_Vbi_ci=DFv_e_Vbi_ci*__d_exp_0;
DFe_Vbp_ei=DFv_e_Vbp_ei*__d_exp_0;
DFe=__exp_0;
DFe_Vsi_ci=0.0;
DFe_Vb_ci=0.0;
DFe_Vbp_ci=0.0;
}
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0+DFe)));
_logE(__logE_0,((1.0+DFe)));
DFv_j_Vbi_ei=(-(VT*(+DFe_Vbi_ei)*__d_logE_0));
DFv_j_Vbi_ci=(-(VT*(+DFe_Vbi_ci)*__d_logE_0));
DFv_j_Vbp_ei=(-(VT*(+DFe_Vbp_ei)*__d_logE_0));
DFv_j_Vtnode_GND=(DFV_f_Vtnode_GND-((VT_Vtnode_GND*__logE_0)+(VT*(+DFe_Vtnode_GND)*__d_logE_0)));
DFv_j=(DFV_f-(VT*__logE_0));
DFv_j_Vsi_ci=0.0;
DFv_j_Vb_ci=0.0;
DFv_j_Vbp_ci=0.0;
}
DFdvj_dv_Vbi_ei=(DFe_Vbi_ei*(1.0+DFe)-DFe*(+DFe_Vbi_ei))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv_Vtnode_GND=(DFe_Vtnode_GND*(1.0+DFe)-DFe*(+DFe_Vtnode_GND))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv_Vbi_ci=(DFe_Vbi_ci*(1.0+DFe)-DFe*(+DFe_Vbi_ci))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv_Vbp_ei=(DFe_Vbp_ei*(1.0+DFe)-DFe*(+DFe_Vbp_ei))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv=(DFe/(1.0+DFe));
DFdvj_dv_Vsi_ci=0.0;
DFdvj_dv_Vb_ci=0.0;
DFdvj_dv_Vbp_ci=0.0;
}
else
{
DFv_j_Vbp_ei=1.0;
DFv_j=BP(bp,ei);
DFv_j_Vsi_ci=0.0;
DFv_j_Vb_ci=0.0;
DFv_j_Vbp_ci=0.0;
DFv_j_Vbi_ci=0.0;
DFv_j_Vtnode_GND=0.0;
DFv_j_Vbi_ei=0.0;
DFdvj_dv=1;
DFdvj_dv_Vsi_ci=0.0;
DFdvj_dv_Vb_ci=0.0;
DFdvj_dv_Vbp_ci=0.0;
DFdvj_dv_Vbp_ei=0.0;
DFdvj_dv_Vbi_ci=0.0;
DFdvj_dv_Vtnode_GND=0.0;
DFdvj_dv_Vbi_ei=0.0;
}
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0-(DFv_j/vdep_t))));
_logE(__logE_0,((1.0-(DFv_j/vdep_t))));
DFb_Vbi_ei=(-DFv_j_Vbi_ei/vdep_t)*__d_logE_0;
DFb_Vtnode_GND=(-(DFv_j_Vtnode_GND*vdep_t-DFv_j*vdep_t_Vtnode_GND)/(vdep_t*vdep_t))*__d_logE_0;
DFb_Vbi_ci=(-DFv_j_Vbi_ci/vdep_t)*__d_logE_0;
DFb_Vbp_ei=(-DFv_j_Vbp_ei/vdep_t)*__d_logE_0;
DFb=__logE_0;
DFb_Vsi_ci=0.0;
DFb_Vb_ci=0.0;
DFb_Vbp_ci=0.0;
}
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(((-zep)*DFb)));
_exp(__exp_0,(((-zep)*DFb)));
DFC_j1_Vbi_ei=(((cjep0_t*((-zep)*DFb_Vbi_ei)*__d_exp_0)*DFdvj_dv)+((cjep0_t*__exp_0)*DFdvj_dv_Vbi_ei));
DFC_j1_Vbi_ci=(((cjep0_t*((-zep)*DFb_Vbi_ci)*__d_exp_0)*DFdvj_dv)+((cjep0_t*__exp_0)*DFdvj_dv_Vbi_ci));
DFC_j1_Vbp_ei=(((cjep0_t*((-zep)*DFb_Vbp_ei)*__d_exp_0)*DFdvj_dv)+((cjep0_t*__exp_0)*DFdvj_dv_Vbp_ei));
DFC_j1_Vtnode_GND=((((cjep0_t_Vtnode_GND*__exp_0)+(cjep0_t*((-zep)*DFb_Vtnode_GND)*__d_exp_0))*DFdvj_dv)+((cjep0_t*__exp_0)*DFdvj_dv_Vtnode_GND));
DFC_j1=((cjep0_t*__exp_0)*DFdvj_dv);
DFC_j1_Vsi_ci=0.0;
DFC_j1_Vb_ci=0.0;
DFC_j1_Vbp_ci=0.0;
}
Cjep_Vbi_ei=(DFC_j1_Vbi_ei+(DFC_max*(-DFdvj_dv_Vbi_ei)));
Cjep_Vtnode_GND=(DFC_j1_Vtnode_GND+((DFC_max_Vtnode_GND*(1.0-DFdvj_dv))+(DFC_max*(-DFdvj_dv_Vtnode_GND))));
Cjep_Vbi_ci=(DFC_j1_Vbi_ci+(DFC_max*(-DFdvj_dv_Vbi_ci)));
Cjep_Vbp_ei=(DFC_j1_Vbp_ei+(DFC_max*(-DFdvj_dv_Vbp_ei)));
Cjep=(DFC_j1+(DFC_max*(1.0-DFdvj_dv)));
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DFb*(1.0-zep))));
_exp(__exp_0,((DFb*(1.0-zep))));
DFQ_j_Vbi_ei=((cjep0_t*vdep_t)*(-DFb_Vbi_ei*(1.0-zep)*__d_exp_0))/(1.0-zep);
DFQ_j_Vbi_ci=((cjep0_t*vdep_t)*(-DFb_Vbi_ci*(1.0-zep)*__d_exp_0))/(1.0-zep);
DFQ_j_Vbp_ei=((cjep0_t*vdep_t)*(-DFb_Vbp_ei*(1.0-zep)*__d_exp_0))/(1.0-zep);
DFQ_j_Vtnode_GND=((((cjep0_t_Vtnode_GND*vdep_t)+(cjep0_t*vdep_t_Vtnode_GND))*(1.0-__exp_0))+((cjep0_t*vdep_t)*(-DFb_Vtnode_GND*(1.0-zep)*__d_exp_0)))/(1.0-zep);
if (doAC)
{
DFQ_j=(((cjep0_t*vdep_t)*(1.0-__exp_0))/(1.0-zep));
}
DFQ_j_Vsi_ci=0.0;
DFQ_j_Vb_ci=0.0;
DFQ_j_Vbp_ci=0.0;
}
}
Qjep_Vbi_ei=(DFQ_j_Vbi_ei+(DFC_max*(-DFv_j_Vbi_ei)));
Qjep_Vtnode_GND=(DFQ_j_Vtnode_GND+((DFC_max_Vtnode_GND*(BP(bp,ei)-DFv_j))+(DFC_max*(-DFv_j_Vtnode_GND))));
Qjep_Vbi_ci=(DFQ_j_Vbi_ci+(DFC_max*(-DFv_j_Vbi_ci)));
Qjep_Vbp_ei=(DFQ_j_Vbp_ei+(DFC_max*(1.0-DFv_j_Vbp_ei)));
if (doAC)
{
Qjep=(DFQ_j+(DFC_max*(BP(bp,ei)-DFv_j)));
}
}
else
{
Cjep=0.0;
Cjep_Vbp_ei=0.0;
Cjep_Vbi_ci=0.0;
Cjep_Vtnode_GND=0.0;
Cjep_Vbi_ei=0.0;
if (doAC)
{
Qjep=0.0;
}
Qjep_Vbp_ei=0.0;
Qjep_Vbi_ci=0.0;
Qjep_Vtnode_GND=0.0;
Qjep_Vbi_ei=0.0;
}
if ((BP(bp,ei)<0.0))
{
if ((cjep0>0.0))
{
a_eg_Vtnode_GND=(-((vgb-(2.55e-4*Tnom))*(-(2.55e-4*Tdev_Vtnode_GND)))/((vgb-(2.55e-4*Tdev))*(vgb-(2.55e-4*Tdev))));
a_eg=((vgb-(2.55e-4*Tnom))/(vgb-(2.55e-4*Tdev)));
{
double __sqrt_0=0.0;
double __d_sqrt_0=0.0;
_d_sqrt(__sqrt_0,__d_sqrt_0,(a_eg));
_sqrt(__sqrt_0,(a_eg));
ab_Vtnode_GND=((((((cjep0_t_Vtnode_GND/cjep0*__sqrt_0)+((cjep0_t/cjep0)*a_eg_Vtnode_GND*__d_sqrt_0))*vdep_t)+(((cjep0_t/cjep0)*__sqrt_0)*vdep_t_Vtnode_GND))*vdep_t)+((((cjep0_t/cjep0)*__sqrt_0)*vdep_t)*vdep_t_Vtnode_GND))/(vdep*vdep);
ab=(((((cjep0_t/cjep0)*__sqrt_0)*vdep_t)*vdep_t)/(vdep*vdep));
}
ibets_t_Vtnode_GND=(ibets*ab_Vtnode_GND);
ibets_t=(ibets*ab);
}
else
{
ibets_t=ibets;
ibets_t_Vtnode_GND=0.0;
}
vve_Vtnode_GND=(-((-BP(bp,ei))*vdep_t_Vtnode_GND)/(vdep_t*vdep_t));
vve_Vbp_ei=(-1.0)/vdep_t;
vve=((-BP(bp,ei))/vdep_t);
cce_Vbi_ei=Cjep_Vbi_ei/cjep0_t;
cce_Vtnode_GND=(Cjep_Vtnode_GND*cjep0_t-Cjep*cjep0_t_Vtnode_GND)/(cjep0_t*cjep0_t);
cce_Vbi_ci=Cjep_Vbi_ci/cjep0_t;
cce_Vbp_ei=Cjep_Vbp_ei/cjep0_t;
cce=(Cjep/cjep0_t);
zex=(1.0/zep);
{
double __logE_0=0.0;
double __exp_1=0.0;
double __d_logE_0=0.0;
double __d_exp_1=0.0;
_d_logE(__logE_0,__d_logE_0,(cce));
_d_exp(__exp_1,__d_exp_1,(((1-zex)*__logE_0)));
_logE(__logE_0,(cce));
_exp(__exp_1,(((1-zex)*__logE_0)));
pocce_Vbi_ei=((1-zex)*cce_Vbi_ei*__d_logE_0)*__d_exp_1;
pocce_Vtnode_GND=((1-zex)*cce_Vtnode_GND*__d_logE_0)*__d_exp_1;
pocce_Vbi_ci=((1-zex)*cce_Vbi_ci*__d_logE_0)*__d_exp_1;
pocce_Vbp_ei=((1-zex)*cce_Vbp_ei*__d_logE_0)*__d_exp_1;
pocce=__exp_1;
}
czz_Vbi_ei=((ibets_t*vve)*pocce_Vbi_ei);
czz_Vbi_ci=((ibets_t*vve)*pocce_Vbi_ci);
czz_Vbp_ei=(((ibets_t*vve_Vbp_ei)*pocce)+((ibets_t*vve)*pocce_Vbp_ei));
czz_Vtnode_GND=((((ibets_t_Vtnode_GND*vve)+(ibets_t*vve_Vtnode_GND))*pocce)+((ibets_t*vve)*pocce_Vtnode_GND));
czz=((ibets_t*vve)*pocce);
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(((-abet)/pocce)));
_exp(__exp_0,(((-abet)/pocce)));
ibet_Vbi_ei=((czz_Vbi_ei*__exp_0)+(czz*(-((-abet)*pocce_Vbi_ei)/(pocce*pocce))*__d_exp_0));
ibet_Vbi_ci=((czz_Vbi_ci*__exp_0)+(czz*(-((-abet)*pocce_Vbi_ci)/(pocce*pocce))*__d_exp_0));
ibet_Vbp_ei=((czz_Vbp_ei*__exp_0)+(czz*(-((-abet)*pocce_Vbp_ei)/(pocce*pocce))*__d_exp_0));
ibet_Vtnode_GND=((czz_Vtnode_GND*__exp_0)+(czz*(-((-abet)*pocce_Vtnode_GND)/(pocce*pocce))*__d_exp_0));
ibet=(czz*__exp_0);
}
}
else
{
ibet=0.0;
ibet_Vtnode_GND=0.0;
ibet_Vbp_ei=0.0;
ibet_Vbi_ci=0.0;
ibet_Vbi_ei=0.0;
}
if ((vptcx_t<1.0e2))
{
if ((cjcx02_t>0.0))
{
if (doAC)
{
Dz_r=(zcx/4.0);
}
Dv_p_Vtnode_GND=(vptcx_t_Vtnode_GND-vdcx_t_Vtnode_GND);
if (doAC)
{
Dv_p=(vptcx_t-vdcx_t);
}
if (doAC)
{
{
double __logE_0=0.0;
double __exp_1=0.0;
_logE(__logE_0,(2.4));
_exp(__exp_1,(((-__logE_0)/zcx)));
DV_f_Vtnode_GND=vdcx_t_Vtnode_GND*(1.0-__exp_1);
if (doAC)
{
DV_f=(vdcx_t*(1.0-__exp_1));
}
}
}
DC_max_Vtnode_GND=(2.4*cjcx02_t_Vtnode_GND);
if (doAC)
{
DC_max=(2.4*cjcx02_t);
}
if (doAC)
{
{
double __logE_0=0.0;
double __exp_1=0.0;
double __d_logE_0=0.0;
double __d_exp_1=0.0;
_d_logE(__logE_0,__d_logE_0,((vptcx_t/vdcx_t)));
_d_exp(__exp_1,__d_exp_1,((__logE_0*(Dz_r-zcx))));
_logE(__logE_0,((vptcx_t/vdcx_t)));
_exp(__exp_1,((__logE_0*(Dz_r-zcx))));
DC_c_Vtnode_GND=((cjcx02_t_Vtnode_GND*__exp_1)+(cjcx02_t*(vptcx_t_Vtnode_GND*vdcx_t-vptcx_t*vdcx_t_Vtnode_GND)/(vdcx_t*vdcx_t)*__d_logE_0*(Dz_r-zcx)*__d_exp_1));
if (doAC)
{
DC_c=(cjcx02_t*__exp_1);
}
}
}
Da_Vtnode_GND=VT_Vtnode_GND;
if (doAC)
{
Da=VT;
}
Dv_e_Vbp_ci=(-1.0)/Da;
Dv_e_Vtnode_GND=(DV_f_Vtnode_GND*Da-(DV_f-BP(bp,ci))*Da_Vtnode_GND)/(Da*Da);
if (doAC)
{
Dv_e=((DV_f-BP(bp,ci))/Da);
}
Dv_e_Vsi_ci=0.0;
Dv_e_Vb_ci=0.0;
Dv_e_Vbi_ci=0.0;
if ((Dv_e<80.0))
{
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(Dv_e));
_exp(__exp_0,(Dv_e));
De_Vbi_ci=Dv_e_Vbi_ci*__d_exp_0;
De_Vtnode_GND=Dv_e_Vtnode_GND*__d_exp_0;
De_Vbp_ci=Dv_e_Vbp_ci*__d_exp_0;
if (doAC)
{
De=__exp_0;
}
De_Vsi_ci=0.0;
De_Vb_ci=0.0;
}
}
De_1_Vbi_ci=(De_Vbi_ci*(1.0+De)-De*(+De_Vbi_ci))/((1.0+De)*(1.0+De));
De_1_Vtnode_GND=(De_Vtnode_GND*(1.0+De)-De*(+De_Vtnode_GND))/((1.0+De)*(1.0+De));
De_1_Vbp_ci=(De_Vbp_ci*(1.0+De)-De*(+De_Vbp_ci))/((1.0+De)*(1.0+De));
if (doAC)
{
De_1=(De/(1.0+De));
}
De_1_Vsi_ci=0.0;
De_1_Vb_ci=0.0;
if (doAC)
{
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0+De)));
_logE(__logE_0,((1.0+De)));
Dv_j1_Vbi_ci=(-(Da*(+De_Vbi_ci)*__d_logE_0));
Dv_j1_Vbp_ci=(-(Da*(+De_Vbp_ci)*__d_logE_0));
Dv_j1_Vtnode_GND=(DV_f_Vtnode_GND-((Da_Vtnode_GND*__logE_0)+(Da*(+De_Vtnode_GND)*__d_logE_0)));
if (doAC)
{
Dv_j1=(DV_f-(Da*__logE_0));
}
Dv_j1_Vsi_ci=0.0;
Dv_j1_Vb_ci=0.0;
}
}
}
else
{
if (doAC)
{
De_1=1.0;
}
De_1_Vsi_ci=0.0;
De_1_Vb_ci=0.0;
De_1_Vbp_ci=0.0;
De_1_Vtnode_GND=0.0;
De_1_Vbi_ci=0.0;
Dv_j1_Vbp_ci=1.0;
if (doAC)
{
Dv_j1=BP(bp,ci);
}
Dv_j1_Vsi_ci=0.0;
Dv_j1_Vb_ci=0.0;
Dv_j1_Vtnode_GND=0.0;
Dv_j1_Vbi_ci=0.0;
}
Da_Vtnode_GND=((0.1*Dv_p_Vtnode_GND)+(4.0*VT_Vtnode_GND));
if (doAC)
{
Da=((0.1*Dv_p)+(4.0*VT));
}
Dv_r_Vbi_ci=(+Dv_j1_Vbi_ci)/Da;
Dv_r_Vbp_ci=(+Dv_j1_Vbp_ci)/Da;
Dv_r_Vtnode_GND=((Dv_p_Vtnode_GND+Dv_j1_Vtnode_GND)*Da-(Dv_p+Dv_j1)*Da_Vtnode_GND)/(Da*Da);
if (doAC)
{
Dv_r=((Dv_p+Dv_j1)/Da);
}
Dv_r_Vsi_ci=0.0;
Dv_r_Vb_ci=0.0;
if ((Dv_r<80.0))
{
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(Dv_r));
_exp(__exp_0,(Dv_r));
De_Vbi_ci=Dv_r_Vbi_ci*__d_exp_0;
De_Vtnode_GND=Dv_r_Vtnode_GND*__d_exp_0;
De_Vbp_ci=Dv_r_Vbp_ci*__d_exp_0;
if (doAC)
{
De=__exp_0;
}
De_Vsi_ci=0.0;
De_Vb_ci=0.0;
}
}
De_2_Vbi_ci=(De_Vbi_ci*(1.0+De)-De*(+De_Vbi_ci))/((1.0+De)*(1.0+De));
De_2_Vtnode_GND=(De_Vtnode_GND*(1.0+De)-De*(+De_Vtnode_GND))/((1.0+De)*(1.0+De));
De_2_Vbp_ci=(De_Vbp_ci*(1.0+De)-De*(+De_Vbp_ci))/((1.0+De)*(1.0+De));
if (doAC)
{
De_2=(De/(1.0+De));
}
De_2_Vsi_ci=0.0;
De_2_Vb_ci=0.0;
if (doAC)
{
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0+De)));
_logE(__logE_0,((1.0+De)));
Dv_j2_Vbi_ci=(+(Da*(+De_Vbi_ci)*__d_logE_0));
Dv_j2_Vbp_ci=(+(Da*(+De_Vbp_ci)*__d_logE_0));
Dv_j2_Vtnode_GND=((-Dv_p_Vtnode_GND)+((Da_Vtnode_GND*__logE_0)+(Da*(+De_Vtnode_GND)*__d_logE_0)));
if (doAC)
{
Dv_j2=((-Dv_p)+(Da*__logE_0));
}
Dv_j2_Vsi_ci=0.0;
Dv_j2_Vb_ci=0.0;
}
}
}
else
{
if (doAC)
{
De_2=1.0;
}
De_2_Vsi_ci=0.0;
De_2_Vb_ci=0.0;
De_2_Vbp_ci=0.0;
De_2_Vtnode_GND=0.0;
De_2_Vbi_ci=0.0;
Dv_j2_Vbi_ci=Dv_j1_Vbi_ci;
Dv_j2_Vtnode_GND=Dv_j1_Vtnode_GND;
Dv_j2_Vbp_ci=Dv_j1_Vbp_ci;
if (doAC)
{
Dv_j2=Dv_j1;
}
Dv_j2_Vsi_ci=0.0;
Dv_j2_Vb_ci=0.0;
}
Dv_j4_Vbi_ci=(-Dv_j1_Vbi_ci);
Dv_j4_Vtnode_GND=(-Dv_j1_Vtnode_GND);
Dv_j4_Vbp_ci=(1.0-Dv_j1_Vbp_ci);
if (doAC)
{
Dv_j4=(BP(bp,ci)-Dv_j1);
}
Dv_j4_Vsi_ci=0.0;
Dv_j4_Vb_ci=0.0;
if (doAC)
{
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0-(Dv_j1/vdcx_t))));
_logE(__logE_0,((1.0-(Dv_j1/vdcx_t))));
DCln1_Vbi_ci=(-Dv_j1_Vbi_ci/vdcx_t)*__d_logE_0;
DCln1_Vtnode_GND=(-(Dv_j1_Vtnode_GND*vdcx_t-Dv_j1*vdcx_t_Vtnode_GND)/(vdcx_t*vdcx_t))*__d_logE_0;
DCln1_Vbp_ci=(-Dv_j1_Vbp_ci/vdcx_t)*__d_logE_0;
if (doAC)
{
DCln1=__logE_0;
}
DCln1_Vsi_ci=0.0;
DCln1_Vb_ci=0.0;
}
}
if (doAC)
{
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0-(Dv_j2/vdcx_t))));
_logE(__logE_0,((1.0-(Dv_j2/vdcx_t))));
DCln2_Vbi_ci=(-Dv_j2_Vbi_ci/vdcx_t)*__d_logE_0;
DCln2_Vtnode_GND=(-(Dv_j2_Vtnode_GND*vdcx_t-Dv_j2*vdcx_t_Vtnode_GND)/(vdcx_t*vdcx_t))*__d_logE_0;
DCln2_Vbp_ci=(-Dv_j2_Vbp_ci/vdcx_t)*__d_logE_0;
if (doAC)
{
DCln2=__logE_0;
}
DCln2_Vsi_ci=0.0;
DCln2_Vb_ci=0.0;
}
}
if (doAC)
{
Dz1=(1.0-zcx);
}
if (doAC)
{
Dzr1=(1.0-Dz_r);
}
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DCln2*(-zcx))));
_exp(__exp_0,((DCln2*(-zcx))));
DC_j1_Vbi_ci=(((((cjcx02_t*DCln2_Vbi_ci*(-zcx)*__d_exp_0)*De_1)+((cjcx02_t*__exp_0)*De_1_Vbi_ci))*De_2)+(((cjcx02_t*__exp_0)*De_1)*De_2_Vbi_ci));
DC_j1_Vbp_ci=(((((cjcx02_t*DCln2_Vbp_ci*(-zcx)*__d_exp_0)*De_1)+((cjcx02_t*__exp_0)*De_1_Vbp_ci))*De_2)+(((cjcx02_t*__exp_0)*De_1)*De_2_Vbp_ci));
DC_j1_Vtnode_GND=((((((cjcx02_t_Vtnode_GND*__exp_0)+(cjcx02_t*DCln2_Vtnode_GND*(-zcx)*__d_exp_0))*De_1)+((cjcx02_t*__exp_0)*De_1_Vtnode_GND))*De_2)+(((cjcx02_t*__exp_0)*De_1)*De_2_Vtnode_GND));
if (doAC)
{
DC_j1=(((cjcx02_t*__exp_0)*De_1)*De_2);
}
DC_j1_Vsi_ci=0.0;
DC_j1_Vb_ci=0.0;
}
}
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DCln1*(-Dz_r))));
_exp(__exp_0,((DCln1*(-Dz_r))));
DC_j2_Vbi_ci=(((DC_c*DCln1_Vbi_ci*(-Dz_r)*__d_exp_0)*(1.0-De_2))+((DC_c*__exp_0)*(-De_2_Vbi_ci)));
DC_j2_Vbp_ci=(((DC_c*DCln1_Vbp_ci*(-Dz_r)*__d_exp_0)*(1.0-De_2))+((DC_c*__exp_0)*(-De_2_Vbp_ci)));
DC_j2_Vtnode_GND=((((DC_c_Vtnode_GND*__exp_0)+(DC_c*DCln1_Vtnode_GND*(-Dz_r)*__d_exp_0))*(1.0-De_2))+((DC_c*__exp_0)*(-De_2_Vtnode_GND)));
if (doAC)
{
DC_j2=((DC_c*__exp_0)*(1.0-De_2));
}
DC_j2_Vsi_ci=0.0;
DC_j2_Vb_ci=0.0;
}
}
DC_j3_Vbi_ci=(DC_max*(-De_1_Vbi_ci));
DC_j3_Vbp_ci=(DC_max*(-De_1_Vbp_ci));
DC_j3_Vtnode_GND=((DC_max_Vtnode_GND*(1.0-De_1))+(DC_max*(-De_1_Vtnode_GND)));
if (doAC)
{
DC_j3=(DC_max*(1.0-De_1));
}
DC_j3_Vsi_ci=0.0;
DC_j3_Vb_ci=0.0;
if (doAC)
{
cjcx0_t_ii=((DC_j1+DC_j2)+DC_j3);
}
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DCln2*Dz1)));
_exp(__exp_0,((DCln2*Dz1)));
DQ_j1_Vbi_ci=(cjcx02_t*(-DCln2_Vbi_ci*Dz1*__d_exp_0))/Dz1;
DQ_j1_Vbp_ci=(cjcx02_t*(-DCln2_Vbp_ci*Dz1*__d_exp_0))/Dz1;
DQ_j1_Vtnode_GND=((cjcx02_t_Vtnode_GND*(1.0-__exp_0))+(cjcx02_t*(-DCln2_Vtnode_GND*Dz1*__d_exp_0)))/Dz1;
if (doAC)
{
DQ_j1=((cjcx02_t*(1.0-__exp_0))/Dz1);
}
DQ_j1_Vsi_ci=0.0;
DQ_j1_Vb_ci=0.0;
}
}
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DCln1*Dzr1)));
_exp(__exp_0,((DCln1*Dzr1)));
DQ_j2_Vbi_ci=(DC_c*(-DCln1_Vbi_ci*Dzr1*__d_exp_0))/Dzr1;
DQ_j2_Vbp_ci=(DC_c*(-DCln1_Vbp_ci*Dzr1*__d_exp_0))/Dzr1;
DQ_j2_Vtnode_GND=((DC_c_Vtnode_GND*(1.0-__exp_0))+(DC_c*(-DCln1_Vtnode_GND*Dzr1*__d_exp_0)))/Dzr1;
if (doAC)
{
DQ_j2=((DC_c*(1.0-__exp_0))/Dzr1);
}
DQ_j2_Vsi_ci=0.0;
DQ_j2_Vb_ci=0.0;
}
}
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DCln2*Dzr1)));
_exp(__exp_0,((DCln2*Dzr1)));
DQ_j3_Vbi_ci=(DC_c*(-DCln2_Vbi_ci*Dzr1*__d_exp_0))/Dzr1;
DQ_j3_Vbp_ci=(DC_c*(-DCln2_Vbp_ci*Dzr1*__d_exp_0))/Dzr1;
DQ_j3_Vtnode_GND=((DC_c_Vtnode_GND*(1.0-__exp_0))+(DC_c*(-DCln2_Vtnode_GND*Dzr1*__d_exp_0)))/Dzr1;
if (doAC)
{
DQ_j3=((DC_c*(1.0-__exp_0))/Dzr1);
}
DQ_j3_Vsi_ci=0.0;
DQ_j3_Vb_ci=0.0;
}
}
qjcx0_t_ii_Vbi_ci=(((DQ_j1_Vbi_ci+DQ_j2_Vbi_ci)-DQ_j3_Vbi_ci)*vdcx_t+(DC_max*Dv_j4_Vbi_ci));
qjcx0_t_ii_Vtnode_GND=(((((DQ_j1_Vtnode_GND+DQ_j2_Vtnode_GND)-DQ_j3_Vtnode_GND)*vdcx_t)+(((DQ_j1+DQ_j2)-DQ_j3)*vdcx_t_Vtnode_GND))+((DC_max_Vtnode_GND*Dv_j4)+(DC_max*Dv_j4_Vtnode_GND)));
qjcx0_t_ii_Vbp_ci=(((DQ_j1_Vbp_ci+DQ_j2_Vbp_ci)-DQ_j3_Vbp_ci)*vdcx_t+(DC_max*Dv_j4_Vbp_ci));
if (doAC)
{
qjcx0_t_ii=((((DQ_j1+DQ_j2)-DQ_j3)*vdcx_t)+(DC_max*Dv_j4));
}
qjcx0_t_ii_Vbp_ei=0.0;
qjcx0_t_ii_Vbi_ei=0.0;
}
else
{
if (doAC)
{
cjcx0_t_ii=0.0;
}
if (doAC)
{
qjcx0_t_ii=0.0;
}
qjcx0_t_ii_Vbp_ei=0.0;
qjcx0_t_ii_Vbi_ei=0.0;
qjcx0_t_ii_Vbp_ci=0.0;
qjcx0_t_ii_Vtnode_GND=0.0;
qjcx0_t_ii_Vbi_ci=0.0;
}
}
else
{
if ((cjcx02_t>0.0))
{
if (doAC)
{
{
double __logE_0=0.0;
double __exp_1=0.0;
_logE(__logE_0,(2.4));
_exp(__exp_1,(((-__logE_0)/zcx)));
DFV_f_Vtnode_GND=vdcx_t_Vtnode_GND*(1.0-__exp_1);
if (doAC)
{
DFV_f=(vdcx_t*(1.0-__exp_1));
}
}
}
DFC_max_Vtnode_GND=(2.4*cjcx02_t_Vtnode_GND);
if (doAC)
{
DFC_max=(2.4*cjcx02_t);
}
DFv_e_Vbp_ci=(-1.0)/VT;
DFv_e_Vtnode_GND=(DFV_f_Vtnode_GND*VT-(DFV_f-BP(bp,ci))*VT_Vtnode_GND)/(VT*VT);
if (doAC)
{
DFv_e=((DFV_f-BP(bp,ci))/VT);
}
DFv_e_Vsi_ci=0.0;
DFv_e_Vb_ci=0.0;
DFv_e_Vbp_ei=0.0;
DFv_e_Vbi_ci=0.0;
DFv_e_Vbi_ei=0.0;
if ((DFv_e<80.0))
{
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(DFv_e));
_exp(__exp_0,(DFv_e));
DFe_Vbi_ei=DFv_e_Vbi_ei*__d_exp_0;
DFe_Vtnode_GND=DFv_e_Vtnode_GND*__d_exp_0;
DFe_Vbi_ci=DFv_e_Vbi_ci*__d_exp_0;
DFe_Vbp_ei=DFv_e_Vbp_ei*__d_exp_0;
DFe_Vbp_ci=DFv_e_Vbp_ci*__d_exp_0;
if (doAC)
{
DFe=__exp_0;
}
DFe_Vsi_ci=0.0;
DFe_Vb_ci=0.0;
}
}
if (doAC)
{
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0+DFe)));
_logE(__logE_0,((1.0+DFe)));
DFv_j_Vbi_ei=(-(VT*(+DFe_Vbi_ei)*__d_logE_0));
DFv_j_Vbi_ci=(-(VT*(+DFe_Vbi_ci)*__d_logE_0));
DFv_j_Vbp_ei=(-(VT*(+DFe_Vbp_ei)*__d_logE_0));
DFv_j_Vbp_ci=(-(VT*(+DFe_Vbp_ci)*__d_logE_0));
DFv_j_Vtnode_GND=(DFV_f_Vtnode_GND-((VT_Vtnode_GND*__logE_0)+(VT*(+DFe_Vtnode_GND)*__d_logE_0)));
if (doAC)
{
DFv_j=(DFV_f-(VT*__logE_0));
}
DFv_j_Vsi_ci=0.0;
DFv_j_Vb_ci=0.0;
}
}
DFdvj_dv_Vbi_ei=(DFe_Vbi_ei*(1.0+DFe)-DFe*(+DFe_Vbi_ei))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv_Vtnode_GND=(DFe_Vtnode_GND*(1.0+DFe)-DFe*(+DFe_Vtnode_GND))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv_Vbi_ci=(DFe_Vbi_ci*(1.0+DFe)-DFe*(+DFe_Vbi_ci))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv_Vbp_ei=(DFe_Vbp_ei*(1.0+DFe)-DFe*(+DFe_Vbp_ei))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv_Vbp_ci=(DFe_Vbp_ci*(1.0+DFe)-DFe*(+DFe_Vbp_ci))/((1.0+DFe)*(1.0+DFe));
if (doAC)
{
DFdvj_dv=(DFe/(1.0+DFe));
}
DFdvj_dv_Vsi_ci=0.0;
DFdvj_dv_Vb_ci=0.0;
}
else
{
DFv_j_Vbp_ci=1.0;
if (doAC)
{
DFv_j=BP(bp,ci);
}
DFv_j_Vsi_ci=0.0;
DFv_j_Vb_ci=0.0;
DFv_j_Vbp_ei=0.0;
DFv_j_Vbi_ci=0.0;
DFv_j_Vtnode_GND=0.0;
DFv_j_Vbi_ei=0.0;
if (doAC)
{
DFdvj_dv=1;
}
DFdvj_dv_Vsi_ci=0.0;
DFdvj_dv_Vb_ci=0.0;
DFdvj_dv_Vbp_ci=0.0;
DFdvj_dv_Vbp_ei=0.0;
DFdvj_dv_Vbi_ci=0.0;
DFdvj_dv_Vtnode_GND=0.0;
DFdvj_dv_Vbi_ei=0.0;
}
if (doAC)
{
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0-(DFv_j/vdcx_t))));
_logE(__logE_0,((1.0-(DFv_j/vdcx_t))));
DFb_Vbi_ei=(-DFv_j_Vbi_ei/vdcx_t)*__d_logE_0;
DFb_Vtnode_GND=(-(DFv_j_Vtnode_GND*vdcx_t-DFv_j*vdcx_t_Vtnode_GND)/(vdcx_t*vdcx_t))*__d_logE_0;
DFb_Vbi_ci=(-DFv_j_Vbi_ci/vdcx_t)*__d_logE_0;
DFb_Vbp_ei=(-DFv_j_Vbp_ei/vdcx_t)*__d_logE_0;
DFb_Vbp_ci=(-DFv_j_Vbp_ci/vdcx_t)*__d_logE_0;
if (doAC)
{
DFb=__logE_0;
}
DFb_Vsi_ci=0.0;
DFb_Vb_ci=0.0;
}
}
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(((-zcx)*DFb)));
_exp(__exp_0,(((-zcx)*DFb)));
DFC_j1_Vbi_ei=(((cjcx02_t*((-zcx)*DFb_Vbi_ei)*__d_exp_0)*DFdvj_dv)+((cjcx02_t*__exp_0)*DFdvj_dv_Vbi_ei));
DFC_j1_Vbi_ci=(((cjcx02_t*((-zcx)*DFb_Vbi_ci)*__d_exp_0)*DFdvj_dv)+((cjcx02_t*__exp_0)*DFdvj_dv_Vbi_ci));
DFC_j1_Vbp_ei=(((cjcx02_t*((-zcx)*DFb_Vbp_ei)*__d_exp_0)*DFdvj_dv)+((cjcx02_t*__exp_0)*DFdvj_dv_Vbp_ei));
DFC_j1_Vbp_ci=(((cjcx02_t*((-zcx)*DFb_Vbp_ci)*__d_exp_0)*DFdvj_dv)+((cjcx02_t*__exp_0)*DFdvj_dv_Vbp_ci));
DFC_j1_Vtnode_GND=((((cjcx02_t_Vtnode_GND*__exp_0)+(cjcx02_t*((-zcx)*DFb_Vtnode_GND)*__d_exp_0))*DFdvj_dv)+((cjcx02_t*__exp_0)*DFdvj_dv_Vtnode_GND));
if (doAC)
{
DFC_j1=((cjcx02_t*__exp_0)*DFdvj_dv);
}
DFC_j1_Vsi_ci=0.0;
DFC_j1_Vb_ci=0.0;
}
}
if (doAC)
{
cjcx0_t_ii=(DFC_j1+(DFC_max*(1.0-DFdvj_dv)));
}
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DFb*(1.0-zcx))));
_exp(__exp_0,((DFb*(1.0-zcx))));
DFQ_j_Vbi_ei=((cjcx02_t*vdcx_t)*(-DFb_Vbi_ei*(1.0-zcx)*__d_exp_0))/(1.0-zcx);
DFQ_j_Vbi_ci=((cjcx02_t*vdcx_t)*(-DFb_Vbi_ci*(1.0-zcx)*__d_exp_0))/(1.0-zcx);
DFQ_j_Vbp_ei=((cjcx02_t*vdcx_t)*(-DFb_Vbp_ei*(1.0-zcx)*__d_exp_0))/(1.0-zcx);
DFQ_j_Vbp_ci=((cjcx02_t*vdcx_t)*(-DFb_Vbp_ci*(1.0-zcx)*__d_exp_0))/(1.0-zcx);
DFQ_j_Vtnode_GND=((((cjcx02_t_Vtnode_GND*vdcx_t)+(cjcx02_t*vdcx_t_Vtnode_GND))*(1.0-__exp_0))+((cjcx02_t*vdcx_t)*(-DFb_Vtnode_GND*(1.0-zcx)*__d_exp_0)))/(1.0-zcx);
if (doAC)
{
DFQ_j=(((cjcx02_t*vdcx_t)*(1.0-__exp_0))/(1.0-zcx));
}
DFQ_j_Vsi_ci=0.0;
DFQ_j_Vb_ci=0.0;
}
}
qjcx0_t_ii_Vbi_ei=(DFQ_j_Vbi_ei+(DFC_max*(-DFv_j_Vbi_ei)));
qjcx0_t_ii_Vtnode_GND=(DFQ_j_Vtnode_GND+((DFC_max_Vtnode_GND*(BP(bp,ci)-DFv_j))+(DFC_max*(-DFv_j_Vtnode_GND))));
qjcx0_t_ii_Vbi_ci=(DFQ_j_Vbi_ci+(DFC_max*(-DFv_j_Vbi_ci)));
qjcx0_t_ii_Vbp_ei=(DFQ_j_Vbp_ei+(DFC_max*(-DFv_j_Vbp_ei)));
qjcx0_t_ii_Vbp_ci=(DFQ_j_Vbp_ci+(DFC_max*(1.0-DFv_j_Vbp_ci)));
if (doAC)
{
qjcx0_t_ii=(DFQ_j+(DFC_max*(BP(bp,ci)-DFv_j)));
}
}
else
{
if (doAC)
{
cjcx0_t_ii=0.0;
}
if (doAC)
{
qjcx0_t_ii=0.0;
}
qjcx0_t_ii_Vbp_ei=0.0;
qjcx0_t_ii_Vbi_ei=0.0;
qjcx0_t_ii_Vbp_ci=0.0;
qjcx0_t_ii_Vtnode_GND=0.0;
qjcx0_t_ii_Vbi_ci=0.0;
}
}
DIOY_Vtnode_GND=(-(BP(bp,ci)*(mbcx*VT_Vtnode_GND))/((mbcx*VT)*(mbcx*VT)));
DIOY_Vbp_ci=(1/(mbcx*VT));
DIOY=(BP(bp,ci)/(mbcx*VT));
DIOY_Vsi_ci=0.0;
DIOY_Vbp_ei=0.0;
DIOY_Vbi_ci=0.0;
DIOY_Vbi_ei=0.0;
if ((ibcxs>0.0))
{
if ((DIOY>80.0))
{
le_Vtnode_GND=(+DIOY_Vtnode_GND);
le_Vbi_ei=(+DIOY_Vbi_ei);
le_Vbi_ci=(+DIOY_Vbi_ci);
le_Vbp_ei=(+DIOY_Vbp_ei);
le_Vbp_ci=(+DIOY_Vbp_ci);
le=(1+(DIOY-80.0));
le_Vsi_ci=0.0;
DIOY=80.0;
DIOY_Vsi_ci=0.0;
DIOY_Vbp_ci=0.0;
DIOY_Vbp_ei=0.0;
DIOY_Vbi_ci=0.0;
DIOY_Vbi_ei=0.0;
DIOY_Vtnode_GND=0.0;
}
else
{
le=1;
le_Vsi_ci=0.0;
le_Vbp_ci=0.0;
le_Vbp_ei=0.0;
le_Vbi_ci=0.0;
le_Vbi_ei=0.0;
le_Vtnode_GND=0.0;
}
{
double __limexp_0=0.0;
double __d_limexp_0=0.0;
_d_limexp(__limexp_0,__d_limexp_0,(DIOY));
_limexp(__limexp_0,(DIOY));
le_Vtnode_GND=((le_Vtnode_GND*__limexp_0)+(le*DIOY_Vtnode_GND*__d_limexp_0));
le_Vbi_ei=((le_Vbi_ei*__limexp_0)+(le*DIOY_Vbi_ei*__d_limexp_0));
le_Vbi_ci=((le_Vbi_ci*__limexp_0)+(le*DIOY_Vbi_ci*__d_limexp_0));
le_Vbp_ei=((le_Vbp_ei*__limexp_0)+(le*DIOY_Vbp_ei*__d_limexp_0));
le_Vbp_ci=((le_Vbp_ci*__limexp_0)+(le*DIOY_Vbp_ci*__d_limexp_0));
le=(le*__limexp_0);
le_Vsi_ci=0.0;
}
ijbcx_Vbi_ei=(ibcxs_t*le_Vbi_ei);
ijbcx_Vbi_ci=(ibcxs_t*le_Vbi_ci);
ijbcx_Vbp_ei=(ibcxs_t*le_Vbp_ei);
ijbcx_Vbp_ci=(ibcxs_t*le_Vbp_ci);
ijbcx_Vtnode_GND=((ibcxs_t_Vtnode_GND*(le-1.0))+(ibcxs_t*le_Vtnode_GND));
ijbcx=(ibcxs_t*(le-1.0));
if ((DIOY<=(-14.0)))
{
ijbcx_Vtnode_GND=(-ibcxs_t_Vtnode_GND);
ijbcx=(-ibcxs_t);
ijbcx_Vbp_ci=0.0;
ijbcx_Vbp_ei=0.0;
ijbcx_Vbi_ci=0.0;
ijbcx_Vbi_ei=0.0;
}
}
else
{
ijbcx=0.0;
ijbcx_Vtnode_GND=0.0;
ijbcx_Vbp_ci=0.0;
ijbcx_Vbp_ei=0.0;
ijbcx_Vbi_ci=0.0;
ijbcx_Vbi_ei=0.0;
}
if ((vptcx_t<1.0e2))
{
if ((cjcx01_t>0.0))
{
if (doAC)
{
Dz_r=(zcx/4.0);
}
Dv_p_Vtnode_GND=(vptcx_t_Vtnode_GND-vdcx_t_Vtnode_GND);
if (doAC)
{
Dv_p=(vptcx_t-vdcx_t);
}
if (doAC)
{
{
double __logE_0=0.0;
double __exp_1=0.0;
_logE(__logE_0,(2.4));
_exp(__exp_1,(((-__logE_0)/zcx)));
DV_f_Vtnode_GND=vdcx_t_Vtnode_GND*(1.0-__exp_1);
if (doAC)
{
DV_f=(vdcx_t*(1.0-__exp_1));
}
}
}
DC_max_Vtnode_GND=(2.4*cjcx01_t_Vtnode_GND);
if (doAC)
{
DC_max=(2.4*cjcx01_t);
}
if (doAC)
{
{
double __logE_0=0.0;
double __exp_1=0.0;
double __d_logE_0=0.0;
double __d_exp_1=0.0;
_d_logE(__logE_0,__d_logE_0,((vptcx_t/vdcx_t)));
_d_exp(__exp_1,__d_exp_1,((__logE_0*(Dz_r-zcx))));
_logE(__logE_0,((vptcx_t/vdcx_t)));
_exp(__exp_1,((__logE_0*(Dz_r-zcx))));
DC_c_Vtnode_GND=((cjcx01_t_Vtnode_GND*__exp_1)+(cjcx01_t*(vptcx_t_Vtnode_GND*vdcx_t-vptcx_t*vdcx_t_Vtnode_GND)/(vdcx_t*vdcx_t)*__d_logE_0*(Dz_r-zcx)*__d_exp_1));
if (doAC)
{
DC_c=(cjcx01_t*__exp_1);
}
}
}
Da_Vtnode_GND=VT_Vtnode_GND;
if (doAC)
{
Da=VT;
}
Dv_e_Vb_ci=(-1.0)/Da;
Dv_e_Vtnode_GND=(DV_f_Vtnode_GND*Da-(DV_f-BP(b,ci))*Da_Vtnode_GND)/(Da*Da);
if (doAC)
{
Dv_e=((DV_f-BP(b,ci))/Da);
}
Dv_e_Vsi_ci=0.0;
Dv_e_Vbp_ci=0.0;
Dv_e_Vbi_ci=0.0;
if ((Dv_e<80.0))
{
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(Dv_e));
_exp(__exp_0,(Dv_e));
De_Vbi_ci=Dv_e_Vbi_ci*__d_exp_0;
De_Vtnode_GND=Dv_e_Vtnode_GND*__d_exp_0;
De_Vbp_ci=Dv_e_Vbp_ci*__d_exp_0;
De_Vb_ci=Dv_e_Vb_ci*__d_exp_0;
if (doAC)
{
De=__exp_0;
}
De_Vsi_ci=0.0;
}
}
De_1_Vbi_ci=(De_Vbi_ci*(1.0+De)-De*(+De_Vbi_ci))/((1.0+De)*(1.0+De));
De_1_Vtnode_GND=(De_Vtnode_GND*(1.0+De)-De*(+De_Vtnode_GND))/((1.0+De)*(1.0+De));
De_1_Vbp_ci=(De_Vbp_ci*(1.0+De)-De*(+De_Vbp_ci))/((1.0+De)*(1.0+De));
De_1_Vb_ci=(De_Vb_ci*(1.0+De)-De*(+De_Vb_ci))/((1.0+De)*(1.0+De));
if (doAC)
{
De_1=(De/(1.0+De));
}
De_1_Vsi_ci=0.0;
if (doAC)
{
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0+De)));
_logE(__logE_0,((1.0+De)));
Dv_j1_Vbi_ci=(-(Da*(+De_Vbi_ci)*__d_logE_0));
Dv_j1_Vbp_ci=(-(Da*(+De_Vbp_ci)*__d_logE_0));
Dv_j1_Vb_ci=(-(Da*(+De_Vb_ci)*__d_logE_0));
Dv_j1_Vtnode_GND=(DV_f_Vtnode_GND-((Da_Vtnode_GND*__logE_0)+(Da*(+De_Vtnode_GND)*__d_logE_0)));
if (doAC)
{
Dv_j1=(DV_f-(Da*__logE_0));
}
Dv_j1_Vsi_ci=0.0;
}
}
}
else
{
if (doAC)
{
De_1=1.0;
}
De_1_Vsi_ci=0.0;
De_1_Vb_ci=0.0;
De_1_Vbp_ci=0.0;
De_1_Vtnode_GND=0.0;
De_1_Vbi_ci=0.0;
Dv_j1_Vb_ci=1.0;
if (doAC)
{
Dv_j1=BP(b,ci);
}
Dv_j1_Vsi_ci=0.0;
Dv_j1_Vbp_ci=0.0;
Dv_j1_Vtnode_GND=0.0;
Dv_j1_Vbi_ci=0.0;
}
Da_Vtnode_GND=((0.1*Dv_p_Vtnode_GND)+(4.0*VT_Vtnode_GND));
if (doAC)
{
Da=((0.1*Dv_p)+(4.0*VT));
}
Dv_r_Vbi_ci=(+Dv_j1_Vbi_ci)/Da;
Dv_r_Vbp_ci=(+Dv_j1_Vbp_ci)/Da;
Dv_r_Vb_ci=(+Dv_j1_Vb_ci)/Da;
Dv_r_Vtnode_GND=((Dv_p_Vtnode_GND+Dv_j1_Vtnode_GND)*Da-(Dv_p+Dv_j1)*Da_Vtnode_GND)/(Da*Da);
if (doAC)
{
Dv_r=((Dv_p+Dv_j1)/Da);
}
Dv_r_Vsi_ci=0.0;
if ((Dv_r<80.0))
{
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(Dv_r));
_exp(__exp_0,(Dv_r));
De_Vbi_ci=Dv_r_Vbi_ci*__d_exp_0;
De_Vtnode_GND=Dv_r_Vtnode_GND*__d_exp_0;
De_Vbp_ci=Dv_r_Vbp_ci*__d_exp_0;
De_Vb_ci=Dv_r_Vb_ci*__d_exp_0;
if (doAC)
{
De=__exp_0;
}
De_Vsi_ci=0.0;
}
}
De_2_Vbi_ci=(De_Vbi_ci*(1.0+De)-De*(+De_Vbi_ci))/((1.0+De)*(1.0+De));
De_2_Vtnode_GND=(De_Vtnode_GND*(1.0+De)-De*(+De_Vtnode_GND))/((1.0+De)*(1.0+De));
De_2_Vbp_ci=(De_Vbp_ci*(1.0+De)-De*(+De_Vbp_ci))/((1.0+De)*(1.0+De));
De_2_Vb_ci=(De_Vb_ci*(1.0+De)-De*(+De_Vb_ci))/((1.0+De)*(1.0+De));
if (doAC)
{
De_2=(De/(1.0+De));
}
De_2_Vsi_ci=0.0;
if (doAC)
{
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0+De)));
_logE(__logE_0,((1.0+De)));
Dv_j2_Vbi_ci=(+(Da*(+De_Vbi_ci)*__d_logE_0));
Dv_j2_Vbp_ci=(+(Da*(+De_Vbp_ci)*__d_logE_0));
Dv_j2_Vb_ci=(+(Da*(+De_Vb_ci)*__d_logE_0));
Dv_j2_Vtnode_GND=((-Dv_p_Vtnode_GND)+((Da_Vtnode_GND*__logE_0)+(Da*(+De_Vtnode_GND)*__d_logE_0)));
if (doAC)
{
Dv_j2=((-Dv_p)+(Da*__logE_0));
}
Dv_j2_Vsi_ci=0.0;
}
}
}
else
{
if (doAC)
{
De_2=1.0;
}
De_2_Vsi_ci=0.0;
De_2_Vb_ci=0.0;
De_2_Vbp_ci=0.0;
De_2_Vtnode_GND=0.0;
De_2_Vbi_ci=0.0;
Dv_j2_Vbi_ci=Dv_j1_Vbi_ci;
Dv_j2_Vtnode_GND=Dv_j1_Vtnode_GND;
Dv_j2_Vbp_ci=Dv_j1_Vbp_ci;
Dv_j2_Vb_ci=Dv_j1_Vb_ci;
if (doAC)
{
Dv_j2=Dv_j1;
}
Dv_j2_Vsi_ci=0.0;
}
Dv_j4_Vbi_ci=(-Dv_j1_Vbi_ci);
Dv_j4_Vtnode_GND=(-Dv_j1_Vtnode_GND);
Dv_j4_Vbp_ci=(-Dv_j1_Vbp_ci);
Dv_j4_Vb_ci=(1.0-Dv_j1_Vb_ci);
if (doAC)
{
Dv_j4=(BP(b,ci)-Dv_j1);
}
Dv_j4_Vsi_ci=0.0;
if (doAC)
{
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0-(Dv_j1/vdcx_t))));
_logE(__logE_0,((1.0-(Dv_j1/vdcx_t))));
DCln1_Vbi_ci=(-Dv_j1_Vbi_ci/vdcx_t)*__d_logE_0;
DCln1_Vtnode_GND=(-(Dv_j1_Vtnode_GND*vdcx_t-Dv_j1*vdcx_t_Vtnode_GND)/(vdcx_t*vdcx_t))*__d_logE_0;
DCln1_Vbp_ci=(-Dv_j1_Vbp_ci/vdcx_t)*__d_logE_0;
DCln1_Vb_ci=(-Dv_j1_Vb_ci/vdcx_t)*__d_logE_0;
if (doAC)
{
DCln1=__logE_0;
}
DCln1_Vsi_ci=0.0;
}
}
if (doAC)
{
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0-(Dv_j2/vdcx_t))));
_logE(__logE_0,((1.0-(Dv_j2/vdcx_t))));
DCln2_Vbi_ci=(-Dv_j2_Vbi_ci/vdcx_t)*__d_logE_0;
DCln2_Vtnode_GND=(-(Dv_j2_Vtnode_GND*vdcx_t-Dv_j2*vdcx_t_Vtnode_GND)/(vdcx_t*vdcx_t))*__d_logE_0;
DCln2_Vbp_ci=(-Dv_j2_Vbp_ci/vdcx_t)*__d_logE_0;
DCln2_Vb_ci=(-Dv_j2_Vb_ci/vdcx_t)*__d_logE_0;
if (doAC)
{
DCln2=__logE_0;
}
DCln2_Vsi_ci=0.0;
}
}
if (doAC)
{
Dz1=(1.0-zcx);
}
if (doAC)
{
Dzr1=(1.0-Dz_r);
}
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DCln2*(-zcx))));
_exp(__exp_0,((DCln2*(-zcx))));
DC_j1_Vbi_ci=(((((cjcx01_t*DCln2_Vbi_ci*(-zcx)*__d_exp_0)*De_1)+((cjcx01_t*__exp_0)*De_1_Vbi_ci))*De_2)+(((cjcx01_t*__exp_0)*De_1)*De_2_Vbi_ci));
DC_j1_Vbp_ci=(((((cjcx01_t*DCln2_Vbp_ci*(-zcx)*__d_exp_0)*De_1)+((cjcx01_t*__exp_0)*De_1_Vbp_ci))*De_2)+(((cjcx01_t*__exp_0)*De_1)*De_2_Vbp_ci));
DC_j1_Vb_ci=(((((cjcx01_t*DCln2_Vb_ci*(-zcx)*__d_exp_0)*De_1)+((cjcx01_t*__exp_0)*De_1_Vb_ci))*De_2)+(((cjcx01_t*__exp_0)*De_1)*De_2_Vb_ci));
DC_j1_Vtnode_GND=((((((cjcx01_t_Vtnode_GND*__exp_0)+(cjcx01_t*DCln2_Vtnode_GND*(-zcx)*__d_exp_0))*De_1)+((cjcx01_t*__exp_0)*De_1_Vtnode_GND))*De_2)+(((cjcx01_t*__exp_0)*De_1)*De_2_Vtnode_GND));
if (doAC)
{
DC_j1=(((cjcx01_t*__exp_0)*De_1)*De_2);
}
DC_j1_Vsi_ci=0.0;
}
}
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DCln1*(-Dz_r))));
_exp(__exp_0,((DCln1*(-Dz_r))));
DC_j2_Vbi_ci=(((DC_c*DCln1_Vbi_ci*(-Dz_r)*__d_exp_0)*(1.0-De_2))+((DC_c*__exp_0)*(-De_2_Vbi_ci)));
DC_j2_Vbp_ci=(((DC_c*DCln1_Vbp_ci*(-Dz_r)*__d_exp_0)*(1.0-De_2))+((DC_c*__exp_0)*(-De_2_Vbp_ci)));
DC_j2_Vb_ci=(((DC_c*DCln1_Vb_ci*(-Dz_r)*__d_exp_0)*(1.0-De_2))+((DC_c*__exp_0)*(-De_2_Vb_ci)));
DC_j2_Vtnode_GND=((((DC_c_Vtnode_GND*__exp_0)+(DC_c*DCln1_Vtnode_GND*(-Dz_r)*__d_exp_0))*(1.0-De_2))+((DC_c*__exp_0)*(-De_2_Vtnode_GND)));
if (doAC)
{
DC_j2=((DC_c*__exp_0)*(1.0-De_2));
}
DC_j2_Vsi_ci=0.0;
}
}
DC_j3_Vbi_ci=(DC_max*(-De_1_Vbi_ci));
DC_j3_Vbp_ci=(DC_max*(-De_1_Vbp_ci));
DC_j3_Vb_ci=(DC_max*(-De_1_Vb_ci));
DC_j3_Vtnode_GND=((DC_max_Vtnode_GND*(1.0-De_1))+(DC_max*(-De_1_Vtnode_GND)));
if (doAC)
{
DC_j3=(DC_max*(1.0-De_1));
}
DC_j3_Vsi_ci=0.0;
if (doAC)
{
cjcx0_t_i=((DC_j1+DC_j2)+DC_j3);
}
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DCln2*Dz1)));
_exp(__exp_0,((DCln2*Dz1)));
DQ_j1_Vbi_ci=(cjcx01_t*(-DCln2_Vbi_ci*Dz1*__d_exp_0))/Dz1;
DQ_j1_Vbp_ci=(cjcx01_t*(-DCln2_Vbp_ci*Dz1*__d_exp_0))/Dz1;
DQ_j1_Vb_ci=(cjcx01_t*(-DCln2_Vb_ci*Dz1*__d_exp_0))/Dz1;
DQ_j1_Vtnode_GND=((cjcx01_t_Vtnode_GND*(1.0-__exp_0))+(cjcx01_t*(-DCln2_Vtnode_GND*Dz1*__d_exp_0)))/Dz1;
if (doAC)
{
DQ_j1=((cjcx01_t*(1.0-__exp_0))/Dz1);
}
DQ_j1_Vsi_ci=0.0;
}
}
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DCln1*Dzr1)));
_exp(__exp_0,((DCln1*Dzr1)));
DQ_j2_Vbi_ci=(DC_c*(-DCln1_Vbi_ci*Dzr1*__d_exp_0))/Dzr1;
DQ_j2_Vbp_ci=(DC_c*(-DCln1_Vbp_ci*Dzr1*__d_exp_0))/Dzr1;
DQ_j2_Vb_ci=(DC_c*(-DCln1_Vb_ci*Dzr1*__d_exp_0))/Dzr1;
DQ_j2_Vtnode_GND=((DC_c_Vtnode_GND*(1.0-__exp_0))+(DC_c*(-DCln1_Vtnode_GND*Dzr1*__d_exp_0)))/Dzr1;
if (doAC)
{
DQ_j2=((DC_c*(1.0-__exp_0))/Dzr1);
}
DQ_j2_Vsi_ci=0.0;
}
}
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DCln2*Dzr1)));
_exp(__exp_0,((DCln2*Dzr1)));
DQ_j3_Vbi_ci=(DC_c*(-DCln2_Vbi_ci*Dzr1*__d_exp_0))/Dzr1;
DQ_j3_Vbp_ci=(DC_c*(-DCln2_Vbp_ci*Dzr1*__d_exp_0))/Dzr1;
DQ_j3_Vb_ci=(DC_c*(-DCln2_Vb_ci*Dzr1*__d_exp_0))/Dzr1;
DQ_j3_Vtnode_GND=((DC_c_Vtnode_GND*(1.0-__exp_0))+(DC_c*(-DCln2_Vtnode_GND*Dzr1*__d_exp_0)))/Dzr1;
if (doAC)
{
DQ_j3=((DC_c*(1.0-__exp_0))/Dzr1);
}
DQ_j3_Vsi_ci=0.0;
}
}
qjcx0_t_i_Vbi_ci=(((DQ_j1_Vbi_ci+DQ_j2_Vbi_ci)-DQ_j3_Vbi_ci)*vdcx_t+(DC_max*Dv_j4_Vbi_ci));
qjcx0_t_i_Vtnode_GND=(((((DQ_j1_Vtnode_GND+DQ_j2_Vtnode_GND)-DQ_j3_Vtnode_GND)*vdcx_t)+(((DQ_j1+DQ_j2)-DQ_j3)*vdcx_t_Vtnode_GND))+((DC_max_Vtnode_GND*Dv_j4)+(DC_max*Dv_j4_Vtnode_GND)));
qjcx0_t_i_Vbp_ci=(((DQ_j1_Vbp_ci+DQ_j2_Vbp_ci)-DQ_j3_Vbp_ci)*vdcx_t+(DC_max*Dv_j4_Vbp_ci));
qjcx0_t_i_Vb_ci=(((DQ_j1_Vb_ci+DQ_j2_Vb_ci)-DQ_j3_Vb_ci)*vdcx_t+(DC_max*Dv_j4_Vb_ci));
if (doAC)
{
qjcx0_t_i=((((DQ_j1+DQ_j2)-DQ_j3)*vdcx_t)+(DC_max*Dv_j4));
}
qjcx0_t_i_Vbp_ei=0.0;
qjcx0_t_i_Vbi_ei=0.0;
}
else
{
if (doAC)
{
cjcx0_t_i=0.0;
}
if (doAC)
{
qjcx0_t_i=0.0;
}
qjcx0_t_i_Vbp_ei=0.0;
qjcx0_t_i_Vbi_ei=0.0;
qjcx0_t_i_Vb_ci=0.0;
qjcx0_t_i_Vbp_ci=0.0;
qjcx0_t_i_Vtnode_GND=0.0;
qjcx0_t_i_Vbi_ci=0.0;
}
}
else
{
if ((cjcx01_t>0.0))
{
if (doAC)
{
{
double __logE_0=0.0;
double __exp_1=0.0;
_logE(__logE_0,(2.4));
_exp(__exp_1,(((-__logE_0)/zcx)));
DFV_f_Vtnode_GND=vdcx_t_Vtnode_GND*(1.0-__exp_1);
if (doAC)
{
DFV_f=(vdcx_t*(1.0-__exp_1));
}
}
}
DFC_max_Vtnode_GND=(2.4*cjcx01_t_Vtnode_GND);
if (doAC)
{
DFC_max=(2.4*cjcx01_t);
}
DFv_e_Vb_ci=(-1.0)/VT;
DFv_e_Vtnode_GND=(DFV_f_Vtnode_GND*VT-(DFV_f-BP(b,ci))*VT_Vtnode_GND)/(VT*VT);
if (doAC)
{
DFv_e=((DFV_f-BP(b,ci))/VT);
}
DFv_e_Vsi_ci=0.0;
DFv_e_Vbp_ci=0.0;
DFv_e_Vbp_ei=0.0;
DFv_e_Vbi_ci=0.0;
DFv_e_Vbi_ei=0.0;
if ((DFv_e<80.0))
{
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(DFv_e));
_exp(__exp_0,(DFv_e));
DFe_Vbi_ei=DFv_e_Vbi_ei*__d_exp_0;
DFe_Vtnode_GND=DFv_e_Vtnode_GND*__d_exp_0;
DFe_Vbi_ci=DFv_e_Vbi_ci*__d_exp_0;
DFe_Vbp_ei=DFv_e_Vbp_ei*__d_exp_0;
DFe_Vbp_ci=DFv_e_Vbp_ci*__d_exp_0;
DFe_Vb_ci=DFv_e_Vb_ci*__d_exp_0;
if (doAC)
{
DFe=__exp_0;
}
DFe_Vsi_ci=0.0;
}
}
if (doAC)
{
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0+DFe)));
_logE(__logE_0,((1.0+DFe)));
DFv_j_Vbi_ei=(-(VT*(+DFe_Vbi_ei)*__d_logE_0));
DFv_j_Vbi_ci=(-(VT*(+DFe_Vbi_ci)*__d_logE_0));
DFv_j_Vbp_ei=(-(VT*(+DFe_Vbp_ei)*__d_logE_0));
DFv_j_Vbp_ci=(-(VT*(+DFe_Vbp_ci)*__d_logE_0));
DFv_j_Vb_ci=(-(VT*(+DFe_Vb_ci)*__d_logE_0));
DFv_j_Vtnode_GND=(DFV_f_Vtnode_GND-((VT_Vtnode_GND*__logE_0)+(VT*(+DFe_Vtnode_GND)*__d_logE_0)));
if (doAC)
{
DFv_j=(DFV_f-(VT*__logE_0));
}
DFv_j_Vsi_ci=0.0;
}
}
DFdvj_dv_Vbi_ei=(DFe_Vbi_ei*(1.0+DFe)-DFe*(+DFe_Vbi_ei))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv_Vtnode_GND=(DFe_Vtnode_GND*(1.0+DFe)-DFe*(+DFe_Vtnode_GND))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv_Vbi_ci=(DFe_Vbi_ci*(1.0+DFe)-DFe*(+DFe_Vbi_ci))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv_Vbp_ei=(DFe_Vbp_ei*(1.0+DFe)-DFe*(+DFe_Vbp_ei))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv_Vbp_ci=(DFe_Vbp_ci*(1.0+DFe)-DFe*(+DFe_Vbp_ci))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv_Vb_ci=(DFe_Vb_ci*(1.0+DFe)-DFe*(+DFe_Vb_ci))/((1.0+DFe)*(1.0+DFe));
if (doAC)
{
DFdvj_dv=(DFe/(1.0+DFe));
}
DFdvj_dv_Vsi_ci=0.0;
}
else
{
DFv_j_Vb_ci=1.0;
if (doAC)
{
DFv_j=BP(b,ci);
}
DFv_j_Vsi_ci=0.0;
DFv_j_Vbp_ci=0.0;
DFv_j_Vbp_ei=0.0;
DFv_j_Vbi_ci=0.0;
DFv_j_Vtnode_GND=0.0;
DFv_j_Vbi_ei=0.0;
if (doAC)
{
DFdvj_dv=1;
}
DFdvj_dv_Vsi_ci=0.0;
DFdvj_dv_Vb_ci=0.0;
DFdvj_dv_Vbp_ci=0.0;
DFdvj_dv_Vbp_ei=0.0;
DFdvj_dv_Vbi_ci=0.0;
DFdvj_dv_Vtnode_GND=0.0;
DFdvj_dv_Vbi_ei=0.0;
}
if (doAC)
{
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0-(DFv_j/vdcx_t))));
_logE(__logE_0,((1.0-(DFv_j/vdcx_t))));
DFb_Vbi_ei=(-DFv_j_Vbi_ei/vdcx_t)*__d_logE_0;
DFb_Vtnode_GND=(-(DFv_j_Vtnode_GND*vdcx_t-DFv_j*vdcx_t_Vtnode_GND)/(vdcx_t*vdcx_t))*__d_logE_0;
DFb_Vbi_ci=(-DFv_j_Vbi_ci/vdcx_t)*__d_logE_0;
DFb_Vbp_ei=(-DFv_j_Vbp_ei/vdcx_t)*__d_logE_0;
DFb_Vbp_ci=(-DFv_j_Vbp_ci/vdcx_t)*__d_logE_0;
DFb_Vb_ci=(-DFv_j_Vb_ci/vdcx_t)*__d_logE_0;
if (doAC)
{
DFb=__logE_0;
}
DFb_Vsi_ci=0.0;
}
}
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(((-zcx)*DFb)));
_exp(__exp_0,(((-zcx)*DFb)));
DFC_j1_Vbi_ei=(((cjcx01_t*((-zcx)*DFb_Vbi_ei)*__d_exp_0)*DFdvj_dv)+((cjcx01_t*__exp_0)*DFdvj_dv_Vbi_ei));
DFC_j1_Vbi_ci=(((cjcx01_t*((-zcx)*DFb_Vbi_ci)*__d_exp_0)*DFdvj_dv)+((cjcx01_t*__exp_0)*DFdvj_dv_Vbi_ci));
DFC_j1_Vbp_ei=(((cjcx01_t*((-zcx)*DFb_Vbp_ei)*__d_exp_0)*DFdvj_dv)+((cjcx01_t*__exp_0)*DFdvj_dv_Vbp_ei));
DFC_j1_Vbp_ci=(((cjcx01_t*((-zcx)*DFb_Vbp_ci)*__d_exp_0)*DFdvj_dv)+((cjcx01_t*__exp_0)*DFdvj_dv_Vbp_ci));
DFC_j1_Vb_ci=(((cjcx01_t*((-zcx)*DFb_Vb_ci)*__d_exp_0)*DFdvj_dv)+((cjcx01_t*__exp_0)*DFdvj_dv_Vb_ci));
DFC_j1_Vtnode_GND=((((cjcx01_t_Vtnode_GND*__exp_0)+(cjcx01_t*((-zcx)*DFb_Vtnode_GND)*__d_exp_0))*DFdvj_dv)+((cjcx01_t*__exp_0)*DFdvj_dv_Vtnode_GND));
if (doAC)
{
DFC_j1=((cjcx01_t*__exp_0)*DFdvj_dv);
}
DFC_j1_Vsi_ci=0.0;
}
}
if (doAC)
{
cjcx0_t_i=(DFC_j1+(DFC_max*(1.0-DFdvj_dv)));
}
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DFb*(1.0-zcx))));
_exp(__exp_0,((DFb*(1.0-zcx))));
DFQ_j_Vbi_ei=((cjcx01_t*vdcx_t)*(-DFb_Vbi_ei*(1.0-zcx)*__d_exp_0))/(1.0-zcx);
DFQ_j_Vbi_ci=((cjcx01_t*vdcx_t)*(-DFb_Vbi_ci*(1.0-zcx)*__d_exp_0))/(1.0-zcx);
DFQ_j_Vbp_ei=((cjcx01_t*vdcx_t)*(-DFb_Vbp_ei*(1.0-zcx)*__d_exp_0))/(1.0-zcx);
DFQ_j_Vbp_ci=((cjcx01_t*vdcx_t)*(-DFb_Vbp_ci*(1.0-zcx)*__d_exp_0))/(1.0-zcx);
DFQ_j_Vb_ci=((cjcx01_t*vdcx_t)*(-DFb_Vb_ci*(1.0-zcx)*__d_exp_0))/(1.0-zcx);
DFQ_j_Vtnode_GND=((((cjcx01_t_Vtnode_GND*vdcx_t)+(cjcx01_t*vdcx_t_Vtnode_GND))*(1.0-__exp_0))+((cjcx01_t*vdcx_t)*(-DFb_Vtnode_GND*(1.0-zcx)*__d_exp_0)))/(1.0-zcx);
if (doAC)
{
DFQ_j=(((cjcx01_t*vdcx_t)*(1.0-__exp_0))/(1.0-zcx));
}
DFQ_j_Vsi_ci=0.0;
}
}
qjcx0_t_i_Vbi_ei=(DFQ_j_Vbi_ei+(DFC_max*(-DFv_j_Vbi_ei)));
qjcx0_t_i_Vtnode_GND=(DFQ_j_Vtnode_GND+((DFC_max_Vtnode_GND*(BP(b,ci)-DFv_j))+(DFC_max*(-DFv_j_Vtnode_GND))));
qjcx0_t_i_Vbi_ci=(DFQ_j_Vbi_ci+(DFC_max*(-DFv_j_Vbi_ci)));
qjcx0_t_i_Vbp_ei=(DFQ_j_Vbp_ei+(DFC_max*(-DFv_j_Vbp_ei)));
qjcx0_t_i_Vbp_ci=(DFQ_j_Vbp_ci+(DFC_max*(-DFv_j_Vbp_ci)));
qjcx0_t_i_Vb_ci=(DFQ_j_Vb_ci+(DFC_max*(1.0-DFv_j_Vb_ci)));
if (doAC)
{
qjcx0_t_i=(DFQ_j+(DFC_max*(BP(b,ci)-DFv_j)));
}
}
else
{
if (doAC)
{
cjcx0_t_i=0.0;
}
if (doAC)
{
qjcx0_t_i=0.0;
}
qjcx0_t_i_Vbp_ei=0.0;
qjcx0_t_i_Vbi_ei=0.0;
qjcx0_t_i_Vb_ci=0.0;
qjcx0_t_i_Vbp_ci=0.0;
qjcx0_t_i_Vtnode_GND=0.0;
qjcx0_t_i_Vbi_ci=0.0;
}
}
if ((vpts_t<1.0e2))
{
if ((cjs0_t>0.0))
{
if (doAC)
{
Dz_r=(zs/4.0);
}
Dv_p_Vtnode_GND=(vpts_t_Vtnode_GND-vds_t_Vtnode_GND);
if (doAC)
{
Dv_p=(vpts_t-vds_t);
}
if (doAC)
{
{
double __logE_0=0.0;
double __exp_1=0.0;
_logE(__logE_0,(2.4));
_exp(__exp_1,(((-__logE_0)/zs)));
DV_f_Vtnode_GND=vds_t_Vtnode_GND*(1.0-__exp_1);
if (doAC)
{
DV_f=(vds_t*(1.0-__exp_1));
}
}
}
DC_max_Vtnode_GND=(2.4*cjs0_t_Vtnode_GND);
if (doAC)
{
DC_max=(2.4*cjs0_t);
}
if (doAC)
{
{
double __logE_0=0.0;
double __exp_1=0.0;
double __d_logE_0=0.0;
double __d_exp_1=0.0;
_d_logE(__logE_0,__d_logE_0,((vpts_t/vds_t)));
_d_exp(__exp_1,__d_exp_1,((__logE_0*(Dz_r-zs))));
_logE(__logE_0,((vpts_t/vds_t)));
_exp(__exp_1,((__logE_0*(Dz_r-zs))));
DC_c_Vtnode_GND=((cjs0_t_Vtnode_GND*__exp_1)+(cjs0_t*(vpts_t_Vtnode_GND*vds_t-vpts_t*vds_t_Vtnode_GND)/(vds_t*vds_t)*__d_logE_0*(Dz_r-zs)*__d_exp_1));
if (doAC)
{
DC_c=(cjs0_t*__exp_1);
}
}
}
Da_Vtnode_GND=VT_Vtnode_GND;
if (doAC)
{
Da=VT;
}
Dv_e_Vsi_ci=(-1.0)/Da;
Dv_e_Vtnode_GND=(DV_f_Vtnode_GND*Da-(DV_f-BP(si,ci))*Da_Vtnode_GND)/(Da*Da);
if (doAC)
{
Dv_e=((DV_f-BP(si,ci))/Da);
}
Dv_e_Vb_ci=0.0;
Dv_e_Vbp_ci=0.0;
Dv_e_Vbi_ci=0.0;
if ((Dv_e<80.0))
{
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(Dv_e));
_exp(__exp_0,(Dv_e));
De_Vbi_ci=Dv_e_Vbi_ci*__d_exp_0;
De_Vtnode_GND=Dv_e_Vtnode_GND*__d_exp_0;
De_Vbp_ci=Dv_e_Vbp_ci*__d_exp_0;
De_Vb_ci=Dv_e_Vb_ci*__d_exp_0;
De_Vsi_ci=Dv_e_Vsi_ci*__d_exp_0;
if (doAC)
{
De=__exp_0;
}
}
}
De_1_Vbi_ci=(De_Vbi_ci*(1.0+De)-De*(+De_Vbi_ci))/((1.0+De)*(1.0+De));
De_1_Vtnode_GND=(De_Vtnode_GND*(1.0+De)-De*(+De_Vtnode_GND))/((1.0+De)*(1.0+De));
De_1_Vbp_ci=(De_Vbp_ci*(1.0+De)-De*(+De_Vbp_ci))/((1.0+De)*(1.0+De));
De_1_Vb_ci=(De_Vb_ci*(1.0+De)-De*(+De_Vb_ci))/((1.0+De)*(1.0+De));
De_1_Vsi_ci=(De_Vsi_ci*(1.0+De)-De*(+De_Vsi_ci))/((1.0+De)*(1.0+De));
if (doAC)
{
De_1=(De/(1.0+De));
}
if (doAC)
{
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0+De)));
_logE(__logE_0,((1.0+De)));
Dv_j1_Vbi_ci=(-(Da*(+De_Vbi_ci)*__d_logE_0));
Dv_j1_Vbp_ci=(-(Da*(+De_Vbp_ci)*__d_logE_0));
Dv_j1_Vb_ci=(-(Da*(+De_Vb_ci)*__d_logE_0));
Dv_j1_Vsi_ci=(-(Da*(+De_Vsi_ci)*__d_logE_0));
Dv_j1_Vtnode_GND=(DV_f_Vtnode_GND-((Da_Vtnode_GND*__logE_0)+(Da*(+De_Vtnode_GND)*__d_logE_0)));
if (doAC)
{
Dv_j1=(DV_f-(Da*__logE_0));
}
}
}
}
else
{
if (doAC)
{
De_1=1.0;
}
De_1_Vsi_ci=0.0;
De_1_Vb_ci=0.0;
De_1_Vbp_ci=0.0;
De_1_Vtnode_GND=0.0;
De_1_Vbi_ci=0.0;
Dv_j1_Vsi_ci=1.0;
if (doAC)
{
Dv_j1=BP(si,ci);
}
Dv_j1_Vb_ci=0.0;
Dv_j1_Vbp_ci=0.0;
Dv_j1_Vtnode_GND=0.0;
Dv_j1_Vbi_ci=0.0;
}
Da_Vtnode_GND=((0.1*Dv_p_Vtnode_GND)+(4.0*VT_Vtnode_GND));
if (doAC)
{
Da=((0.1*Dv_p)+(4.0*VT));
}
Dv_r_Vbi_ci=(+Dv_j1_Vbi_ci)/Da;
Dv_r_Vbp_ci=(+Dv_j1_Vbp_ci)/Da;
Dv_r_Vb_ci=(+Dv_j1_Vb_ci)/Da;
Dv_r_Vsi_ci=(+Dv_j1_Vsi_ci)/Da;
Dv_r_Vtnode_GND=((Dv_p_Vtnode_GND+Dv_j1_Vtnode_GND)*Da-(Dv_p+Dv_j1)*Da_Vtnode_GND)/(Da*Da);
if (doAC)
{
Dv_r=((Dv_p+Dv_j1)/Da);
}
if ((Dv_r<80.0))
{
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(Dv_r));
_exp(__exp_0,(Dv_r));
De_Vbi_ci=Dv_r_Vbi_ci*__d_exp_0;
De_Vtnode_GND=Dv_r_Vtnode_GND*__d_exp_0;
De_Vbp_ci=Dv_r_Vbp_ci*__d_exp_0;
De_Vb_ci=Dv_r_Vb_ci*__d_exp_0;
De_Vsi_ci=Dv_r_Vsi_ci*__d_exp_0;
if (doAC)
{
De=__exp_0;
}
}
}
De_2_Vbi_ci=(De_Vbi_ci*(1.0+De)-De*(+De_Vbi_ci))/((1.0+De)*(1.0+De));
De_2_Vtnode_GND=(De_Vtnode_GND*(1.0+De)-De*(+De_Vtnode_GND))/((1.0+De)*(1.0+De));
De_2_Vbp_ci=(De_Vbp_ci*(1.0+De)-De*(+De_Vbp_ci))/((1.0+De)*(1.0+De));
De_2_Vb_ci=(De_Vb_ci*(1.0+De)-De*(+De_Vb_ci))/((1.0+De)*(1.0+De));
De_2_Vsi_ci=(De_Vsi_ci*(1.0+De)-De*(+De_Vsi_ci))/((1.0+De)*(1.0+De));
if (doAC)
{
De_2=(De/(1.0+De));
}
if (doAC)
{
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0+De)));
_logE(__logE_0,((1.0+De)));
Dv_j2_Vbi_ci=(+(Da*(+De_Vbi_ci)*__d_logE_0));
Dv_j2_Vbp_ci=(+(Da*(+De_Vbp_ci)*__d_logE_0));
Dv_j2_Vb_ci=(+(Da*(+De_Vb_ci)*__d_logE_0));
Dv_j2_Vsi_ci=(+(Da*(+De_Vsi_ci)*__d_logE_0));
Dv_j2_Vtnode_GND=((-Dv_p_Vtnode_GND)+((Da_Vtnode_GND*__logE_0)+(Da*(+De_Vtnode_GND)*__d_logE_0)));
if (doAC)
{
Dv_j2=((-Dv_p)+(Da*__logE_0));
}
}
}
}
else
{
if (doAC)
{
De_2=1.0;
}
De_2_Vsi_ci=0.0;
De_2_Vb_ci=0.0;
De_2_Vbp_ci=0.0;
De_2_Vtnode_GND=0.0;
De_2_Vbi_ci=0.0;
Dv_j2_Vbi_ci=Dv_j1_Vbi_ci;
Dv_j2_Vtnode_GND=Dv_j1_Vtnode_GND;
Dv_j2_Vbp_ci=Dv_j1_Vbp_ci;
Dv_j2_Vb_ci=Dv_j1_Vb_ci;
Dv_j2_Vsi_ci=Dv_j1_Vsi_ci;
if (doAC)
{
Dv_j2=Dv_j1;
}
}
Dv_j4_Vbi_ci=(-Dv_j1_Vbi_ci);
Dv_j4_Vtnode_GND=(-Dv_j1_Vtnode_GND);
Dv_j4_Vbp_ci=(-Dv_j1_Vbp_ci);
Dv_j4_Vb_ci=(-Dv_j1_Vb_ci);
Dv_j4_Vsi_ci=(1.0-Dv_j1_Vsi_ci);
if (doAC)
{
Dv_j4=(BP(si,ci)-Dv_j1);
}
if (doAC)
{
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0-(Dv_j1/vds_t))));
_logE(__logE_0,((1.0-(Dv_j1/vds_t))));
DCln1_Vbi_ci=(-Dv_j1_Vbi_ci/vds_t)*__d_logE_0;
DCln1_Vtnode_GND=(-(Dv_j1_Vtnode_GND*vds_t-Dv_j1*vds_t_Vtnode_GND)/(vds_t*vds_t))*__d_logE_0;
DCln1_Vbp_ci=(-Dv_j1_Vbp_ci/vds_t)*__d_logE_0;
DCln1_Vb_ci=(-Dv_j1_Vb_ci/vds_t)*__d_logE_0;
DCln1_Vsi_ci=(-Dv_j1_Vsi_ci/vds_t)*__d_logE_0;
if (doAC)
{
DCln1=__logE_0;
}
}
}
if (doAC)
{
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0-(Dv_j2/vds_t))));
_logE(__logE_0,((1.0-(Dv_j2/vds_t))));
DCln2_Vbi_ci=(-Dv_j2_Vbi_ci/vds_t)*__d_logE_0;
DCln2_Vtnode_GND=(-(Dv_j2_Vtnode_GND*vds_t-Dv_j2*vds_t_Vtnode_GND)/(vds_t*vds_t))*__d_logE_0;
DCln2_Vbp_ci=(-Dv_j2_Vbp_ci/vds_t)*__d_logE_0;
DCln2_Vb_ci=(-Dv_j2_Vb_ci/vds_t)*__d_logE_0;
DCln2_Vsi_ci=(-Dv_j2_Vsi_ci/vds_t)*__d_logE_0;
if (doAC)
{
DCln2=__logE_0;
}
}
}
if (doAC)
{
Dz1=(1.0-zs);
}
if (doAC)
{
Dzr1=(1.0-Dz_r);
}
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DCln2*(-zs))));
_exp(__exp_0,((DCln2*(-zs))));
DC_j1_Vbi_ci=(((((cjs0_t*DCln2_Vbi_ci*(-zs)*__d_exp_0)*De_1)+((cjs0_t*__exp_0)*De_1_Vbi_ci))*De_2)+(((cjs0_t*__exp_0)*De_1)*De_2_Vbi_ci));
DC_j1_Vbp_ci=(((((cjs0_t*DCln2_Vbp_ci*(-zs)*__d_exp_0)*De_1)+((cjs0_t*__exp_0)*De_1_Vbp_ci))*De_2)+(((cjs0_t*__exp_0)*De_1)*De_2_Vbp_ci));
DC_j1_Vb_ci=(((((cjs0_t*DCln2_Vb_ci*(-zs)*__d_exp_0)*De_1)+((cjs0_t*__exp_0)*De_1_Vb_ci))*De_2)+(((cjs0_t*__exp_0)*De_1)*De_2_Vb_ci));
DC_j1_Vsi_ci=(((((cjs0_t*DCln2_Vsi_ci*(-zs)*__d_exp_0)*De_1)+((cjs0_t*__exp_0)*De_1_Vsi_ci))*De_2)+(((cjs0_t*__exp_0)*De_1)*De_2_Vsi_ci));
DC_j1_Vtnode_GND=((((((cjs0_t_Vtnode_GND*__exp_0)+(cjs0_t*DCln2_Vtnode_GND*(-zs)*__d_exp_0))*De_1)+((cjs0_t*__exp_0)*De_1_Vtnode_GND))*De_2)+(((cjs0_t*__exp_0)*De_1)*De_2_Vtnode_GND));
if (doAC)
{
DC_j1=(((cjs0_t*__exp_0)*De_1)*De_2);
}
}
}
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DCln1*(-Dz_r))));
_exp(__exp_0,((DCln1*(-Dz_r))));
DC_j2_Vbi_ci=(((DC_c*DCln1_Vbi_ci*(-Dz_r)*__d_exp_0)*(1.0-De_2))+((DC_c*__exp_0)*(-De_2_Vbi_ci)));
DC_j2_Vbp_ci=(((DC_c*DCln1_Vbp_ci*(-Dz_r)*__d_exp_0)*(1.0-De_2))+((DC_c*__exp_0)*(-De_2_Vbp_ci)));
DC_j2_Vb_ci=(((DC_c*DCln1_Vb_ci*(-Dz_r)*__d_exp_0)*(1.0-De_2))+((DC_c*__exp_0)*(-De_2_Vb_ci)));
DC_j2_Vsi_ci=(((DC_c*DCln1_Vsi_ci*(-Dz_r)*__d_exp_0)*(1.0-De_2))+((DC_c*__exp_0)*(-De_2_Vsi_ci)));
DC_j2_Vtnode_GND=((((DC_c_Vtnode_GND*__exp_0)+(DC_c*DCln1_Vtnode_GND*(-Dz_r)*__d_exp_0))*(1.0-De_2))+((DC_c*__exp_0)*(-De_2_Vtnode_GND)));
if (doAC)
{
DC_j2=((DC_c*__exp_0)*(1.0-De_2));
}
}
}
DC_j3_Vbi_ci=(DC_max*(-De_1_Vbi_ci));
DC_j3_Vbp_ci=(DC_max*(-De_1_Vbp_ci));
DC_j3_Vb_ci=(DC_max*(-De_1_Vb_ci));
DC_j3_Vsi_ci=(DC_max*(-De_1_Vsi_ci));
DC_j3_Vtnode_GND=((DC_max_Vtnode_GND*(1.0-De_1))+(DC_max*(-De_1_Vtnode_GND)));
if (doAC)
{
DC_j3=(DC_max*(1.0-De_1));
}
if (doAC)
{
Cjs=((DC_j1+DC_j2)+DC_j3);
}
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DCln2*Dz1)));
_exp(__exp_0,((DCln2*Dz1)));
DQ_j1_Vbi_ci=(cjs0_t*(-DCln2_Vbi_ci*Dz1*__d_exp_0))/Dz1;
DQ_j1_Vbp_ci=(cjs0_t*(-DCln2_Vbp_ci*Dz1*__d_exp_0))/Dz1;
DQ_j1_Vb_ci=(cjs0_t*(-DCln2_Vb_ci*Dz1*__d_exp_0))/Dz1;
DQ_j1_Vsi_ci=(cjs0_t*(-DCln2_Vsi_ci*Dz1*__d_exp_0))/Dz1;
DQ_j1_Vtnode_GND=((cjs0_t_Vtnode_GND*(1.0-__exp_0))+(cjs0_t*(-DCln2_Vtnode_GND*Dz1*__d_exp_0)))/Dz1;
if (doAC)
{
DQ_j1=((cjs0_t*(1.0-__exp_0))/Dz1);
}
}
}
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DCln1*Dzr1)));
_exp(__exp_0,((DCln1*Dzr1)));
DQ_j2_Vbi_ci=(DC_c*(-DCln1_Vbi_ci*Dzr1*__d_exp_0))/Dzr1;
DQ_j2_Vbp_ci=(DC_c*(-DCln1_Vbp_ci*Dzr1*__d_exp_0))/Dzr1;
DQ_j2_Vb_ci=(DC_c*(-DCln1_Vb_ci*Dzr1*__d_exp_0))/Dzr1;
DQ_j2_Vsi_ci=(DC_c*(-DCln1_Vsi_ci*Dzr1*__d_exp_0))/Dzr1;
DQ_j2_Vtnode_GND=((DC_c_Vtnode_GND*(1.0-__exp_0))+(DC_c*(-DCln1_Vtnode_GND*Dzr1*__d_exp_0)))/Dzr1;
if (doAC)
{
DQ_j2=((DC_c*(1.0-__exp_0))/Dzr1);
}
}
}
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DCln2*Dzr1)));
_exp(__exp_0,((DCln2*Dzr1)));
DQ_j3_Vbi_ci=(DC_c*(-DCln2_Vbi_ci*Dzr1*__d_exp_0))/Dzr1;
DQ_j3_Vbp_ci=(DC_c*(-DCln2_Vbp_ci*Dzr1*__d_exp_0))/Dzr1;
DQ_j3_Vb_ci=(DC_c*(-DCln2_Vb_ci*Dzr1*__d_exp_0))/Dzr1;
DQ_j3_Vsi_ci=(DC_c*(-DCln2_Vsi_ci*Dzr1*__d_exp_0))/Dzr1;
DQ_j3_Vtnode_GND=((DC_c_Vtnode_GND*(1.0-__exp_0))+(DC_c*(-DCln2_Vtnode_GND*Dzr1*__d_exp_0)))/Dzr1;
if (doAC)
{
DQ_j3=((DC_c*(1.0-__exp_0))/Dzr1);
}
}
}
Qjs_Vbi_ci=(((DQ_j1_Vbi_ci+DQ_j2_Vbi_ci)-DQ_j3_Vbi_ci)*vds_t+(DC_max*Dv_j4_Vbi_ci));
Qjs_Vtnode_GND=(((((DQ_j1_Vtnode_GND+DQ_j2_Vtnode_GND)-DQ_j3_Vtnode_GND)*vds_t)+(((DQ_j1+DQ_j2)-DQ_j3)*vds_t_Vtnode_GND))+((DC_max_Vtnode_GND*Dv_j4)+(DC_max*Dv_j4_Vtnode_GND)));
Qjs_Vbp_ci=(((DQ_j1_Vbp_ci+DQ_j2_Vbp_ci)-DQ_j3_Vbp_ci)*vds_t+(DC_max*Dv_j4_Vbp_ci));
Qjs_Vb_ci=(((DQ_j1_Vb_ci+DQ_j2_Vb_ci)-DQ_j3_Vb_ci)*vds_t+(DC_max*Dv_j4_Vb_ci));
Qjs_Vsi_ci=(((DQ_j1_Vsi_ci+DQ_j2_Vsi_ci)-DQ_j3_Vsi_ci)*vds_t+(DC_max*Dv_j4_Vsi_ci));
if (doAC)
{
Qjs=((((DQ_j1+DQ_j2)-DQ_j3)*vds_t)+(DC_max*Dv_j4));
}
Qjs_Vbp_ei=0.0;
Qjs_Vbi_ei=0.0;
}
else
{
if (doAC)
{
Cjs=0.0;
}
if (doAC)
{
Qjs=0.0;
}
Qjs_Vbp_ei=0.0;
Qjs_Vbi_ei=0.0;
Qjs_Vsi_ci=0.0;
Qjs_Vb_ci=0.0;
Qjs_Vbp_ci=0.0;
Qjs_Vtnode_GND=0.0;
Qjs_Vbi_ci=0.0;
}
}
else
{
if ((cjs0_t>0.0))
{
if (doAC)
{
{
double __logE_0=0.0;
double __exp_1=0.0;
_logE(__logE_0,(2.4));
_exp(__exp_1,(((-__logE_0)/zs)));
DFV_f_Vtnode_GND=vds_t_Vtnode_GND*(1.0-__exp_1);
if (doAC)
{
DFV_f=(vds_t*(1.0-__exp_1));
}
}
}
DFC_max_Vtnode_GND=(2.4*cjs0_t_Vtnode_GND);
if (doAC)
{
DFC_max=(2.4*cjs0_t);
}
DFv_e_Vsi_ci=(-1.0)/VT;
DFv_e_Vtnode_GND=(DFV_f_Vtnode_GND*VT-(DFV_f-BP(si,ci))*VT_Vtnode_GND)/(VT*VT);
if (doAC)
{
DFv_e=((DFV_f-BP(si,ci))/VT);
}
DFv_e_Vb_ci=0.0;
DFv_e_Vbp_ci=0.0;
DFv_e_Vbp_ei=0.0;
DFv_e_Vbi_ci=0.0;
DFv_e_Vbi_ei=0.0;
if ((DFv_e<80.0))
{
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(DFv_e));
_exp(__exp_0,(DFv_e));
DFe_Vbi_ei=DFv_e_Vbi_ei*__d_exp_0;
DFe_Vtnode_GND=DFv_e_Vtnode_GND*__d_exp_0;
DFe_Vbi_ci=DFv_e_Vbi_ci*__d_exp_0;
DFe_Vbp_ei=DFv_e_Vbp_ei*__d_exp_0;
DFe_Vbp_ci=DFv_e_Vbp_ci*__d_exp_0;
DFe_Vb_ci=DFv_e_Vb_ci*__d_exp_0;
DFe_Vsi_ci=DFv_e_Vsi_ci*__d_exp_0;
if (doAC)
{
DFe=__exp_0;
}
}
}
if (doAC)
{
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0+DFe)));
_logE(__logE_0,((1.0+DFe)));
DFv_j_Vbi_ei=(-(VT*(+DFe_Vbi_ei)*__d_logE_0));
DFv_j_Vbi_ci=(-(VT*(+DFe_Vbi_ci)*__d_logE_0));
DFv_j_Vbp_ei=(-(VT*(+DFe_Vbp_ei)*__d_logE_0));
DFv_j_Vbp_ci=(-(VT*(+DFe_Vbp_ci)*__d_logE_0));
DFv_j_Vb_ci=(-(VT*(+DFe_Vb_ci)*__d_logE_0));
DFv_j_Vsi_ci=(-(VT*(+DFe_Vsi_ci)*__d_logE_0));
DFv_j_Vtnode_GND=(DFV_f_Vtnode_GND-((VT_Vtnode_GND*__logE_0)+(VT*(+DFe_Vtnode_GND)*__d_logE_0)));
if (doAC)
{
DFv_j=(DFV_f-(VT*__logE_0));
}
}
}
DFdvj_dv_Vbi_ei=(DFe_Vbi_ei*(1.0+DFe)-DFe*(+DFe_Vbi_ei))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv_Vtnode_GND=(DFe_Vtnode_GND*(1.0+DFe)-DFe*(+DFe_Vtnode_GND))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv_Vbi_ci=(DFe_Vbi_ci*(1.0+DFe)-DFe*(+DFe_Vbi_ci))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv_Vbp_ei=(DFe_Vbp_ei*(1.0+DFe)-DFe*(+DFe_Vbp_ei))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv_Vbp_ci=(DFe_Vbp_ci*(1.0+DFe)-DFe*(+DFe_Vbp_ci))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv_Vb_ci=(DFe_Vb_ci*(1.0+DFe)-DFe*(+DFe_Vb_ci))/((1.0+DFe)*(1.0+DFe));
DFdvj_dv_Vsi_ci=(DFe_Vsi_ci*(1.0+DFe)-DFe*(+DFe_Vsi_ci))/((1.0+DFe)*(1.0+DFe));
if (doAC)
{
DFdvj_dv=(DFe/(1.0+DFe));
}
}
else
{
DFv_j_Vsi_ci=1.0;
if (doAC)
{
DFv_j=BP(si,ci);
}
DFv_j_Vb_ci=0.0;
DFv_j_Vbp_ci=0.0;
DFv_j_Vbp_ei=0.0;
DFv_j_Vbi_ci=0.0;
DFv_j_Vtnode_GND=0.0;
DFv_j_Vbi_ei=0.0;
if (doAC)
{
DFdvj_dv=1;
}
DFdvj_dv_Vsi_ci=0.0;
DFdvj_dv_Vb_ci=0.0;
DFdvj_dv_Vbp_ci=0.0;
DFdvj_dv_Vbp_ei=0.0;
DFdvj_dv_Vbi_ci=0.0;
DFdvj_dv_Vtnode_GND=0.0;
DFdvj_dv_Vbi_ei=0.0;
}
if (doAC)
{
{
double __logE_0=0.0;
double __d_logE_0=0.0;
_d_logE(__logE_0,__d_logE_0,((1.0-(DFv_j/vds_t))));
_logE(__logE_0,((1.0-(DFv_j/vds_t))));
DFb_Vbi_ei=(-DFv_j_Vbi_ei/vds_t)*__d_logE_0;
DFb_Vtnode_GND=(-(DFv_j_Vtnode_GND*vds_t-DFv_j*vds_t_Vtnode_GND)/(vds_t*vds_t))*__d_logE_0;
DFb_Vbi_ci=(-DFv_j_Vbi_ci/vds_t)*__d_logE_0;
DFb_Vbp_ei=(-DFv_j_Vbp_ei/vds_t)*__d_logE_0;
DFb_Vbp_ci=(-DFv_j_Vbp_ci/vds_t)*__d_logE_0;
DFb_Vb_ci=(-DFv_j_Vb_ci/vds_t)*__d_logE_0;
DFb_Vsi_ci=(-DFv_j_Vsi_ci/vds_t)*__d_logE_0;
if (doAC)
{
DFb=__logE_0;
}
}
}
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,(((-zs)*DFb)));
_exp(__exp_0,(((-zs)*DFb)));
DFC_j1_Vbi_ei=(((cjs0_t*((-zs)*DFb_Vbi_ei)*__d_exp_0)*DFdvj_dv)+((cjs0_t*__exp_0)*DFdvj_dv_Vbi_ei));
DFC_j1_Vbi_ci=(((cjs0_t*((-zs)*DFb_Vbi_ci)*__d_exp_0)*DFdvj_dv)+((cjs0_t*__exp_0)*DFdvj_dv_Vbi_ci));
DFC_j1_Vbp_ei=(((cjs0_t*((-zs)*DFb_Vbp_ei)*__d_exp_0)*DFdvj_dv)+((cjs0_t*__exp_0)*DFdvj_dv_Vbp_ei));
DFC_j1_Vbp_ci=(((cjs0_t*((-zs)*DFb_Vbp_ci)*__d_exp_0)*DFdvj_dv)+((cjs0_t*__exp_0)*DFdvj_dv_Vbp_ci));
DFC_j1_Vb_ci=(((cjs0_t*((-zs)*DFb_Vb_ci)*__d_exp_0)*DFdvj_dv)+((cjs0_t*__exp_0)*DFdvj_dv_Vb_ci));
DFC_j1_Vsi_ci=(((cjs0_t*((-zs)*DFb_Vsi_ci)*__d_exp_0)*DFdvj_dv)+((cjs0_t*__exp_0)*DFdvj_dv_Vsi_ci));
DFC_j1_Vtnode_GND=((((cjs0_t_Vtnode_GND*__exp_0)+(cjs0_t*((-zs)*DFb_Vtnode_GND)*__d_exp_0))*DFdvj_dv)+((cjs0_t*__exp_0)*DFdvj_dv_Vtnode_GND));
if (doAC)
{
DFC_j1=((cjs0_t*__exp_0)*DFdvj_dv);
}
}
}
if (doAC)
{
Cjs=(DFC_j1+(DFC_max*(1.0-DFdvj_dv)));
}
if (doAC)
{
{
double __exp_0=0.0;
double __d_exp_0=0.0;
_d_exp(__exp_0,__d_exp_0,((DFb*(1.0-zs))));
_exp(__exp_0,((DFb*(1.0-zs))));
DFQ_j_Vbi_ei=((cjs0_t*vds_t)*(-DFb_Vbi_ei*(1.0-zs)*__d_exp_0))/(1.0-zs);
DFQ_j_Vbi_ci=((cjs0_t*vds_t)*(-DFb_Vbi_ci*(1.0-zs)*__d_exp_0))/(1.0-zs);
DFQ_j_Vbp_ei=((cjs0_t*vds_t)*(-DFb_Vbp_ei*(1.0-zs)*__d_exp_0))/(1.0-zs);
DFQ_j_Vbp_ci=((cjs0_t*vds_t)*(-DFb_Vbp_ci*(1.0-zs)*__d_exp_0))/(1.0-zs);
DFQ_j_Vb_ci=((cjs0_t*vds_t)*(-DFb_Vb_ci*(1.0-zs)*__d_exp_0))/(1.0-zs);
DFQ_j_Vsi_ci=((cjs0_t*vds_t)*(-DFb_Vsi_ci*(1.0-zs)*__d_exp_0))/(1.0-zs);
DFQ_j_Vtnode_GND=((((cjs0_t_Vtnode_GND*vds_t)+(cjs0_t*vds_t_Vtnode_GND))*(1.0-__exp_0))+((cjs0_t*vds_t)*(-DFb_Vtnode_GND*(1.0-zs)*__d_exp_0)))/(1.0-zs);
if (doAC)
{
DFQ_j=(((cjs0_t*vds_t)*(1.0-__exp_0))/(1.0-zs));
}
}
}
Qjs_Vbi_ei=(DFQ_j_Vbi_ei+(DFC_max*(-DFv_j_Vbi_ei)));
Qjs_Vtnode_GND=(DFQ_j_Vtnode_GND+((DFC_max_Vtnode_GND*(BP(si,ci)-DFv_j))+(DFC_max*(-DFv_j_Vtnode_GND))));
Qjs_Vbi_ci=(DFQ_j_Vbi_ci+(DFC_max*(-DFv_j_Vbi_ci)));
Qjs_Vbp_ei=(DFQ_j_Vbp_ei+(DFC_max*(-DFv_j_Vbp_ei)));
Qjs_Vbp_ci=(DFQ_j_Vbp_ci+(DFC_max*(-DFv_j_Vbp_ci)));
Qjs_Vb_ci=(DFQ_j_Vb_ci+(DFC_max*(-DFv_j_Vb_ci)));
Qjs_Vsi_ci=(DFQ_j_Vsi_ci+(DFC_max*(1.0-DFv_j_Vsi_ci)));
if (doAC)
{
Qjs=(DFQ_j+(DFC_max*(BP(si,ci)-DFv_j)));
}
}
else
{
if (doAC)
{
Cjs=0.0;
}
if (doAC)
{
Qjs=0.0;
}
Qjs_Vbp_ei=0.0;
Qjs_Vbi_ei=0.0;
Qjs_Vsi_ci=0.0;
Qjs_Vb_ci=0.0;
Qjs_Vbp_ci=0.0;
Qjs_Vtnode_GND=0.0;
Qjs_Vbi_ci=0.0;
}
}
if ((itss>0.0))
{
HSUM_Vtnode_GND=(msf*VT_Vtnode_GND);
HSUM=(msf*VT);
{
double __limexp_0=0.0;
double __d_limexp_0=0.0;
_d_limexp(__limexp_0,__d_limexp_0,((BP(bp,ci)/HSUM)));
_limexp(__limexp_0,((BP(bp,ci)/HSUM)));
HSa_Vtnode_GND=(-(BP(bp,ci)*HSUM_Vtnode_GND)/(HSUM*HSUM))*__d_limexp_0;
HSa_Vbp_ci=(1/HSUM)*__d_limexp_0;
HSa=__limexp_0;
}
{
double __limexp_0=0.0;
double __d_limexp_0=0.0;
_d_limexp(__limexp_0,__d_limexp_0,((BP(si,ci)/HSUM)));
_limexp(__limexp_0,((BP(si,ci)/HSUM)));
HSb_Vtnode_GND=(-(BP(si,ci)*HSUM_Vtnode_GND)/(HSUM*HSUM))*__d_limexp_0;
HSb_Vsi_ci=(1/HSUM)*__d_limexp_0;
HSb=__limexp_0;
}
HSI_Tsu_Vsi_ci=(itss_t*(-HSb_Vsi_ci));
HSI_Tsu_Vbp_ci=(itss_t*HSa_Vbp_ci);
HSI_Tsu_Vtnode_GND=((itss_t_Vtnode_GND*(HSa-HSb))+(itss_t*(HSa_Vtnode_GND-HSb_Vtnode_GND)));
HSI_Tsu=(itss_t*(HSa-HSb));
if ((tsf>0.0))
{
Qdsu_Vbp_ci=((tsf_t*itss_t)*HSa_Vbp_ci);
Qdsu_Vtnode_GND=((((tsf_t_Vtnode_GND*itss_t)+(tsf_t*itss_t_Vtnode_GND))*HSa)+((tsf_t*itss_t)*HSa_Vtnode_GND));
if (doAC)
{
Qdsu=((tsf_t*itss_t)*HSa);
}
}
else
{
if (doAC)
{
Qdsu=0.0;
}
Qdsu_Vtnode_GND=0.0;
Qdsu_Vbp_ci=0.0;
}
}
else
{
HSI_Tsu=0.0;
HSI_Tsu_Vtnode_GND=0.0;
HSI_Tsu_Vbp_ci=0.0;
HSI_Tsu_Vsi_ci=0.0;
if (doAC)
{
Qdsu=0.0;
}
Qdsu_Vtnode_GND=0.0;
Qdsu_Vbp_ci=0.0;
}
DIOY_Vtnode_GND=(-(BP(si,ci)*(msc*VT_Vtnode_GND))/((msc*VT)*(msc*VT)));
DIOY_Vsi_ci=(1/(msc*VT));
DIOY=(BP(si,ci)/(msc*VT));
DIOY_Vbp_ci=0.0;
DIOY_Vbp_ei=0.0;
DIOY_Vbi_ci=0.0;
DIOY_Vbi_ei=0.0;
if ((iscs>0.0))
{
if ((DIOY>80.0))
{
le_Vtnode_GND=(+DIOY_Vtnode_GND);
le_Vbi_ei=(+DIOY_Vbi_ei);
le_Vbi_ci=(+DIOY_Vbi_ci);
le_Vbp_ei=(+DIOY_Vbp_ei);
le_Vbp_ci=(+DIOY_Vbp_ci);
le_Vsi_ci=(+DIOY_Vsi_ci);
le=(1+(DIOY-80.0));
DIOY=80.0;
DIOY_Vsi_ci=0.0;
DIOY_Vbp_ci=0.0;
DIOY_Vbp_ei=0.0;
DIOY_Vbi_ci=0.0;
DIOY_Vbi_ei=0.0;
DIOY_Vtnode_GND=0.0;
}
else
{
le=1;
le_Vsi_ci=0.0;
le_Vbp_ci=0.0;
le_Vbp_ei=0.0;
le_Vbi_ci=0.0;
le_Vbi_ei=0.0;
le_Vtnode_GND=0.0;
}
{
double __limexp_0=0.0;
double __d_limexp_0=0.0;
_d_limexp(__limexp_0,__d_limexp_0,(DIOY));
_limexp(__limexp_0,(DIOY));
le_Vtnode_GND=((le_Vtnode_GND*__limexp_0)+(le*DIOY_Vtnode_GND*__d_limexp_0));
le_Vbi_ei=((le_Vbi_ei*__limexp_0)+(le*DIOY_Vbi_ei*__d_limexp_0));
le_Vbi_ci=((le_Vbi_ci*__limexp_0)+(le*DIOY_Vbi_ci*__d_limexp_0));
le_Vbp_ei=((le_Vbp_ei*__limexp_0)+(le*DIOY_Vbp_ei*__d_limexp_0));
le_Vbp_ci=((le_Vbp_ci*__limexp_0)+(le*DIOY_Vbp_ci*__d_limexp_0));
le_Vsi_ci=((le_Vsi_ci*__limexp_0)+(le*DIOY_Vsi_ci*__d_limexp_0));
le=(le*__limexp_0);
}
ijsc_Vbi_ei=(iscs_t*le_Vbi_ei);
ijsc_Vbi_ci=(iscs_t*le_Vbi_ci);
ijsc_Vbp_ei=(iscs_t*le_Vbp_ei);
ijsc_Vbp_ci=(iscs_t*le_Vbp_ci);
ijsc_Vsi_ci=(iscs_t*le_Vsi_ci);
ijsc_Vtnode_GND=((iscs_t_Vtnode_GND*(le-1.0))+(iscs_t*le_Vtnode_GND));
ijsc=(iscs_t*(le-1.0));
if ((DIOY<=(-14.0)))
{
ijsc_Vtnode_GND=(-iscs_t_Vtnode_GND);
ijsc=(-iscs_t);
ijsc_Vsi_ci=0.0;
ijsc_Vbp_ci=0.0;
ijsc_Vbp_ei=0.0;
ijsc_Vbi_ci=0.0;
ijsc_Vbi_ei=0.0;
}
}
else
{
ijsc=0.0;
ijsc_Vtnode_GND=0.0;
ijsc_Vsi_ci=0.0;
ijsc_Vbp_ci=0.0;
ijsc_Vbp_ei=0.0;
ijsc_Vbi_ci=0.0;
ijsc_Vbi_ei=0.0;
}
if ((rth>0.0))
{
pterm_Vbi_ci=((BP(ci,ei)*it_Vbi_ci)+(((-1.0)*iavl)+((vdci_t-BP(bi,ci))*iavl_Vbi_ci)));
pterm_Vbi_ei=((BP(ci,ei)*it_Vbi_ei)+((vdci_t-BP(bi,ci))*iavl_Vbi_ei));
pterm_Vtnode_GND=((BP(ci,ei)*it_Vtnode_GND)+((vdci_t_Vtnode_GND*iavl)+((vdci_t-BP(bi,ci))*iavl_Vtnode_GND)));
pterm_Vci_ei=((it+(it_Vci_ei*BP(ci,ei)))+((vdci_t-BP(bi,ci))*iavl_Vci_ei));
pterm=((BP(ci,ei)*it)+((vdci_t-BP(bi,ci))*iavl));
}
_load_static_residual2(bp,ei,(((-ibet)+ibep)+irep));
_load_static_jacobian4(bp,ei,bi,ei,(((-ibet_Vbi_ei)+ibep_Vbi_ei)+irep_Vbi_ei));
_load_static_jacobian4(bp,ei,bi,ci,(((-ibet_Vbi_ci)+ibep_Vbi_ci)+irep_Vbi_ci));
_load_static_jacobian4(bp,ei,bp,ei,(((-ibet_Vbp_ei)+ibep_Vbp_ei)+irep_Vbp_ei));
_load_static_jacobian2s(bp,ei,tnode,(((-ibet_Vtnode_GND)+ibep_Vtnode_GND)+irep_Vtnode_GND));
_load_static_residual2(bi,ei,(ibei+irei));
_load_static_jacobian4(bi,ei,bi,ei,(ibei_Vbi_ei+irei_Vbi_ei));
_load_static_jacobian2s(bi,ei,tnode,(ibei_Vtnode_GND+irei_Vtnode_GND));
_load_static_residual2(bp,si,HSI_Tsu);
_load_static_jacobian4(bp,si,si,ci,HSI_Tsu_Vsi_ci);
_load_static_jacobian4(bp,si,bp,ci,HSI_Tsu_Vbp_ci);
_load_static_jacobian2s(bp,si,tnode,HSI_Tsu_Vtnode_GND);
_load_static_residual2(bp,ci,ijbcx);
_load_static_jacobian4(bp,ci,bi,ei,ijbcx_Vbi_ei);
_load_static_jacobian4(bp,ci,bi,ci,ijbcx_Vbi_ci);
_load_static_jacobian4(bp,ci,bp,ei,ijbcx_Vbp_ei);
_load_static_jacobian4(bp,ci,bp,ci,ijbcx_Vbp_ci);
_load_static_jacobian2s(bp,ci,tnode,ijbcx_Vtnode_GND);
_load_static_residual2(bi,ci,(ibci-iavl));
_load_static_jacobian4(bi,ci,ci,ei,(-iavl_Vci_ei));
_load_static_jacobian4(bi,ci,bi,ei,(ibci_Vbi_ei-iavl_Vbi_ei));
_load_static_jacobian4(bi,ci,bi,ci,(ibci_Vbi_ci-iavl_Vbi_ci));
_load_static_jacobian2s(bi,ci,tnode,(ibci_Vtnode_GND-iavl_Vtnode_GND));
_load_static_residual2(si,ci,ijsc);
_load_static_jacobian4(si,ci,bi,ei,ijsc_Vbi_ei);
_load_static_jacobian4(si,ci,bi,ci,ijsc_Vbi_ci);
_load_static_jacobian4(si,ci,bp,ei,ijsc_Vbp_ei);
_load_static_jacobian4(si,ci,bp,ci,ijsc_Vbp_ci);
_load_static_jacobian4(si,ci,si,ci,ijsc_Vsi_ci);
_load_static_jacobian2s(si,ci,tnode,ijsc_Vtnode_GND);
_load_static_residual2(ci,ei,it);
_load_static_jacobian4(ci,ei,bi,ci,it_Vbi_ci);
_load_static_jacobian4(ci,ei,bi,ei,it_Vbi_ei);
_load_static_jacobian2s(ci,ei,tnode,it_Vtnode_GND);
_load_static_jacobian4(ci,ei,ci,ei,it_Vci_ei);
_load_dynamic_residual2(b,ci,(ccox1*BP(b,ci)));
_load_dynamic_jacobian4(b,ci,b,ci,(ccox1));
_load_dynamic_residual2(bp,ci,(ccox2*BP(bp,ci)));
_load_dynamic_jacobian4(bp,ci,bp,ci,(ccox2));
_load_dynamic_residual2(bp,e,(ceox*BP(bp,e)));
_load_dynamic_jacobian4(bp,e,bp,e,(ceox));
_load_dynamic_residual2(si,ci,Qjs);
_load_dynamic_jacobian4(si,ci,bi,ci,Qjs_Vbi_ci);
_load_dynamic_jacobian2s(si,ci,tnode,Qjs_Vtnode_GND);
_load_dynamic_jacobian4(si,ci,bp,ci,Qjs_Vbp_ci);
_load_dynamic_jacobian4(si,ci,b,ci,Qjs_Vb_ci);
_load_dynamic_jacobian4(si,ci,si,ci,Qjs_Vsi_ci);
_load_dynamic_jacobian4(si,ci,bi,ei,Qjs_Vbi_ei);
_load_dynamic_jacobian4(si,ci,bp,ei,Qjs_Vbp_ei);
_load_dynamic_residual2(bp,ei,Qjep);
_load_dynamic_jacobian4(bp,ei,bi,ei,Qjep_Vbi_ei);
_load_dynamic_jacobian2s(bp,ei,tnode,Qjep_Vtnode_GND);
_load_dynamic_jacobian4(bp,ei,bi,ci,Qjep_Vbi_ci);
_load_dynamic_jacobian4(bp,ei,bp,ei,Qjep_Vbp_ei);
_load_dynamic_residual2(bi,ei,(Qdei+Qjei));
_load_dynamic_jacobian4(bi,ei,bi,ei,(Qdei_Vbi_ei+Qjei_Vbi_ei));
_load_dynamic_jacobian4(bi,ei,bi,ci,Qdei_Vbi_ci);
_load_dynamic_jacobian2s(bi,ei,tnode,(Qdei_Vtnode_GND+Qjei_Vtnode_GND));
_load_dynamic_jacobian4(bi,ei,ci,ei,Qdei_Vci_ei);
_load_dynamic_residual2(bp,ci,(qjcx0_t_ii+Qdsu));
_load_dynamic_jacobian4(bp,ci,bi,ci,qjcx0_t_ii_Vbi_ci);
_load_dynamic_jacobian2s(bp,ci,tnode,(qjcx0_t_ii_Vtnode_GND+Qdsu_Vtnode_GND));
_load_dynamic_jacobian4(bp,ci,bp,ci,(qjcx0_t_ii_Vbp_ci+Qdsu_Vbp_ci));
_load_dynamic_jacobian4(bp,ci,bi,ei,qjcx0_t_ii_Vbi_ei);
_load_dynamic_jacobian4(bp,ci,bp,ei,qjcx0_t_ii_Vbp_ei);
_load_dynamic_residual2(bi,ci,(Qdci+Qjci));
_load_dynamic_jacobian4(bi,ci,bi,ei,(Qdci_Vbi_ei+Qjci_Vbi_ei));
_load_dynamic_jacobian4(bi,ci,bi,ci,(Qdci_Vbi_ci+Qjci_Vbi_ci));
_load_dynamic_jacobian2s(bi,ci,tnode,(Qdci_Vtnode_GND+Qjci_Vtnode_GND));
_load_dynamic_jacobian4(bi,ci,ci,ei,Qdci_Vci_ei);
_load_dynamic_residual2(b,ci,qjcx0_t_i);
_load_dynamic_jacobian4(b,ci,bi,ci,qjcx0_t_i_Vbi_ci);
_load_dynamic_jacobian2s(b,ci,tnode,qjcx0_t_i_Vtnode_GND);
_load_dynamic_jacobian4(b,ci,bp,ci,qjcx0_t_i_Vbp_ci);
_load_dynamic_jacobian4(b,ci,b,ci,qjcx0_t_i_Vb_ci);
_load_dynamic_jacobian4(b,ci,bi,ei,qjcx0_t_i_Vbi_ei);
_load_dynamic_jacobian4(b,ci,bp,ei,qjcx0_t_i_Vbp_ei);
if ((rbx>0.0))
{
_load_static_residual2(b,bp,(BP(b,bp)/rbx_t));
_load_static_jacobian2s(b,bp,tnode,(-(BP(b,bp)*rbx_t_Vtnode_GND)/(rbx_t*rbx_t)));
_load_static_jacobian4(b,bp,b,bp,(1/rbx_t));
}
else
{
_load_static_residual2(b,bp,0.0);
}
if ((rbi0>0.0))
{
_load_static_residual2(bp,bi,(BP(bp,bi)/rbi));
_load_static_jacobian4(bp,bi,bi,ci,(-(BP(bp,bi)*rbi_Vbi_ci)/(rbi*rbi)));
_load_static_jacobian4(bp,bi,ci,ei,(-(BP(bp,bi)*rbi_Vci_ei)/(rbi*rbi)));
_load_static_jacobian4(bp,bi,bi,ei,(-(BP(bp,bi)*rbi_Vbi_ei)/(rbi*rbi)));
_load_static_jacobian2s(bp,bi,tnode,(-(BP(bp,bi)*rbi_Vtnode_GND)/(rbi*rbi)));
_load_static_jacobian4(bp,bi,bp,bi,(1/rbi));
_load_dynamic_residual2(bp,bi,qrbi);
_load_dynamic_jacobian4(bp,bi,bi,ci,qrbi_Vbi_ci);
_load_dynamic_jacobian4(bp,bi,ci,ei,qrbi_Vci_ei);
_load_dynamic_jacobian4(bp,bi,bi,ei,qrbi_Vbi_ei);
_load_dynamic_jacobian2s(bp,bi,tnode,qrbi_Vtnode_GND);
}
else
{
_load_static_residual2(bp,bi,0.0);
}
if ((rcx>0.0))
{
_load_static_residual2(ci,c,(BP(ci,c)/rcx_t));
_load_static_jacobian2s(ci,c,tnode,(-(BP(ci,c)*rcx_t_Vtnode_GND)/(rcx_t*rcx_t)));
_load_static_jacobian4(ci,c,ci,c,(1/rcx_t));
}
else
{
_load_static_residual2(ci,c,0.0);
}
if ((re>0.0))
{
_load_static_residual2(ei,e,(BP(ei,e)/re_t));
_load_static_jacobian2s(ei,e,tnode,(-(BP(ei,e)*re_t_Vtnode_GND)/(re_t*re_t)));
_load_static_jacobian4(ei,e,ei,e,(1/re_t));
}
else
{
_load_static_residual2(ei,e,0.0);
}
if ((rsu>0.0))
{
_load_static_residual2(si,s,(BP(si,s)/rsu));
_load_static_jacobian4(si,s,si,s,(1/rsu));
_load_dynamic_residual2(si,s,(csu*BP(si,s)));
_load_dynamic_jacobian4(si,s,si,s,(csu));
}
else
{
_load_static_residual2(si,s,0.0);
}
if ((rth>0.0))
{
_load_static_residual1(tnode,(NP(tnode)/rth));
_load_static_jacobian1(tnode,tnode,(1/rth));
_load_static_residual1(tnode,(-pterm));
_load_static_jacobian2p(tnode,bi,ci,(-pterm_Vbi_ci));
_load_static_jacobian2p(tnode,bi,ei,(-pterm_Vbi_ei));
_load_static_jacobian1(tnode,tnode,(-pterm_Vtnode_GND));
_load_static_jacobian2p(tnode,ci,ei,(-pterm_Vci_ei));
_load_dynamic_residual1(tnode,(cth*NP(tnode)));
_load_dynamic_jacobian1(tnode,tnode,(cth));
}
else
{
_load_static_residual1(tnode,0.0);
}
fourkt_Vtnode_GND=((4.0*1.3806503e-23)*Tdev_Vtnode_GND);
fourkt=((4.0*1.3806503e-23)*Tdev);
if ((rbx>0.0))
{
_save_whitenoise2(b,bp,(fourkt/rbx_t),"thermal");
}
if ((rbi0>0.0))
{
rbin_Vbi_ci=(krbi*rbi_Vbi_ci);
rbin_Vci_ei=(krbi*rbi_Vci_ei);
rbin_Vbi_ei=(krbi*rbi_Vbi_ei);
rbin_Vtnode_GND=(krbi*rbi_Vtnode_GND);
rbin=(krbi*rbi);
_save_whitenoise2(bp,bi,(fourkt/rbin),"thermal");
}
if ((rcx>0.0))
{
_save_whitenoise2(ci,c,(fourkt/rcx_t),"thermal");
}
if ((re>0.0))
{
_save_whitenoise2(ei,e,(fourkt/re_t),"thermal");
}
if ((rsu>0.0))
{
_save_whitenoise2(si,s,(fourkt/rsu),"thermal");
}
{
double __pow_0=0.0;
double __dFx_pow_0=0.0;
_pow(__pow_0,(ibei+ibep),af);
_dx_pow(__dFx_pow_0,__pow_0,(ibei+ibep),af);
_pow(__pow_0,(ibei+ibep),af);
flicker_Pwr_Vbi_ci=(kf*(__dFx_pow_0*(+ibep_Vbi_ci)));
flicker_Pwr_Vbp_ei=(kf*(__dFx_pow_0*(+ibep_Vbp_ei)));
flicker_Pwr_Vbi_ei=(kf*(__dFx_pow_0*(ibei_Vbi_ei+ibep_Vbi_ei)));
flicker_Pwr_Vtnode_GND=(kf*(__dFx_pow_0*(ibei_Vtnode_GND+ibep_Vtnode_GND)));
flicker_Pwr=(kf*__pow_0);
}
_save_flickernoise2(bi,ei,flicker_Pwr,1.0,NULL);
twoq=(2.0*1.602176462e-19);
_save_whitenoise2(ci,ei,(twoq*it),"shot");
_save_whitenoise2(ci,bi,(twoq*iavl),"shot");
_save_whitenoise2(bi,ei,(twoq*ibei),"shot");
_save_whitenoise2(bi,ci,(twoq*ibci),"shot");
_save_whitenoise2(bp,ei,(twoq*ibep),"shot");
_save_whitenoise2(bp,ci,(twoq*ijbcx),"shot");
_save_whitenoise2(si,ci,(twoq*ijsc),"shot");

/* ------------------ end of verilog analog equations --------------------- */

/* ------------------ evaluate verilog noise equations -------------------- */

/* ------------------- end of verilog noise equations --------------------- */

}

/* Perform DC iteration. */
void hicumL2p1::calcDC (void)
{
  // evaluate Verilog code
  initVerilog ();		
  calcVerilog ();		

  // fill right hand side and static jacobian
  for (int i1 = 0; i1 < 10; i1++) {
    setI (i1, _rhs[i1]);
    for (int i2 = 0; i2 < 10; i2++) {
      setY (i1, i2, _jstat[i1][i2]);
    }
  }
}

/* Save operating points. */
void hicumL2p1::saveOperatingPoints (void)
{
#if DEBUG
  setOperatingPoint ("jstat[c][c]", _jstat[c][c]);
  setOperatingPoint ("jdyna[c][c]", _jdyna[c][c]);
  setOperatingPoint ("jstat[c][b]", _jstat[c][b]);
  setOperatingPoint ("jdyna[c][b]", _jdyna[c][b]);
  setOperatingPoint ("jstat[c][e]", _jstat[c][e]);
  setOperatingPoint ("jdyna[c][e]", _jdyna[c][e]);
  setOperatingPoint ("jstat[c][s]", _jstat[c][s]);
  setOperatingPoint ("jdyna[c][s]", _jdyna[c][s]);
  setOperatingPoint ("jstat[c][tnode]", _jstat[c][tnode]);
  setOperatingPoint ("jdyna[c][tnode]", _jdyna[c][tnode]);
  setOperatingPoint ("jstat[c][ci]", _jstat[c][ci]);
  setOperatingPoint ("jdyna[c][ci]", _jdyna[c][ci]);
  setOperatingPoint ("jstat[c][ei]", _jstat[c][ei]);
  setOperatingPoint ("jdyna[c][ei]", _jdyna[c][ei]);
  setOperatingPoint ("jstat[c][bp]", _jstat[c][bp]);
  setOperatingPoint ("jdyna[c][bp]", _jdyna[c][bp]);
  setOperatingPoint ("jstat[c][bi]", _jstat[c][bi]);
  setOperatingPoint ("jdyna[c][bi]", _jdyna[c][bi]);
  setOperatingPoint ("jstat[c][si]", _jstat[c][si]);
  setOperatingPoint ("jdyna[c][si]", _jdyna[c][si]);
  setOperatingPoint ("jstat[b][c]", _jstat[b][c]);
  setOperatingPoint ("jdyna[b][c]", _jdyna[b][c]);
  setOperatingPoint ("jstat[b][b]", _jstat[b][b]);
  setOperatingPoint ("jdyna[b][b]", _jdyna[b][b]);
  setOperatingPoint ("jstat[b][e]", _jstat[b][e]);
  setOperatingPoint ("jdyna[b][e]", _jdyna[b][e]);
  setOperatingPoint ("jstat[b][s]", _jstat[b][s]);
  setOperatingPoint ("jdyna[b][s]", _jdyna[b][s]);
  setOperatingPoint ("jstat[b][tnode]", _jstat[b][tnode]);
  setOperatingPoint ("jdyna[b][tnode]", _jdyna[b][tnode]);
  setOperatingPoint ("jstat[b][ci]", _jstat[b][ci]);
  setOperatingPoint ("jdyna[b][ci]", _jdyna[b][ci]);
  setOperatingPoint ("jstat[b][ei]", _jstat[b][ei]);
  setOperatingPoint ("jdyna[b][ei]", _jdyna[b][ei]);
  setOperatingPoint ("jstat[b][bp]", _jstat[b][bp]);
  setOperatingPoint ("jdyna[b][bp]", _jdyna[b][bp]);
  setOperatingPoint ("jstat[b][bi]", _jstat[b][bi]);
  setOperatingPoint ("jdyna[b][bi]", _jdyna[b][bi]);
  setOperatingPoint ("jstat[b][si]", _jstat[b][si]);
  setOperatingPoint ("jdyna[b][si]", _jdyna[b][si]);
  setOperatingPoint ("jstat[e][c]", _jstat[e][c]);
  setOperatingPoint ("jdyna[e][c]", _jdyna[e][c]);
  setOperatingPoint ("jstat[e][b]", _jstat[e][b]);
  setOperatingPoint ("jdyna[e][b]", _jdyna[e][b]);
  setOperatingPoint ("jstat[e][e]", _jstat[e][e]);
  setOperatingPoint ("jdyna[e][e]", _jdyna[e][e]);
  setOperatingPoint ("jstat[e][s]", _jstat[e][s]);
  setOperatingPoint ("jdyna[e][s]", _jdyna[e][s]);
  setOperatingPoint ("jstat[e][tnode]", _jstat[e][tnode]);
  setOperatingPoint ("jdyna[e][tnode]", _jdyna[e][tnode]);
  setOperatingPoint ("jstat[e][ci]", _jstat[e][ci]);
  setOperatingPoint ("jdyna[e][ci]", _jdyna[e][ci]);
  setOperatingPoint ("jstat[e][ei]", _jstat[e][ei]);
  setOperatingPoint ("jdyna[e][ei]", _jdyna[e][ei]);
  setOperatingPoint ("jstat[e][bp]", _jstat[e][bp]);
  setOperatingPoint ("jdyna[e][bp]", _jdyna[e][bp]);
  setOperatingPoint ("jstat[e][bi]", _jstat[e][bi]);
  setOperatingPoint ("jdyna[e][bi]", _jdyna[e][bi]);
  setOperatingPoint ("jstat[e][si]", _jstat[e][si]);
  setOperatingPoint ("jdyna[e][si]", _jdyna[e][si]);
  setOperatingPoint ("jstat[s][c]", _jstat[s][c]);
  setOperatingPoint ("jdyna[s][c]", _jdyna[s][c]);
  setOperatingPoint ("jstat[s][b]", _jstat[s][b]);
  setOperatingPoint ("jdyna[s][b]", _jdyna[s][b]);
  setOperatingPoint ("jstat[s][e]", _jstat[s][e]);
  setOperatingPoint ("jdyna[s][e]", _jdyna[s][e]);
  setOperatingPoint ("jstat[s][s]", _jstat[s][s]);
  setOperatingPoint ("jdyna[s][s]", _jdyna[s][s]);
  setOperatingPoint ("jstat[s][tnode]", _jstat[s][tnode]);
  setOperatingPoint ("jdyna[s][tnode]", _jdyna[s][tnode]);
  setOperatingPoint ("jstat[s][ci]", _jstat[s][ci]);
  setOperatingPoint ("jdyna[s][ci]", _jdyna[s][ci]);
  setOperatingPoint ("jstat[s][ei]", _jstat[s][ei]);
  setOperatingPoint ("jdyna[s][ei]", _jdyna[s][ei]);
  setOperatingPoint ("jstat[s][bp]", _jstat[s][bp]);
  setOperatingPoint ("jdyna[s][bp]", _jdyna[s][bp]);
  setOperatingPoint ("jstat[s][bi]", _jstat[s][bi]);
  setOperatingPoint ("jdyna[s][bi]", _jdyna[s][bi]);
  setOperatingPoint ("jstat[s][si]", _jstat[s][si]);
  setOperatingPoint ("jdyna[s][si]", _jdyna[s][si]);
  setOperatingPoint ("jstat[tnode][c]", _jstat[tnode][c]);
  setOperatingPoint ("jdyna[tnode][c]", _jdyna[tnode][c]);
  setOperatingPoint ("jstat[tnode][b]", _jstat[tnode][b]);
  setOperatingPoint ("jdyna[tnode][b]", _jdyna[tnode][b]);
  setOperatingPoint ("jstat[tnode][e]", _jstat[tnode][e]);
  setOperatingPoint ("jdyna[tnode][e]", _jdyna[tnode][e]);
  setOperatingPoint ("jstat[tnode][s]", _jstat[tnode][s]);
  setOperatingPoint ("jdyna[tnode][s]", _jdyna[tnode][s]);
  setOperatingPoint ("jstat[tnode][tnode]", _jstat[tnode][tnode]);
  setOperatingPoint ("jdyna[tnode][tnode]", _jdyna[tnode][tnode]);
  setOperatingPoint ("jstat[tnode][ci]", _jstat[tnode][ci]);
  setOperatingPoint ("jdyna[tnode][ci]", _jdyna[tnode][ci]);
  setOperatingPoint ("jstat[tnode][ei]", _jstat[tnode][ei]);
  setOperatingPoint ("jdyna[tnode][ei]", _jdyna[tnode][ei]);
  setOperatingPoint ("jstat[tnode][bp]", _jstat[tnode][bp]);
  setOperatingPoint ("jdyna[tnode][bp]", _jdyna[tnode][bp]);
  setOperatingPoint ("jstat[tnode][bi]", _jstat[tnode][bi]);
  setOperatingPoint ("jdyna[tnode][bi]", _jdyna[tnode][bi]);
  setOperatingPoint ("jstat[tnode][si]", _jstat[tnode][si]);
  setOperatingPoint ("jdyna[tnode][si]", _jdyna[tnode][si]);
  setOperatingPoint ("jstat[ci][c]", _jstat[ci][c]);
  setOperatingPoint ("jdyna[ci][c]", _jdyna[ci][c]);
  setOperatingPoint ("jstat[ci][b]", _jstat[ci][b]);
  setOperatingPoint ("jdyna[ci][b]", _jdyna[ci][b]);
  setOperatingPoint ("jstat[ci][e]", _jstat[ci][e]);
  setOperatingPoint ("jdyna[ci][e]", _jdyna[ci][e]);
  setOperatingPoint ("jstat[ci][s]", _jstat[ci][s]);
  setOperatingPoint ("jdyna[ci][s]", _jdyna[ci][s]);
  setOperatingPoint ("jstat[ci][tnode]", _jstat[ci][tnode]);
  setOperatingPoint ("jdyna[ci][tnode]", _jdyna[ci][tnode]);
  setOperatingPoint ("jstat[ci][ci]", _jstat[ci][ci]);
  setOperatingPoint ("jdyna[ci][ci]", _jdyna[ci][ci]);
  setOperatingPoint ("jstat[ci][ei]", _jstat[ci][ei]);
  setOperatingPoint ("jdyna[ci][ei]", _jdyna[ci][ei]);
  setOperatingPoint ("jstat[ci][bp]", _jstat[ci][bp]);
  setOperatingPoint ("jdyna[ci][bp]", _jdyna[ci][bp]);
  setOperatingPoint ("jstat[ci][bi]", _jstat[ci][bi]);
  setOperatingPoint ("jdyna[ci][bi]", _jdyna[ci][bi]);
  setOperatingPoint ("jstat[ci][si]", _jstat[ci][si]);
  setOperatingPoint ("jdyna[ci][si]", _jdyna[ci][si]);
  setOperatingPoint ("jstat[ei][c]", _jstat[ei][c]);
  setOperatingPoint ("jdyna[ei][c]", _jdyna[ei][c]);
  setOperatingPoint ("jstat[ei][b]", _jstat[ei][b]);
  setOperatingPoint ("jdyna[ei][b]", _jdyna[ei][b]);
  setOperatingPoint ("jstat[ei][e]", _jstat[ei][e]);
  setOperatingPoint ("jdyna[ei][e]", _jdyna[ei][e]);
  setOperatingPoint ("jstat[ei][s]", _jstat[ei][s]);
  setOperatingPoint ("jdyna[ei][s]", _jdyna[ei][s]);
  setOperatingPoint ("jstat[ei][tnode]", _jstat[ei][tnode]);
  setOperatingPoint ("jdyna[ei][tnode]", _jdyna[ei][tnode]);
  setOperatingPoint ("jstat[ei][ci]", _jstat[ei][ci]);
  setOperatingPoint ("jdyna[ei][ci]", _jdyna[ei][ci]);
  setOperatingPoint ("jstat[ei][ei]", _jstat[ei][ei]);
  setOperatingPoint ("jdyna[ei][ei]", _jdyna[ei][ei]);
  setOperatingPoint ("jstat[ei][bp]", _jstat[ei][bp]);
  setOperatingPoint ("jdyna[ei][bp]", _jdyna[ei][bp]);
  setOperatingPoint ("jstat[ei][bi]", _jstat[ei][bi]);
  setOperatingPoint ("jdyna[ei][bi]", _jdyna[ei][bi]);
  setOperatingPoint ("jstat[ei][si]", _jstat[ei][si]);
  setOperatingPoint ("jdyna[ei][si]", _jdyna[ei][si]);
  setOperatingPoint ("jstat[bp][c]", _jstat[bp][c]);
  setOperatingPoint ("jdyna[bp][c]", _jdyna[bp][c]);
  setOperatingPoint ("jstat[bp][b]", _jstat[bp][b]);
  setOperatingPoint ("jdyna[bp][b]", _jdyna[bp][b]);
  setOperatingPoint ("jstat[bp][e]", _jstat[bp][e]);
  setOperatingPoint ("jdyna[bp][e]", _jdyna[bp][e]);
  setOperatingPoint ("jstat[bp][s]", _jstat[bp][s]);
  setOperatingPoint ("jdyna[bp][s]", _jdyna[bp][s]);
  setOperatingPoint ("jstat[bp][tnode]", _jstat[bp][tnode]);
  setOperatingPoint ("jdyna[bp][tnode]", _jdyna[bp][tnode]);
  setOperatingPoint ("jstat[bp][ci]", _jstat[bp][ci]);
  setOperatingPoint ("jdyna[bp][ci]", _jdyna[bp][ci]);
  setOperatingPoint ("jstat[bp][ei]", _jstat[bp][ei]);
  setOperatingPoint ("jdyna[bp][ei]", _jdyna[bp][ei]);
  setOperatingPoint ("jstat[bp][bp]", _jstat[bp][bp]);
  setOperatingPoint ("jdyna[bp][bp]", _jdyna[bp][bp]);
  setOperatingPoint ("jstat[bp][bi]", _jstat[bp][bi]);
  setOperatingPoint ("jdyna[bp][bi]", _jdyna[bp][bi]);
  setOperatingPoint ("jstat[bp][si]", _jstat[bp][si]);
  setOperatingPoint ("jdyna[bp][si]", _jdyna[bp][si]);
  setOperatingPoint ("jstat[bi][c]", _jstat[bi][c]);
  setOperatingPoint ("jdyna[bi][c]", _jdyna[bi][c]);
  setOperatingPoint ("jstat[bi][b]", _jstat[bi][b]);
  setOperatingPoint ("jdyna[bi][b]", _jdyna[bi][b]);
  setOperatingPoint ("jstat[bi][e]", _jstat[bi][e]);
  setOperatingPoint ("jdyna[bi][e]", _jdyna[bi][e]);
  setOperatingPoint ("jstat[bi][s]", _jstat[bi][s]);
  setOperatingPoint ("jdyna[bi][s]", _jdyna[bi][s]);
  setOperatingPoint ("jstat[bi][tnode]", _jstat[bi][tnode]);
  setOperatingPoint ("jdyna[bi][tnode]", _jdyna[bi][tnode]);
  setOperatingPoint ("jstat[bi][ci]", _jstat[bi][ci]);
  setOperatingPoint ("jdyna[bi][ci]", _jdyna[bi][ci]);
  setOperatingPoint ("jstat[bi][ei]", _jstat[bi][ei]);
  setOperatingPoint ("jdyna[bi][ei]", _jdyna[bi][ei]);
  setOperatingPoint ("jstat[bi][bp]", _jstat[bi][bp]);
  setOperatingPoint ("jdyna[bi][bp]", _jdyna[bi][bp]);
  setOperatingPoint ("jstat[bi][bi]", _jstat[bi][bi]);
  setOperatingPoint ("jdyna[bi][bi]", _jdyna[bi][bi]);
  setOperatingPoint ("jstat[bi][si]", _jstat[bi][si]);
  setOperatingPoint ("jdyna[bi][si]", _jdyna[bi][si]);
  setOperatingPoint ("jstat[si][c]", _jstat[si][c]);
  setOperatingPoint ("jdyna[si][c]", _jdyna[si][c]);
  setOperatingPoint ("jstat[si][b]", _jstat[si][b]);
  setOperatingPoint ("jdyna[si][b]", _jdyna[si][b]);
  setOperatingPoint ("jstat[si][e]", _jstat[si][e]);
  setOperatingPoint ("jdyna[si][e]", _jdyna[si][e]);
  setOperatingPoint ("jstat[si][s]", _jstat[si][s]);
  setOperatingPoint ("jdyna[si][s]", _jdyna[si][s]);
  setOperatingPoint ("jstat[si][tnode]", _jstat[si][tnode]);
  setOperatingPoint ("jdyna[si][tnode]", _jdyna[si][tnode]);
  setOperatingPoint ("jstat[si][ci]", _jstat[si][ci]);
  setOperatingPoint ("jdyna[si][ci]", _jdyna[si][ci]);
  setOperatingPoint ("jstat[si][ei]", _jstat[si][ei]);
  setOperatingPoint ("jdyna[si][ei]", _jdyna[si][ei]);
  setOperatingPoint ("jstat[si][bp]", _jstat[si][bp]);
  setOperatingPoint ("jdyna[si][bp]", _jdyna[si][bp]);
  setOperatingPoint ("jstat[si][bi]", _jstat[si][bi]);
  setOperatingPoint ("jdyna[si][bi]", _jdyna[si][bi]);
  setOperatingPoint ("jstat[si][si]", _jstat[si][si]);
  setOperatingPoint ("jdyna[si][si]", _jdyna[si][si]);
  setOperatingPoint ("white_pwr[ci][bi]", _white_pwr[ci][bi]);
  setOperatingPoint ("white_pwr[si][s]", _white_pwr[si][s]);
  setOperatingPoint ("white_pwr[ei][e]", _white_pwr[ei][e]);
  setOperatingPoint ("white_pwr[ci][c]", _white_pwr[ci][c]);
  setOperatingPoint ("white_pwr[bp][bi]", _white_pwr[bp][bi]);
  setOperatingPoint ("white_pwr[b][bp]", _white_pwr[b][bp]);
  setOperatingPoint ("white_pwr[ci][ei]", _white_pwr[ci][ei]);
  setOperatingPoint ("white_pwr[si][ci]", _white_pwr[si][ci]);
  setOperatingPoint ("white_pwr[bi][ci]", _white_pwr[bi][ci]);
  setOperatingPoint ("white_pwr[bp][ci]", _white_pwr[bp][ci]);
  setOperatingPoint ("white_pwr[bi][ei]", _white_pwr[bi][ei]);
  setOperatingPoint ("white_pwr[bp][ei]", _white_pwr[bp][ei]);
  setOperatingPoint ("flicker_pwr[bi][ei]", _flicker_pwr[bi][ei]);
#endif /* DEBUG */
}

/* Load operating points. */
void hicumL2p1::loadOperatingPoints (void)
{
}

/* Calculate operating points. */
void hicumL2p1::calcOperatingPoints (void)
{
}

/* Initialization of AC analysis. */
void hicumL2p1::initAC (void)
{
  allocMatrixMNA ();
}

/* Perform AC calculations. */
void hicumL2p1::calcAC (nr_double_t frequency)
{
  setMatrixY (calcMatrixY (frequency));
}

/* Compute Y-matrix for AC analysis. */
matrix hicumL2p1::calcMatrixY (nr_double_t frequency)
{
  _freq = frequency;
  saveOperatingPoints ();
  matrix y (10);

  for (int i1 = 0; i1 < 10; i1++) {
    for (int i2 = 0; i2 < 10; i2++) {
      y (i1,i2) = rect (_jstat[i1][i2], _jdyna[i1][i2] * 2 * M_PI * _freq);
    }
  }

  return y;
}

/* Initialization of S-parameter analysis. */
void hicumL2p1::initSP (void)
{
  allocMatrixS ();
}

/* Perform S-parameter calculations. */
void hicumL2p1::calcSP (nr_double_t frequency)
{
  setMatrixS (ytos (calcMatrixY (frequency)));   
}

/* Initialization of transient analysis. */
void hicumL2p1::initTR (void)
{
  setStates (2 * 10 * 10);
  initDC ();
}

/* Perform transient analysis iteration step. */
void hicumL2p1::calcTR (nr_double_t)
{
  doHB = 0;
  doAC = 1;
  doTR = 1;
  calcDC ();

  int i1, i2, i3, i4, state;

  // 2-node charge integrations
  for (i1 = 0; i1 < 10; i1++) {
  for (i2 = 0; i2 < 10; i2++) {
    state = 2 * (i2 + 10 * i1);
    if (i1 != i2)
    if (_charges[i1][i2] != 0.0)
      transientCapacitanceQ (state, i1, i2, _charges[i1][i2]);
  } }

  // 1-node charge integrations
  for (i1 = 0; i1 < 10; i1++) {
    state = 2 * (i1 + 10 * i1);
    if (_charges[i1][i1] != 0.0)
      transientCapacitanceQ (state, i1, _charges[i1][i1]);
  }

  // charge: 2-node, voltage: 2-node
  for (i1 = 0; i1 < 10; i1++) {
  for (i2 = 0; i2 < 10; i2++) {
  if (i1 != i2)
  for (i3 = 0; i3 < 10; i3++) {
  for (i4 = 0; i4 < 10; i4++) {
    if (i3 != i4)
    if (_caps[i1][i2][i3][i4] != 0.0)
      transientCapacitanceC (i1, i2, i3, i4, _caps[i1][i2][i3][i4], BP(i3,i4));
  } } } }

  // charge: 2-node, voltage: 1-node
  for (i1 = 0; i1 < 10; i1++) {
  for (i2 = 0; i2 < 10; i2++) {
  if (i1 != i2)
  for (i3 = 0; i3 < 10; i3++) {
    if (_caps[i1][i2][i3][i3] != 0.0)
      transientCapacitanceC2Q (i1, i2, i3, _caps[i1][i2][i3][i3], NP(i3));
  } } }

  // charge: 1-node, voltage: 2-node
  for (i1 = 0; i1 < 10; i1++) {
  for (i3 = 0; i3 < 10; i3++) {
  for (i4 = 0; i4 < 10; i4++) {
    if (i3 != i4)
    if (_caps[i1][i1][i3][i4] != 0.0)
      transientCapacitanceC2V (i1, i3, i4, _caps[i1][i1][i3][i4], BP(i3,i4));
  } } }
     
  // charge: 1-node, voltage: 1-node
  for (i1 = 0; i1 < 10; i1++) {
  for (i3 = 0; i3 < 10; i3++) {
    if (_caps[i1][i1][i3][i3] != 0.0)
      transientCapacitanceC (i1, i3, _caps[i1][i1][i3][i3], NP(i3));
  } }
}

/* Compute Cy-matrix for AC noise analysis. */
matrix hicumL2p1::calcMatrixCy (nr_double_t frequency) 
{
  _freq = frequency;
  matrix cy (10);

  _load_flickernoise2 (bi,ei,_flicker_pwr[bi][ei],_flicker_exp[bi][ei]);
  _load_whitenoise2 (ci,bi,_white_pwr[ci][bi]);
  _load_whitenoise2 (si,s,_white_pwr[si][s]);
  _load_whitenoise2 (ei,e,_white_pwr[ei][e]);
  _load_whitenoise2 (ci,c,_white_pwr[ci][c]);
  _load_whitenoise2 (bp,bi,_white_pwr[bp][bi]);
  _load_whitenoise2 (b,bp,_white_pwr[b][bp]);
  _load_whitenoise2 (ci,ei,_white_pwr[ci][ei]);
  _load_whitenoise2 (si,ci,_white_pwr[si][ci]);
  _load_whitenoise2 (bi,ci,_white_pwr[bi][ci]);
  _load_whitenoise2 (bp,ci,_white_pwr[bp][ci]);
  _load_whitenoise2 (bi,ei,_white_pwr[bi][ei]);
  _load_whitenoise2 (bp,ei,_white_pwr[bp][ei]);

  return cy;
}

/* Perform AC noise computations. */
void hicumL2p1::calcNoiseAC (nr_double_t frequency) 
{
  setMatrixN (calcMatrixCy (frequency));
}

/* Perform S-parameter noise computations. */
void hicumL2p1::calcNoiseSP (nr_double_t frequency) 
{
  setMatrixN (cytocs (calcMatrixCy (frequency) * z0, getMatrixS ()));
}

/* Initialization of HB analysis. */
void hicumL2p1::initHB (int)
{
  initDC ();
  allocMatrixHB ();
}

/* Perform HB analysis. */
void hicumL2p1::calcHB (int)
{
  doHB = 1;
  doAC = 1;
  doTR = 0;

  // jacobian dI/dV and currents get filled
  calcDC ();
  saveOperatingPoints ();

  // fill in HB matrices
  for (int i1 = 0; i1 < 10; i1++) {
    setQ  (i1, _qhs[i1]); // charges
    setCV (i1, _chs[i1]); // jacobian dQ/dV * V
    setGV (i1, _ghs[i1]); // jacobian dI/dV * V
    for (int i2 = 0; i2 < 10; i2++) {
      setQV (i1, i2, _jdyna[i1][i2]); // jacobian dQ/dV
    }
  }
}
