/* -*- mode: c++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

/*
 Copyright (C) 2010 Master IMAFA - Polytech'Nice Sophia - Université de Nice Sophia Antipolis

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it
 under the terms of the QuantLib license.  You should have received a
 copy of the license along with this program; if not, please email
 <quantlib-dev@lists.sf.net>. The license is also available online at
 <http://quantlib.org/license.shtml>.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

/*! \file analyticsimplechooserengine.hpp
    \brief Analytic engine for simple chooser option
*/

#ifndef quantlib_analytic_simple_chooser_engine_hpp
#define quantlib_analytic_simple_chooser_engine_hpp

#include <ql/experimental/exoticoptions/simplechooseroption.hpp>
#include <ql/processes/blackscholesprocess.hpp>

namespace QuantLib {

    //! Pricing engine for European Simple Chooser option
    /*! This class implements a Simple Chooser Option
        option, with European exercise.
    */
    class AnalyticSimpleChooserEngine : public SimpleChooserOption::engine {
      public:
        AnalyticSimpleChooserEngine(
            const boost::shared_ptr<GeneralizedBlackScholesProcess>& process);
        void calculate() const;
      private:
        boost::shared_ptr<GeneralizedBlackScholesProcess> process_;
    };

}

#endif
