/* Copyright (C) 2006 P.L. Lucas
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA. 
 */

#ifndef __TERMINAL_H__
#define __TERMINAL_H__

#include <QTextEdit>
#include <QPushButton>
#include <QMdiArea>
#include <QCloseEvent>
#include "basewidget.h"
#include "octave_connection.h"
#include "dynamic_help/dynamic_help.h"
#include "autocomplete.h"
#include "command_list.h"

/** Builds windows with QtextEdit and QLineEdit. QTextEdit shows OctaveConnection output.
 * QLineEdit is used to write commands.
 * 
 */

class Terminal:public BaseWidget
{
	Q_OBJECT
	public:
	Terminal( QWidget * parent = 0 );
	~Terminal();
	QTextEdit *getTextEdit();
	void setOctaveConnection(OctaveConnection *octave_connection);
	OctaveConnection *getOctaveConnection();
	void command_enter(const QString &text);
	
	void setSession(Session *session);
	BaseWidget *copyBaseWidget( QWidget * parent = 0 );
	
	/**Use 'save' octave commend to save variables.*/
	void saveVariables();
	
	Autocomplete *getAutocomplete();
	
	QMdiArea *work_space;
	//Session *session;
	private:
	QTextEdit *text;
	Autocomplete *combo_box;
	QPushButton *show_commands_button;
	OctaveConnection *octave_connection;
	int lines_in_terminal;
	int cols_in_terminal;
	void remove_lines(QTextCursor &cursor);
	
	void closeEvent(QCloseEvent*);
	protected:
	//Drag and drop
	void dragEnterEvent(QDragEnterEvent *event);
	void dropEvent ( QDropEvent * event );
	public slots:
	void return_pressed();
	void write_output(QString output);
	void write_error(QString error);
	void write_command(QString command);
	void completion_matches_callback();
	void stop_process_callback();
	void clear_callback();
	void clear_command_line_first_time();
	CommandList *show_commands_callback();
	void textChanged(const QString &text);
	void setProject(QString project=QString());
};


#endif
