/****************************************************************************
**
** Copyright (C) 1992-2005 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "abstractwidgetbox.h"

/*!
    \class QDesignerWidgetBoxInterface
    \inmodule QtDesigner
*/

/*!
*/
QDesignerWidgetBoxInterface::QDesignerWidgetBoxInterface(QWidget *parent, Qt::WindowFlags flags)
    : QWidget(parent, flags)
{
}

/*!
*/
QDesignerWidgetBoxInterface::~QDesignerWidgetBoxInterface()
{
}

/*!
*/
int QDesignerWidgetBoxInterface::findOrInsertCategory(const QString &categoryName)
{
    int count = categoryCount();
    for (int index=0; index<count; ++index) {
        Category c = category(index);
        if (c.name() == categoryName)
            return index;
    }

    addCategory(Category(categoryName));
    return count;
}

/*!
    \fn QDesignerWidgetBoxInterface::QDesignerWidgetBoxInterface(QWidget *parent, Qt::WindowFlags flags)
*/

/*!
    \fn virtual QDesignerWidgetBoxInterface::~QDesignerWidgetBoxInterface()
*/

/*!
    \fn virtual int QDesignerWidgetBoxInterface::categoryCount() const = 0
*/

/*!
    \fn virtual Category QDesignerWidgetBoxInterface::category(int cat_idx) const = 0
*/

/*!
    \fn virtual void QDesignerWidgetBoxInterface::addCategory(const Category &cat) = 0
*/

/*!
    \fn virtual void QDesignerWidgetBoxInterface::removeCategory(int cat_idx) = 0
*/

/*!
    \fn virtual int QDesignerWidgetBoxInterface::widgetCount(int cat_idx) const = 0
*/

/*!
    \fn virtual Widget QDesignerWidgetBoxInterface::widget(int cat_idx, int wgt_idx) const = 0
*/

/*!
    \fn virtual void QDesignerWidgetBoxInterface::addWidget(int cat_idx, const Widget &wgt) = 0
*/

/*!
    \fn virtual void QDesignerWidgetBoxInterface::removeWidget(int cat_idx, int wgt_idx) = 0
*/

/*!
    \fn int QDesignerWidgetBoxInterface::findOrInsertCategory(const QString &categoryName)
*/

/*!
    \fn virtual void QDesignerWidgetBoxInterface::dropWidgets(const QList<QDesignerDnDItemInterface*> &item_list, const QPoint &global_mouse_pos) = 0
*/

/*!
    \fn virtual void QDesignerWidgetBoxInterface::setFileName(const QString &file_name) = 0
*/

/*!
    \fn virtual QString QDesignerWidgetBoxInterface::fileName() const = 0
*/

/*!
    \fn virtual bool QDesignerWidgetBoxInterface::load() = 0
*/

/*!
    \fn virtual bool QDesignerWidgetBoxInterface::save() = 0
*/


/*!
    \class QDesignerWidgetBoxInterface::Widget
*/

/*!
    \enum QDesignerWidgetBoxInterface::Widget::Type

    \value Default
    \value Custom
*/

/*!
    \fn QDesignerWidgetBoxInterface::Widget::Widget(const QString &aname, const QString &xml, const QString &icon_name, Type atype)
*/

/*!
    \fn QString QDesignerWidgetBoxInterface::Widget::name() const
*/

/*!
    \fn void QDesignerWidgetBoxInterface::Widget::setName(const QString &aname)
*/

/*!
    \fn QString QDesignerWidgetBoxInterface::Widget::domXml() const
*/

/*!
    \fn void QDesignerWidgetBoxInterface::Widget::setDomXml(const QString &xml)
*/

/*!
    \fn QString QDesignerWidgetBoxInterface::Widget::iconName() const
*/

/*!
    \fn void QDesignerWidgetBoxInterface::Widget::setIconName(const QString &icon_name)
*/

/*!
    \fn Type QDesignerWidgetBoxInterface::Widget::type() const
*/

/*!
    \fn void QDesignerWidgetBoxInterface::Widget::setType(Type atype)
*/

/*!
    \fn bool QDesignerWidgetBoxInterface::Widget::isNull() const
*/


/*!
    \class QDesignerWidgetBoxInterface::Category
*/

/*!
    \enum QDesignerWidgetBoxInterface::Category::Type

    \value Default
    \value Scratchpad
*/

/*!
    \fn QDesignerWidgetBoxInterface::Category::Category(const QString &aname, Type atype)
*/

/*!
    \fn QString QDesignerWidgetBoxInterface::Category::name() const
*/

/*!
    \fn void QDesignerWidgetBoxInterface::Category::setName(const QString &aname)
*/

/*!
    \fn int QDesignerWidgetBoxInterface::Category::widgetCount() const
*/

/*!
    \fn Widget QDesignerWidgetBoxInterface::Category::widget(int idx) const
*/

/*!
    \fn void QDesignerWidgetBoxInterface::Category::removeWidget(int idx)
*/

/*!
    \fn void QDesignerWidgetBoxInterface::Category::addWidget(const Widget &awidget)
*/

/*!
    \fn Type QDesignerWidgetBoxInterface::Category::type() const
*/

/*!
    \fn void QDesignerWidgetBoxInterface::Category::setType(Type atype)
*/

/*!
    \fn bool QDesignerWidgetBoxInterface::Category::isNull() const
*/
