/****************************************************************************
**
** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the Qt Designer of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of the Qt tools.  This header
// file may change from version to version without notice, or even be removed.
//
// We mean it.
//

#ifndef GRIDPANEL_H
#define GRIDPANEL_H

#include "shared_global_p.h"

#include <QtGui/QGroupBox>

class QSpinBox;
class QCheckBox;

namespace qdesigner_internal {

class Grid;

class  QDESIGNER_SHARED_EXPORT GridPanel : public QGroupBox
{
    Q_OBJECT
public:
    GridPanel(QWidget *parentWidget = 0);

    void setGrid(const Grid &g);
    Grid grid() const;

private slots:
    void reset();

private:
    QCheckBox *m_visibleCheckBox;
    QCheckBox *m_snapXCheckBox;
    QCheckBox *m_snapYCheckBox;
    QSpinBox *m_deltaXSpinBox;
    QSpinBox *m_deltaYSpinBox;
};
}
#endif // GRIDPANEL_H
