/***************************************************************************
 *   Copyright (C) 2004 by Stefan Kombrink                                 *
 *   katakombi@web.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
#ifndef __MYQSDLG_H
#define __MYQSDLG_H

//
// the basics
//
#include <iostream>
#include <string>
#include <map>

//
// routines related to the synaptics tp driver
//
#include "syntp.h"
#include "synparam.h"

#include <qevent.h>
#include <qframe.h>

//
// the class declaration
//
#include "qsdlg.h"

class myFrame : public QFrame
{
    Q_OBJECT
    
public:
    
    myFrame();
        
public slots:
    
    // for displaying the active edges (circular scrolling!)
    void displayCSEdges(int);
    
protected:
    virtual void paintEvent(QPaintEvent *event);
    
    int sTrigger;
};

class myQsDlg : public qsDlg
{
    Q_OBJECT
public:
    myQsDlg();
    
protected:
    //
    // enable all functionality that can be used from the system's side
    //
    void enableFunctionality();
    
    //
    // monitors the current settings (might not be applied yet!)
    //
    void displayConfig();
    
    SynTouchPad myTP;
private slots:
    // for multifinger button emulation...
    void mfButtonUpdate(int);
    void mfFingerUpdate(int);
    
    // for enabling/disabling the touch pad
    void touchPadState(int);
    
    // selects scrolling mode    
    void scrollingState(int);
    
    // for changing the scrolling speed
    void horizScrollingUpdate(int);
    void vertScrollingUpdate(int);
    void circScrollingUpdate(int);
    void circScrollingCorners(int);
    
    // for changing the tapping time
    void tappingTimeUpdate(int);
    void tappingUpdate(bool);
    
    // for switching on/off the syndaemon and setting its delay
    void synDaemonToggle(bool);
    void synDaemonUpdate(int);
    
private:
    myFrame myCSEdgesFrame;
};


#endif

