/*
 * This file is part of the QPxTool project.
 * Copyright (C) 2005-2006 Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#include <stdio.h>
#include <stdlib.h>
//#include "qpx_const.h"
#include <qevent.h>
#include <qthread.h>
#include <qmutex.h>
#include <qevent.h>
#include "scan_pointers.h"
const int event_test_init		=0x401;
const int event_test_done		=0x402;
const int event_all_tests_done		=0x403;
const int event_block_done_rd		=0x404;
const int event_block_done_wr		=0x405;
const int event_block_done_c1pie	=0x406;
const int event_block_done_c2pif	=0x407;
const int event_block_done_cupof	=0x408;

const int event_block_done_jb		=0x409;
const int event_block_done_ta		=0x40A;
const int event_block_done_fete		=0x40B;
const int event_debug			=0x40C;
const int event_show_lba		=0x40D;
const int event_tests_aborted		=0x40E;

const int event_block_done_BLER		=0x40F;
const int event_block_done_E11		=0x410;
const int event_block_done_E21		=0x411;
const int event_block_done_E31		=0x412;
const int event_block_done_E12		=0x413;
const int event_block_done_E22		=0x414;
const int event_block_done_E32		=0x415;

class QCustomEvent;
class QMutex;
class QThread;

class ScanThread: public QThread//, public QObject
{
public:
	ScanThread(){
		printf("** Init scan thread...");
// 		scan_tbl = (scan_commands**)malloc((VENDORS+1)*sizeof(scan_commands*));
// 		for (int i=0; i<(VENDORS+1); i++)
// 			scan_tbl[i] = (scan_commands*)malloc(sizeof(scan_commands));
		init_check_table();
		printf(" OK\n");
	}
	~ScanThread(){
		if (drive) delete drive;
// 		for (int i=0; i<=VENDORS; i++)
// 			delete scan_tbl[i];// = (scan_commands*)malloc(sizeof(scan_commands));
	}
	void set_parent (QWidget* p){
		parent = (QObject*)p;
		drive = NULL;
	}

	void	run();
//	int current_test();
	void	skip_test();
	void	abort_test();
	void	set_drive(drive_info* drv);
private:
	void	post_signal(int event_id, void* data){
		QCustomEvent*	event = new QCustomEvent(event_id);
		if (data) event->setData(data);
		postEvent(parent, event);
	}
	void	event_block_done(int event_id,block_data b){
		block_data* block = new block_data;
		memcpy(block,&b,sizeof(block_data));
		QCustomEvent*	event = new QCustomEvent(event_id);
		event->setData(block);
		postEvent(parent, event);
	}

	int	skip();
	void	reset_skip_flag();
	int	skip_flag;

	int	init_check_table();

	int 	rd_rate();
	void	scan_cx();
	void	scan_jb_cd();
	void	scan_pie();
	void	scan_pif();
	void	scan_jb_dvd();
	void	scan_fete();
	void	plextor_scan_TA();

	QMutex		mutex;
	QObject*	parent;
	drive_info*	drive;

// 	scan_commands	commands_generic;
	scan_commands	scan_tbl[VENDORS+1];
signals:
};

#ifndef __USE_QTHREAD
extern	void	*scan(void* arg);
#endif
