/*
 * This file is part of the QPxTool project.
 * Copyright (C) 2005-2006 Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 *
 * Thanks to Artur Kalimullin (Kaliy) <kalimullin@gmail.com> for assistance in LiteOn Cx scan implementation
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */
 

#include <stdio.h>
#include <stdlib.h>

#include <transport.h>
#include <qpx_mmc.h>
#include <common_functions.h>

#include "media_check_liteon.h"

// ************* Scan init commands *********
int ltn_init_cx_scan(drive_info* drive) {
	drive->cmd_clear();
	drive->cmd[0] = 0xDF;
	drive->cmd[1] = 0xA3;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,256))){
		sperror ("LiteOn_init_A_cx_scan",drive->err); return 1;
	}
	printf("LiteOn_init_0_cx_scan: OK\n");

	drive->cmd_clear();
	drive->cmd[0] = 0xDF;
	drive->cmd[1] = 0xA0;
	drive->cmd[4] = 0x02;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,256))){
		sperror ("LiteOn_init_B_cx_scan",drive->err); return 1;
	}
	printf("LiteOn_init_1_cx_scan: OK\n");

	drive->cmd_clear();
	drive->cmd[0] = 0xDF;
	drive->cmd[1] = 0xA0;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,256))){
		sperror ("LiteOn_init_C_cx_scan",drive->err); return 1;
	}
	printf("LiteOn_init_2_cx_scan: OK\n");

	drive->cmd_clear();
	drive->cmd[0] = 0xDF;
	drive->cmd[1] = 0xA0;
	drive->cmd[4] = 0x04;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,256))){
		sperror ("LiteOn_init_D_cx_scan",drive->err); return 1;
	}
	printf("LiteOn_init1_3_scan: OK\n");

	drive->cmd_clear();
	drive->cmd[0] = 0xDF;
	drive->cmd[1] = 0xA0;
	drive->cmd[4] = 0x02;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,256))){
		sperror ("LiteOn_init_E_cx_scan",drive->err); return 1;
	}
	printf("LiteOn_init_4_cx_scan: OK\n");
	return 0;
}

int ltn_init_pi_scan(drive_info* drive) {
// 2B 00 00 00 00 00 00 00 00 00
	drive->cmd_clear();
	drive->cmd[0] = 0x2B;
	if ((drive->err=drive->cmd.transport(READ,NULL,0))){
		sperror ("LiteOn_init_pi_scan",drive->err); return 1;
	}
	printf("LiteOn_init_pi_scan: OK\n");
	return 0;
}


int ltn_cx_scan(drive_info* drive) {
	drive->cmd_clear();
	drive->cmd[0] = 0xDF;
	drive->cmd[1] = 0x82;
	drive->cmd[2] = 0x09;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,256))){
		sperror ("LiteOn_cx_do_one_interval_scan",drive->err); return 1;
	}
//	printf("LiteOn_cx_do_one_interval_scan: OK");
	return 0;
}

int ltn_cx_readout(drive_info* drive) {
	drive->cmd_clear();
	drive->cmd[0] = 0xDF;
	drive->cmd[1] = 0x82;
	drive->cmd[2] = 0x05;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,256))){
		sperror ("LiteOn_cx_do_one_interval_readout",drive->err); return 1;
	}
//	printf("LiteOn_cx_do_one_interval_readout: OK");
	return 0;
}

int ltn_cx_inteval_rst(drive_info* drive) {
	drive->cmd_clear();
	drive->cmd[0] = 0xDF;
	drive->cmd[1] = 0x97;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,256))){
		sperror ("LiteOn_cx_do_one_interval_rst",drive->err); return 1;
	}
	return 0;
}

int ltn_pi_scan(drive_info* drive) {

// CDB:
// 00000000  F3 0E 00 00 00 00 00 00 10 00 00 00               ...........    

// Data Received:
// 00000000  00 00 00 8E 00 00 00 00                           .......        

	drive->cmd_clear();
	drive->cmd[0] = 0xF3;
	drive->cmd[1] = 0x0E;
	drive->cmd[8] = 0x10;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,8))){
		sperror ("LiteOn_pi_do_one_interval_scan",drive->err); return 1;
	}
//	printf("LiteOn_cx_do_one_interval_scan: OK");
	return 0;
}

// **********************
int ltn_cx_do_one_interval(drive_info* drive, int* lba, int* BLER,
	int* E11, int* E21, int* E31, int* E12, int* E22, int* E32)
{
	if (ltn_cx_scan(drive)) return drive->err;
	if (ltn_cx_readout(drive)) return drive->err;

	*BLER = swap2(drive->rd_buf);
	*E11 = 0;
	*E21 = 0;
	*E31 = 0;
	*E12 = 0;
	*E22 = swap2(drive->rd_buf+2);
	*E32 = swap2(drive->rd_buf+4);
/*
	*C1 = drive->rd_buf[0];
	*C2 = drive->rd_buf[2];
	*CU = drive->rd_buf[4];
*/
	*lba+=75;

	if (ltn_cx_inteval_rst(drive)) return drive->err;
//	printf("LiteOn_cx_do_one_interval_rst: OK");
	return 0;
}

int ltn_pie_do_one_interval(drive_info* drive, int* lba, int* pie) {
	int i;
	*pie = 0;
	ltn_pi_scan(drive);
// Data Received:
// 00000000  00 00 00 8E 00 00 00 00                           .......        
	*lba = ((drive->rd_buf[1] << 16 )& 0xFF0000) + ((drive->rd_buf[2] << 8)&0xFF00 ) + (drive->rd_buf[3] & 0xFF);
	*pie = ((drive->rd_buf[4] << 8)  & 0xFF00 )  + (drive->rd_buf[5] & 0xFF);
	return 0;
}

int ltn_pif_do_one_interval(drive_info* drive, int* lba, int* pif) {
	ltn_pi_scan(drive);
// Data Received:
// 00000000  00 00 00 8E 00 00 00 00                           .......        
	*lba = ((drive->rd_buf[1] << 16 )& 0xFF0000) + ((drive->rd_buf[2] << 8)&0xFF00 ) + (drive->rd_buf[3] & 0xFF);
	*pif = ((drive->rd_buf[6] << 8)  & 0xFF00 )  + (drive->rd_buf[7] & 0xFF);
	return 0;
}

// ************* END SCAN COMMANDS *********
int ltn_end_scan_cd(drive_info* drive) {
	drive->cmd_clear();
	drive->cmd[0] = 0xDF;
	drive->cmd[1] = 0xA3;
	drive->cmd[2] = 0x01;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,256))){
		sperror ("LiteOn_end_scan",drive->err); return 1;
	}
	return 0;
}

int ltn_end_scan_dvd(drive_info* drive) {
	drive->err = 0;
	return 0;
}

scan_commands commands_list_liteon = {
	ltn_init_cx_scan, ltn_cx_do_one_interval, ltn_end_scan_cd,
	NULL, NULL, NULL,
	ltn_init_pi_scan, ltn_pie_do_one_interval, ltn_end_scan_dvd,
	ltn_init_pi_scan, ltn_pif_do_one_interval, ltn_end_scan_dvd,
	NULL, NULL, NULL,
	NULL, NULL, NULL,
};

scan_commands commands_liteon()  { return commands_list_liteon; }
