// pstable.h				emacs, this is written in -*-c++-*-
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997-1999

#ifndef PSTABLE_H
#define PSTABLE_H

//#include "qps.h"
#include "htable.h"
#include "proc.h"
//class Qps;
class Pstable : public HeadedTable
{
    Q_OBJECT
public:
//	Qps		*qps;
    Pstable(QWidget *parent);

    void transfer_selection();
    void set_sortcol();
    void setProcview(Procview *pv);
    void set_mode(bool treemode);
    virtual void moveCol(int col, int place);
    void update_customfield();
    void refresh();
	

public slots:
    void selection_update(const Svec<int> *row);
    void sortcol_change(int col);
    void subtree_folded(int row);

signals:
    void selection_changed();

protected:
    // implementation of the interface to HeadedTable
    virtual QString title(int col);
    virtual QString text(int row, int col);
    virtual int colWidth(int col);
    virtual int alignment(int col);
    virtual int leftGap(int col);
    virtual QString tipText(int col);
    virtual int rowDepth(int row);
    virtual NodeState folded(int row);
    virtual int parentRow(int row);
    virtual bool lastChild(int row);
	virtual char* total_selectedRow(int col);

//virtual void drawCellContents(int row, int col, int w, int h, QPainter *p);

private:
    	Procview *procview;
};

#endif // PSTABLE_H

