#ifndef PASSWIDGET_H
#define PASSWIDGET_H

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <qstring.h>
#include <qlabel.h>
#include <qslider.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qspinbox.h>

class PassWidget : public QVBox

{
  Q_OBJECT

  private:
    QCheckBox *discardCheck;
    QSpinBox *portUnmatchedSpin;
          
  public:
    PassWidget(int p_portcount, QWidget* parent=0, const char *name=0);
    ~PassWidget();
    void setDiscard(bool on);
    void setPortUnmatched(int id);
    
  signals:
    void discardToggled(bool);  
    void newPortUnmatched(int);
        
  public slots:
    void updateDiscard(bool on);
    void updatePortUnmatched(int);
};
  
#endif
