/****************************************************************************
 **
 ** Copyright (C) 2004-2007 Trolltech ASA. All rights reserved.
 **
 ** This file is part of the demonstration applications of the Qt Toolkit.
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://trolltech.com/products/qt/licenses/licensing/opensource/
 **
 ** If you are unsure which license is appropriate for your use, please
 ** review the following information:
 ** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 ** or contact the sales department at sales@trolltech.com.
 **
 ** In addition, as a special exception, Trolltech gives you certain
 ** additional rights. These rights are described in the Trolltech GPL
 ** Exception version 1.0, which can be found at
 ** http://www.trolltech.com/products/qt/gplexception/ and in the file
 ** GPL_EXCEPTION.txt in this package.
 **
 ** In addition, as a special exception, Trolltech, as the sole copyright
 ** holder for Qt Designer, grants users of the Qt/Eclipse Integration
 ** plug-in the right for the Qt/Eclipse Integration to link to
 ** functionality provided by Qt Designer and its related libraries.
 **
 ** Trolltech reserves all rights not expressly granted herein.
 **
 ** Trolltech ASA (c) 2007
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/

#ifndef PRINTPREVIEW_H
#define PRINTPREVIEW_H

#include <QMainWindow>
#include <QPrinter>
#include <QPointF>
#include <QSizeF>

#include <QAbstractScrollArea>

class PreviewView;
class QTextDocument;

class PrintPreview : public QMainWindow
{
    Q_OBJECT
        public:
        PrintPreview(const QTextDocument *document, QWidget *parent);
        virtual ~PrintPreview();

        QSizeF paperSize;
        QPointF pageTopLeft;

    private slots:
        void print();
        void pageSetup();

    private:
        void setup();

        QTextDocument *doc;
        PreviewView *view;
        QPrinter printer;
};

class PreviewView : public QAbstractScrollArea
{
    Q_OBJECT
        public:
        PreviewView(QTextDocument *document, PrintPreview *printPrev);

        inline void updateLayout() { resizeEvent(0); viewport()->update(); }

    public slots:
        void zoomIn();
        void zoomOut();

    protected:
        virtual void paintEvent(QPaintEvent *e);
        virtual void resizeEvent(QResizeEvent *);
        virtual void mousePressEvent(QMouseEvent *e);
        virtual void mouseMoveEvent(QMouseEvent *e);
        virtual void mouseReleaseEvent(QMouseEvent *e);

    private:
        void paintMap(QPainter *painter, int page);
        void paintPage(QPainter *painter, int page);
        QTextDocument *doc;
        qreal scale;
        int interPageSpacing;
        QPoint mousePressPos;
        QPoint scrollBarValuesOnMousePress;
        PrintPreview *printPreview;
};
#endif                           // PRINTPREVIEW_H
