/**********************************************************************************************
    Copyright (C) 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/

#include "CDlgWptIcon.h"
#include "GarminIcons.h"

#include <QtGui>

extern garmin_icon_t GarminIcons[];

int grpSymbols[] =
{
    8284,8285,8286,8287,8288,8289,8290,8291
    ,8292,8198,8199,8200
};

int grpFavIcons[] =
{
    8255,8256, 157, 158,  10,8246,8245, 166
    , 170,8238
};

int grpCustomIcons[] =
{
    7680,7681,7682,7683,7684,7685,7686,7687
    ,7688,7689,7690,7691,7692,7693,7694,7695
    ,7696,7697,7698,7699,7700,7701,7702,7703
};

CDlgWptIcon::CDlgWptIcon(quint16& id, QWidget * parent)
: QDialog(parent)
, id(id)
{
    layout = new QVBoxLayout(this);
    layout->setMargin(2);
    layout->setSpacing(0);

    lblSymbol = new QLabel(tr("Marker"),this);
    layout->addWidget(lblSymbol);

    layoutSymbols = new QGridLayout();
    layoutSymbols->setMargin(0);
    layoutSymbols->setSpacing(1);
    setupSampleIcons(layoutSymbols,grpSymbols,sizeof(grpSymbols)/sizeof(int));
    layout->addLayout(layoutSymbols);

    lblFavIcon = new QLabel(tr("Favorit Icons"),this);
    layout->addWidget(lblFavIcon);

    layoutFavIcon = new QGridLayout();
    layoutFavIcon->setMargin(0);
    layoutFavIcon->setSpacing(1);
    setupSampleIcons(layoutFavIcon,grpFavIcons,sizeof(grpFavIcons)/sizeof(int));
    layout->addLayout(layoutFavIcon);

    lblCustomIcon = new QLabel(tr("Custom Icons"),this);
    layout->addWidget(lblCustomIcon);

    layoutCustomIcon = new QGridLayout();
    layoutCustomIcon->setMargin(0);
    layoutCustomIcon->setSpacing(1);
    setupSampleIcons(layoutCustomIcon,grpCustomIcons,sizeof(grpCustomIcons)/sizeof(int));
    layout->addLayout(layoutCustomIcon);

    QSpacerItem * spacer = new QSpacerItem(20, 40, QSizePolicy::Minimum, QSizePolicy::Expanding);
    layout->addItem(spacer);
}


CDlgWptIcon::~CDlgWptIcon()
{

}


void CDlgWptIcon::setupSampleIcons(QGridLayout * gridLayout, int * groupIDs, int len)
{

    int row = 0, col = 0;
    QPixmap pix;
    QString str;
    QLabel * icon;

    for(int i=0; i<len; ++i) {
        icon = new QLabel(this);
        getWptIconById(groupIDs[i],pix,str);
        icon->setPixmap(pix);
        icon->setToolTip(str);
        gridLayout->addWidget(icon,row,col);
        items << icon;
        ++col;
        if(col == 8) {
            col = 0;
            ++row;
        }
    }
}


void CDlgWptIcon::mousePressEvent(QMouseEvent * event)
{
    QLabel * item;

    foreach(item,items) {
        if(item->geometry().contains(event->pos())) {
            getWptIconByName(item->toolTip(),id);
            accept();
            break;
        }
    }
}
