/***************************************************************************
 *   Copyright (C) 2007 by Sikon                                           *
 *   sikon@lucidfox.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef QINK_H
#define QINK_H

namespace inklevel
{
    extern "C"
    {
        #include <inklevel.h>
    }
}

#undef OK

static const int INKLEVEL_OK        = 0;
static const int MIN_DEVICE_TYPE    = 1;
static const int MAX_DEVICE_TYPE    = 4;
static const int LAST_PORT          = 17;

typedef struct _device_info
{
    int device_type;
    int device_port;
}
DEVICE_INFO;

#include <QApplication>
#include <QDesktopWidget>
#include <QDialog>
#include <QComboBox>
#include <QGroupBox>
#include <QProgressBar>
#include <QLabel>
#include <QPushButton>
#include <QVector>

#define DOCDIR DATADIR "/doc/qink"
#define RESDIR DATADIR "/qink"
#define ICONFILE(dimension) DATADIR "/icons/hicolor/" dimension "/apps/qink.png"

#endif
