/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.gui.ReflectiveAction;
import driftwood.util.SoftLog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import king.KingMain;

public class HTMLHelp
implements HyperlinkListener {
    KingMain kMain;
    JFrame frame;
    JEditorPane editpane;
    URL homepage;
    URL prevpage = null;
    LinkedList history;

    public HTMLHelp(KingMain kingMain, URL uRL) {
        this.kMain = kingMain;
        this.homepage = uRL;
        this.history = new LinkedList();
        this.frame = new JFrame("KiNG Help");
        this.frame.setDefaultCloseOperation(2);
        this.frame.setIconImage(this.kMain.prefs.windowIcon);
        this.editpane = new JEditorPane();
        this.editpane.addHyperlinkListener(this);
        this.editpane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.editpane);
        jScrollPane.setPreferredSize(new Dimension(600, 400));
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(new JButton(new ReflectiveAction("Back", this.kMain.prefs.htmlBackIcon, this, "onBack")));
        jToolBar.addSeparator();
        jToolBar.add(new JButton(new ReflectiveAction("Home", this.kMain.prefs.htmlHomeIcon, this, "onHome")));
        this.frame.getContentPane().add((Component)jToolBar, "North");
        this.frame.getContentPane().add((Component)jScrollPane, "Center");
    }

    public void show() {
        try {
            this.editpane.setPage(this.homepage);
            this.history = new LinkedList();
            this.prevpage = this.homepage;
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
        }
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void hide() {
        this.frame.dispose();
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                HTMLDocument hTMLDocument = (HTMLDocument)this.editpane.getDocument();
                hTMLDocument.processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)hyperlinkEvent);
            } else {
                try {
                    if (this.prevpage != null) {
                        this.history.addLast(this.prevpage);
                    }
                    while (this.history.size() > 100) {
                        this.history.removeFirst();
                    }
                    URL uRL = hyperlinkEvent.getURL();
                    this.editpane.setPage(uRL);
                    this.prevpage = uRL;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(SoftLog.err);
                }
            }
        }
    }

    public void onBack(ActionEvent actionEvent) {
        if (this.history.size() < 1) {
            return;
        }
        try {
            URL uRL = (URL)this.history.removeLast();
            this.editpane.setPage(uRL);
            this.prevpage = uRL;
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
        }
    }

    public void onHome(ActionEvent actionEvent) {
        try {
            this.history = new LinkedList();
            this.editpane.setPage(this.homepage);
            this.prevpage = this.homepage;
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
        }
    }
}

